# -*- coding: utf-8 -*-
# vim:set noet ts=4:
#
# scim-python
#
# Copyright (c) 2007-2008 Huang Peng <shawn.p.huang@gmail.com>
#
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330,
# Boston, MA  02111-1307  USA
#
# $Id: $
#
import sys
import os
import os.path as path
import traceback

class Log:
	_file_name = path.expanduser ("~/.scim/scim-python/log")
	def __init__ (self, module_name):
		self._module_name = module_name

	def print_exc (self):
		_file = open (self._file_name, "a")
		traceback.print_exc (file = _file)

	def log(self, level, *args):
		_file = open (self._file_name, "a")
		print >> _file, level, args
