/*
 *  rpc.rstatd version 3.03 rpc remote statistics daemon.
 *  Copyright (C) 1995  Adam Migus, Memorial University of Newfoundland
 *	(MUN)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  If you make modifications to the source, I would be happy to have
 *  them to include in future releases.  Feel free to send them to:
 *    Adam Migus	      				
 *	  amigus@cs.mun.ca 
 *    amigus@ucs.mun.ca   
 *
 *	Original Sun version by:
 * Copyright (c) 1984 by Sun Microsystems, Inc.
 **************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <limits.h>
#include <rpc/rpc.h>
#include <sys/socket.h>
#include <nlist.h>
#include <syslog.h>
#include <sys/errno.h>
#include <sys/param.h>
#include <net/if.h>
#include <utmp.h>
#include "rstat.h"

#define LOADAVG "/proc/loadavg"
#define STAT "/proc/stat"
#define UPTIME "/proc/uptime"
#define NETSTUFF "/proc/net/dev"
#ifndef NET_IFACE
#define NET_IFACE "eth0"
#endif
#ifndef _PATH_UTMP
#define _PATH_UTMP "/var/adm/utmp"
#endif

/* Must be redefined if using libc's rpc functions */
/* libc's rpc is recommended despite compilation errors */
#ifdef NORPCLIB 
#define rstatproc_stats_5 rstatproc_stats5_svc
#define rstatproc_stats_3 rstatproc_stats3_svc
#define rstatproc_stats_2 rstatproc_stats2_svc
#define rstatproc_stats_1 rstatproc_stats1_svc
#define rstatproc_havedisk_5 rstatproc_havedisk_5_svc
#define rstatproc_havedisk_3 rstatproc_havedisk_3_svc
#define rstatproc_havedisk_2 rstatproc_havedisk_2_svc
#define rstatproc_havedisk_1 rstatproc_havedisk_1_svc
#endif

int stats_service();
static void get_stats();

union {
	struct stats s1;
	struct statsswtch s2;
	struct statstime s3;
	struct statsusers s5;
} stats_all;

extern int inetd_connect;

void test_connect()
{
	if(inetd_connect != 0) {
		exit(0);
	}
}

statsusers *rstatproc_stats_5(arg, rqstp)
void *arg;
struct svc_req *rqstp;
{
	get_stats();
	return &stats_all.s5;
}

statstime *rstatproc_stats_3(arg, rqstp)
	void *arg;
	struct svc_req *rqstp;
{
	get_stats();
	return &stats_all.s3;
}

statsswtch *rstatproc_stats_2(arg, rqstp)
	void *arg;
	struct svc_req *rqstp;
{
	get_stats();
	return (&stats_all.s2);
}

stats *rstatproc_stats_1(arg, rqstp)
	void *arg;
	struct svc_req *rqstp;
{
	get_stats();
	return (&stats_all.s1);
}

u_int *rstatproc_havedisk_5(arg, rqstp)
	void *arg;
	struct svc_req *rqstp;
{
	static u_int have;

	get_stats();
	have = havedisk();
	return (&have);
}

u_int *rstatproc_havedisk_3(arg, rqstp)
	void *arg;
	struct svc_req *rqstp;
{
	return (rstatproc_havedisk_5(arg, rqstp));
}

u_int *rstatproc_havedisk_2(arg, rqstp)
	void *arg;
	struct svc_req *rqstp;
{
	return (rstatproc_havedisk_5(arg, rqstp));
}

u_int *rstatproc_havedisk_1(arg, rqstp)
	void *arg;
	struct svc_req *rqstp;
{
	return (rstatproc_havedisk_5(arg, rqstp));
}

static void get_stats()
{
	double avrun[3];
	FILE *fst, *fla, *fnet;
	int result=6;
	char iface[8]="",temp[256];

	if((fst = fopen(STAT, "r")) == NULL) {
		syslog(LOG_ERR, "can't open /proc/stat");
	}

	fscanf(fst, "cpu  %u %u %u %u\n",&stats_all.s1.cp_time[0],
				&stats_all.s1.cp_time[1],&stats_all.s1.cp_time[2],
				&stats_all.s1.cp_time[3]);

	if((fla = fopen(LOADAVG, "r")) == NULL) {
		syslog(LOG_ERR, "can't open /proc/loadavg");
	}
	fscanf(fla, "%lf %lf %lf", &avrun[0], &avrun[1], &avrun[2]);
	stats_all.s2.avenrun[0] = avrun[0] * FSCALE;
	stats_all.s2.avenrun[1] = avrun[1] * FSCALE;
	stats_all.s2.avenrun[2] = avrun[2] * FSCALE;

	fscanf(fst, "disk %u %u %u %u\n",&stats_all.s1.dk_xfer[0],
			&stats_all.s1.dk_xfer[1],&stats_all.s1.dk_xfer[2],
			&stats_all.s1.dk_xfer[3]);

	fscanf(fst, "page %u %u\n", &stats_all.s1.v_pgpgin, &stats_all.s1.v_pgpgout);
	fscanf(fst, "swap %u %u\n", &stats_all.s1.v_pswpin, &stats_all.s1.v_pswpout);

	fscanf(fst, "intr %u %*u %*u %*u %*u %*u %*u %*u %*u %*u %*u %*u %*u %*u %*u %*u %*u\n",
				 &stats_all.s1.v_intr);
	fscanf(fst, "ctxt %u\n", &stats_all.s2.v_swtch);

	if ((fnet = fopen(NETSTUFF,"r")) == NULL) {
		syslog(LOG_ERR,"can't open /proc/net/dev");
	}

	fgets(temp,256,fnet); /* header in /proc/dev/net */
	fgets(temp,256,fnet); /* second header in /proc/dev/net */

	while(!strstr((char *)&iface,NET_IFACE) && (result != EOF) ) {
		result = fscanf(fnet, " %s %u %u %*u %*u %*u %u %u %*u %*u %u %*u\n",
			&iface, &stats_all.s1.if_ipackets, &stats_all.s1.if_ierrors, 
			&stats_all.s3.if_opackets, &stats_all.s1.if_oerrors,
			&stats_all.s1.if_collisions);
		if (result != 6) /* "No statistics available" or EOF reached */
			stats_all.s1.if_ipackets = stats_all.s1.if_ierrors = 
				stats_all.s3.if_opackets =
				stats_all.s1.if_oerrors = 
				stats_all.s1.if_collisions = 0;
	}

	fclose(fst);
	fclose(fla);
	fclose(fnet);

	stats_all.s5.users = l_users();

	gettimeofday((struct timeval *)
				&stats_all.s3.curtime,(struct timezone *) 0);
	stats_all.s2.boottime.tv_sec = (stats_all.s3.curtime.tv_sec - l_uptime());
	if(inetd_connect) alarm(1); 
}

int havedisk()
{

	int i, cnt;
	long  xfer[DK_NDRIVE];

	cnt = 0;
	for (i=0; i < DK_NDRIVE; i++)
		cnt += xfer[i];
	return (cnt != 0);
}

int l_uptime()
{
	int fd;
	double up_secs, idle_secs;
	char buf[BUFSIZ];

	if((fd = open(UPTIME,O_RDONLY)) < 0) {
		return;
	}
	if((read(fd,(char *)&buf,sizeof(buf))) < 0) {
		return;
	}
	(void)close(fd);
	if(sscanf(buf,"%lf %lf",&up_secs,&idle_secs) < 2) {
		return;
	}
	return((unsigned int)up_secs);
}

int l_users()
{
	int ufd, users = 0;
	static char buf[3];
    struct utmp u;

    if ((ufd = open(_PATH_UTMP, O_RDONLY)) < 0) {
		return;
	}
    while (read(ufd, (char *) &u, sizeof(u)) == sizeof(u)) {
        if(u.ut_type==7 && u.ut_name[0] != '\0') {
            users++;
        }
    }
	(void)close(ufd);
	sprintf(buf,"%i",users);
	return(users);
}

void rstat_service(rqstp, transp)
	struct svc_req *rqstp;
	SVCXPRT *transp;
{
	union {
		int fill;
	} argument;
	char *result;
	xdrproc_t xdr_argument, xdr_result;
	char *(*local) __P((void *, struct svc_req *));
	void *v;

	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void)svc_sendreply(transp, (xdrproc_t) xdr_void, (char *)NULL);
      if(inetd_connect) exit(0);

	case RSTATPROC_STATS:
		xdr_argument = (xdrproc_t)xdr_void;
		xdr_result = (xdrproc_t)xdr_statsusers;
      switch (rqstp->rq_vers) {
          case RSTATVERS_ORIG:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_stats_1;
               break;
          case RSTATVERS_SWTCH:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_stats_2;
               break;
          case RSTATVERS_TIME:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_stats_3;
               break;
          case RSTATVERS_USERS:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_stats_5;
               break;
          default:
               svcerr_progvers(transp, RSTATVERS_ORIG, RSTATVERS_USERS);
               if(inetd_connect) exit(0);
      }
		break;

	case RSTATPROC_HAVEDISK:
		xdr_argument = (xdrproc_t)xdr_void;
		xdr_result = (xdrproc_t)xdr_u_int;
      switch (rqstp->rq_vers) {
          case RSTATVERS_ORIG:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_havedisk_1;
               break;
          case RSTATVERS_SWTCH:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_havedisk_2;
               break;
          case RSTATVERS_TIME:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_havedisk_3;
               break;
          case RSTATVERS_USERS:
               local = (char *(*) __P((void *, struct svc_req *)))
					rstatproc_havedisk_5;
               break;
          default:
               svcerr_progvers(transp, RSTATVERS_ORIG, RSTATVERS_USERS);
               if(inetd_connect) exit(0);
      }
		break;
	default:
		svcerr_noproc(transp);
      if(inetd_connect) exit(0);
	}
	bzero((char *)&argument, sizeof(argument));
	if (!svc_getargs(transp, xdr_argument, (caddr_t)&argument)) {
		svcerr_decode(transp);
      if(inetd_connect) exit(0);
	}
	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, xdr_result, result)) {
		svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, xdr_argument, (caddr_t)&argument)) {
		(void)fprintf(stderr, "unable to free arguments\n");
		exit(1);
	}
}
