
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>

#define BUF_SIZE 4096


int main (void)
{
    RList *list;
    RListOfRBufEntry *rbuf_entry;
    char buf[BUF_SIZE];
    char *split_chars = ":|";

    FILE *fp;

    rinit ();

    fp = fopen("strsplit-tests.txt", "r");
    if (!fp) {
        printf ("Unable to open file 'strsplit-tests.txt', exiting\n");
        exit (1);
    }

    while (fgets (buf, sizeof (buf), fp)) {

        /* Remove newline for cleanliness */
        buf[strlen (buf) - 1] = '\0';
        
        list = rstr_split (buf, split_chars, -1);

        printf ("Splitting string '%s' on characters '%s':\n", buf, split_chars);

        RLIST_FOREACH (list, rbuf_entry) {
            printf ("'%s'\n", rbuf_str (rbuf_entry->buf));
            rlist_remove (list, rbuf_entry);
            rbuf_free (rbuf_entry->buf);
            rlist_of_rbuf_entry_free (rbuf_entry);
        } RFOREACH_CLOSE;

        rlist_free (list);
    }

    rcleanup ();

    return 0;
}

