
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>


int
main (void)
{
    RBuf *buf1;
    char buf2[2048];

    char *fp_fmt[] = {
        "%-1.5f",
        "%1.5f",
        "%123.9f",
        "%10.5f",
        "% 10.5f",
        "%+22.9f",
        "%+4.9f",
        "%01.3f",
        "%4f",
        "%3.1f",
        "%3.2f",
        NULL
    };
    double fp_nums[] = { -1.5, 134.21, 91340.2, 341.1234, 0203.9, 0.96, 0.996, 
        0.9996, 1.996, 0.000447, 4.136, 1.00025, 0 };
    char *int_fmt[] = {
        "%-1.5d",
        "%1.5d",
        "%123.9d",
        "%5.5d",
        "%10.5d",
        "% 10.5d",
        "%+22.33d",
        "%01.3d",
        "%4d",
        NULL
    };
    long int_nums[] = { -1, 134, 91340, 341, 0203, 0};
    int x, y;
    int fail = 0;
    int num = 0;

    rinit ();

    printf ("Testing rbuf_sprintf format codes against system sprintf...\n");

    buf1 = rbuf_new ();

    for (x = 0; fp_fmt[x] != NULL ; x++)
        for (y = 0; fp_nums[y] != 0 ; y++)
        {
            rbuf_sprintf (buf1, fp_fmt[x], fp_nums[y]);
            sprintf (buf2, fp_fmt[x], fp_nums[y]);
            if (!rbuf_equal_str (buf1, buf2))
            {
                printf("rbuf_sprintf doesn't match Format: %s\n\trbuf_sprintf = %s\n\tsprintf  = %s\n\tvalue   = %f\n", 
                    fp_fmt[x], rbuf_str (buf1), buf2, fp_nums[y]);
                fail++;
            }
            num++;
        }

    for (x = 0; int_fmt[x] != NULL ; x++)
        for (y = 0; int_nums[y] != 0 ; y++)
        {
            rbuf_sprintf (buf1, int_fmt[x], int_nums[y]);
            sprintf (buf2, int_fmt[x], int_nums[y]);
            if (!rbuf_equal_str (buf1, buf2))
            {
                printf("rbuf_sprintf doesn't match Format: %s\n\trbuf_sprintf = %s\n\tsprintf  = %s\n", 
                    int_fmt[x], rbuf_str (buf1), buf2);
                fail++;
            }
            num++;
        }


    rbuf_sprintf (buf1, "%hi", 30000000);
    sprintf (buf2, "%hi",      30000000);
    if (!rbuf_equal_str (buf1, buf2))
    {
        printf("rbuf_sprintf doesn't match Format: %s\n\trbuf_sprintf = %s\n\tsprintf  = %s\n", 
            "%hi", rbuf_str (buf1), buf2);
        fail++;
    }
    num++;

    rbuf_sprintf (buf1, "%hx", -3);
    sprintf (buf2, "%hx", -3);
    if (!rbuf_equal_str (buf1, buf2))
    {
        printf("rbuf_sprintf doesn't match Format: %s\n\trbuf_sprintf = %s\n\tsprintf  = %s\n", 
            "%hx", rbuf_str (buf1), buf2);
        fail++;
    }
    num++;

    rbuf_sprintf (buf1, "%hu", -3);
    sprintf (buf2, "%hu", -3);
    if (!rbuf_equal_str (buf1, buf2))
    {
        printf("rbuf_sprintf doesn't match Format: %s\n\trbuf_sprintf = %s\n\tsprintf  = %s\n", 
            "%hu", rbuf_str (buf1), buf2);
        fail++;
    }
    num++;

    rbuf_sprintf (buf1, "%d %b %d\n", fail, rbuf_auto ("tests failed out of"), num);
    printf ("%s", rbuf_str (buf1));

    rbuf_sprintf (buf1, "%b :%-30b:\n", NULL, rbuf_auto ("Padding is good"));
    printf ("%s", rbuf_str (buf1));

    rbuf_free (buf1);

    rcleanup ();
    return (0);
}


