
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#ifndef __RNODE_H__
#define __RNODE_H__

typedef struct _RNode       RNode;

struct _RNode {

    /* Every node is part of a list */
    RLIST_HEADER;

    /* The element type of this node */
    RBuf *type;

    /* A list of this nodes children */
    RList *children;

    /* Pointer to the parent */
    RNode *parent;

    /* Hash of all attributes set */
    RBHash *attribs;

    /* Hash for key/value pairs */
    RBHash *kvs;

    /* Flags for node. */
    unsigned int flags;

    /* Reference count */
    int refcount;

    /* User data */
    void *user_data;
};


#include <roy/roynode/rnode_new.h>
#include <roy/roynode/rnode_destroy.h>
#include <roy/roynode/rnode_attrib.h>
#include <roy/roynode/rnode_search.h>
#include <roy/roynode/rnode_kv.h>
#include <roy/roynode/rnode_foreach.h>
#include <roy/roynode/rnode_therml.h>
#include <roy/roynode/rnmap.h>

#endif /* __RNODE_H__ */


