
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

/* -*- mode: C; c-basic-offset: 4  -*- */ 
#include <roy.h>

RListOfPtrEntry *
rlist_of_ptr_entry_new (void *ptr)
{
    RListOfPtrEntry *new_entry;

    new_entry = (RListOfPtrEntry*)rmem_alloc(sizeof(RListOfPtrEntry));
    new_entry->data = ptr;

    return new_entry;
}


void
rlist_of_ptr_entry_free (RListOfPtrEntry *ptr)
{
    if (!ptr)
	return;
    
    rmem_free (ptr);
}


RListOfRBufEntry *
rlist_of_rbuf_entry_new (RBuf *buf)
{
    RListOfRBufEntry *newentry;

    newentry = rchunk_alloc (sizeof (RListOfRBufEntry));
    newentry->buf = buf;

    return (newentry);
}

void
rlist_of_rbuf_entry_free (RListOfRBufEntry *ptr)
{
    if (!ptr)
        return;

    rchunk_free (ptr, sizeof (RListOfRBufEntry));
}

int
rlist_of_rbuf_compare (const RListEntry *a_, const RListEntry *b_)
{
    const RListOfRBufEntry *a = (RListOfRBufEntry *)a_;
    const RListOfRBufEntry *b = (RListOfRBufEntry *)b_;

    /* i declare that there is no meaningful ordering for NULL entries */
    if (!a || !b)
        return -1;

    return rbuf_equal_rbuf (a->buf, b->buf);

}


