
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>

RList *
rlist_new (void)
{
    RList *list;

    list = rchunk_alloc (sizeof (RList));
    RLIST_INIT (list);

    return (list);
}

void
rlist_free (RList *list)
{
    rchunk_free (list, sizeof (RList));
}

void *
rlist_nth (RList *list, unsigned int nth)
{
    RListEntry *entry;
    unsigned int i = 0;

    RLIST_FOREACH (list, entry) {
        if (i == nth)
            return (entry);
        i++;
    } RFOREACH_CLOSE;

    return (NULL);
}

int
rlist_len (RList *list)
{
    RListEntry *entry;
    unsigned int i = 0;

    RLIST_FOREACH (list, entry) {
        i++;
    } RFOREACH_CLOSE;

    return (i);
}


int
rlist_compare (RList *a, RList *b, RListComparatorFunction comparator)
{
    RListEntry *ae, *be;
    int ret;

    if (!a || !b)
        return -1;

    for (ae = rlist_first (a), be = rlist_first (a);
         ae && be; ae = rlist_next (ae), be = rlist_next (be)) {
        
        if (!(ret = comparator(ae,be)))
            return ret;
    }

    if (ae || be)
        return -1;

    return 0;
}

