
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>

static RList *rcleanup_hooks = NULL;

void 
rcleanup (void)
{
    RListOfPtrEntry *entry;
    
    if (!rcleanup_hooks)
        return;

    RLIST_FOREACH (rcleanup_hooks, entry) {
        RCleanupHook function = (RCleanupHook) entry->data;
        if (function)
            function ();
        rlist_of_ptr_entry_free (entry);
    } RFOREACH_CLOSE;

    rlist_free (rcleanup_hooks);
    rcleanup_hooks = NULL;
}


void
rcleanup_add_hook (RCleanupHook function)
{
    RListOfPtrEntry *entry;

    if (rcleanup_hooks == NULL) {
        rcleanup_hooks = rlist_new ();
    }

    entry = rlist_of_ptr_entry_new ((void *) function);

    rlist_append (rcleanup_hooks, entry);
}


