/*
 * robwxext.cpp
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// Provides some extensions to wxWidgets

#include <wx/wx.h>
#include "robwxext.h"

BEGIN_EVENT_TABLE(ImprovedListCtrl, wxListCtrl)
  EVT_SIZE(ImprovedListCtrl::OnSize)
END_EVENT_TABLE()

ImprovedListCtrl::ImprovedListCtrl(wxWindow* parent, wxWindowID id, const wxPoint& pos,
	const wxSize& size, long style, const wxValidator& validator, const wxString& name)
	:wxListCtrl(parent, id, pos, size, style, validator, name), growableCol(-1)
{
}

void ImprovedListCtrl::SetGrowableCol(int col)
{
	growableCol = col;
}

void ImprovedListCtrl::OnSize(wxSizeEvent& evt)
{
	if(!(GetWindowStyle() & wxLC_REPORT) || growableCol < 0 || growableCol >= GetColumnCount())
		return; // Nothing to do
	wxSize sz = GetClientSize();
	int growColWidth = sz.x;
	for(int i = 0; i < GetColumnCount(); i++)
		if(i != growableCol)
			growColWidth -= GetColumnWidth(i);
	if(growColWidth < 80) growColWidth = 80;
	SetColumnWidth(growableCol, growColWidth);

	evt.Skip();
}



BEGIN_EVENT_TABLE(ImprovedSplitter, wxSplitterWindow)
  EVT_ERASE_BACKGROUND(ImprovedSplitter::OnErase)
END_EVENT_TABLE()

ImprovedSplitter::ImprovedSplitter(wxWindow* parent, wxWindowID id, const wxPoint& point, 
		const wxSize& size, long style, const wxString& name)
		: wxSplitterWindow(parent, id, point, size, style, name)
{
}

void ImprovedSplitter::OnErase(wxEraseEvent& )
{
	// do nothing
	;
}



