% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NET.R
\name{net}
\alias{net}
\title{Nesting and Equivalence Testing}
\usage{
net(..., crit = 1e-04)
}
\arguments{
\item{\dots}{The \code{lavaan} objects used for test of nesting and
equivalence}

\item{crit}{The upper-bound criterion for testing the equivalence of models.
Models are considered nested (or equivalent) if the difference between
their \eqn{\chi^2} fit statistics is less than this criterion.}
}
\value{
The \linkS4class{Net} object representing the outputs for nesting
  and equivalent testing, including a logical matrix of test results and a
  vector of degrees of freedom for each model.
}
\description{
This test examines whether pairs of SEMs are nested or equivalent.
}
\details{
The concept of nesting/equivalence should be the same regardless of
estimation method. However, the particular method of testing
nesting/equivalence (as described in Bentler & Satorra, 2010) employed by
the \code{net} function analyzes summary statistics (model-implied means and
covariance matrices, not raw data). In the case of robust methods like MLR,
the raw data is only utilized for the robust adjustment to SE and chi-sq,
and the net function only checks the unadjusted chi-sq for the purposes of
testing nesting/equivalence.  This method also applies to models for
categorical data, following the procedure described by Asparouhov & Muthen
(2019).
}
\examples{

\dontrun{
m1 <- ' visual  =~ x1 + x2 + x3
	       textual =~ x4 + x5 + x6
	       speed   =~ x7 + x8 + x9 '


m2 <- ' f1  =~ x1 + x2 + x3 + x4
	       f2 =~ x5 + x6 + x7 + x8 + x9 '

m3 <- ' visual  =~ x1 + x2 + x3
	       textual =~ eq*x4 + eq*x5 + eq*x6
	       speed   =~ x7 + x8 + x9 '

fit1 <- cfa(m1, data = HolzingerSwineford1939)
fit1a <- cfa(m1, data = HolzingerSwineford1939, std.lv = TRUE) # Equivalent to fit1
fit2 <- cfa(m2, data = HolzingerSwineford1939) # Not equivalent to or nested in fit1
fit3 <- cfa(m3, data = HolzingerSwineford1939) # Nested in fit1 and fit1a

tests <- net(fit1, fit1a, fit2, fit3)
tests
summary(tests)
}

}
\references{
Bentler, P. M., & Satorra, A. (2010). Testing model nesting and equivalence.
\emph{Psychological Methods, 15}(2), 111--123. \doi{10.1037/a0019625}

Asparouhov, T., & Muthen, B. (2019). Nesting and equivalence testing for
structural equation models. \emph{Structural Equation Modeling, 26}(2),
302--309. \doi{10.1080/10705511.2018.1513795}
}
\author{
Terrence D. Jorgensen (University of Amsterdam; \email{TJorgensen314@gmail.com})
}
