=begin
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
=end

# $Id: swap.rb,v 1.5 2002/03/07 14:06:47 lballabio Exp $

require 'QuantLib'
require 'date'
require 'runit/testcase'
require 'runit/testsuite'
require 'runit/cui/testrunner'

def today
    QuantLib::Date.new(Date.today.day,
                       Date.today.month,
                       Date.today.year)
end

class SimpleSwapTest < RUNIT::TestCase
    include QuantLib
    def name
        "Testing simple swap..."
    end
    def test
        euriborHandle = TermStructureHandle.new
        fixedRate = 0.0
        fixingDays = 0
        spread = 0.0
        settlementDays = 2
        payFixed = true
        years = 10
        indexFixingDays = 0
        nominal = 100.0
        rollingConvention = 'modifiedFollowing'
        fixedFrequency = 1; floatingFrequency = 2
        fixedDayCount = DayCounter.new('30/360'); fixedAdj = 0
        index = Euribor.new(12/floatingFrequency,'Months',euriborHandle)
        calendar = index.calendar
        termStructure = FlatForward.new('EUR',DayCounter.new('Act/365'),today,
            calendar,settlementDays,0.05)
        settlement = termStructure.settlementDate
        swap = SimpleSwap.new(payFixed, settlement, years, 'years', calendar,
            rollingConvention, nominal, fixedFrequency, fixedRate,
            fixedAdj, fixedDayCount, floatingFrequency, index, indexFixingDays,
            spread, euriborHandle)
        euriborHandle.linkTo(termStructure)
        impliedRate = fixedRate-swap.NPV/swap.fixedLegBPS
        impliedSpread = spread-swap.NPV/swap.floatingLegBPS

        # check 1 - fair fixed rate must yield a null NPV
        swap = SimpleSwap.new(payFixed, settlement, years, 'years', calendar,
            rollingConvention, nominal, fixedFrequency, impliedRate,
            fixedAdj, fixedDayCount,floatingFrequency, index, indexFixingDays,
            spread, euriborHandle)
        unless swap.NPV.abs <= 1e-10
            assert_fail(<<-MESSAGE

    recalculating with implied rate:
        calculated value: #{swap.NPV}
        expected value:   0.0

                MESSAGE
            )
        end

        # check 2 - fair floating spread must yield a null NPV
        swap = SimpleSwap.new(payFixed, settlement, years, 'years', calendar,
            rollingConvention, nominal, fixedFrequency, fixedRate,
            fixedAdj, fixedDayCount,floatingFrequency, index, indexFixingDays,
            impliedSpread, euriborHandle)
        unless swap.NPV.abs <= 1e-10
            assert_fail(<<-MESSAGE

    recalculating with implied spread:
        calculated value: #{swap.NPV}
        expected value:   0.0

                MESSAGE
            )
        end
    end
end

if $0 == __FILE__
    RUNIT::CUI::TestRunner.run(SimpleSwapTest.suite)
end

