"""
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
"""

__version__ = "$Revision: 1.10 $"
# $Source: /cvsroot/quantlib/QuantLib-Python/QuantLib/test/old_implied_volatility.py,v $


# this file tests the method impliedVolatility
# (it actually tests the Brent 1D solver used)

import QuantLib
import unittest

class OldImpliedVolatilityTest(unittest.TestCase):
    def runTest(self):
        "Testing old-style implied volatility and Brent 1D solver"
        typRange = ['Call', 'Put', 'Straddle']
        underRange = [80, 95, 99.90, 100, 100.10, 105, 120]
        strikeRange = [80, 95, 99.90, 100, 100.10, 105, 120]
        qRateRange = [0.01, 0.05, 0.10]
        rRateRange = [0.01, 0.05, 0.10]
        resTimeRange = [0.001, 0.1, 0.5, 1.0, 3.0]
        volRange = [0.01, 0.2, 0.3, 0.7, 0.9]
        dVolRange = [0.5, 0.999, 1.0, 1.001, 1.5]

        maxEval = 100
        tol = 1e-6

        for typ in typRange:
          for under in underRange:
            for strike in strikeRange:
              for qRate in qRateRange:
                for rRate in rRateRange:
                  for resTime in resTimeRange:
                    for vol in volRange:
                      bsm = QuantLib.EuropeanOption(typ, under, \
                          strike, qRate, rRate, resTime, vol)
                      bsmValue = bsm.value()
                      if bsmValue==0.0 :
                        continue
                      for dVol in dVolRange:
                        vol2 = vol*dVol
                        bsm2 = QuantLib.EuropeanOption(typ, under, \
                            strike, qRate, rRate, resTime, vol2)
                        try:
                            implVol = bsm2.impliedVolatility(bsmValue, tol,
                              maxEval)
                        except Exception, e:
                            value2 = bsm2.value()
                            raise """
"%(e)s
Option details: %(typ)s %(under)f %(strike)f %(qRate)f %(rRate)f %(resTime)f
    volatility:   %(vol2)18.16f
    option value: %(value2)20.12e
    while trying to calculate implied vol from value %(bsmValue)20.12e
                                  """
                        if abs(implVol-vol) > tol:
                          bsm3 = QuantLib.EuropeanOption(typ, under,
                            strike, qRate, rRate, resTime, implVol)
                          bsm3Value = bsm3.value()
                          if not (abs(bsm3Value-bsmValue)/under<=1.0e-3):
                              value2 = bsm2.value()
                              self.fail("""
Option details: %(typ)s %(under)f %(strike)f %(qRate)f %(rRate)f %(resTime)f
    at %(vol)18.16f vol the option value is %(bsmValue)20.12e
    at %(vol2)18.16f vol the option value is %(value2)20.12e
    at %(bsmValue)20.12e value the implied vol is %(implVol)20.16f
    the error is %(err)10.2e (tolerance is %(tol)10.2e)
    at %(implVol)18.16f vol the option value is %(bs3value)20.12e
	                                    """ % locals())


if __name__ == '__main__':
    print 'testing QuantLib', QuantLib.__version__, QuantLib.QuantLibc.__file__, QuantLib.__file__
    import sys
    suite = unittest.TestSuite()
    suite.addTest(OldImpliedVolatilityTest())
    if sys.hexversion >= 0x020100f0:
        unittest.TextTestRunner(verbosity=2).run(suite)
    else:
        unittest.TextTestRunner().run(suite)
    raw_input('press any key to continue')
