/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.9u-20020211-1143
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGPYTHON
/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__)
#       if defined(_MSC_VER)
#               if defined(STATIC_LINKED)
#                       define SWIGEXPORT(a) a
#               else
#                       define SWIGEXPORT(a) __declspec(dllexport) a
#               endif
#       else
#               if defined(__BORLANDC__)
#                       define SWIGEXPORT(a) a _export
#               else
#                       define SWIGEXPORT(a) a
#       endif
#endif
#else
#       define SWIGEXPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGRUNTIME(a) static a
#endif

typedef void *(*swig_converter_func)(void *);

#ifdef __cplusplus
extern "C" {
#endif

typedef struct swig_type_info {
  const char  *name;                 
  swig_converter_func converter;
  const char  *str;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE
SWIGEXPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGEXPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGEXPORT(void *) SWIG_TypeCast(swig_type_info *, void *);
SWIGEXPORT(swig_type_info *) SWIG_TypeQuery(const char *);
#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti)
{
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
 l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty)
{
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  while (s) {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
	s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      return s;
    }
    s = s->next;
  }
  return 0;
}

/* Cast a pointer (needed for C++ inheritance */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) 
{
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

#endif

#ifdef __cplusplus
}
#endif



/***********************************************************************
 * python.swg
 *
 *     This file contains the runtime support for Python modules
 *     and includes code for managing global variables and pointer
 *     type checking.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 ************************************************************************/

#include <stdlib.h>
#include "Python.h"

#ifdef __cplusplus
extern "C" {
#endif

#define SWIG_PY_INT     1
#define SWIG_PY_FLOAT   2
#define SWIG_PY_STRING  3
#define SWIG_PY_POINTER 4

/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;

#ifdef SWIG_NOINCLUDE

SWIGEXPORT(PyObject *)        SWIG_newvarlink();
SWIGEXPORT(void)              SWIG_addvarlink(PyObject *, char *, PyObject *(*)(void), int (*)(PyObject *));
SWIGEXPORT(int)               SWIG_ConvertPtr(PyObject *, void **, swig_type_info *, int);
SWIGEXPORT(int)               SWIG_ConvertPacked(PyObject *, void *, int sz, swig_type_info *, int);
SWIGEXPORT(char *)            SWIG_PackData(char *c, void *, int);
SWIGEXPORT(char *)            SWIG_UnpackData(char *c, void *, int);
SWIGEXPORT(PyObject *)        SWIG_NewPointerObj(void *, swig_type_info *);
SWIGEXPORT(PyObject *)        SWIG_NewPackedObj(void *, int sz, swig_type_info *);
SWIGEXPORT(void)              SWIG_InstallConstants(PyObject *d, swig_const_info constants[]);

#else

/* -----------------------------------------------------------------------------
 * global variable support code.
 * ----------------------------------------------------------------------------- */

typedef struct swig_globalvar {   
  char       *name;                  /* Name of global variable */
  PyObject *(*get_attr)(void);       /* Return the current value */
  int       (*set_attr)(PyObject *); /* Set the value */
  struct swig_globalvar *next;
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar *vars;
} swig_varlinkobject;

static PyObject *
swig_varlink_repr(swig_varlinkobject *v) {
  v = v;
  return PyString_FromString("<Global variables>");
}

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags) {
  swig_globalvar  *var;
  flags = flags;
  fprintf(fp,"Global variables { ");
  for (var = v->vars; var; var=var->next) {
    fprintf(fp,"%s", var->name);
    if (var->next) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->get_attr)();
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return NULL;
}

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p) {
  swig_globalvar *var = v->vars;
  while (var) {
    if (strcmp(var->name,n) == 0) {
      return (*var->set_attr)(p);
    }
    var = var->next;
  }
  PyErr_SetString(PyExc_NameError,"Unknown C global variable");
  return 1;
}

statichere PyTypeObject varlinktype = {
  PyObject_HEAD_INIT(0)              
  0,
  (char *)"swigvarlink",                      /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */
SWIGRUNTIME(PyObject *)
SWIG_newvarlink(void) {
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  result->vars = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGRUNTIME(void)
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p)) {
  swig_varlinkobject *v;
  swig_globalvar *gv;
  v= (swig_varlinkobject *) p;
  gv = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  gv->name = (char *) malloc(strlen(name)+1);
  strcpy(gv->name,name);
  gv->get_attr = get_attr;
  gv->set_attr = set_attr;
  gv->next = v->vars;
  v->vars = gv;
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  int i;
  unsigned char *u = (unsigned char *) ptr;
  register unsigned char uu;
  for (i = 0; i < sz; i++,u++) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  int i;
  for (i = 0; i < sz; i++, u++) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_ConvertPtr(PyObject *obj, void **ptr, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c;
  static PyObject *SWIG_this = 0;
  int    newref = 0;

  if (!obj) return 0;
  if (obj == Py_None) {
    *ptr = 0;
    return 0;
  }
#ifdef SWIG_COBJECT_TYPES
  if (!(PyCObject_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_InternFromString("this");
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyCObject_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  *ptr = PyCObject_AsVoidPtr(obj);
  c = (char *) PyCObject_GetDesc(obj);
  if (newref) Py_DECREF(obj);
  goto cobject;
#else
  if (!(PyString_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_InternFromString("this");
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyString_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  c = PyString_AsString(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) {
      if (newref) Py_DECREF(obj);
      return 0;
    } else {
      if (newref) Py_DECREF(obj);
      goto type_error;
    }
  }
  c++;
  c = SWIG_UnpackData(c,ptr,sizeof(void *));
  if (newref) Py_DECREF(obj);
#endif

#ifdef SWIG_COBJECT_TYPES
cobject:
#endif

  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
    *ptr = SWIG_TypeCast(tc,(void*) *ptr);
  }
  return 0;

type_error:
  if (flags) {
    if (ty) {
      char *temp = (char *) malloc(64+strlen(ty->name));
      sprintf(temp,"Type error. Expected %s", ty->name);
      PyErr_SetString(PyExc_TypeError, temp);
      free((char *) temp);
    } else {
      PyErr_SetString(PyExc_TypeError,"Expected a pointer");
    }
  }
  return -1;
}

/* Convert a packed value value */
SWIGRUNTIME(int)
SWIG_ConvertPacked(PyObject *obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c;

  if ((!obj) || (!PyString_Check(obj))) goto type_error;
  c = PyString_AsString(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c,ptr,sz);
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
  }
  return 0;

type_error:

  if (flags) {
    if (ty) {
      char *temp = (char *) malloc(64+strlen(ty->name));
      sprintf(temp,"Type error. Expected %s", ty->name);
      PyErr_SetString(PyExc_TypeError, temp);
      free((char *) temp);
    } else {
      PyErr_SetString(PyExc_TypeError,"Expected a pointer");
    }
  }
  return -1;
}

/* Create a new pointer object */
SWIGRUNTIME(PyObject *)
SWIG_NewPointerObj(void *ptr, swig_type_info *type) {
  PyObject *robj;
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#ifdef SWIG_COBJECT_TYPES
  robj = PyCObject_FromVoidPtrAndDesc((void *) ptr, (char *) type->name, NULL);
#else
  {
    char result[512];
    char *r = result;
    *(r++) = '_';
    r = SWIG_PackData(r,&ptr,sizeof(void *));
    strcpy(r,type->name);
    robj = PyString_FromString(result);
  }
#endif
  return robj;
}

SWIGRUNTIME(PyObject *)
SWIG_NewPackedObj(void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  strcpy(r,type->name);
  return PyString_FromString(result);
}

/* Install Constants */
SWIGRUNTIME(void)
SWIG_InstallConstants(PyObject *d, swig_const_info constants[]) {
  int i;
  PyObject *obj;
  for (i = 0; constants[i].type; i++) {
    switch(constants[i].type) {
    case SWIG_PY_INT:
      obj = PyInt_FromLong(constants[i].lvalue);
      break;
    case SWIG_PY_FLOAT:
      obj = PyFloat_FromDouble(constants[i].dvalue);
      break;
    case SWIG_PY_STRING:
      obj = PyString_FromString((char *) constants[i].pvalue);
      break;
    case SWIG_PY_POINTER:
      obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype);
      break;
    default:
      obj = 0;
      break;
    }
    if (obj) {
      PyDict_SetItemString(d,constants[i].name,obj);
      Py_DECREF(obj);
    }
  }
}

#endif

#ifdef __cplusplus
}
#endif







/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_HistoryValidDataIterator swig_types[0] 
#define  SWIGTYPE_p_HistoryIterator swig_types[1] 
#define  SWIGTYPE_p_HistoryValidIterator swig_types[2] 
#define  SWIGTYPE_p_HistoryDataIterator swig_types[3] 
#define  SWIGTYPE_p_GaussianPathGenerator swig_types[4] 
#define  SWIGTYPE_p_GaussianMultiPathGenerator swig_types[5] 
#define  SWIGTYPE_p_TridiagonalOperator swig_types[6] 
#define  SWIGTYPE_p_UniformRandomGenerator swig_types[7] 
#define  SWIGTYPE_p_GaussianRandomGenerator swig_types[8] 
#define  SWIGTYPE_p_FdEuropean swig_types[9] 
#define  SWIGTYPE_p_McEuropean swig_types[10] 
#define  SWIGTYPE_p_InvCumulativeNormalDistribution swig_types[11] 
#define  SWIGTYPE_p_CumulativeNormalDistribution swig_types[12] 
#define  SWIGTYPE_p_NormalDistribution swig_types[13] 
#define  SWIGTYPE_p_CashFlowHandleVector swig_types[14] 
#define  SWIGTYPE_p_DoubleVector swig_types[15] 
#define  SWIGTYPE_p_DateVector swig_types[16] 
#define  SWIGTYPE_p_RateHelperHandleVector swig_types[17] 
#define  SWIGTYPE_p_DMinus swig_types[18] 
#define  SWIGTYPE_p_DPlusDMinus swig_types[19] 
#define  SWIGTYPE_p_DiscreteGeometricASO swig_types[20] 
#define  SWIGTYPE_p_History swig_types[21] 
#define  SWIGTYPE_p_LexicographicalViewColumn swig_types[22] 
#define  SWIGTYPE_p_Date swig_types[23] 
#define  SWIGTYPE_p_DZero swig_types[24] 
#define  SWIGTYPE_p_RiskStatistics swig_types[25] 
#define  SWIGTYPE_p_Statistics swig_types[26] 
#define  SWIGTYPE_p_Brent swig_types[27] 
#define  SWIGTYPE_p_Period swig_types[28] 
#define  SWIGTYPE_p_PyBilinearInterpolation swig_types[29] 
#define  SWIGTYPE_p_PyLinearInterpolation swig_types[30] 
#define  SWIGTYPE_p_SampleNumber swig_types[31] 
#define  SWIGTYPE_p_SegmentIntegral swig_types[32] 
#define  SWIGTYPE_p_Ridder swig_types[33] 
#define  SWIGTYPE_p_HistoryEntry swig_types[34] 
#define  SWIGTYPE_p_DayCounter swig_types[35] 
#define  SWIGTYPE_p_PyCubicSpline swig_types[36] 
#define  SWIGTYPE_p_DPlus swig_types[37] 
#define  SWIGTYPE_p_SamplePath swig_types[38] 
#define  SWIGTYPE_p_Scheduler swig_types[39] 
#define  SWIGTYPE_p_XiborManagerClass swig_types[40] 
#define  SWIGTYPE_p_Array swig_types[41] 
#define  SWIGTYPE_p_McEverest swig_types[42] 
#define  SWIGTYPE_p_McPagoda swig_types[43] 
#define  SWIGTYPE_p_FloatingRateCouponVector swig_types[44] 
#define  SWIGTYPE_p_FixedRateCouponVector swig_types[45] 
#define  SWIGTYPE_p_PeriodVector swig_types[46] 
#define  SWIGTYPE_p_IntVector swig_types[47] 
#define  SWIGTYPE_p_SimpleCashFlowHandle swig_types[48] 
#define  SWIGTYPE_p_CashFlowHandle swig_types[49] 
#define  SWIGTYPE_p_StockHandle swig_types[50] 
#define  SWIGTYPE_p_MarketElementRelinkableHandle swig_types[51] 
#define  SWIGTYPE_p_ObservableHandle swig_types[52] 
#define  SWIGTYPE_p_TermStructureHandle swig_types[53] 
#define  SWIGTYPE_p_TermStructureRelinkableHandle swig_types[54] 
#define  SWIGTYPE_p_ImpliedTermStructureHandle swig_types[55] 
#define  SWIGTYPE_p_ZeroSpreadedTermStructureHandle swig_types[56] 
#define  SWIGTYPE_p_ForwardSpreadedTermStructureHandle swig_types[57] 
#define  SWIGTYPE_p_OptionEngineHandle swig_types[58] 
#define  SWIGTYPE_p_EuropeanEngineHandle swig_types[59] 
#define  SWIGTYPE_p_SwaptionVolatilityStructureHandle swig_types[60] 
#define  SWIGTYPE_p_SwaptionVolatilityStructureRelinkableHandle swig_types[61] 
#define  SWIGTYPE_p_CapFlatVolatilityStructureHandle swig_types[62] 
#define  SWIGTYPE_p_CapFlatVolatilityStructureRelinkableHandle swig_types[63] 
#define  SWIGTYPE_p_Exercise swig_types[64] 
#define  SWIGTYPE_p_EuropeanExercise swig_types[65] 
#define  SWIGTYPE_p_AmericanExercise swig_types[66] 
#define  SWIGTYPE_p_BermudanExercise swig_types[67] 
#define  SWIGTYPE_p_Secant swig_types[68] 
#define  SWIGTYPE_p_McDiscreteArithmeticAPO swig_types[69] 
#define  SWIGTYPE_p_BinaryOption swig_types[70] 
#define  SWIGTYPE_p_Calendar swig_types[71] 
#define  SWIGTYPE_p_Newton swig_types[72] 
#define  SWIGTYPE_p_Path swig_types[73] 
#define  SWIGTYPE_p_McBasket swig_types[74] 
#define  SWIGTYPE_p_BoundaryCondition swig_types[75] 
#define  SWIGTYPE_p_RiskMeasures swig_types[76] 
#define  SWIGTYPE_p_LecuyerUniformRng swig_types[77] 
#define  SWIGTYPE_p_KnuthUniformRng swig_types[78] 
#define  SWIGTYPE_p_FalsePosition swig_types[79] 
#define  SWIGTYPE_p_McDiscreteArithmeticASO swig_types[80] 
#define  SWIGTYPE_p_McHimalaya swig_types[81] 
#define  SWIGTYPE_p_BlackCapFloorHandle swig_types[82] 
#define  SWIGTYPE_p_BlackSwaptionHandle swig_types[83] 
#define  SWIGTYPE_p_BlackModelHandle swig_types[84] 
#define  SWIGTYPE_p_VanillaCollarHandle swig_types[85] 
#define  SWIGTYPE_p_VanillaFloorHandle swig_types[86] 
#define  SWIGTYPE_p_VanillaCapHandle swig_types[87] 
#define  SWIGTYPE_p_SwaptionHandle swig_types[88] 
#define  SWIGTYPE_p_SimpleSwapHandle swig_types[89] 
#define  SWIGTYPE_p_SwapHandle swig_types[90] 
#define  SWIGTYPE_p_FloatingRateCouponHandle swig_types[91] 
#define  SWIGTYPE_p_FixedRateCouponHandle swig_types[92] 
#define  SWIGTYPE_p_XiborHandle swig_types[93] 
#define  SWIGTYPE_p_IndexHandle swig_types[94] 
#define  SWIGTYPE_p_InstrumentHandle swig_types[95] 
#define  SWIGTYPE_p_CompositeMarketElementHandle swig_types[96] 
#define  SWIGTYPE_p_DerivedMarketElementHandle swig_types[97] 
#define  SWIGTYPE_p_SimpleMarketElementHandle swig_types[98] 
#define  SWIGTYPE_p_MarketElementHandle swig_types[99] 
#define  SWIGTYPE_p_FlatForwardHandle swig_types[100] 
#define  SWIGTYPE_p_PlainOptionHandle swig_types[101] 
#define  SWIGTYPE_p_MatrixRow swig_types[102] 
#define  SWIGTYPE_p_PyObserver swig_types[103] 
#define  SWIGTYPE_p_RateHelperHandle swig_types[104] 
#define  SWIGTYPE_p_DepositRateHelperHandle swig_types[105] 
#define  SWIGTYPE_p_FraRateHelperHandle swig_types[106] 
#define  SWIGTYPE_p_FuturesRateHelperHandle swig_types[107] 
#define  SWIGTYPE_p_SwapRateHelperHandle swig_types[108] 
#define  SWIGTYPE_p_PiecewiseFlatForwardHandle swig_types[109] 
#define  SWIGTYPE_p_SwaptionVolatilityMatrixHandle swig_types[110] 
#define  SWIGTYPE_p_CapFlatVolatilityVectorHandle swig_types[111] 
#define  SWIGTYPE_p_Solver1D swig_types[112] 
#define  SWIGTYPE_p_FdDividendEuropeanOption swig_types[113] 
#define  SWIGTYPE_p_FdDividendAmericanOption swig_types[114] 
#define  SWIGTYPE_p_FdDividendShoutOption swig_types[115] 
#define  SWIGTYPE_p_FdBermudanOption swig_types[116] 
#define  SWIGTYPE_p_FdShoutOption swig_types[117] 
#define  SWIGTYPE_p_FdAmericanOption swig_types[118] 
#define  SWIGTYPE_p_EuropeanOption swig_types[119] 
#define  SWIGTYPE_p_CliquetOption swig_types[120] 
#define  SWIGTYPE_p_BarrierOption swig_types[121] 
#define  SWIGTYPE_p_Matrix swig_types[122] 
#define  SWIGTYPE_p_LexicographicalView swig_types[123] 
#define  SWIGTYPE_p_ContinuousGeometricAPO swig_types[124] 
#define  SWIGTYPE_p_DiscreteGeometricAPO swig_types[125] 
#define  SWIGTYPE_p_McMaxBasket swig_types[126] 
#define  SWIGTYPE_p_Bisection swig_types[127] 
#define  SWIGTYPE_p_NewtonSafe swig_types[128] 
#define  SWIGTYPE_p_MultiPath swig_types[129] 
#define  SWIGTYPE_p_SampleMultiPath swig_types[130] 
#define  SWIGTYPE_p_TridiagonalIdentity swig_types[131] 
#define  SWIGTYPE_p_MultivariateAccumulator swig_types[132] 
static swig_type_info *swig_types[134];

/* -------- TYPES TABLE (END) -------- */


/*-----------------------------------------------
              @(target):= QuantLibc.so
  ------------------------------------------------*/
#define SWIG_init    initQuantLibc

#define SWIG_name    "QuantLibc"

#include <ql/quantlib.hpp>

using QuantLib::Error;
using QuantLib::IndexError;


    const int    __hexversion__ = QL_HEX_VERSION;
    const char* __version__    = QL_VERSION;


#include <ql/quantlib.hpp>

#if QL_HEX_VERSION < 0x000300b1
    #error using an old version of QuantLib, please update
#endif

#if PY_VERSION_HEX < 0x02010000
    #error using an old version of Python, please update
#endif

// add here SWIG version check

#if defined(_MSC_VER)         // Microsoft Visual C++ 6.0
// disable Swig dependent useless warning

// 'identifier1' has C-linkage specified,
// but returns UDT 'identifier2' which is incompatible with C
#pragma warning(disable: 4190)

// 'int' : forcing value to bool 'true' or 'false' (performance warning)
#pragma warning(disable: 4800)

#endif



using QuantLib::Pricers::BarrierOption;
typedef QuantLib::Pricers::BarrierOption::BarrierType BarrierType;
using QuantLib::StringFormatter;


using QuantLib::Integer;
using QuantLib::Real;
// using QuantLib::Size;
using QuantLib::Time;
using QuantLib::Rate;
using QuantLib::Spread;
using QuantLib::DiscountFactor;


using QuantLib::Patterns::Observer;
using QuantLib::Patterns::Observable;
using QuantLib::Handle;
typedef Handle<Observer> ObserverHandle;
typedef Handle<Observable> ObservableHandle;


// C++ wrapper for Python observer
// the observables it registers with should be stored from Python
// so that they can be unregistered
class PyObserver : public Observer {
  public:
	PyObserver(PyObject* pyObserverCallback)
	: pyObserverCallback_(pyObserverCallback) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyObserverCallback_);
    }
    PyObserver(const PyObserver& o)
    : pyObserverCallback_(o.pyObserverCallback_) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyObserverCallback_);
    }
    PyObserver& operator=(const PyObserver& o) {
        if ((this != &o) && (pyObserverCallback_ != o.pyObserverCallback_)) {
            Py_XDECREF(pyObserverCallback_);
            pyObserverCallback_ = o.pyObserverCallback_;
    	    Py_XINCREF(pyObserverCallback_);
        }
        return *this;
    }
    ~PyObserver() {
        // now it can go as far as we are concerned
        Py_XDECREF(pyObserverCallback_);
    }
    void update() {
		PyObject* pyResult = PyObject_CallFunction(pyObserverCallback_,NULL);
		QL_ENSURE(pyResult != NULL, "failed to notify Python observer");
		Py_XDECREF(pyResult);
    }
  private:
	PyObject* pyObserverCallback_;
};


#include <ql/null.hpp>


typedef int intOrNull;
typedef double doubleOrNull;


class PyUnaryFunction {
  public:
	PyUnaryFunction(PyObject* pyFunction) : pyFunction_(pyFunction) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyFunction_);
    }
    PyUnaryFunction(const PyUnaryFunction& f) : pyFunction_(f.pyFunction_) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyFunction_);
    }
    PyUnaryFunction& operator=(const PyUnaryFunction& f) {
        if ((this != &f) && (pyFunction_ != f.pyFunction_)) {
            Py_XDECREF(pyFunction_);
            pyFunction_ = f.pyFunction_;
    	    Py_XINCREF(pyFunction_);
        }
        return *this;
    }
    ~PyUnaryFunction() {
        // now it can go as far as we are concerned
        Py_XDECREF(pyFunction_);
    }
	double operator()(double x) const {
		PyObject* pyResult = PyObject_CallFunction(pyFunction_,"d",x);
		QL_ENSURE(pyResult != NULL, "failed to call Python function");
		double result = PyFloat_AsDouble(pyResult);
		Py_XDECREF(pyResult);
		return result;
	}
  private:
	PyObject* pyFunction_;
};

class PyBinaryFunction {
  public:
	PyBinaryFunction(PyObject* pyFunction) : pyFunction_(pyFunction) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyFunction_);
    }
    PyBinaryFunction(const PyBinaryFunction& f)
    : pyFunction_(f.pyFunction_) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyFunction_);
    }
    PyBinaryFunction& operator=(const PyBinaryFunction& f) {
        if ((this != &f) && (pyFunction_ != f.pyFunction_)) {
            Py_XDECREF(pyFunction_);
            pyFunction_ = f.pyFunction_;
    	    Py_XINCREF(pyFunction_);
        }
        return *this;
    }
    ~PyBinaryFunction() {
        // now it can go as far as we are concerned
        Py_XDECREF(pyFunction_);
    }
	double operator()(double x, double y) const {
		PyObject* pyResult = PyObject_CallFunction(pyFunction_,"dd",x,y);
		QL_ENSURE(pyResult != NULL, "failed to call Python function");
		double result = PyFloat_AsDouble(pyResult);
		Py_XDECREF(pyResult);
		return result;
	}
  private:
	PyObject* pyFunction_;
};


using QuantLib::ObjectiveFunction;

class PyObjectiveFunction : public ObjectiveFunction {
  public:
	PyObjectiveFunction(PyObject* pyFunction) : pyFunction_(pyFunction) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyFunction_);
    }
    PyObjectiveFunction(const PyObjectiveFunction& f)
    : pyFunction_(f.pyFunction_) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyFunction_);
    }
    PyObjectiveFunction& operator=(const PyObjectiveFunction& f) {
        if ((this != &f) && (pyFunction_ != f.pyFunction_)) {
            Py_XDECREF(pyFunction_);
            pyFunction_ = f.pyFunction_;
    	    Py_XINCREF(pyFunction_);
        }
        return *this;
    }
    ~PyObjectiveFunction() {
        // now it can go as far as we are concerned
        Py_XDECREF(pyFunction_);
    }
	double operator()(double x) const {
		PyObject* pyResult = PyObject_CallFunction(pyFunction_,"d",x);
		QL_ENSURE(pyResult != NULL, "failed to call Python function");
		double result = PyFloat_AsDouble(pyResult);
		Py_XDECREF(pyResult);
		return result;
	}
	double derivative(double x) const {
		PyObject* pyResult =
		  PyObject_CallMethod(pyFunction_,"derivative","d",x);
		QL_ENSURE(pyResult != NULL,
		  "failed to call derivative() on Python object");
		double result = PyFloat_AsDouble(pyResult);
		Py_XDECREF(pyResult);
		return result;
	}
  private:
	PyObject* pyFunction_;
};


using QuantLib::MarketElement;
using QuantLib::Handle;
using QuantLib::RelinkableHandle;
typedef Handle<MarketElement> MarketElementHandle;
typedef RelinkableHandle<MarketElement> MarketElementRelinkableHandle;


// its C++ wrapper
class PyMarketElement : public MarketElement {
  public:
	PyMarketElement(PyObject* pyMarketElement)
	: pyMarketElement_(pyMarketElement) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyMarketElement_);
    }
    PyMarketElement(const PyMarketElement& me)
    : pyMarketElement_(me.pyMarketElement_) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyMarketElement_);
    }
    PyMarketElement& operator=(const PyMarketElement& me) {
        if ((this != &me) && (pyMarketElement_ != me.pyMarketElement_)) {
            Py_XDECREF(pyMarketElement_);
            pyMarketElement_ = me.pyMarketElement_;
    	    Py_XINCREF(pyMarketElement_);
        }
        return *this;
    }
    ~PyMarketElement() {
        // now it can go as far as we are concerned
        Py_XDECREF(pyMarketElement_);
    }
	double value() const {
		PyObject* pyResult =
		  PyObject_CallMethod(pyMarketElement_,"value",NULL);
		QL_ENSURE(pyResult != NULL,
		  "failed to call value() on Python market element");
		double result = PyFloat_AsDouble(pyResult);
		Py_XDECREF(pyResult);
		return result;
	}
  private:
	PyObject* pyMarketElement_;
};


    using QuantLib::SimpleMarketElement;
    typedef Handle<SimpleMarketElement> SimpleMarketElementHandle;


using QuantLib::DerivedMarketElement;
using QuantLib::CompositeMarketElement;
typedef Handle<DerivedMarketElement<PyUnaryFunction> >
    DerivedMarketElementHandle;
typedef Handle<CompositeMarketElement<PyBinaryFunction> >
    CompositeMarketElementHandle;


typedef std::string String;


	typedef std::vector<std::string> StringVector;


#include <cstdlib>
using QuantLib::Instrument;
using QuantLib::Handle;
typedef Handle<Instrument> InstrumentHandle;


    using QuantLib::Instruments::Stock;
    typedef Handle<Stock> StockHandle;


#include <vector>
typedef std::vector<int> IntVector;
typedef std::vector<double> DoubleVector;
using QuantLib::Null;
using QuantLib::IntegerFormatter;
using QuantLib::DoubleFormatter;


#include <cstdlib>
#include <string>
using QuantLib::Date;

using QuantLib::Day;
using QuantLib::Year;


using QuantLib::Weekday;
using QuantLib::Sunday;
using QuantLib::Monday;
using QuantLib::Tuesday;
using QuantLib::Wednesday;
using QuantLib::Thursday;
using QuantLib::Friday;
using QuantLib::Saturday;

using QuantLib::StringFormatter;
using QuantLib::DateFormatter;


using QuantLib::Month;
using QuantLib::January;
using QuantLib::February;
using QuantLib::March;
using QuantLib::April;
using QuantLib::May;
using QuantLib::June;
using QuantLib::July;
using QuantLib::August;
using QuantLib::September;
using QuantLib::October;
using QuantLib::November;
using QuantLib::December;


using QuantLib::TimeUnit;
using QuantLib::Days;
using QuantLib::Weeks;
using QuantLib::Months;
using QuantLib::Years;


using QuantLib::Period;


typedef std::vector<Period> PeriodVector;


    Date DateFromSerialNumber(int serialNumber) {
        return Date(serialNumber);
    }


typedef std::vector<Date> DateVector;


typedef std::vector<Date> DateVector;


using QuantLib::RollingConvention;
using QuantLib::Preceding;
using QuantLib::ModifiedPreceding;
using QuantLib::Following;
using QuantLib::ModifiedFollowing;


using QuantLib::Calendar;
using QuantLib::Calendars::Frankfurt;
using QuantLib::Calendars::Helsinki;
using QuantLib::Calendars::Johannesburg;
using QuantLib::Calendars::London;
using QuantLib::Calendars::Milan;
using QuantLib::Calendars::NewYork;
using QuantLib::Calendars::TARGET;
using QuantLib::Calendars::Tokyo;
using QuantLib::Calendars::Toronto;
using QuantLib::Calendars::Sydney;
using QuantLib::Calendars::Wellington;
using QuantLib::Calendars::Zurich;


using QuantLib::DayCounter;
using QuantLib::DayCounters::Actual360;
using QuantLib::DayCounters::Actual365;
using QuantLib::DayCounters::ActualActual;
using QuantLib::DayCounters::Thirty360;


using QuantLib::Currency;
using QuantLib::EUR;
using QuantLib::USD;
using QuantLib::GBP;
using QuantLib::DEM;
using QuantLib::ITL;
using QuantLib::CHF;
using QuantLib::AUD;
using QuantLib::CAD;
using QuantLib::DKK;
using QuantLib::JPY;
using QuantLib::PLZ;
using QuantLib::SEK;
using QuantLib::CZK;
using QuantLib::EEK;
using QuantLib::ISK;
using QuantLib::NOK;
using QuantLib::SKK;
using QuantLib::HKD;
using QuantLib::NZD;
using QuantLib::SGD;
using QuantLib::GRD;
using QuantLib::HUF;
using QuantLib::LVL;
using QuantLib::ROL;
using QuantLib::BGL;
using QuantLib::CYP;
using QuantLib::LTL;
using QuantLib::MTL;
using QuantLib::TRL;
using QuantLib::ZAR;
using QuantLib::SIT;
using QuantLib::KRW;
using QuantLib::StringFormatter;
using QuantLib::CurrencyFormatter;


using QuantLib::TermStructure;
using QuantLib::Handle;
using QuantLib::RelinkableHandle;
typedef Handle<TermStructure> TermStructureHandle;
typedef RelinkableHandle<TermStructure> TermStructureRelinkableHandle;


using QuantLib::ImpliedTermStructure;
typedef Handle<ImpliedTermStructure> ImpliedTermStructureHandle;


using QuantLib::ZeroSpreadedTermStructure;
typedef Handle<ZeroSpreadedTermStructure> ZeroSpreadedTermStructureHandle;


using QuantLib::ForwardSpreadedTermStructure;
typedef Handle<ForwardSpreadedTermStructure>
    ForwardSpreadedTermStructureHandle;


using QuantLib::TermStructures::FlatForward;
typedef Handle<FlatForward> FlatForwardHandle;


using QuantLib::Option;
typedef Option::Type OptionType;
using QuantLib::StringFormatter;


using QuantLib::OptionPricingEngine;
typedef Handle<OptionPricingEngine> OptionEngineHandle;


using QuantLib::Instruments::PlainOption;
typedef Handle<PlainOption> PlainOptionHandle;


using QuantLib::Pricers::EuropeanEngine;
typedef Handle<EuropeanEngine> EuropeanEngineHandle;


using QuantLib::Exercise;
typedef Exercise::Type ExerciseType;
using QuantLib::StringFormatter;


using QuantLib::EuropeanExercise;
using QuantLib::AmericanExercise;
using QuantLib::BermudanExercise;


using QuantLib::History;
typedef QuantLib::History::Entry HistoryEntry;
typedef QuantLib::History::const_iterator HistoryIterator;
typedef QuantLib::History::const_valid_iterator HistoryValidIterator;
typedef QuantLib::History::const_data_iterator HistoryDataIterator;
typedef QuantLib::History::const_valid_data_iterator HistoryValidDataIterator;
using QuantLib::DateFormatter;
using QuantLib::DoubleFormatter;


    typedef QuantLib::Indexes::XiborManager XiborManagerClass;


    XiborManagerClass XiborManager;


using QuantLib::Handle;
using QuantLib::Index;
typedef Handle<Index> IndexHandle;


using QuantLib::Indexes::Xibor;
using QuantLib::Indexes::Euribor;
using QuantLib::Indexes::AUDLibor;
using QuantLib::Indexes::GBPLibor;
using QuantLib::Indexes::USDLibor;
using QuantLib::Indexes::JPYLibor;
using QuantLib::Indexes::CADLibor;
using QuantLib::Indexes::CHFLibor;
using QuantLib::Indexes::ZARLibor;
typedef Handle<Xibor> XiborHandle;


XiborHandle NewEuribor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new Euribor(n,units,h)); }
XiborHandle NewAUDLibor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new AUDLibor(n,units,h)); }
XiborHandle NewGBPLibor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new GBPLibor(n,units,h)); }
XiborHandle NewUSDLibor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new USDLibor(n,units,h)); }
XiborHandle NewJPYLibor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new JPYLibor(n,units,h)); }
XiborHandle NewCADLibor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new CADLibor(n,units,h)); }
XiborHandle NewCHFLibor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new CHFLibor(n,units,h)); }
XiborHandle NewZARLibor(int n, TimeUnit units,
    TermStructureRelinkableHandle h) {
        return XiborHandle(new ZARLibor(n,units,h)); }


    using QuantLib::Handle;
    using QuantLib::CashFlow;
    using QuantLib::CashFlows::SimpleCashFlow;
    using QuantLib::CashFlows::FixedRateCoupon;
    using QuantLib::CashFlows::FloatingRateCoupon;
    typedef Handle<CashFlow> CashFlowHandle;
    typedef Handle<SimpleCashFlow> SimpleCashFlowHandle;
    typedef Handle<FixedRateCoupon> FixedRateCouponHandle;
    typedef Handle<FloatingRateCoupon> FloatingRateCouponHandle;


// its C++ wrapper
class PyCashFlow : public CashFlow {
  public:
	PyCashFlow(PyObject* pyCashFlow) : pyCashFlow_(pyCashFlow) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyCashFlow_);
    }
    PyCashFlow(const PyCashFlow& cf)
    : pyCashFlow_(cf.pyCashFlow_) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyCashFlow_);
    }
    PyCashFlow& operator=(const PyCashFlow& cf) {
        if ((this != &cf) && (pyCashFlow_ != cf.pyCashFlow_)) {
            Py_XDECREF(pyCashFlow_);
            pyCashFlow_ = cf.pyCashFlow_;
    	    Py_XINCREF(pyCashFlow_);
        }
        return *this;
    }
    ~PyCashFlow() {
        // now it can go as far as we are concerned
        Py_XDECREF(pyCashFlow_);
    }
	double amount() const {
		PyObject* pyResult =
		  PyObject_CallMethod(pyCashFlow_,"amount",NULL);
		QL_ENSURE(pyResult != NULL,
		  "failed to call amount() on Python cash flow");
		double result = PyFloat_AsDouble(pyResult);
		Py_XDECREF(pyResult);
		return result;
	}
	Date date() const {
		PyObject* pyResult =
		  PyObject_CallMethod(pyCashFlow_,"date",NULL);
		QL_ENSURE(pyResult != NULL,
		  "failed to call date() on Python cash flow");
		Date result, *x;
        if ((SWIG_ConvertPtr(pyResult,(void **)&x,SWIGTYPE_p_Date,0)) != -1) {
                result = *x;
                Py_XDECREF(pyResult);
        } else {
            Py_XDECREF(pyResult);
            throw Error("calling date() on Python cash flow "
                        "did not return a Date");
        }
        return result;
	}
  private:
	PyObject* pyCashFlow_;
};


typedef std::vector<CashFlowHandle> CashFlowHandleVector;


typedef std::vector<CashFlowHandle> CashFlowHandleVector;


using QuantLib::CashFlows::FixedRateCouponVector;
using QuantLib::CashFlows::FloatingRateCouponVector;


using QuantLib::Instruments::Swap;
using QuantLib::Instruments::SimpleSwap;
typedef Handle<Swap> SwapHandle;
typedef Handle<SimpleSwap> SimpleSwapHandle;


using QuantLib::Handle;
using QuantLib::Instruments::Swaption;
using QuantLib::Instruments::VanillaCap;
using QuantLib::Instruments::VanillaFloor;
using QuantLib::Instruments::VanillaCollar;
typedef Handle<Swaption> SwaptionHandle;
typedef Handle<VanillaCap> VanillaCapHandle;
typedef Handle<VanillaFloor> VanillaFloorHandle;
typedef Handle<VanillaCollar> VanillaCollarHandle;


using QuantLib::InterestRateModelling::BlackModel;
typedef Handle<BlackModel> BlackModelHandle;


using QuantLib::Pricers::BlackSwaption;
using QuantLib::Pricers::BlackCapFloor;
typedef Handle<BlackSwaption> BlackSwaptionHandle;
typedef Handle<BlackCapFloor> BlackCapFloorHandle;


using QuantLib::FiniteDifferences::BoundaryCondition;
typedef BoundaryCondition::Type BoundaryConditionType;
using QuantLib::StringFormatter;


using QuantLib::Math::NormalDistribution;
using QuantLib::Math::CumulativeNormalDistribution;
using QuantLib::Math::InvCumulativeNormalDistribution;


using QuantLib::Pricers::FdAmericanOption;
using QuantLib::Pricers::FdBermudanOption;
using QuantLib::Pricers::FdDividendAmericanOption;
using QuantLib::Pricers::FdDividendEuropeanOption;
using QuantLib::Pricers::FdDividendShoutOption;
using QuantLib::Pricers::FdEuropean;
using QuantLib::Pricers::FdShoutOption;


using QuantLib::Array;
typedef QuantLib::Math::LexicographicalView<Array::iterator>
    LexicographicalView;
typedef QuantLib::Math::LexicographicalView<Array::iterator>::y_iterator
    LexicographicalViewColumn;


using QuantLib::Math::Matrix;
typedef QuantLib::Math::Matrix::row_iterator MatrixRow;
using QuantLib::Math::outerProduct;
using QuantLib::Math::transpose;
using QuantLib::Math::matrixSqrt;


    Matrix matrixProduct(const Matrix& m1, const Matrix& m2) {
        return m1*m2;
    }


using QuantLib::Array;
using QuantLib::Math::Matrix;
using QuantLib::Handle;
using QuantLib::Math::Interpolation;
using QuantLib::Math::LinearInterpolation;
using QuantLib::Math::CubicSpline;
using QuantLib::Math::Interpolation2D;
using QuantLib::Math::BilinearInterpolation;

// safe versions which copy their arguments
// Python users are not supposed to worry about lifetimes
class PyInterpolation {
  public:
    PyInterpolation(const Array& x, const Array& y, bool allowExtrapolation)
    : x_(x), y_(y) {}
    double __call__(double x) { return (*f_)(x); }
  protected:
    Array x_, y_;
    Handle<Interpolation<Array::const_iterator,
                         Array::const_iterator> > f_;
};

class PyInterpolation2D {
  public:
    PyInterpolation2D(const Array& x, const Array& y, const Matrix& m, bool allowExtrapolation)
    : x_(x), y_(y), m_(m) {}
    double __call__(double x, double y) { return (*f_)(x,y); }
  protected:
    Array x_, y_;
    Matrix m_;
    Handle<Interpolation2D<Array::const_iterator,
                           Array::const_iterator,
                           Matrix> > f_;
};


class PyLinearInterpolation : public PyInterpolation {
  public:
    PyLinearInterpolation(const Array& x, const Array& y, bool allowExtrapolation)
    : PyInterpolation(x,y,allowExtrapolation) {
        f_ = Handle<Interpolation<Array::const_iterator,
                                  Array::const_iterator> >(
                new LinearInterpolation<Array::const_iterator,
                                        Array::const_iterator>(
                    x_.begin(),x_.end(),y_.begin(), allowExtrapolation));
    }
};

class PyCubicSpline : public PyInterpolation {
  public:
    PyCubicSpline(const Array& x, const Array& y, bool allowExtrapolation)
    : PyInterpolation(x,y,allowExtrapolation) {
        f_ = Handle<Interpolation<Array::const_iterator,
                                  Array::const_iterator> >(
                new CubicSpline<Array::const_iterator,
                                Array::const_iterator>(
                    x_.begin(),x_.end(),y_.begin(), allowExtrapolation));
    }
};


class PyBilinearInterpolation : public PyInterpolation2D {
  public:
    PyBilinearInterpolation(const Array& x, const Array& y, const Matrix& m, bool allowExtrapolation)
    : PyInterpolation2D(x,y,m,allowExtrapolation) {
        f_ = Handle<Interpolation2D<Array::const_iterator,
                                    Array::const_iterator,
                                    Matrix> >(
                new BilinearInterpolation<Array::const_iterator,
                                          Array::const_iterator,
                                          Matrix>(
                    x_.begin(),x_.end(),y_.begin(),y_.end(),m_, allowExtrapolation));
    }
};


// single asset
using QuantLib::Pricers::McDiscreteArithmeticAPO;
using QuantLib::Pricers::McDiscreteArithmeticASO;
using QuantLib::Pricers::McEuropean;

// multi asset
using QuantLib::Pricers::McBasket;
using QuantLib::Pricers::McMaxBasket;
using QuantLib::Pricers::McEverest;
using QuantLib::Pricers::McHimalaya;
using QuantLib::Pricers::McPagoda;


using QuantLib::MonteCarlo::GaussianMultiPathGenerator;
using QuantLib::MonteCarlo::getCovariance;


using QuantLib::MonteCarlo::Path;
using QuantLib::MonteCarlo::GaussianPathGenerator;
typedef QuantLib::MonteCarlo::Sample<QuantLib::MonteCarlo::Path> SamplePath;


using QuantLib::MonteCarlo::Path;
using QuantLib::MonteCarlo::MultiPath;
using QuantLib::MonteCarlo::GaussianMultiPathGenerator;
typedef QuantLib::MonteCarlo::Sample<QuantLib::MonteCarlo::MultiPath>
    SampleMultiPath;


using QuantLib::FiniteDifferences::TridiagonalOperator;


typedef TridiagonalOperator TridiagonalIdentity;
using QuantLib::FiniteDifferences::DPlus;
using QuantLib::FiniteDifferences::DMinus;
using QuantLib::FiniteDifferences::DZero;
using QuantLib::FiniteDifferences::DPlusDMinus;


using QuantLib::FiniteDifferences::valueAtCenter;
using QuantLib::FiniteDifferences::firstDerivativeAtCenter;
using QuantLib::FiniteDifferences::secondDerivativeAtCenter;


using QuantLib::Math::SymmetricEigenvalues;
using QuantLib::Math::SymmetricEigenvectors;


    using QuantLib::Handle;
    using QuantLib::TermStructures::RateHelper;
    using QuantLib::TermStructures::DepositRateHelper;
    using QuantLib::TermStructures::FraRateHelper;
    using QuantLib::TermStructures::FuturesRateHelper;
    using QuantLib::TermStructures::SwapRateHelper;
    typedef Handle<RateHelper> RateHelperHandle;
    typedef Handle<DepositRateHelper> DepositRateHelperHandle;
    typedef Handle<FraRateHelper> FraRateHelperHandle;
    typedef Handle<FuturesRateHelper> FuturesRateHelperHandle;
    typedef Handle<SwapRateHelper> SwapRateHelperHandle;


typedef std::vector<RateHelperHandle> RateHelperHandleVector;


typedef std::vector<RateHelperHandle> RateHelperHandleVector;


using QuantLib::TermStructures::PiecewiseFlatForward;
typedef Handle<PiecewiseFlatForward> PiecewiseFlatForwardHandle;


using QuantLib::Pricers::BarrierOption;
using QuantLib::Pricers::BinaryOption;
using QuantLib::Pricers::CliquetOption;
using QuantLib::Pricers::ContinuousGeometricAPO;
using QuantLib::Pricers::DiscreteGeometricAPO;
using QuantLib::Pricers::DiscreteGeometricASO;
using QuantLib::Pricers::EuropeanOption;


using QuantLib::RandomNumbers::UniformRandomGenerator;
using QuantLib::RandomNumbers::GaussianRandomGenerator;
using QuantLib::RandomNumbers::LecuyerUniformRng;
using QuantLib::RandomNumbers::KnuthUniformRng;
typedef QuantLib::MonteCarlo::Sample<double> SampleNumber;


using QuantLib::RiskStatistics;
using QuantLib::Math::RiskMeasures;


using QuantLib::Scheduler;


using QuantLib::Solver1D;
using QuantLib::Solvers1D::Bisection;
using QuantLib::Solvers1D::Brent;
using QuantLib::Solvers1D::FalsePosition;
using QuantLib::Solvers1D::Newton;
using QuantLib::Solvers1D::NewtonSafe;
using QuantLib::Solvers1D::Ridder;
using QuantLib::Solvers1D::Secant;


using QuantLib::Math::SegmentIntegral;


using QuantLib::Math::Statistics;


using QuantLib::Math::MultivariateAccumulator;


using QuantLib::SwaptionVolatilityStructure;
using QuantLib::Handle;
using QuantLib::RelinkableHandle;
typedef Handle<SwaptionVolatilityStructure>
    SwaptionVolatilityStructureHandle;
typedef RelinkableHandle<SwaptionVolatilityStructure>
    SwaptionVolatilityStructureRelinkableHandle;


using QuantLib::CapFlatVolatilityStructure;
using QuantLib::Handle;
using QuantLib::RelinkableHandle;
typedef Handle<CapFlatVolatilityStructure>
    CapFlatVolatilityStructureHandle;
typedef RelinkableHandle<CapFlatVolatilityStructure>
    CapFlatVolatilityStructureRelinkableHandle;


using QuantLib::Volatilities::SwaptionVolatilityMatrix;
typedef Handle<SwaptionVolatilityMatrix> SwaptionVolatilityMatrixHandle;


using QuantLib::Volatilities::CapFlatVolatilityVector;
typedef Handle<CapFlatVolatilityVector> CapFlatVolatilityVectorHandle;

#ifdef __cplusplus
extern "C" {
#endif
static int _wrap___hexversion___set(PyObject *val) {
    PyErr_SetString(PyExc_TypeError,"Variable __hexversion__ is read-only.");
    return 1;
}


static PyObject *_wrap___hexversion___get() {
    PyObject *pyobj;
    
    pyobj = PyInt_FromLong((long) __hexversion__);
    return pyobj;
}


static int _wrap___version___set(PyObject *val) {
    PyErr_SetString(PyExc_TypeError,"Variable __version__ is read-only.");
    return 1;
}


static PyObject *_wrap___version___get() {
    PyObject *pyobj;
    
    if (__version__)
    pyobj = PyString_FromString(__version__);
    else pyobj = PyString_FromString("(NULL)");
    return pyobj;
}


static PyObject *_wrap_delete_ObservableHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    ObservableHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_ObservableHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_ObservableHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_new_Observer(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PyObject *arg0 ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "pyObserverCallback", NULL 
    };
    PyObserver *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_Observer",kwnames,&obj0)) return NULL;
    {
        arg0 = obj0;
    }
    {
        try {
            result = (PyObserver *)new PyObserver(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_PyObserver);
    return resultobj;
}


static PyObject *_wrap_delete_PyObserver(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PyObserver *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_PyObserver",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PyObserver,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_Observer_registerWith(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PyObserver *arg0 ;
    ObservableHandle *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","arg1", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:Observer_registerWith",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PyObserver,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_ObservableHandle,1)) == -1) return NULL;
    {
        try {
            arg0->registerWith((ObservableHandle const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_Observer_unregisterWith(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PyObserver *arg0 ;
    ObservableHandle *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","arg1", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:Observer_unregisterWith",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PyObserver,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_ObservableHandle,1)) == -1) return NULL;
    {
        try {
            arg0->unregisterWith((ObservableHandle const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_delete_MarketElementHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_MarketElementHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MarketElementHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


MarketElementHandle * new_MarketElementHandle(PyObject *pyMarketElement) {
    {
        return new MarketElementHandle(new PyMarketElement(pyMarketElement));
    }
}


static PyObject *_wrap_new_MarketElement(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PyObject *arg0 ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "pyMarketElement", NULL 
    };
    MarketElementHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_MarketElement",kwnames,&obj0)) return NULL;
    {
        arg0 = obj0;
    }
    {
        try {
            result = (MarketElementHandle *)new_MarketElementHandle(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_MarketElementHandle);
    return resultobj;
}


double MarketElementHandle_value(MarketElementHandle *self) {
    {
        return (*self)->value();
    }
}


static PyObject *_wrap_MarketElement_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:MarketElement_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MarketElementHandle,1)) == -1) return NULL;
    {
        try {
            result = (double )MarketElementHandle_value(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


bool MarketElementHandle___nonzero__(MarketElementHandle *self) {
    {
        return !self->isNull();
    }
}


static PyObject *_wrap_MarketElement___nonzero__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:MarketElement___nonzero__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MarketElementHandle,1)) == -1) return NULL;
    {
        try {
            result = (bool )MarketElementHandle___nonzero__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


void MarketElementHandle_notifyObservers(MarketElementHandle *self) {
    {
        (*self)->notifyObservers();
    }
}


static PyObject *_wrap_MarketElement_notifyObservers(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:MarketElement_notifyObservers",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MarketElementHandle,1)) == -1) return NULL;
    {
        try {
            MarketElementHandle_notifyObservers(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_new_MarketElementHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementHandle *arg0 ;
    MarketElementHandle temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "h", NULL 
    };
    MarketElementRelinkableHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_MarketElementHandle",kwnames,&obj0)) return NULL;
    {
        MarketElementHandle* x;
        if (obj0 == Py_None) {
            temp = MarketElementHandle();
            arg0 = &temp;
        }else if ((SWIG_ConvertPtr(obj0,(void **) &x,
        SWIGTYPE_p_MarketElementHandle,0)) != -1) {
            arg0 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"MarketElement" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (MarketElementRelinkableHandle *)new MarketElementRelinkableHandle(*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_MarketElementRelinkableHandle);
    return resultobj;
}


static PyObject *_wrap_delete_MarketElementRelinkableHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementRelinkableHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_MarketElementRelinkableHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_MarketElementHandle_linkTo(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementRelinkableHandle *arg0 ;
    MarketElementHandle *arg1 ;
    PyObject * argo0 =0 ;
    MarketElementHandle temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","arg1", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:MarketElementHandle_linkTo",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    {
        MarketElementHandle* x;
        if (obj1 == Py_None) {
            temp = MarketElementHandle();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_MarketElementHandle,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"MarketElement" " expected");
            return NULL;
        }
    }
    {
        try {
            arg0->linkTo(*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


bool MarketElementRelinkableHandle___nonzero__(MarketElementRelinkableHandle *self) {
    {
        return !self->isNull();
    }
}


static PyObject *_wrap_MarketElementHandle___nonzero__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementRelinkableHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:MarketElementHandle___nonzero__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            result = (bool )MarketElementRelinkableHandle___nonzero__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_delete_SimpleMarketElementHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SimpleMarketElementHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_SimpleMarketElementHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SimpleMarketElementHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


SimpleMarketElementHandle * new_SimpleMarketElementHandle(double value) {
    {
        return new SimpleMarketElementHandle(
        new SimpleMarketElement(value));
    }
}


static PyObject *_wrap_new_SimpleMarketElement(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    double arg0 ;
    char *kwnames[] = {
        "value", NULL 
    };
    SimpleMarketElementHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"d:new_SimpleMarketElement",kwnames,&arg0)) return NULL;
    {
        try {
            result = (SimpleMarketElementHandle *)new_SimpleMarketElementHandle(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SimpleMarketElementHandle);
    return resultobj;
}


void SimpleMarketElementHandle_setValue(SimpleMarketElementHandle *self,double value) {
    {
        (*self)->setValue(value);
    }
}


static PyObject *_wrap_SimpleMarketElement_setValue(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SimpleMarketElementHandle *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","value", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:SimpleMarketElement_setValue",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SimpleMarketElementHandle,1)) == -1) return NULL;
    {
        try {
            SimpleMarketElementHandle_setValue(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_delete_DerivedMarketElementHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DerivedMarketElementHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_DerivedMarketElementHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DerivedMarketElementHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


DerivedMarketElementHandle * new_DerivedMarketElementHandle(MarketElementRelinkableHandle h,PyObject *pyFunction) {
    {
        return new DerivedMarketElementHandle(
        new DerivedMarketElement<PyUnaryFunction>(
        h,PyUnaryFunction(pyFunction)));
    }
}


static PyObject *_wrap_new_DerivedMarketElement(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementRelinkableHandle *arg0 ;
    PyObject *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "h","pyFunction", NULL 
    };
    DerivedMarketElementHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:new_DerivedMarketElement",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    {
        arg1 = obj1;
    }
    {
        try {
            result = (DerivedMarketElementHandle *)new_DerivedMarketElementHandle(*arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DerivedMarketElementHandle);
    return resultobj;
}


static PyObject *_wrap_delete_CompositeMarketElementHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CompositeMarketElementHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_CompositeMarketElementHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CompositeMarketElementHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


CompositeMarketElementHandle * new_CompositeMarketElementHandle(MarketElementRelinkableHandle h1,MarketElementRelinkableHandle h2,PyObject *pyFunction) {
    {
        return new CompositeMarketElementHandle(
        new CompositeMarketElement<PyBinaryFunction>(
        h1,h2,PyBinaryFunction(pyFunction)));
    }
}


static PyObject *_wrap_new_CompositeMarketElement(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementRelinkableHandle *arg0 ;
    MarketElementRelinkableHandle *arg1 ;
    PyObject *arg2 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    PyObject * obj2  = 0 ;
    char *kwnames[] = {
        "h1","h2","pyFunction", NULL 
    };
    CompositeMarketElementHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOO:new_CompositeMarketElement",kwnames,&argo0,&argo1,&obj2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    {
        arg2 = obj2;
    }
    {
        try {
            result = (CompositeMarketElementHandle *)new_CompositeMarketElementHandle(*arg0,*arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_CompositeMarketElementHandle);
    return resultobj;
}


static PyObject *_wrap_delete_InstrumentHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    InstrumentHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_InstrumentHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_InstrumentHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


String InstrumentHandle_isinCode(InstrumentHandle *self) {
    {
        return (*self)->isinCode();
    }
}


static PyObject *_wrap_Instrument_isinCode(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    InstrumentHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Instrument_isinCode",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_InstrumentHandle,1)) == -1) return NULL;
    {
        try {
            result = new String (InstrumentHandle_isinCode(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


String InstrumentHandle_description(InstrumentHandle *self) {
    {
        return (*self)->description();
    }
}


static PyObject *_wrap_Instrument_description(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    InstrumentHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Instrument_description",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_InstrumentHandle,1)) == -1) return NULL;
    {
        try {
            result = new String (InstrumentHandle_description(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


double InstrumentHandle_NPV(InstrumentHandle *self) {
    {
        return (*self)->NPV();
    }
}


static PyObject *_wrap_Instrument_NPV(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    InstrumentHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Instrument_NPV",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_InstrumentHandle,1)) == -1) return NULL;
    {
        try {
            result = (double )InstrumentHandle_NPV(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


bool InstrumentHandle_isExpired(InstrumentHandle *self) {
    {
        return (*self)->isExpired();
    }
}


static PyObject *_wrap_Instrument_isExpired(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    InstrumentHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Instrument_isExpired",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_InstrumentHandle,1)) == -1) return NULL;
    {
        try {
            result = (bool )InstrumentHandle_isExpired(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


void InstrumentHandle_recalculate(InstrumentHandle *self) {
    {
        (*self)->recalculate();
    }
}


static PyObject *_wrap_Instrument_recalculate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    InstrumentHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Instrument_recalculate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_InstrumentHandle,1)) == -1) return NULL;
    {
        try {
            InstrumentHandle_recalculate(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


String InstrumentHandle___str__(InstrumentHandle *self) {
    {
        if (self->isNull())
        return "Null instrument";
        std::string isin = (*self)->isinCode();
        if (isin == "")
        isin = "unknown";
        std::string desc = (*self)->description();
        if (desc == "")
        desc = "no description available";
        return ("Instrument: "+isin+" ("+desc+")");
    }
}


static PyObject *_wrap_Instrument___str__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    InstrumentHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Instrument___str__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_InstrumentHandle,1)) == -1) return NULL;
    {
        try {
            result = new String (InstrumentHandle___str__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


int InstrumentHandle___cmp__(InstrumentHandle *self,InstrumentHandle const &other) {
    {
        return ((*self)->isinCode() == other->isinCode() ? 0 : 1);
    }
}


static PyObject *_wrap_Instrument___cmp__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    InstrumentHandle *arg0 ;
    InstrumentHandle *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","other", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:Instrument___cmp__",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_InstrumentHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_InstrumentHandle,1)) == -1) return NULL;
    {
        try {
            result = (int )InstrumentHandle___cmp__(arg0,(InstrumentHandle const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


bool InstrumentHandle___nonzero__(InstrumentHandle *self) {
    {
        return !self->isNull();
    }
}


static PyObject *_wrap_Instrument___nonzero__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    InstrumentHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Instrument___nonzero__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_InstrumentHandle,1)) == -1) return NULL;
    {
        try {
            result = (bool )InstrumentHandle___nonzero__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_delete_StockHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    StockHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_StockHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_StockHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


StockHandle * new_StockHandle(MarketElementRelinkableHandle quote,String isinCode,String description) {
    {
        return new StockHandle(new Stock(quote,isinCode,description));
    }
}


static PyObject *_wrap_new_Stock(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementRelinkableHandle *arg0 ;
    String *arg1 ;
    String *arg2 ;
    PyObject * argo0 =0 ;
    PyObject * obj1  = 0 ;
    PyObject * obj2  = 0 ;
    char *kwnames[] = {
        "quote","isinCode","description", NULL 
    };
    StockHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOO:new_Stock",kwnames,&argo0,&obj1,&obj2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    {
        if (PyString_Check(obj1)) {
            arg1 = new std::string(PyString_AsString(obj1));
        }else {
            PyErr_SetString(PyExc_TypeError,"not a string");
            return NULL;
        }
    }
    {
        if (PyString_Check(obj2)) {
            arg2 = new std::string(PyString_AsString(obj2));
        }else {
            PyErr_SetString(PyExc_TypeError,"not a string");
            return NULL;
        }
    }
    {
        try {
            result = (StockHandle *)new_StockHandle(*arg0,*arg1,*arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_StockHandle);
    {
        delete arg1;
    }
    {
        delete arg2;
    }
    return resultobj;
}


static PyObject *_wrap_delete_IntVector(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    IntVector *arg0 ;
    IntVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_IntVector",kwnames,&obj0)) return NULL;
    {
        IntVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = IntVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<int>();
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = int(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"ints expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_IntVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"IntVector expected");
            return NULL;
        }
    }
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


IntVector * new_IntVector(IntVector const &v) {
    {
        return new IntVector(v);
    }
}


static PyObject *_wrap_new_IntVector(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    IntVector *arg0 ;
    IntVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "v", NULL 
    };
    IntVector *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_IntVector",kwnames,&obj0)) return NULL;
    {
        IntVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = IntVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<int>();
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = int(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"ints expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_IntVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"IntVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (IntVector *)new_IntVector((IntVector const &)*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_IntVector);
    return resultobj;
}


String IntVector___str__(IntVector *self) {
    {
        String s = "(";
        /*Size */ int size_ = self->size();
        if (size_>0) {
            for (/* Size */ int i=0; i<size_-1; i++) {
                s += IntegerFormatter::toString((*self)[i]);
                s += ", ";
            }
            s += IntegerFormatter::toString((*self)[self->size()-1]);
        }
        s += ")";
        return s;
    }
}


static PyObject *_wrap_IntVector___str__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    IntVector *arg0 ;
    IntVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:IntVector___str__",kwnames,&obj0)) return NULL;
    {
        IntVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = IntVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<int>();
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = int(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"ints expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_IntVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"IntVector expected");
            return NULL;
        }
    }
    {
        try {
            result = new String (IntVector___str__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


int IntVector___len__(IntVector *self) {
    {
        return self->size();
    }
}


static PyObject *_wrap_IntVector___len__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    IntVector *arg0 ;
    IntVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:IntVector___len__",kwnames,&obj0)) return NULL;
    {
        IntVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = IntVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<int>();
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = int(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"ints expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_IntVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"IntVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (int )IntVector___len__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


int IntVector___getitem__(IntVector *self,int i) {
    {
        int size_ = static_cast<int>(self->size());
        if (i>=0 && i<size_) {
            return (*self)[i];
        }else if (i<0 && -i<=size_) {
            return (*self)[size_+i];
        }else {
            throw IndexError("IntVector index out of range");
        }
        QL_DUMMY_RETURN(0)
    }
}


static PyObject *_wrap_IntVector___getitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    IntVector *arg0 ;
    int arg1 ;
    IntVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self","i", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:IntVector___getitem__",kwnames,&obj0,&arg1)) return NULL;
    {
        IntVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = IntVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<int>();
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = int(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"ints expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_IntVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"IntVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (int )IntVector___getitem__(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


void IntVector___setitem__(IntVector *self,int i,int x) {
    {
        int size_ = static_cast<int>(self->size());
        if (i>=0 && i<size_) {
            (*self)[i] = x;
        }else if (i<0 && -i<=size_) {
            (*self)[size_+i] = x;
        }else {
            throw IndexError("IntVector index out of range");
        }
    }
}


static PyObject *_wrap_IntVector___setitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    IntVector *arg0 ;
    int arg1 ;
    int arg2 ;
    IntVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self","i","x", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oii:IntVector___setitem__",kwnames,&obj0,&arg1,&arg2)) return NULL;
    {
        IntVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = IntVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<int>();
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = int(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"ints expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_IntVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"IntVector expected");
            return NULL;
        }
    }
    {
        try {
            IntVector___setitem__(arg0,arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


IntVector IntVector___getslice__(IntVector *self,int i,int j) {
    {
        int size_ = static_cast<int>(self->size());
        if (i<0)
        i = size_+i;
        if (j<0)
        j = size_+j;
        i = QL_MAX(0,i);
        j = QL_MIN(size_,j);
        IntVector tmp(j-i);
        std::copy(self->begin()+i,self->begin()+j,tmp.begin());
        return tmp;
    }
}


static PyObject *_wrap_IntVector___getslice__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    IntVector *arg0 ;
    int arg1 ;
    int arg2 ;
    IntVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self","i","j", NULL 
    };
    IntVector *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oii:IntVector___getslice__",kwnames,&obj0,&arg1,&arg2)) return NULL;
    {
        IntVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = IntVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<int>();
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = int(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"ints expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_IntVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"IntVector expected");
            return NULL;
        }
    }
    {
        try {
            result = new IntVector (IntVector___getslice__(arg0,arg1,arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_IntVector);
    return resultobj;
}


void IntVector___setslice__(IntVector *self,int i,int j,IntVector const &rhs) {
    {
        int size_ = static_cast<int>(self->size());
        if (i<0)
        i = size_+i;
        if (j<0)
        j = size_+j;
        i = QL_MAX(0,i);
        j = QL_MIN(size_,j);
        QL_ENSURE(static_cast<int>(rhs.size()) == j-i,
        "IntVectors are not resizable");
        std::copy(rhs.begin(),rhs.end(),self->begin()+i);
    }
}


static PyObject *_wrap_IntVector___setslice__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    IntVector *arg0 ;
    int arg1 ;
    int arg2 ;
    IntVector *arg3 ;
    IntVector temp ;
    PyObject * obj0  = 0 ;
    IntVector temp0 ;
    PyObject * obj3  = 0 ;
    char *kwnames[] = {
        "self","i","j","rhs", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OiiO:IntVector___setslice__",kwnames,&obj0,&arg1,&arg2,&obj3)) return NULL;
    {
        IntVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = IntVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<int>();
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = int(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"ints expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_IntVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"IntVector expected");
            return NULL;
        }
    }
    {
        IntVector* v;
        if (PyTuple_Check(obj3) || PyList_Check(obj3)) {
            /* Size */ int size = (PyTuple_Check(obj3) ?
            PyTuple_Size(obj3) :
            PyList_Size(obj3));
            temp0 = IntVector(size);
            arg3 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj3,i);
                if (o == Py_None) {
                    (*arg3)[i] = Null<int>();
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg3)[i] = int(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"ints expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj3,(void **) &v,
        SWIGTYPE_p_IntVector,0)) != -1) {
            arg3 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"IntVector expected");
            return NULL;
        }
    }
    {
        try {
            IntVector___setslice__(arg0,arg1,arg2,(IntVector const &)*arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


bool IntVector___nonzero__(IntVector *self) {
    {
        return (self->size() != 0);
    }
}


static PyObject *_wrap_IntVector___nonzero__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    IntVector *arg0 ;
    IntVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:IntVector___nonzero__",kwnames,&obj0)) return NULL;
    {
        IntVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = IntVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<int>();
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = int(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"ints expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_IntVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"IntVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (bool )IntVector___nonzero__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_delete_DoubleVector(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DoubleVector *arg0 ;
    DoubleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_DoubleVector",kwnames,&obj0)) return NULL;
    {
        DoubleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DoubleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


DoubleVector * new_DoubleVector(DoubleVector const &v) {
    {
        return new DoubleVector(v);
    }
}


static PyObject *_wrap_new_DoubleVector(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DoubleVector *arg0 ;
    DoubleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "v", NULL 
    };
    DoubleVector *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_DoubleVector",kwnames,&obj0)) return NULL;
    {
        DoubleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DoubleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (DoubleVector *)new_DoubleVector((DoubleVector const &)*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DoubleVector);
    return resultobj;
}


String DoubleVector___str__(DoubleVector *self) {
    {
        String s = "(";
        /*Size */ int size_ = self->size();
        if (size_>0) {
            for (/* Size */ int i=0; i<size_-1; i++) {
                s += DoubleFormatter::toString((*self)[i]);
                s += ", ";
            }
            s += DoubleFormatter::toString((*self)[size_-1]);
        }
        s += ")";
        return s;
    }
}


static PyObject *_wrap_DoubleVector___str__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DoubleVector *arg0 ;
    DoubleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:DoubleVector___str__",kwnames,&obj0)) return NULL;
    {
        DoubleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DoubleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            result = new String (DoubleVector___str__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


int DoubleVector___len__(DoubleVector *self) {
    {
        return self->size();
    }
}


static PyObject *_wrap_DoubleVector___len__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DoubleVector *arg0 ;
    DoubleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:DoubleVector___len__",kwnames,&obj0)) return NULL;
    {
        DoubleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DoubleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (int )DoubleVector___len__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


double DoubleVector___getitem__(DoubleVector *self,int i) {
    {
        int size_ = static_cast<int>(self->size());
        if (i>=0 && i<size_) {
            return (*self)[i];
        }else if (i<0 && -i<=size_) {
            return (*self)[size_+i];
        }else {
            throw IndexError("DoubleVector index out of range");
        }
        QL_DUMMY_RETURN(0.0)
    }
}


static PyObject *_wrap_DoubleVector___getitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DoubleVector *arg0 ;
    int arg1 ;
    DoubleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self","i", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:DoubleVector___getitem__",kwnames,&obj0,&arg1)) return NULL;
    {
        DoubleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DoubleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (double )DoubleVector___getitem__(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


void DoubleVector___setitem__(DoubleVector *self,int i,double x) {
    {
        int size_ = static_cast<int>(self->size());
        if (i>=0 && i<size_) {
            (*self)[i] = x;
        }else if (i<0 && -i<=size_) {
            (*self)[size_+i] = x;
        }else {
            throw IndexError("DoubleVector index out of range");
        }
    }
}


static PyObject *_wrap_DoubleVector___setitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DoubleVector *arg0 ;
    int arg1 ;
    double arg2 ;
    DoubleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self","i","x", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oid:DoubleVector___setitem__",kwnames,&obj0,&arg1,&arg2)) return NULL;
    {
        DoubleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DoubleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            DoubleVector___setitem__(arg0,arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


DoubleVector DoubleVector___getslice__(DoubleVector *self,int i,int j) {
    {
        int size_ = static_cast<int>(self->size());
        if (i<0)
        i = size_+i;
        if (j<0)
        j = size_+j;
        i = QL_MAX(0,i);
        j = QL_MIN(size_,j);
        DoubleVector tmp(j-i);
        std::copy(self->begin()+i,self->begin()+j,tmp.begin());
        return tmp;
    }
}


static PyObject *_wrap_DoubleVector___getslice__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DoubleVector *arg0 ;
    int arg1 ;
    int arg2 ;
    DoubleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self","i","j", NULL 
    };
    DoubleVector *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oii:DoubleVector___getslice__",kwnames,&obj0,&arg1,&arg2)) return NULL;
    {
        DoubleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DoubleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            result = new DoubleVector (DoubleVector___getslice__(arg0,arg1,arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_DoubleVector);
    return resultobj;
}


void DoubleVector___setslice__(DoubleVector *self,int i,int j,DoubleVector const &rhs) {
    {
        int size_ = static_cast<int>(self->size());
        if (i<0)
        i = size_+i;
        if (j<0)
        j = size_+j;
        i = QL_MAX(0,i);
        j = QL_MIN(size_,j);
        QL_ENSURE(static_cast<int>(rhs.size()) == j-i,
        "DoubleVectors are not resizable");
        std::copy(rhs.begin(),rhs.end(),self->begin()+i);
    }
}


static PyObject *_wrap_DoubleVector___setslice__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DoubleVector *arg0 ;
    int arg1 ;
    int arg2 ;
    DoubleVector *arg3 ;
    DoubleVector temp ;
    PyObject * obj0  = 0 ;
    DoubleVector temp0 ;
    PyObject * obj3  = 0 ;
    char *kwnames[] = {
        "self","i","j","rhs", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OiiO:DoubleVector___setslice__",kwnames,&obj0,&arg1,&arg2,&obj3)) return NULL;
    {
        DoubleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DoubleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj3) || PyList_Check(obj3)) {
            /* Size */ int size = (PyTuple_Check(obj3) ?
            PyTuple_Size(obj3) :
            PyList_Size(obj3));
            temp0 = DoubleVector(size);
            arg3 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj3,i);
                if (o == Py_None) {
                    (*arg3)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg3)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg3)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj3,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg3 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            DoubleVector___setslice__(arg0,arg1,arg2,(DoubleVector const &)*arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


bool DoubleVector___nonzero__(DoubleVector *self) {
    {
        return (self->size() != 0);
    }
}


static PyObject *_wrap_DoubleVector___nonzero__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DoubleVector *arg0 ;
    DoubleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:DoubleVector___nonzero__",kwnames,&obj0)) return NULL;
    {
        DoubleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DoubleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (bool )DoubleVector___nonzero__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_new_Period(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    int arg0 ;
    TimeUnit *arg1 ;
    TimeUnit temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "n","units", NULL 
    };
    Period *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"iO:new_Period",kwnames,&arg0,&obj1)) return NULL;
    {
        if (PyString_Check(obj1)) {
            std::string s(PyString_AsString(obj1));
            s = StringFormatter::toLowercase(s);
            if (s == "d" || s == "day" || s == "days")
            temp = Days;
            else if (s == "w" || s == "week" || s == "weeks")
            temp = Weeks;
            else if (s == "m" || s == "month" || s == "months")
            temp = Months;
            else if (s == "y" || s == "year" || s == "years")
            temp = Years;
            else {
                PyErr_SetString(PyExc_TypeError,"not a time unit");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a time unit");
            return NULL;
        }
        arg1 = &temp;
    }
    {
        try {
            result = (Period *)new Period(arg0,*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Period);
    return resultobj;
}


static PyObject *_wrap_delete_Period(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Period *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_Period",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Period,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_Period_length(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Period *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Period_length",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Period,1)) == -1) return NULL;
    {
        try {
            result = (int )arg0->length();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_Period_units(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Period *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    TimeUnit *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Period_units",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Period,1)) == -1) return NULL;
    {
        try {
            result = new TimeUnit (arg0->units());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        switch (*result) {
            case Days:    resultobj = PyString_FromString("days");   break;
            case Weeks:   resultobj = PyString_FromString("weeks");  break;
            case Months:  resultobj = PyString_FromString("months"); break;
            case Years:   resultobj = PyString_FromString("years");  break;
            default:      throw Error("unknown time unit");
        }
    }
    {
        delete result;
    }
    return resultobj;
}


String Period___str__(Period *self) {
    {
        String s = IntegerFormatter::toString(self->length());
        switch (self->units()) {
            case Days:
            return s + " day(s)";
            case Weeks:
            return s + " week(s)";
            case Months:
            return s + " month(s)";
            case Years:
            return s + " year(s)";
            default:
            return "Unknown period";
        }
        QL_DUMMY_RETURN(String());
    }
}


static PyObject *_wrap_Period___str__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Period *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Period___str__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Period,1)) == -1) return NULL;
    {
        try {
            result = new String (Period___str__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


static PyObject *_wrap_new_Date(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Day arg0 ;
    Month *arg1 ;
    Year arg2 ;
    Month temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "d","m","y", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"iOi:new_Date",kwnames,&arg0,&obj1,&arg2)) return NULL;
    {
        if (PyString_Check(obj1)) {
            std::string s(PyString_AsString(obj1));
            s = StringFormatter::toLowercase(s);
            if (s == "jan" || s == "january")
            temp = January;
            else if (s == "feb" || s == "february")
            temp = February;
            else if (s == "mar" || s == "march")
            temp = March;
            else if (s == "apr" || s == "april")
            temp = April;
            else if (s == "may")
            temp = May;
            else if (s == "jun" || s == "june")
            temp = June;
            else if (s == "jul" || s == "july")
            temp = July;
            else if (s == "aug" || s == "august")
            temp = August;
            else if (s == "sep" || s == "september")
            temp = September;
            else if (s == "oct" || s == "october")
            temp = October;
            else if (s == "nov" || s == "november")
            temp = November;
            else if (s == "dec" || s == "december")
            temp = December;
            else {
                PyErr_SetString(PyExc_TypeError,"not a month");
                return NULL;
            }
        }else if (PyInt_Check(obj1)) {
            int i = int(PyInt_AsLong(obj1));
            if (i>=1 && i<=12)
            temp = Month(i);
            else {
                PyErr_SetString(PyExc_TypeError,"not a month");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a weekday");
            return NULL;
        }
        arg1 = &temp;
    }
    {
        try {
            result = (Date *)new Date(arg0,*arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Date);
    return resultobj;
}


static PyObject *_wrap_delete_Date(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_Date",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_Date_weekday(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Weekday *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Date_weekday",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = new Weekday (arg0->weekday());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        switch (*result) {
            case Sunday:      resultobj = PyString_FromString("Sunday");     break;
            case Monday:      resultobj = PyString_FromString("Monday");     break;
            case Tuesday:     resultobj = PyString_FromString("Tuesday");    break;
            case Wednesday:   resultobj = PyString_FromString("Wednesday");  break;
            case Thursday:    resultobj = PyString_FromString("Thursday");   break;
            case Friday:      resultobj = PyString_FromString("Friday");     break;
            case Saturday:    resultobj = PyString_FromString("Saturday");   break;
            default:          throw Error("unknown weekday");
        }
    }
    {
        delete result;
    }
    return resultobj;
}


static PyObject *_wrap_Date_dayOfMonth(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Day result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Date_dayOfMonth",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = (Day )arg0->dayOfMonth();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_Date_dayOfYear(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Day result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Date_dayOfYear",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = (Day )arg0->dayOfYear();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_Date_month(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Month *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Date_month",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = new Month (arg0->month());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        switch (*result) {
            case January:     resultobj = PyString_FromString("January");    break;
            case February:    resultobj = PyString_FromString("February");   break;
            case March:       resultobj = PyString_FromString("March");      break;
            case April:       resultobj = PyString_FromString("April");      break;
            case May:         resultobj = PyString_FromString("May");        break;
            case June:        resultobj = PyString_FromString("June");       break;
            case July:        resultobj = PyString_FromString("July");       break;
            case August:      resultobj = PyString_FromString("August");     break;
            case September:   resultobj = PyString_FromString("September");  break;
            case October:     resultobj = PyString_FromString("October");    break;
            case November:    resultobj = PyString_FromString("November");   break;
            case December:    resultobj = PyString_FromString("December");   break;
            default:          throw Error("unknown month");
        }
    }
    {
        delete result;
    }
    return resultobj;
}


static PyObject *_wrap_Date_year(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Year result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Date_year",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = (Year )arg0->year();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_Date_serialNumber(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Date_serialNumber",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = (int )arg0->serialNumber();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_Date_plusDays(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","days", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:Date_plusDays",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = new Date (arg0->plusDays(arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


static PyObject *_wrap_Date_plusWeeks(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","weeks", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:Date_plusWeeks",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = new Date (arg0->plusWeeks(arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


static PyObject *_wrap_Date_plusMonths(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","months", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:Date_plusMonths",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = new Date (arg0->plusMonths(arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


static PyObject *_wrap_Date_plusYears(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","years", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:Date_plusYears",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = new Date (arg0->plusYears(arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


static PyObject *_wrap_Date_plus(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    int arg1 ;
    TimeUnit *arg2 ;
    PyObject * argo0 =0 ;
    TimeUnit temp ;
    PyObject * obj2  = 0 ;
    char *kwnames[] = {
        "self","units","arg2", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OiO:Date_plus",kwnames,&argo0,&arg1,&obj2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        if (PyString_Check(obj2)) {
            std::string s(PyString_AsString(obj2));
            s = StringFormatter::toLowercase(s);
            if (s == "d" || s == "day" || s == "days")
            temp = Days;
            else if (s == "w" || s == "week" || s == "weeks")
            temp = Weeks;
            else if (s == "m" || s == "month" || s == "months")
            temp = Months;
            else if (s == "y" || s == "year" || s == "years")
            temp = Years;
            else {
                PyErr_SetString(PyExc_TypeError,"not a time unit");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a time unit");
            return NULL;
        }
        arg2 = &temp;
    }
    {
        try {
            result = new Date (arg0->plus(arg1,*arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


static PyObject *_wrap_Date_isLeap(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Year arg0 ;
    char *kwnames[] = {
        "y", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"i:Date_isLeap",kwnames,&arg0)) return NULL;
    {
        try {
            result = (bool )Date::isLeap(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_Date_minDate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    char *kwnames[] = {
        NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)":Date_minDate",kwnames)) return NULL;
    {
        try {
            result = new Date (Date::minDate());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


static PyObject *_wrap_Date_maxDate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    char *kwnames[] = {
        NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)":Date_maxDate",kwnames)) return NULL;
    {
        try {
            result = new Date (Date::maxDate());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


int Date_monthNumber(Date *self) {
    {
        return int(self->month());
    }
}


static PyObject *_wrap_Date_monthNumber(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Date_monthNumber",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = (int )Date_monthNumber(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


int Date_weekdayNumber(Date *self) {
    {
        return int(self->weekday());
    }
}


static PyObject *_wrap_Date_weekdayNumber(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Date_weekdayNumber",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = (int )Date_weekdayNumber(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


Date Date___add__(Date *self,int days) {
    {
        return self->plusDays(days);
    }
}


static PyObject *_wrap_Date___add__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","days", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:Date___add__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = new Date (Date___add__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


Date Date___sub__(Date *self,int days) {
    {
        return self->plusDays(-days);
    }
}


static PyObject *_wrap_Date___sub__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","days", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:Date___sub__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = new Date (Date___sub__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


int Date___cmp__(Date *self,Date const &other) {
    {
        if (*self < other)
        return -1;
        if (*self == other)
        return 0;
        return 1;
    }
}


static PyObject *_wrap_Date___cmp__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    Date *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","other", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:Date___cmp__",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = (int )Date___cmp__(arg0,(Date const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


String Date___str__(Date *self) {
    {
        return DateFormatter::toString(*self);
    }
}


static PyObject *_wrap_Date___str__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Date___str__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = new String (Date___str__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


String Date___repr__(Date *self) {
    {
        return "Date(" +
        IntegerFormatter::toString(self->dayOfMonth()) +
        ","+
        IntegerFormatter::toString(int(self->month())) +
        ","+
        IntegerFormatter::toString(self->year()) +
        ")";
    }
}


static PyObject *_wrap_Date___repr__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Date___repr__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = new String (Date___repr__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


Date Date___iadd__(Date *self,int days) {
    {
        return self->plusDays(days);
    }
}


static PyObject *_wrap_Date___iadd__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","days", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:Date___iadd__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = new Date (Date___iadd__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


Date Date___isub__(Date *self,int days) {
    {
        return self->plusDays(-days);
    }
}


static PyObject *_wrap_Date___isub__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","days", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:Date___isub__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = new Date (Date___isub__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


bool Date___nonzero__(Date *self) {
    {
        return (*self != Date());
    }
}


static PyObject *_wrap_Date___nonzero__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Date___nonzero__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Date,1)) == -1) return NULL;
    {
        try {
            result = (bool )Date___nonzero__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_DateFromSerialNumber(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    int arg0 ;
    char *kwnames[] = {
        "serialNumber", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"i:DateFromSerialNumber",kwnames,&arg0)) return NULL;
    {
        try {
            result = new Date (DateFromSerialNumber(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


static PyObject *_wrap_delete_DateVector(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DateVector *arg0 ;
    DateVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_DateVector",kwnames,&obj0)) return NULL;
    {
        DateVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DateVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                Date* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<Date>();
                    Py_DECREF(o);
                }else if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_Date,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"Date" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DateVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DateVector" " expected");
            return NULL;
        }
    }
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


DateVector * new_DateVector(DateVector const &v) {
    {
        return new DateVector(v);
    }
}


static PyObject *_wrap_new_DateVector(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DateVector *arg0 ;
    DateVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "v", NULL 
    };
    DateVector *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_DateVector",kwnames,&obj0)) return NULL;
    {
        DateVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DateVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                Date* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<Date>();
                    Py_DECREF(o);
                }else if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_Date,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"Date" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DateVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DateVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (DateVector *)new_DateVector((DateVector const &)*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DateVector);
    return resultobj;
}


int DateVector___len__(DateVector *self) {
    {
        return self->size();
    }
}


static PyObject *_wrap_DateVector___len__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DateVector *arg0 ;
    DateVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:DateVector___len__",kwnames,&obj0)) return NULL;
    {
        DateVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DateVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                Date* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<Date>();
                    Py_DECREF(o);
                }else if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_Date,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"Date" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DateVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DateVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (int )DateVector___len__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


Date DateVector___getitem__(DateVector *self,int i) {
    {
        int size_ = static_cast<int>(self->size());
        if (i>=0 && i<size_) {
            return (*self)[i];
        }else if (i<0 && -i<=size_) {
            return (*self)[size_+i];
        }else {
            throw IndexError("DateVector" " index out of range");
        }
        QL_DUMMY_RETURN(Date())
    }
}


static PyObject *_wrap_DateVector___getitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DateVector *arg0 ;
    int arg1 ;
    DateVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self","i", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:DateVector___getitem__",kwnames,&obj0,&arg1)) return NULL;
    {
        DateVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DateVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                Date* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<Date>();
                    Py_DECREF(o);
                }else if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_Date,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"Date" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DateVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DateVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = new Date (DateVector___getitem__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


void DateVector___setitem__(DateVector *self,int i,Date const &x) {
    {
        int size_ = static_cast<int>(self->size());
        if (i>=0 && i<size_) {
            (*self)[i] = x;
        }else if (i<0 && -i<=size_) {
            (*self)[size_+i] = x;
        }else {
            throw IndexError("DateVector" " index out of range");
        }
    }
}


static PyObject *_wrap_DateVector___setitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DateVector *arg0 ;
    int arg1 ;
    Date *arg2 ;
    DateVector temp ;
    PyObject * obj0  = 0 ;
    Date temp0 ;
    PyObject * obj2  = 0 ;
    char *kwnames[] = {
        "self","i","x", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OiO:DateVector___setitem__",kwnames,&obj0,&arg1,&obj2)) return NULL;
    {
        DateVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DateVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                Date* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<Date>();
                    Py_DECREF(o);
                }else if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_Date,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"Date" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DateVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DateVector" " expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj2 == Py_None) {
            temp0 = Date();
            arg2 = &temp0;
        }else if ((SWIG_ConvertPtr(obj2,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg2 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            DateVector___setitem__(arg0,arg1,(Date const &)*arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


DateVector DateVector___getslice__(DateVector *self,int i,int j) {
    {
        int size_ = static_cast<int>(self->size());
        if (i<0)
        i = size_+i;
        if (j<0)
        j = size_+j;
        i = QL_MAX(0,i);
        j = QL_MIN(size_,j);
        DateVector tmp(j-i);
        std::copy(self->begin()+i,self->begin()+j,tmp.begin());
        return tmp;
    }
}


static PyObject *_wrap_DateVector___getslice__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DateVector *arg0 ;
    int arg1 ;
    int arg2 ;
    DateVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self","i","j", NULL 
    };
    DateVector *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oii:DateVector___getslice__",kwnames,&obj0,&arg1,&arg2)) return NULL;
    {
        DateVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DateVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                Date* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<Date>();
                    Py_DECREF(o);
                }else if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_Date,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"Date" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DateVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DateVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = new DateVector (DateVector___getslice__(arg0,arg1,arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_DateVector);
    return resultobj;
}


void DateVector___setslice__(DateVector *self,int i,int j,DateVector const &rhs) {
    {
        int size_ = static_cast<int>(self->size());
        if (i<0)
        i = size_+i;
        if (j<0)
        j = size_+j;
        i = QL_MAX(0,i);
        j = QL_MIN(size_,j);
        QL_ENSURE(static_cast<int>(rhs.size()) == j-i,
        "DateVector""s are not resizable");
        std::copy(rhs.begin(),rhs.end(),self->begin()+i);
    }
}


static PyObject *_wrap_DateVector___setslice__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DateVector *arg0 ;
    int arg1 ;
    int arg2 ;
    DateVector *arg3 ;
    DateVector temp ;
    PyObject * obj0  = 0 ;
    DateVector temp0 ;
    PyObject * obj3  = 0 ;
    char *kwnames[] = {
        "self","i","j","rhs", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OiiO:DateVector___setslice__",kwnames,&obj0,&arg1,&arg2,&obj3)) return NULL;
    {
        DateVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DateVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                Date* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<Date>();
                    Py_DECREF(o);
                }else if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_Date,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"Date" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DateVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DateVector" " expected");
            return NULL;
        }
    }
    {
        DateVector* v;
        if (PyTuple_Check(obj3) || PyList_Check(obj3)) {
            /* Size */ int size = (PyTuple_Check(obj3) ?
            PyTuple_Size(obj3) :
            PyList_Size(obj3));
            temp0 = DateVector(size);
            arg3 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                Date* x;
                PyObject* o = PySequence_GetItem(obj3,i);
                if (o == Py_None) {
                    (*arg3)[i] = Null<Date>();
                    Py_DECREF(o);
                }else if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_Date,0)) != -1) {
                    (*arg3)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"Date" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj3,(void **) &v,
        SWIGTYPE_p_DateVector,0)) != -1) {
            arg3 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DateVector" " expected");
            return NULL;
        }
    }
    {
        try {
            DateVector___setslice__(arg0,arg1,arg2,(DateVector const &)*arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


bool DateVector___nonzero__(DateVector *self) {
    {
        return (self->size() != 0);
    }
}


static PyObject *_wrap_DateVector___nonzero__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DateVector *arg0 ;
    DateVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:DateVector___nonzero__",kwnames,&obj0)) return NULL;
    {
        DateVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DateVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                Date* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<Date>();
                    Py_DECREF(o);
                }else if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_Date,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"Date" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DateVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DateVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (bool )DateVector___nonzero__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


String DateVector___str__(DateVector *self) {
    {
        String s = "(";
        /*Size */ int size_ = self->size();
        if (size_>0) {
            for (/* Size */ int i=0; i<size_-1; i++) {
                s += DateFormatter::toString((*self)[i]);
                s += ", ";
            }
            s += DateFormatter::toString((*self)[size_-1]);
        }
        s += ")";
        return s;
    }
}


static PyObject *_wrap_DateVector___str__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DateVector *arg0 ;
    DateVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:DateVector___str__",kwnames,&obj0)) return NULL;
    {
        DateVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DateVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                Date* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<Date>();
                    Py_DECREF(o);
                }else if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_Date,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"Date" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DateVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DateVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = new String (DateVector___str__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


static PyObject *_wrap_delete_Calendar(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Calendar *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_Calendar",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_Calendar_isBusinessDay(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Calendar *arg0 ;
    Date *arg1 ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","d", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:Calendar_isBusinessDay",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (bool )arg0->isBusinessDay((Date const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_Calendar_isHoliday(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Calendar *arg0 ;
    Date *arg1 ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","d", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:Calendar_isHoliday",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (bool )arg0->isHoliday((Date const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_Calendar_roll(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Calendar *arg0 ;
    Date *arg1 ;
    RollingConvention *arg2 ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    RollingConvention temp0 ;
    PyObject * obj2  = 0 ;
    char *kwnames[] = {
        "self","d","convention", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOO:Calendar_roll",kwnames,&argo0,&obj1,&obj2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        if (PyString_Check(obj2)) {
            std::string s(PyString_AsString(obj2));
            s = StringFormatter::toLowercase(s);
            if (s == "f" || s == "fol" || s == "following")
            temp0 = Following;
            else if (s == "mf" ||s == "modfol" || s == "modifiedfollowing")
            temp0 = ModifiedFollowing;
            else if (s == "p" || s == "pre" || s == "preceding")
            temp0 = Preceding;
            else if (s == "mp" ||s == "modpre" || s == "modifiedpreceding")
            temp0 = ModifiedPreceding;
            else {
                PyErr_SetString(PyExc_TypeError,(s+" is not "
                "a rolling convention").c_str());
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"rolling convention expected");
            return NULL;
        }
        arg2 = &temp0;
    }
    {
        try {
            result = new Date (arg0->roll((Date const &)*arg1,*arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


static PyObject *_wrap_Calendar_advance(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Calendar *arg0 ;
    Date *arg1 ;
    int arg2 ;
    TimeUnit *arg3 ;
    RollingConvention *arg4 ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    TimeUnit temp0 ;
    PyObject * obj3  = 0 ;
    RollingConvention temp1 ;
    PyObject * obj4  = 0 ;
    char *kwnames[] = {
        "self","d","n","unit","convention", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOiOO:Calendar_advance",kwnames,&argo0,&obj1,&arg2,&obj3,&obj4)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        if (PyString_Check(obj3)) {
            std::string s(PyString_AsString(obj3));
            s = StringFormatter::toLowercase(s);
            if (s == "d" || s == "day" || s == "days")
            temp0 = Days;
            else if (s == "w" || s == "week" || s == "weeks")
            temp0 = Weeks;
            else if (s == "m" || s == "month" || s == "months")
            temp0 = Months;
            else if (s == "y" || s == "year" || s == "years")
            temp0 = Years;
            else {
                PyErr_SetString(PyExc_TypeError,"not a time unit");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a time unit");
            return NULL;
        }
        arg3 = &temp0;
    }
    {
        if (PyString_Check(obj4)) {
            std::string s(PyString_AsString(obj4));
            s = StringFormatter::toLowercase(s);
            if (s == "f" || s == "fol" || s == "following")
            temp1 = Following;
            else if (s == "mf" ||s == "modfol" || s == "modifiedfollowing")
            temp1 = ModifiedFollowing;
            else if (s == "p" || s == "pre" || s == "preceding")
            temp1 = Preceding;
            else if (s == "mp" ||s == "modpre" || s == "modifiedpreceding")
            temp1 = ModifiedPreceding;
            else {
                PyErr_SetString(PyExc_TypeError,(s+" is not "
                "a rolling convention").c_str());
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"rolling convention expected");
            return NULL;
        }
        arg4 = &temp1;
    }
    {
        try {
            result = new Date (arg0->advance((Date const &)*arg1,arg2,*arg3,*arg4));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


Calendar * new_Calendar(String const &name) {
    {
        String s = StringFormatter::toLowercase(name);
        if (s == "target" || s == "euro" || s == "eur")
        return new TARGET;
        else if (s == "newyork" || s == "ny" || s == "nyc")
        return new NewYork;
        else if (s == "london" || s == "lon")
        return new London;
        else if (s == "milan" || s == "mil")
        return new Milan;
        else if (s == "frankfurt" || s == "fft")
        return new Frankfurt;
        else if (s == "zurich" || s == "zur")
        return new Zurich;
        else if (s == "helsinki")
        return new Helsinki;
        else if (s == "johannesburg")
        return new Johannesburg;
        else if (s == "wellington")
        return new Wellington;
        else if (s == "tokyo")
        return new Tokyo;
        else if (s == "toronto")
        return new Toronto;
        else if (s == "sydney")
        return new Sydney;
        else
        throw Error("Unknown calendar: " + name);
        QL_DUMMY_RETURN((Calendar*)(0));
    }
}


static PyObject *_wrap_new_Calendar(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    String *arg0 ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "name", NULL 
    };
    Calendar *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_Calendar",kwnames,&obj0)) return NULL;
    {
        if (PyString_Check(obj0)) {
            arg0 = new std::string(PyString_AsString(obj0));
        }else {
            PyErr_SetString(PyExc_TypeError,"not a string");
            return NULL;
        }
    }
    {
        try {
            result = (Calendar *)new_Calendar((String const &)*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Calendar);
    {
        delete arg0;
    }
    return resultobj;
}


String Calendar___str__(Calendar *self) {
    {
        return self->name()+" calendar";
    }
}


static PyObject *_wrap_Calendar___str__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Calendar *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Calendar___str__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        try {
            result = new String (Calendar___str__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


String Calendar___repr__(Calendar *self) {
    {
        return "Calendar('" + self->name() + "')";
    }
}


static PyObject *_wrap_Calendar___repr__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Calendar *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Calendar___repr__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        try {
            result = new String (Calendar___repr__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


int Calendar___cmp__(Calendar *self,Calendar const &other) {
    {
        return ((*self) == other ? 0 : 1);
    }
}


static PyObject *_wrap_Calendar___cmp__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Calendar *arg0 ;
    Calendar *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","other", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:Calendar___cmp__",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        try {
            result = (int )Calendar___cmp__(arg0,(Calendar const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_delete_DayCounter(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DayCounter *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_DayCounter",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_DayCounter_dayCount(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DayCounter *arg0 ;
    Date *arg1 ;
    Date *arg2 ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    Date temp0 ;
    PyObject * obj2  = 0 ;
    char *kwnames[] = {
        "self","d1","d2", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOO:DayCounter_dayCount",kwnames,&argo0,&obj1,&obj2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj2 == Py_None) {
            temp0 = Date();
            arg2 = &temp0;
        }else if ((SWIG_ConvertPtr(obj2,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg2 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (int )arg0->dayCount((Date const &)*arg1,(Date const &)*arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_DayCounter_yearFraction(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DayCounter *arg0 ;
    Date *arg1 ;
    Date *arg2 ;
    Date *arg3 ;
    Date *arg4 ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    Date temp0 ;
    PyObject * obj2  = 0 ;
    Date temp1 ;
    PyObject * obj3  = 0 ;
    Date temp2 ;
    PyObject * obj4  = 0 ;
    char *kwnames[] = {
        "self","d1","d2","startRef","endRef", NULL 
    };
    Time result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOOOO:DayCounter_yearFraction",kwnames,&argo0,&obj1,&obj2,&obj3,&obj4)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj2 == Py_None) {
            temp0 = Date();
            arg2 = &temp0;
        }else if ((SWIG_ConvertPtr(obj2,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg2 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj3 == Py_None) {
            temp1 = Date();
            arg3 = &temp1;
        }else if ((SWIG_ConvertPtr(obj3,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg3 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj4 == Py_None) {
            temp2 = Date();
            arg4 = &temp2;
        }else if ((SWIG_ConvertPtr(obj4,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg4 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (Time )arg0->yearFraction((Date const &)*arg1,(Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


DayCounter * new_DayCounter(String const &name) {
    {
        String s = StringFormatter::toLowercase(name);
        
        if (s == "act365" || s == "act/365")
        return new Actual365;
        else if (s == "act360" || s == "act/360")
        return new Actual360;
        else if (s == "actacte" || s == "act/act(e)" || s == "act/act(Euro)")
        return new ActualActual(ActualActual::Euro);
        else if (s == "30/360" || s == "30/360us")
        return new Thirty360(Thirty360::USA);
        else if (s == "30e/360" || s == "30/360e" || s == "30/360eu")
        return new Thirty360(Thirty360::European);
        else if (s == "30/360i" || s == "30/360it")
        return new Thirty360(Thirty360::Italian);
        else if (s == "actact" || s == "act/act" || s == "act/act(b)" || s == "act/act (Bond)")
        return new ActualActual(ActualActual::Bond);
        else if (s == "actacth" || s == "act/act(h)" || s == "act/act (ISDA)")
        return new ActualActual(ActualActual::Historical);
        else
        throw Error("Unknown day counter: " + name);
        QL_DUMMY_RETURN((DayCounter*)(0));
    }
}


static PyObject *_wrap_new_DayCounter(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    String *arg0 ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "name", NULL 
    };
    DayCounter *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_DayCounter",kwnames,&obj0)) return NULL;
    {
        if (PyString_Check(obj0)) {
            arg0 = new std::string(PyString_AsString(obj0));
        }else {
            PyErr_SetString(PyExc_TypeError,"not a string");
            return NULL;
        }
    }
    {
        try {
            result = (DayCounter *)new_DayCounter((String const &)*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DayCounter);
    {
        delete arg0;
    }
    return resultobj;
}


String DayCounter___str__(DayCounter *self) {
    {
        return self->name()+" day counter";
    }
}


static PyObject *_wrap_DayCounter___str__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DayCounter *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:DayCounter___str__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    {
        try {
            result = new String (DayCounter___str__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


String DayCounter___repr__(DayCounter *self) {
    {
        return "DayCounter('"+self->name()+"')";
    }
}


static PyObject *_wrap_DayCounter___repr__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DayCounter *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:DayCounter___repr__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    {
        try {
            result = new String (DayCounter___repr__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


int DayCounter___cmp__(DayCounter *self,DayCounter const &other) {
    {
        return ((*self) == other ? 0 : 1);
    }
}


static PyObject *_wrap_DayCounter___cmp__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DayCounter *arg0 ;
    DayCounter *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","other", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:DayCounter___cmp__",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    {
        try {
            result = (int )DayCounter___cmp__(arg0,(DayCounter const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_delete_TermStructureHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_TermStructureHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


Currency TermStructureHandle_currency(TermStructureHandle *self) {
    {
        return (*self)->currency();
    }
}


static PyObject *_wrap_TermStructure_currency(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Currency *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:TermStructure_currency",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    {
        try {
            result = new Currency (TermStructureHandle_currency(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(
        CurrencyFormatter::toString(*result).c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


Date TermStructureHandle_todaysDate(TermStructureHandle *self) {
    {
        return (*self)->todaysDate();
    }
}


static PyObject *_wrap_TermStructure_todaysDate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:TermStructure_todaysDate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    {
        try {
            result = new Date (TermStructureHandle_todaysDate(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


Calendar TermStructureHandle_calendar(TermStructureHandle *self) {
    {
        return (*self)->calendar();
    }
}


static PyObject *_wrap_TermStructure_calendar(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Calendar *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:TermStructure_calendar",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    {
        try {
            result = new Calendar (TermStructureHandle_calendar(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Calendar);
    return resultobj;
}


DayCounter TermStructureHandle_dayCounter(TermStructureHandle *self) {
    {
        return (*self)->dayCounter();
    }
}


static PyObject *_wrap_TermStructure_dayCounter(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    DayCounter *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:TermStructure_dayCounter",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    {
        try {
            result = new DayCounter (TermStructureHandle_dayCounter(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_DayCounter);
    return resultobj;
}


int TermStructureHandle_settlementDays(TermStructureHandle *self) {
    {
        return (*self)->settlementDays();
    }
}


static PyObject *_wrap_TermStructure_settlementDays(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:TermStructure_settlementDays",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    {
        try {
            result = (int )TermStructureHandle_settlementDays(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


Date TermStructureHandle_settlementDate(TermStructureHandle *self) {
    {
        return (*self)->settlementDate();
    }
}


static PyObject *_wrap_TermStructure_settlementDate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:TermStructure_settlementDate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    {
        try {
            result = new Date (TermStructureHandle_settlementDate(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


Date TermStructureHandle_maxDate(TermStructureHandle *self) {
    {
        return (*self)->maxDate();
    }
}


static PyObject *_wrap_TermStructure_maxDate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:TermStructure_maxDate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    {
        try {
            result = new Date (TermStructureHandle_maxDate(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


Date TermStructureHandle_minDate(TermStructureHandle *self) {
    {
        return (*self)->minDate();
    }
}


static PyObject *_wrap_TermStructure_minDate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:TermStructure_minDate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    {
        try {
            result = new Date (TermStructureHandle_minDate(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


Time TermStructureHandle_maxTime(TermStructureHandle *self) {
    {
        return (*self)->maxTime();
    }
}


static PyObject *_wrap_TermStructure_maxTime(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Time result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:TermStructure_maxTime",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    {
        try {
            result = (Time )TermStructureHandle_maxTime(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


Time TermStructureHandle_minTime(TermStructureHandle *self) {
    {
        return (*self)->minTime();
    }
}


static PyObject *_wrap_TermStructure_minTime(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Time result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:TermStructure_minTime",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    {
        try {
            result = (Time )TermStructureHandle_minTime(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


Rate TermStructureHandle__zeroYieldVsDate(TermStructureHandle *self,Date const &d,bool extrapolate) {
    {
        return (*self)->zeroYield(d, extrapolate);
    }
}


static PyObject *_wrap_TermStructure__zeroYieldVsDate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    Date *arg1 ;
    bool arg2 = false ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    int tempbool2 = (int) false ;
    char *kwnames[] = {
        "self","d","extrapolate", NULL 
    };
    Rate result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO|i:TermStructure__zeroYieldVsDate",kwnames,&argo0,&obj1,&tempbool2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    arg2 = (bool ) tempbool2;
    {
        try {
            result = (Rate )TermStructureHandle__zeroYieldVsDate(arg0,(Date const &)*arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


Rate TermStructureHandle__zeroYieldVsTime(TermStructureHandle *self,Time t,bool extrapolate) {
    {
        return (*self)->zeroYield(t, extrapolate);
    }
}


static PyObject *_wrap_TermStructure__zeroYieldVsTime(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    Time arg1 ;
    bool arg2 = false ;
    PyObject * argo0 =0 ;
    int tempbool2 = (int) false ;
    char *kwnames[] = {
        "self","t","extrapolate", NULL 
    };
    Rate result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|i:TermStructure__zeroYieldVsTime",kwnames,&argo0,&arg1,&tempbool2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    arg2 = (bool ) tempbool2;
    {
        try {
            result = (Rate )TermStructureHandle__zeroYieldVsTime(arg0,arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


DiscountFactor TermStructureHandle__discountVsDate(TermStructureHandle *self,Date const &d,bool extrapolate) {
    {
        return (*self)->discount(d, extrapolate);
    }
}


static PyObject *_wrap_TermStructure__discountVsDate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    Date *arg1 ;
    bool arg2 = false ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    int tempbool2 = (int) false ;
    char *kwnames[] = {
        "self","d","extrapolate", NULL 
    };
    DiscountFactor result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO|i:TermStructure__discountVsDate",kwnames,&argo0,&obj1,&tempbool2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    arg2 = (bool ) tempbool2;
    {
        try {
            result = (DiscountFactor )TermStructureHandle__discountVsDate(arg0,(Date const &)*arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


DiscountFactor TermStructureHandle__discountVsTime(TermStructureHandle *self,Time t,bool extrapolate) {
    {
        return (*self)->discount(t, extrapolate);
    }
}


static PyObject *_wrap_TermStructure__discountVsTime(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    Time arg1 ;
    bool arg2 = false ;
    PyObject * argo0 =0 ;
    int tempbool2 = (int) false ;
    char *kwnames[] = {
        "self","t","extrapolate", NULL 
    };
    DiscountFactor result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|i:TermStructure__discountVsTime",kwnames,&argo0,&arg1,&tempbool2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    arg2 = (bool ) tempbool2;
    {
        try {
            result = (DiscountFactor )TermStructureHandle__discountVsTime(arg0,arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


Rate TermStructureHandle__forwardVsDate(TermStructureHandle *self,Date const &d,bool extrapolate) {
    {
        return (*self)->forward(d, extrapolate);
    }
}


static PyObject *_wrap_TermStructure__forwardVsDate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    Date *arg1 ;
    bool arg2 = false ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    int tempbool2 = (int) false ;
    char *kwnames[] = {
        "self","d","extrapolate", NULL 
    };
    Rate result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO|i:TermStructure__forwardVsDate",kwnames,&argo0,&obj1,&tempbool2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    arg2 = (bool ) tempbool2;
    {
        try {
            result = (Rate )TermStructureHandle__forwardVsDate(arg0,(Date const &)*arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


Rate TermStructureHandle__forwardVsTime(TermStructureHandle *self,Time t,bool extrapolate) {
    {
        return (*self)->forward(t, extrapolate);
    }
}


static PyObject *_wrap_TermStructure__forwardVsTime(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    Time arg1 ;
    bool arg2 = false ;
    PyObject * argo0 =0 ;
    int tempbool2 = (int) false ;
    char *kwnames[] = {
        "self","t","extrapolate", NULL 
    };
    Rate result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|i:TermStructure__forwardVsTime",kwnames,&argo0,&arg1,&tempbool2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    arg2 = (bool ) tempbool2;
    {
        try {
            result = (Rate )TermStructureHandle__forwardVsTime(arg0,arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


bool TermStructureHandle___nonzero__(TermStructureHandle *self) {
    {
        return !self->isNull();
    }
}


static PyObject *_wrap_TermStructure___nonzero__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:TermStructure___nonzero__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureHandle,1)) == -1) return NULL;
    {
        try {
            result = (bool )TermStructureHandle___nonzero__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_new_TermStructureHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureHandle *arg0 ;
    TermStructureHandle temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "h", NULL 
    };
    TermStructureRelinkableHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_TermStructureHandle",kwnames,&obj0)) return NULL;
    {
        TermStructureHandle* x;
        if (obj0 == Py_None) {
            temp = TermStructureHandle();
            arg0 = &temp;
        }else if ((SWIG_ConvertPtr(obj0,(void **) &x,
        SWIGTYPE_p_TermStructureHandle,0)) != -1) {
            arg0 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"TermStructure" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (TermStructureRelinkableHandle *)new TermStructureRelinkableHandle(*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_TermStructureRelinkableHandle);
    return resultobj;
}


static PyObject *_wrap_delete_TermStructureRelinkableHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureRelinkableHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_TermStructureRelinkableHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_TermStructureHandle_linkTo(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureRelinkableHandle *arg0 ;
    TermStructureHandle *arg1 ;
    PyObject * argo0 =0 ;
    TermStructureHandle temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","arg1", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:TermStructureHandle_linkTo",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        TermStructureHandle* x;
        if (obj1 == Py_None) {
            temp = TermStructureHandle();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_TermStructureHandle,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"TermStructure" " expected");
            return NULL;
        }
    }
    {
        try {
            arg0->linkTo(*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


bool TermStructureRelinkableHandle___nonzero__(TermStructureRelinkableHandle *self) {
    {
        return !self->isNull();
    }
}


static PyObject *_wrap_TermStructureHandle___nonzero__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureRelinkableHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:TermStructureHandle___nonzero__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            result = (bool )TermStructureRelinkableHandle___nonzero__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_delete_ImpliedTermStructureHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    ImpliedTermStructureHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_ImpliedTermStructureHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_ImpliedTermStructureHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


ImpliedTermStructureHandle * new_ImpliedTermStructureHandle(TermStructureRelinkableHandle curveHandle,Date todaysDate) {
    {
        return new ImpliedTermStructureHandle(
        new ImpliedTermStructure(curveHandle,todaysDate));
    }
}


static PyObject *_wrap_new_ImpliedTermStructure(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureRelinkableHandle *arg0 ;
    Date *arg1 ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "curveHandle","todaysDate", NULL 
    };
    ImpliedTermStructureHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:new_ImpliedTermStructure",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (ImpliedTermStructureHandle *)new_ImpliedTermStructureHandle(*arg0,*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_ImpliedTermStructureHandle);
    return resultobj;
}


static PyObject *_wrap_delete_ZeroSpreadedTermStructureHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    ZeroSpreadedTermStructureHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_ZeroSpreadedTermStructureHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_ZeroSpreadedTermStructureHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


ZeroSpreadedTermStructureHandle * new_ZeroSpreadedTermStructureHandle(TermStructureRelinkableHandle curveHandle,MarketElementRelinkableHandle spreadHandle) {
    {
        return new ZeroSpreadedTermStructureHandle(
        new ZeroSpreadedTermStructure(curveHandle,spreadHandle));
    }
}


static PyObject *_wrap_new_ZeroSpreadedTermStructure(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureRelinkableHandle *arg0 ;
    MarketElementRelinkableHandle *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "curveHandle","spreadHandle", NULL 
    };
    ZeroSpreadedTermStructureHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:new_ZeroSpreadedTermStructure",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            result = (ZeroSpreadedTermStructureHandle *)new_ZeroSpreadedTermStructureHandle(*arg0,*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_ZeroSpreadedTermStructureHandle);
    return resultobj;
}


static PyObject *_wrap_delete_ForwardSpreadedTermStructureHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    ForwardSpreadedTermStructureHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_ForwardSpreadedTermStructureHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_ForwardSpreadedTermStructureHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


ForwardSpreadedTermStructureHandle * new_ForwardSpreadedTermStructureHandle(TermStructureRelinkableHandle curveHandle,MarketElementRelinkableHandle spreadHandle) {
    {
        return new ForwardSpreadedTermStructureHandle(
        new ForwardSpreadedTermStructure(curveHandle,spreadHandle));
    }
}


static PyObject *_wrap_new_ForwardSpreadedTermStructure(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TermStructureRelinkableHandle *arg0 ;
    MarketElementRelinkableHandle *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "curveHandle","spreadHandle", NULL 
    };
    ForwardSpreadedTermStructureHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:new_ForwardSpreadedTermStructure",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            result = (ForwardSpreadedTermStructureHandle *)new_ForwardSpreadedTermStructureHandle(*arg0,*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_ForwardSpreadedTermStructureHandle);
    return resultobj;
}


static PyObject *_wrap_delete_FlatForwardHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FlatForwardHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_FlatForwardHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FlatForwardHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


FlatForwardHandle * new_FlatForwardHandle(Currency currency,DayCounter dayCounter,Date todaysDate,Calendar calendar,int settlementDays,Rate forward) {
    {
        return new FlatForwardHandle(
        new FlatForward(currency,dayCounter,todaysDate,
        calendar,settlementDays,forward));
    }
}


static PyObject *_wrap_new_FlatForward(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Currency *arg0 ;
    DayCounter *arg1 ;
    Date *arg2 ;
    Calendar *arg3 ;
    int arg4 ;
    Rate arg5 ;
    Currency temp ;
    PyObject * obj0  = 0 ;
    PyObject * argo1 =0 ;
    Date temp0 ;
    PyObject * obj2  = 0 ;
    PyObject * argo3 =0 ;
    char *kwnames[] = {
        "currency","dayCounter","todaysDate","calendar","settlementDays","forward", NULL 
    };
    FlatForwardHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOOOid:new_FlatForward",kwnames,&obj0,&argo1,&obj2,&argo3,&arg4,&arg5)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toUppercase(s);
            if (s == "EUR")      temp = EUR;
            else if (s == "USD") temp = USD;
            else if (s == "GBP") temp = GBP;
            else if (s == "DEM") temp = DEM;
            else if (s == "ITL") temp = ITL;
            else if (s == "CHF") temp = CHF;
            else if (s == "AUD") temp = AUD;
            else if (s == "CAD") temp = CAD;
            else if (s == "DKK") temp = DKK;
            else if (s == "JPY") temp = JPY;
            else if (s == "PLZ") temp = PLZ;
            else if (s == "SEK") temp = SEK;
            else if (s == "CZK") temp = CZK;
            else if (s == "EEK") temp = EEK;
            else if (s == "ISK") temp = ISK;
            else if (s == "NOK") temp = NOK;
            else if (s == "SKK") temp = SKK;
            else if (s == "HKD") temp = HKD;
            else if (s == "NZD") temp = NZD;
            else if (s == "SGD") temp = SGD;
            else if (s == "GRD") temp = GRD;
            else if (s == "HUF") temp = HUF;
            else if (s == "LVL") temp = LVL;
            else if (s == "ROL") temp = ROL;
            else if (s == "BGL") temp = BGL;
            else if (s == "CYP") temp = CYP;
            else if (s == "LTL") temp = LTL;
            else if (s == "MTL") temp = MTL;
            else if (s == "TRL") temp = TRL;
            else if (s == "ZAR") temp = ZAR;
            else if (s == "SIT") temp = SIT;
            else if (s == "KRW") temp = KRW;
            else {
                PyErr_SetString(PyExc_TypeError,"not a currency");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a currency");
            return NULL;
        }
        arg0 = &temp;
    }
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    {
        Date* x;
        if (obj2 == Py_None) {
            temp0 = Date();
            arg2 = &temp0;
        }else if ((SWIG_ConvertPtr(obj2,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg2 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    if ((SWIG_ConvertPtr(argo3,(void **) &arg3,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        try {
            result = (FlatForwardHandle *)new_FlatForwardHandle(*arg0,*arg1,*arg2,*arg3,arg4,arg5);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FlatForwardHandle);
    return resultobj;
}


static PyObject *_wrap_delete_OptionEngineHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionEngineHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_OptionEngineHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_OptionEngineHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_delete_PlainOptionHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PlainOptionHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_PlainOptionHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PlainOptionHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


PlainOptionHandle * new_PlainOptionHandle(OptionType type,MarketElementRelinkableHandle underlying,double strike,TermStructureRelinkableHandle dividendYield,TermStructureRelinkableHandle riskFreeRate,Date exerciseDate,MarketElementRelinkableHandle volatility,OptionEngineHandle engine,String isinCode,String description) {
    {
        return new PlainOptionHandle(new PlainOption(type,underlying,
        strike,dividendYield,riskFreeRate,exerciseDate,volatility,
        engine,isinCode,description));
    }
}


static PyObject *_wrap_new_PlainOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    MarketElementRelinkableHandle *arg1 ;
    double arg2 ;
    TermStructureRelinkableHandle *arg3 ;
    TermStructureRelinkableHandle *arg4 ;
    Date *arg5 ;
    MarketElementRelinkableHandle *arg6 ;
    OptionEngineHandle *arg7 ;
    String *arg8 ;
    String *arg9 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    PyObject * argo1 =0 ;
    PyObject * argo3 =0 ;
    PyObject * argo4 =0 ;
    Date temp0 ;
    PyObject * obj5  = 0 ;
    PyObject * argo6 =0 ;
    PyObject * argo7 =0 ;
    PyObject * obj8  = 0 ;
    PyObject * obj9  = 0 ;
    char *kwnames[] = {
        "type","underlying","strike","dividendYield","riskFreeRate","exerciseDate","volatility","engine","isinCode","description", NULL 
    };
    PlainOptionHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOdOOOOOOO:new_PlainOption",kwnames,&obj0,&argo1,&arg2,&argo3,&argo4,&obj5,&argo6,&argo7,&obj8,&obj9)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo3,(void **) &arg3,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo4,(void **) &arg4,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        Date* x;
        if (obj5 == Py_None) {
            temp0 = Date();
            arg5 = &temp0;
        }else if ((SWIG_ConvertPtr(obj5,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg5 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    if ((SWIG_ConvertPtr(argo6,(void **) &arg6,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo7,(void **) &arg7,SWIGTYPE_p_OptionEngineHandle,1)) == -1) return NULL;
    {
        if (PyString_Check(obj8)) {
            arg8 = new std::string(PyString_AsString(obj8));
        }else {
            PyErr_SetString(PyExc_TypeError,"not a string");
            return NULL;
        }
    }
    {
        if (PyString_Check(obj9)) {
            arg9 = new std::string(PyString_AsString(obj9));
        }else {
            PyErr_SetString(PyExc_TypeError,"not a string");
            return NULL;
        }
    }
    {
        try {
            result = (PlainOptionHandle *)new_PlainOptionHandle(*arg0,*arg1,arg2,*arg3,*arg4,*arg5,*arg6,*arg7,*arg8,*arg9);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_PlainOptionHandle);
    {
        delete arg8;
    }
    {
        delete arg9;
    }
    return resultobj;
}


double PlainOptionHandle_delta(PlainOptionHandle *self) {
    {
        return (*self)->delta();
    }
}


static PyObject *_wrap_PlainOption_delta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PlainOptionHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:PlainOption_delta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PlainOptionHandle,1)) == -1) return NULL;
    {
        try {
            result = (double )PlainOptionHandle_delta(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


double PlainOptionHandle_gamma(PlainOptionHandle *self) {
    {
        return (*self)->gamma();
    }
}


static PyObject *_wrap_PlainOption_gamma(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PlainOptionHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:PlainOption_gamma",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PlainOptionHandle,1)) == -1) return NULL;
    {
        try {
            result = (double )PlainOptionHandle_gamma(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


double PlainOptionHandle_theta(PlainOptionHandle *self) {
    {
        return (*self)->theta();
    }
}


static PyObject *_wrap_PlainOption_theta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PlainOptionHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:PlainOption_theta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PlainOptionHandle,1)) == -1) return NULL;
    {
        try {
            result = (double )PlainOptionHandle_theta(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


double PlainOptionHandle_vega(PlainOptionHandle *self) {
    {
        return (*self)->vega();
    }
}


static PyObject *_wrap_PlainOption_vega(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PlainOptionHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:PlainOption_vega",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PlainOptionHandle,1)) == -1) return NULL;
    {
        try {
            result = (double )PlainOptionHandle_vega(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


double PlainOptionHandle_rho(PlainOptionHandle *self) {
    {
        return (*self)->rho();
    }
}


static PyObject *_wrap_PlainOption_rho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PlainOptionHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:PlainOption_rho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PlainOptionHandle,1)) == -1) return NULL;
    {
        try {
            result = (double )PlainOptionHandle_rho(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


double PlainOptionHandle_dividendRho(PlainOptionHandle *self) {
    {
        return (*self)->dividendRho();
    }
}


static PyObject *_wrap_PlainOption_dividendRho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PlainOptionHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:PlainOption_dividendRho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PlainOptionHandle,1)) == -1) return NULL;
    {
        try {
            result = (double )PlainOptionHandle_dividendRho(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


double PlainOptionHandle_impliedVolatility(PlainOptionHandle *self,double targetValue,double accuracy,int maxEvaluations,double minVol,double maxVol) {
    {
        return (*self)->impliedVolatility(
        targetValue,accuracy,maxEvaluations,minVol,maxVol);
    }
}


static PyObject *_wrap_PlainOption_impliedVolatility(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PlainOptionHandle *arg0 ;
    double arg1 ;
    double arg2 = 1.0e-4 ;
    int arg3 = 100 ;
    double arg4 = 1.0e-4 ;
    double arg5 = 4.0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","targetValue","accuracy","maxEvaluations","minVol","maxVol", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|didd:PlainOption_impliedVolatility",kwnames,&argo0,&arg1,&arg2,&arg3,&arg4,&arg5)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PlainOptionHandle,1)) == -1) return NULL;
    {
        try {
            result = (double )PlainOptionHandle_impliedVolatility(arg0,arg1,arg2,arg3,arg4,arg5);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_delete_EuropeanEngineHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    EuropeanEngineHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_EuropeanEngineHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EuropeanEngineHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


EuropeanEngineHandle * new_EuropeanEngineHandle() {
    {
        return new EuropeanEngineHandle(new EuropeanEngine);
    }
}


static PyObject *_wrap_new_EuropeanEngine(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    char *kwnames[] = {
        NULL 
    };
    EuropeanEngineHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)":new_EuropeanEngine",kwnames)) return NULL;
    {
        try {
            result = (EuropeanEngineHandle *)new_EuropeanEngineHandle();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_EuropeanEngineHandle);
    return resultobj;
}


static PyObject *_wrap_new_Exercise(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    ExerciseType *arg0 ;
    DateVector *arg1 ;
    ExerciseType temp ;
    PyObject * obj0  = 0 ;
    DateVector temp0 ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "type","dates", NULL 
    };
    Exercise *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:new_Exercise",kwnames,&obj0,&obj1)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "e" || s == "european")      temp = Exercise::European;
            else if (s == "a" || s == "american") temp = Exercise::American;
            else if (s == "b" || s == "bermudan") temp = Exercise::Bermudan;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown exercise type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an exercise type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        DateVector* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            /* Size */ int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp0 = DateVector(size);
            arg1 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                Date* x;
                PyObject* o = PySequence_GetItem(obj1,i);
                if (o == Py_None) {
                    (*arg1)[i] = Null<Date>();
                    Py_DECREF(o);
                }else if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_Date,0)) != -1) {
                    (*arg1)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"Date" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_DateVector,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DateVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (Exercise *)new Exercise(*arg0,(DateVector const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Exercise);
    return resultobj;
}


static PyObject *_wrap_delete_Exercise(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Exercise *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_Exercise",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Exercise,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_new_EuropeanExercise(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    Date temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "date", NULL 
    };
    EuropeanExercise *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_EuropeanExercise",kwnames,&obj0)) return NULL;
    {
        Date* x;
        if (obj0 == Py_None) {
            temp = Date();
            arg0 = &temp;
        }else if ((SWIG_ConvertPtr(obj0,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg0 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (EuropeanExercise *)new EuropeanExercise(*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_EuropeanExercise);
    return resultobj;
}


static PyObject *_wrap_delete_EuropeanExercise(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    EuropeanExercise *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_EuropeanExercise",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EuropeanExercise,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_new_AmericanExercise(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Date *arg0 ;
    Date *arg1 ;
    Date temp ;
    PyObject * obj0  = 0 ;
    Date temp0 ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "earliestDate","latestDate", NULL 
    };
    AmericanExercise *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:new_AmericanExercise",kwnames,&obj0,&obj1)) return NULL;
    {
        Date* x;
        if (obj0 == Py_None) {
            temp = Date();
            arg0 = &temp;
        }else if ((SWIG_ConvertPtr(obj0,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg0 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj1 == Py_None) {
            temp0 = Date();
            arg1 = &temp0;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (AmericanExercise *)new AmericanExercise(*arg0,*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_AmericanExercise);
    return resultobj;
}


static PyObject *_wrap_delete_AmericanExercise(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    AmericanExercise *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_AmericanExercise",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_AmericanExercise,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_new_BermudanExercise(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DateVector *arg0 ;
    DateVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "dates", NULL 
    };
    BermudanExercise *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_BermudanExercise",kwnames,&obj0)) return NULL;
    {
        DateVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DateVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                Date* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<Date>();
                    Py_DECREF(o);
                }else if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_Date,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"Date" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DateVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DateVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (BermudanExercise *)new BermudanExercise((DateVector const &)*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_BermudanExercise);
    return resultobj;
}


static PyObject *_wrap_delete_BermudanExercise(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BermudanExercise *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_BermudanExercise",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BermudanExercise,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_delete_HistoryEntry(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryEntry *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_HistoryEntry",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryEntry,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_HistoryEntry_date(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryEntry *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:HistoryEntry_date",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryEntry,1)) == -1) return NULL;
    {
        try {
            result = new Date (arg0->date());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


static PyObject *_wrap_HistoryEntry_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryEntry *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    doubleOrNull result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:HistoryEntry_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryEntry,1)) == -1) return NULL;
    {
        try {
            result = (doubleOrNull )arg0->value();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        if (result == Null<double>()) {
            Py_INCREF(Py_None);
            resultobj = Py_None;
        }else {
            resultobj = PyFloat_FromDouble(result);
        }
    }
    return resultobj;
}


String HistoryEntry___str__(HistoryEntry *self) {
    {
        return DateFormatter::toString(self->date()) +
        "\t"+ (self->value() == Null<double>() ? String("Null") :
        DoubleFormatter::toString(self->value()));
    }
}


static PyObject *_wrap_HistoryEntry___str__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryEntry *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:HistoryEntry___str__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryEntry,1)) == -1) return NULL;
    {
        try {
            result = new String (HistoryEntry___str__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


static PyObject *_wrap_delete_HistoryIterator(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryIterator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_HistoryIterator",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryIterator,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


int HistoryIterator___cmp__(HistoryIterator *self,HistoryIterator const &other) {
    {
        return (*self == other ? 0 : -1);
    }
}


static PyObject *_wrap_HistoryIterator___cmp__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryIterator *arg0 ;
    HistoryIterator *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","other", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:HistoryIterator___cmp__",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryIterator,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_HistoryIterator,1)) == -1) return NULL;
    {
        try {
            result = (int )HistoryIterator___cmp__(arg0,(HistoryIterator const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


HistoryEntry HistoryIterator__value(HistoryIterator *self) {
    {
        return **self;
    }
}


static PyObject *_wrap_HistoryIterator__value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryIterator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    HistoryEntry *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:HistoryIterator__value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryIterator,1)) == -1) return NULL;
    {
        try {
            result = new HistoryEntry (HistoryIterator__value(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_HistoryEntry);
    return resultobj;
}


void HistoryIterator__advance(HistoryIterator *self) {
    {
        (*self)++;
    }
}


static PyObject *_wrap_HistoryIterator__advance(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryIterator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:HistoryIterator__advance",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryIterator,1)) == -1) return NULL;
    {
        try {
            HistoryIterator__advance(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_delete_HistoryValidIterator(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryValidIterator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_HistoryValidIterator",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryValidIterator,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


int HistoryValidIterator___cmp__(HistoryValidIterator *self,HistoryValidIterator const &other) {
    {
        return (*self == other ? 0 : -1);
    }
}


static PyObject *_wrap_HistoryValidIterator___cmp__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryValidIterator *arg0 ;
    HistoryValidIterator *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","other", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:HistoryValidIterator___cmp__",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryValidIterator,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_HistoryValidIterator,1)) == -1) return NULL;
    {
        try {
            result = (int )HistoryValidIterator___cmp__(arg0,(HistoryValidIterator const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


HistoryEntry HistoryValidIterator__value(HistoryValidIterator *self) {
    {
        return **self;
    }
}


static PyObject *_wrap_HistoryValidIterator__value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryValidIterator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    HistoryEntry *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:HistoryValidIterator__value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryValidIterator,1)) == -1) return NULL;
    {
        try {
            result = new HistoryEntry (HistoryValidIterator__value(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_HistoryEntry);
    return resultobj;
}


void HistoryValidIterator__advance(HistoryValidIterator *self) {
    {
        (*self)++;
    }
}


static PyObject *_wrap_HistoryValidIterator__advance(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryValidIterator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:HistoryValidIterator__advance",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryValidIterator,1)) == -1) return NULL;
    {
        try {
            HistoryValidIterator__advance(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_delete_HistoryDataIterator(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryDataIterator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_HistoryDataIterator",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryDataIterator,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


int HistoryDataIterator___cmp__(HistoryDataIterator *self,HistoryDataIterator const &other) {
    {
        return (*self == other ? 0 : -1);
    }
}


static PyObject *_wrap_HistoryDataIterator___cmp__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryDataIterator *arg0 ;
    HistoryDataIterator *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","other", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:HistoryDataIterator___cmp__",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryDataIterator,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_HistoryDataIterator,1)) == -1) return NULL;
    {
        try {
            result = (int )HistoryDataIterator___cmp__(arg0,(HistoryDataIterator const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


doubleOrNull HistoryDataIterator__value(HistoryDataIterator *self) {
    {
        return **self;
    }
}


static PyObject *_wrap_HistoryDataIterator__value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryDataIterator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    doubleOrNull result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:HistoryDataIterator__value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryDataIterator,1)) == -1) return NULL;
    {
        try {
            result = (doubleOrNull )HistoryDataIterator__value(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        if (result == Null<double>()) {
            Py_INCREF(Py_None);
            resultobj = Py_None;
        }else {
            resultobj = PyFloat_FromDouble(result);
        }
    }
    return resultobj;
}


void HistoryDataIterator__advance(HistoryDataIterator *self) {
    {
        (*self)++;
    }
}


static PyObject *_wrap_HistoryDataIterator__advance(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryDataIterator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:HistoryDataIterator__advance",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryDataIterator,1)) == -1) return NULL;
    {
        try {
            HistoryDataIterator__advance(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_delete_HistoryValidDataIterator(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryValidDataIterator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_HistoryValidDataIterator",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryValidDataIterator,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


int HistoryValidDataIterator___cmp__(HistoryValidDataIterator *self,HistoryValidDataIterator const &other) {
    {
        return (*self == other ? 0 : -1);
    }
}


static PyObject *_wrap_HistoryValidDataIterator___cmp__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryValidDataIterator *arg0 ;
    HistoryValidDataIterator *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","other", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:HistoryValidDataIterator___cmp__",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryValidDataIterator,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_HistoryValidDataIterator,1)) == -1) return NULL;
    {
        try {
            result = (int )HistoryValidDataIterator___cmp__(arg0,(HistoryValidDataIterator const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


doubleOrNull HistoryValidDataIterator__value(HistoryValidDataIterator *self) {
    {
        return **self;
    }
}


static PyObject *_wrap_HistoryValidDataIterator__value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryValidDataIterator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    doubleOrNull result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:HistoryValidDataIterator__value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryValidDataIterator,1)) == -1) return NULL;
    {
        try {
            result = (doubleOrNull )HistoryValidDataIterator__value(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        if (result == Null<double>()) {
            Py_INCREF(Py_None);
            resultobj = Py_None;
        }else {
            resultobj = PyFloat_FromDouble(result);
        }
    }
    return resultobj;
}


void HistoryValidDataIterator__advance(HistoryValidDataIterator *self) {
    {
        (*self)++;
    }
}


static PyObject *_wrap_HistoryValidDataIterator__advance(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    HistoryValidDataIterator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:HistoryValidDataIterator__advance",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_HistoryValidDataIterator,1)) == -1) return NULL;
    {
        try {
            HistoryValidDataIterator__advance(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_new_History(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DateVector *arg0 ;
    DoubleVector *arg1 ;
    DateVector temp ;
    PyObject * obj0  = 0 ;
    DoubleVector temp0 ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "dates","values", NULL 
    };
    History *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:new_History",kwnames,&obj0,&obj1)) return NULL;
    {
        DateVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DateVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                Date* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<Date>();
                    Py_DECREF(o);
                }else if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_Date,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"Date" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DateVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DateVector" " expected");
            return NULL;
        }
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            /* Size */ int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp0 = DoubleVector(size);
            arg1 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (o == Py_None) {
                    (*arg1)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (History *)new History(*arg0,*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_History);
    return resultobj;
}


static PyObject *_wrap_delete_History(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_History",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_History_firstDate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:History_firstDate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        try {
            result = new Date (arg0->firstDate());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


static PyObject *_wrap_History_lastDate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:History_lastDate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        try {
            result = new Date (arg0->lastDate());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


int History___len__(History *self) {
    {
        return self->size();
    }
}


static PyObject *_wrap_History___len__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:History___len__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        try {
            result = (int )History___len__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


doubleOrNull History___getitem__(History *self,Date d) {
    {
        return (*self)[d];
    }
}


static PyObject *_wrap_History___getitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    Date *arg1 ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","d", NULL 
    };
    doubleOrNull result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:History___getitem__",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (doubleOrNull )History___getitem__(arg0,*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        if (result == Null<double>()) {
            Py_INCREF(Py_None);
            resultobj = Py_None;
        }else {
            resultobj = PyFloat_FromDouble(result);
        }
    }
    return resultobj;
}


String History___str__(History *self) {
    {
        return "Historical data from " +
        DateFormatter::toString(self->firstDate()) +
        " to "+ DateFormatter::toString(self->lastDate());
    }
}


static PyObject *_wrap_History___str__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:History___str__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        try {
            result = new String (History___str__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


HistoryIterator History__begin(History *self) {
    {
        return self->begin();
    }
}


static PyObject *_wrap_History__begin(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    HistoryIterator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:History__begin",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        try {
            result = new HistoryIterator (History__begin(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_HistoryIterator);
    return resultobj;
}


HistoryIterator History__end(History *self) {
    {
        return self->end();
    }
}


static PyObject *_wrap_History__end(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    HistoryIterator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:History__end",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        try {
            result = new HistoryIterator (History__end(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_HistoryIterator);
    return resultobj;
}


HistoryIterator History__iterator(History *self,Date d) {
    {
        return self->iterator(d);
    }
}


static PyObject *_wrap_History__iterator(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    Date *arg1 ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","d", NULL 
    };
    HistoryIterator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:History__iterator",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = new HistoryIterator (History__iterator(arg0,*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_HistoryIterator);
    return resultobj;
}


HistoryValidIterator History__vbegin(History *self) {
    {
        return self->vbegin();
    }
}


static PyObject *_wrap_History__vbegin(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    HistoryValidIterator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:History__vbegin",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        try {
            result = new HistoryValidIterator (History__vbegin(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_HistoryValidIterator);
    return resultobj;
}


HistoryValidIterator History__vend(History *self) {
    {
        return self->vend();
    }
}


static PyObject *_wrap_History__vend(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    HistoryValidIterator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:History__vend",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        try {
            result = new HistoryValidIterator (History__vend(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_HistoryValidIterator);
    return resultobj;
}


HistoryValidIterator History__valid_iterator(History *self,Date d) {
    {
        return self->valid_iterator(d);
    }
}


static PyObject *_wrap_History__valid_iterator(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    Date *arg1 ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","d", NULL 
    };
    HistoryValidIterator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:History__valid_iterator",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = new HistoryValidIterator (History__valid_iterator(arg0,*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_HistoryValidIterator);
    return resultobj;
}


HistoryDataIterator History__dbegin(History *self) {
    {
        return self->dbegin();
    }
}


static PyObject *_wrap_History__dbegin(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    HistoryDataIterator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:History__dbegin",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        try {
            result = new HistoryDataIterator (History__dbegin(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_HistoryDataIterator);
    return resultobj;
}


HistoryDataIterator History__dend(History *self) {
    {
        return self->dend();
    }
}


static PyObject *_wrap_History__dend(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    HistoryDataIterator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:History__dend",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        try {
            result = new HistoryDataIterator (History__dend(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_HistoryDataIterator);
    return resultobj;
}


HistoryDataIterator History__data_iterator(History *self,Date d) {
    {
        return self->data_iterator(d);
    }
}


static PyObject *_wrap_History__data_iterator(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    Date *arg1 ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","d", NULL 
    };
    HistoryDataIterator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:History__data_iterator",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = new HistoryDataIterator (History__data_iterator(arg0,*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_HistoryDataIterator);
    return resultobj;
}


HistoryValidDataIterator History__vdbegin(History *self) {
    {
        return self->vdbegin();
    }
}


static PyObject *_wrap_History__vdbegin(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    HistoryValidDataIterator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:History__vdbegin",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        try {
            result = new HistoryValidDataIterator (History__vdbegin(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_HistoryValidDataIterator);
    return resultobj;
}


HistoryValidDataIterator History__vdend(History *self) {
    {
        return self->vdend();
    }
}


static PyObject *_wrap_History__vdend(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    HistoryValidDataIterator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:History__vdend",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        try {
            result = new HistoryValidDataIterator (History__vdend(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_HistoryValidDataIterator);
    return resultobj;
}


HistoryValidDataIterator History__valid_data_iterator(History *self,Date d) {
    {
        return self->valid_data_iterator(d);
    }
}


static PyObject *_wrap_History__valid_data_iterator(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    History *arg0 ;
    Date *arg1 ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","d", NULL 
    };
    HistoryValidDataIterator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:History__valid_data_iterator",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_History,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = new HistoryValidDataIterator (History__valid_data_iterator(arg0,*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_HistoryValidDataIterator);
    return resultobj;
}


static PyObject *_wrap_new_XiborManagerClass(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    char *kwnames[] = {
        NULL 
    };
    XiborManagerClass *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)":new_XiborManagerClass",kwnames)) return NULL;
    {
        try {
            result = (XiborManagerClass *)new XiborManagerClass();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_XiborManagerClass);
    return resultobj;
}


static PyObject *_wrap_delete_XiborManagerClass(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    XiborManagerClass *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_XiborManagerClass",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_XiborManagerClass,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_XiborManagerClass_setHistory(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    XiborManagerClass *arg0 ;
    String *arg1 ;
    History *arg2 ;
    PyObject * argo0 =0 ;
    PyObject * obj1  = 0 ;
    History temp ;
    PyObject * obj2  = 0 ;
    char *kwnames[] = {
        "self","name","termStructure", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOO:XiborManagerClass_setHistory",kwnames,&argo0,&obj1,&obj2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_XiborManagerClass,1)) == -1) return NULL;
    {
        if (PyString_Check(obj1)) {
            arg1 = new std::string(PyString_AsString(obj1));
        }else {
            PyErr_SetString(PyExc_TypeError,"not a string");
            return NULL;
        }
    }
    {
        History* x;
        if (obj2 == Py_None) {
            temp = History();
            arg2 = &temp;
        }else if ((SWIG_ConvertPtr(obj2,(void **) &x,
        SWIGTYPE_p_History,0)) != -1) {
            arg2 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"History" " expected");
            return NULL;
        }
    }
    {
        try {
            arg0->setHistory(*arg1,*arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    {
        delete arg1;
    }
    return resultobj;
}


static PyObject *_wrap_XiborManagerClass_getHistory(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    XiborManagerClass *arg0 ;
    String *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","name", NULL 
    };
    History *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:XiborManagerClass_getHistory",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_XiborManagerClass,1)) == -1) return NULL;
    {
        if (PyString_Check(obj1)) {
            arg1 = new std::string(PyString_AsString(obj1));
        }else {
            PyErr_SetString(PyExc_TypeError,"not a string");
            return NULL;
        }
    }
    {
        try {
            result = new History (arg0->getHistory(*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_History);
    {
        delete arg1;
    }
    return resultobj;
}


static PyObject *_wrap_XiborManagerClass_hasHistory(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    XiborManagerClass *arg0 ;
    String *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","name", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:XiborManagerClass_hasHistory",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_XiborManagerClass,1)) == -1) return NULL;
    {
        if (PyString_Check(obj1)) {
            arg1 = new std::string(PyString_AsString(obj1));
        }else {
            PyErr_SetString(PyExc_TypeError,"not a string");
            return NULL;
        }
    }
    {
        try {
            result = (bool )arg0->hasHistory(*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    {
        delete arg1;
    }
    return resultobj;
}


static PyObject *_wrap_XiborManagerClass_histories(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    XiborManagerClass *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    StringVector *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:XiborManagerClass_histories",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_XiborManagerClass,1)) == -1) return NULL;
    {
        try {
            result = new StringVector (arg0->histories());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyTuple_New(result->size());
        for (QL::Size i=0; i<result->size(); i++)
        PyTuple_SetItem(resultobj,i,PyString_FromString((*result)[i].c_str()));
    }
    {
        delete result;
    }
    return resultobj;
}


static int _wrap_XiborManager_set(PyObject *val) {
    XiborManagerClass * temp ;
    
    if ((SWIG_ConvertPtr(val,(void **) &temp,SWIGTYPE_p_XiborManagerClass,1)) == -1) return 1;
    XiborManager = *temp;
    return 0;
}


static PyObject *_wrap_XiborManager_get() {
    PyObject *pyobj;
    
    pyobj = SWIG_NewPointerObj((void *) &XiborManager, SWIGTYPE_p_XiborManagerClass);
    return pyobj;
}


static PyObject *_wrap_delete_IndexHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    IndexHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_IndexHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_IndexHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


Rate IndexHandle_fixing(IndexHandle *self,Date fixingDate) {
    {
        return (*self)->fixing(fixingDate);
    }
}


static PyObject *_wrap_Index_fixing(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    IndexHandle *arg0 ;
    Date *arg1 ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","fixingDate", NULL 
    };
    Rate result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:Index_fixing",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_IndexHandle,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (Rate )IndexHandle_fixing(arg0,*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


String IndexHandle_name(IndexHandle *self) {
    {
        return (*self)->name();
    }
}


static PyObject *_wrap_Index_name(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    IndexHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Index_name",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_IndexHandle,1)) == -1) return NULL;
    {
        try {
            result = new String (IndexHandle_name(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


String IndexHandle___str__(IndexHandle *self) {
    {
        if (!self->isNull())
        return (*self)->name()+" index";
        else
        return "Null index";
    }
}


static PyObject *_wrap_Index___str__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    IndexHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Index___str__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_IndexHandle,1)) == -1) return NULL;
    {
        try {
            result = new String (IndexHandle___str__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


static PyObject *_wrap_delete_XiborHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    XiborHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_XiborHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_XiborHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


XiborHandle * new_XiborHandle(String name,int n,TimeUnit units,TermStructureRelinkableHandle h) {
    {
        String s = StringFormatter::toLowercase(name);
        if (s == "euribor")
        return new XiborHandle(new Euribor(n,units,h));
        else if (s == "audlibor")
        return new XiborHandle(new AUDLibor(n,units,h));
        else if (s == "gbplibor")
        return new XiborHandle(new GBPLibor(n,units,h));
        else if (s == "usdlibor")
        return new XiborHandle(new USDLibor(n,units,h));
        else if (s == "jpylibor")
        return new XiborHandle(new JPYLibor(n,units,h));
        else if (s == "cadlibor")
        return new XiborHandle(new CADLibor(n,units,h));
        else if (s == "chflibor")
        return new XiborHandle(new CHFLibor(n,units,h));
        else if (s == "zarlibor")
        return new XiborHandle(new ZARLibor(n,units,h));
        else
        throw Error("unknown index: " + name);
        QL_DUMMY_RETURN(new XiborHandle);
    }
}


static PyObject *_wrap_new_Xibor(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    String *arg0 ;
    int arg1 ;
    TimeUnit *arg2 ;
    TermStructureRelinkableHandle *arg3 ;
    PyObject * obj0  = 0 ;
    TimeUnit temp ;
    PyObject * obj2  = 0 ;
    PyObject * argo3 =0 ;
    char *kwnames[] = {
        "name","n","units","h", NULL 
    };
    XiborHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OiOO:new_Xibor",kwnames,&obj0,&arg1,&obj2,&argo3)) return NULL;
    {
        if (PyString_Check(obj0)) {
            arg0 = new std::string(PyString_AsString(obj0));
        }else {
            PyErr_SetString(PyExc_TypeError,"not a string");
            return NULL;
        }
    }
    {
        if (PyString_Check(obj2)) {
            std::string s(PyString_AsString(obj2));
            s = StringFormatter::toLowercase(s);
            if (s == "d" || s == "day" || s == "days")
            temp = Days;
            else if (s == "w" || s == "week" || s == "weeks")
            temp = Weeks;
            else if (s == "m" || s == "month" || s == "months")
            temp = Months;
            else if (s == "y" || s == "year" || s == "years")
            temp = Years;
            else {
                PyErr_SetString(PyExc_TypeError,"not a time unit");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a time unit");
            return NULL;
        }
        arg2 = &temp;
    }
    if ((SWIG_ConvertPtr(argo3,(void **) &arg3,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            result = (XiborHandle *)new_XiborHandle(*arg0,arg1,*arg2,*arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_XiborHandle);
    {
        delete arg0;
    }
    return resultobj;
}


Period XiborHandle_tenor(XiborHandle *self) {
    {
        return (*self)->tenor();
    }
}


static PyObject *_wrap_Xibor_tenor(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    XiborHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Period *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Xibor_tenor",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_XiborHandle,1)) == -1) return NULL;
    {
        try {
            result = new Period (XiborHandle_tenor(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Period);
    return resultobj;
}


Currency XiborHandle_currency(XiborHandle *self) {
    {
        return (*self)->currency();
    }
}


static PyObject *_wrap_Xibor_currency(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    XiborHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Currency *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Xibor_currency",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_XiborHandle,1)) == -1) return NULL;
    {
        try {
            result = new Currency (XiborHandle_currency(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(
        CurrencyFormatter::toString(*result).c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


Calendar XiborHandle_calendar(XiborHandle *self) {
    {
        return (*self)->calendar();
    }
}


static PyObject *_wrap_Xibor_calendar(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    XiborHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Calendar *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Xibor_calendar",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_XiborHandle,1)) == -1) return NULL;
    {
        try {
            result = new Calendar (XiborHandle_calendar(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Calendar);
    return resultobj;
}


bool XiborHandle_isAdjusted(XiborHandle *self) {
    {
        return (*self)->isAdjusted();
    }
}


static PyObject *_wrap_Xibor_isAdjusted(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    XiborHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Xibor_isAdjusted",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_XiborHandle,1)) == -1) return NULL;
    {
        try {
            result = (bool )XiborHandle_isAdjusted(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


RollingConvention XiborHandle_rollingConvention(XiborHandle *self) {
    {
        return (*self)->rollingConvention();
    }
}


static PyObject *_wrap_Xibor_rollingConvention(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    XiborHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    RollingConvention *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Xibor_rollingConvention",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_XiborHandle,1)) == -1) return NULL;
    {
        try {
            result = new RollingConvention (XiborHandle_rollingConvention(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        switch (*result) {
            case Following:
            resultobj = PyString_FromString("Following");
            break;
            case ModifiedFollowing:
            resultobj = PyString_FromString("ModifiedFollowing");
            break;
            case Preceding:
            resultobj = PyString_FromString("Preceding");
            break;
            case ModifiedPreceding:
            resultobj = PyString_FromString("ModifiedPreceding");
            break;
            default:
            resultobj = PyString_FromString("Unknown");
        }
    }
    {
        delete result;
    }
    return resultobj;
}


DayCounter XiborHandle_dayCounter(XiborHandle *self) {
    {
        return (*self)->dayCounter();
    }
}


static PyObject *_wrap_Xibor_dayCounter(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    XiborHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    DayCounter *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Xibor_dayCounter",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_XiborHandle,1)) == -1) return NULL;
    {
        try {
            result = new DayCounter (XiborHandle_dayCounter(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_DayCounter);
    return resultobj;
}


static PyObject *_wrap_Euribor(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    int arg0 ;
    TimeUnit *arg1 ;
    TermStructureRelinkableHandle *arg2 ;
    TimeUnit temp ;
    PyObject * obj1  = 0 ;
    PyObject * argo2 =0 ;
    char *kwnames[] = {
        "n","units","h", NULL 
    };
    XiborHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"iOO:Euribor",kwnames,&arg0,&obj1,&argo2)) return NULL;
    {
        if (PyString_Check(obj1)) {
            std::string s(PyString_AsString(obj1));
            s = StringFormatter::toLowercase(s);
            if (s == "d" || s == "day" || s == "days")
            temp = Days;
            else if (s == "w" || s == "week" || s == "weeks")
            temp = Weeks;
            else if (s == "m" || s == "month" || s == "months")
            temp = Months;
            else if (s == "y" || s == "year" || s == "years")
            temp = Years;
            else {
                PyErr_SetString(PyExc_TypeError,"not a time unit");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a time unit");
            return NULL;
        }
        arg1 = &temp;
    }
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            result = new XiborHandle (NewEuribor(arg0,*arg1,*arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_XiborHandle);
    return resultobj;
}


static PyObject *_wrap_AUDLibor(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    int arg0 ;
    TimeUnit *arg1 ;
    TermStructureRelinkableHandle *arg2 ;
    TimeUnit temp ;
    PyObject * obj1  = 0 ;
    PyObject * argo2 =0 ;
    char *kwnames[] = {
        "n","units","h", NULL 
    };
    XiborHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"iOO:AUDLibor",kwnames,&arg0,&obj1,&argo2)) return NULL;
    {
        if (PyString_Check(obj1)) {
            std::string s(PyString_AsString(obj1));
            s = StringFormatter::toLowercase(s);
            if (s == "d" || s == "day" || s == "days")
            temp = Days;
            else if (s == "w" || s == "week" || s == "weeks")
            temp = Weeks;
            else if (s == "m" || s == "month" || s == "months")
            temp = Months;
            else if (s == "y" || s == "year" || s == "years")
            temp = Years;
            else {
                PyErr_SetString(PyExc_TypeError,"not a time unit");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a time unit");
            return NULL;
        }
        arg1 = &temp;
    }
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            result = new XiborHandle (NewAUDLibor(arg0,*arg1,*arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_XiborHandle);
    return resultobj;
}


static PyObject *_wrap_GBPLibor(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    int arg0 ;
    TimeUnit *arg1 ;
    TermStructureRelinkableHandle *arg2 ;
    TimeUnit temp ;
    PyObject * obj1  = 0 ;
    PyObject * argo2 =0 ;
    char *kwnames[] = {
        "n","units","h", NULL 
    };
    XiborHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"iOO:GBPLibor",kwnames,&arg0,&obj1,&argo2)) return NULL;
    {
        if (PyString_Check(obj1)) {
            std::string s(PyString_AsString(obj1));
            s = StringFormatter::toLowercase(s);
            if (s == "d" || s == "day" || s == "days")
            temp = Days;
            else if (s == "w" || s == "week" || s == "weeks")
            temp = Weeks;
            else if (s == "m" || s == "month" || s == "months")
            temp = Months;
            else if (s == "y" || s == "year" || s == "years")
            temp = Years;
            else {
                PyErr_SetString(PyExc_TypeError,"not a time unit");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a time unit");
            return NULL;
        }
        arg1 = &temp;
    }
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            result = new XiborHandle (NewGBPLibor(arg0,*arg1,*arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_XiborHandle);
    return resultobj;
}


static PyObject *_wrap_USDLibor(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    int arg0 ;
    TimeUnit *arg1 ;
    TermStructureRelinkableHandle *arg2 ;
    TimeUnit temp ;
    PyObject * obj1  = 0 ;
    PyObject * argo2 =0 ;
    char *kwnames[] = {
        "n","units","h", NULL 
    };
    XiborHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"iOO:USDLibor",kwnames,&arg0,&obj1,&argo2)) return NULL;
    {
        if (PyString_Check(obj1)) {
            std::string s(PyString_AsString(obj1));
            s = StringFormatter::toLowercase(s);
            if (s == "d" || s == "day" || s == "days")
            temp = Days;
            else if (s == "w" || s == "week" || s == "weeks")
            temp = Weeks;
            else if (s == "m" || s == "month" || s == "months")
            temp = Months;
            else if (s == "y" || s == "year" || s == "years")
            temp = Years;
            else {
                PyErr_SetString(PyExc_TypeError,"not a time unit");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a time unit");
            return NULL;
        }
        arg1 = &temp;
    }
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            result = new XiborHandle (NewUSDLibor(arg0,*arg1,*arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_XiborHandle);
    return resultobj;
}


static PyObject *_wrap_JPYLibor(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    int arg0 ;
    TimeUnit *arg1 ;
    TermStructureRelinkableHandle *arg2 ;
    TimeUnit temp ;
    PyObject * obj1  = 0 ;
    PyObject * argo2 =0 ;
    char *kwnames[] = {
        "n","units","h", NULL 
    };
    XiborHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"iOO:JPYLibor",kwnames,&arg0,&obj1,&argo2)) return NULL;
    {
        if (PyString_Check(obj1)) {
            std::string s(PyString_AsString(obj1));
            s = StringFormatter::toLowercase(s);
            if (s == "d" || s == "day" || s == "days")
            temp = Days;
            else if (s == "w" || s == "week" || s == "weeks")
            temp = Weeks;
            else if (s == "m" || s == "month" || s == "months")
            temp = Months;
            else if (s == "y" || s == "year" || s == "years")
            temp = Years;
            else {
                PyErr_SetString(PyExc_TypeError,"not a time unit");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a time unit");
            return NULL;
        }
        arg1 = &temp;
    }
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            result = new XiborHandle (NewJPYLibor(arg0,*arg1,*arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_XiborHandle);
    return resultobj;
}


static PyObject *_wrap_CADLibor(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    int arg0 ;
    TimeUnit *arg1 ;
    TermStructureRelinkableHandle *arg2 ;
    TimeUnit temp ;
    PyObject * obj1  = 0 ;
    PyObject * argo2 =0 ;
    char *kwnames[] = {
        "n","units","h", NULL 
    };
    XiborHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"iOO:CADLibor",kwnames,&arg0,&obj1,&argo2)) return NULL;
    {
        if (PyString_Check(obj1)) {
            std::string s(PyString_AsString(obj1));
            s = StringFormatter::toLowercase(s);
            if (s == "d" || s == "day" || s == "days")
            temp = Days;
            else if (s == "w" || s == "week" || s == "weeks")
            temp = Weeks;
            else if (s == "m" || s == "month" || s == "months")
            temp = Months;
            else if (s == "y" || s == "year" || s == "years")
            temp = Years;
            else {
                PyErr_SetString(PyExc_TypeError,"not a time unit");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a time unit");
            return NULL;
        }
        arg1 = &temp;
    }
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            result = new XiborHandle (NewCADLibor(arg0,*arg1,*arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_XiborHandle);
    return resultobj;
}


static PyObject *_wrap_CHFLibor(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    int arg0 ;
    TimeUnit *arg1 ;
    TermStructureRelinkableHandle *arg2 ;
    TimeUnit temp ;
    PyObject * obj1  = 0 ;
    PyObject * argo2 =0 ;
    char *kwnames[] = {
        "n","units","h", NULL 
    };
    XiborHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"iOO:CHFLibor",kwnames,&arg0,&obj1,&argo2)) return NULL;
    {
        if (PyString_Check(obj1)) {
            std::string s(PyString_AsString(obj1));
            s = StringFormatter::toLowercase(s);
            if (s == "d" || s == "day" || s == "days")
            temp = Days;
            else if (s == "w" || s == "week" || s == "weeks")
            temp = Weeks;
            else if (s == "m" || s == "month" || s == "months")
            temp = Months;
            else if (s == "y" || s == "year" || s == "years")
            temp = Years;
            else {
                PyErr_SetString(PyExc_TypeError,"not a time unit");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a time unit");
            return NULL;
        }
        arg1 = &temp;
    }
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            result = new XiborHandle (NewCHFLibor(arg0,*arg1,*arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_XiborHandle);
    return resultobj;
}


static PyObject *_wrap_ZARLibor(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    int arg0 ;
    TimeUnit *arg1 ;
    TermStructureRelinkableHandle *arg2 ;
    TimeUnit temp ;
    PyObject * obj1  = 0 ;
    PyObject * argo2 =0 ;
    char *kwnames[] = {
        "n","units","h", NULL 
    };
    XiborHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"iOO:ZARLibor",kwnames,&arg0,&obj1,&argo2)) return NULL;
    {
        if (PyString_Check(obj1)) {
            std::string s(PyString_AsString(obj1));
            s = StringFormatter::toLowercase(s);
            if (s == "d" || s == "day" || s == "days")
            temp = Days;
            else if (s == "w" || s == "week" || s == "weeks")
            temp = Weeks;
            else if (s == "m" || s == "month" || s == "months")
            temp = Months;
            else if (s == "y" || s == "year" || s == "years")
            temp = Years;
            else {
                PyErr_SetString(PyExc_TypeError,"not a time unit");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a time unit");
            return NULL;
        }
        arg1 = &temp;
    }
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            result = new XiborHandle (NewZARLibor(arg0,*arg1,*arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_XiborHandle);
    return resultobj;
}


static PyObject *_wrap_delete_CashFlowHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CashFlowHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_CashFlowHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CashFlowHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


CashFlowHandle * new_CashFlowHandle(PyObject *pyCashFlow) {
    {
        return new CashFlowHandle(new PyCashFlow(pyCashFlow));
    }
}


static PyObject *_wrap_new_CashFlow(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PyObject *arg0 ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "pyCashFlow", NULL 
    };
    CashFlowHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_CashFlow",kwnames,&obj0)) return NULL;
    {
        arg0 = obj0;
    }
    {
        try {
            result = (CashFlowHandle *)new_CashFlowHandle(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_CashFlowHandle);
    return resultobj;
}


double CashFlowHandle_amount(CashFlowHandle *self) {
    {
        return (*self)->amount();
    }
}


static PyObject *_wrap_CashFlow_amount(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CashFlowHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:CashFlow_amount",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CashFlowHandle,1)) == -1) return NULL;
    {
        try {
            result = (double )CashFlowHandle_amount(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


Date CashFlowHandle_date(CashFlowHandle *self) {
    {
        return (*self)->date();
    }
}


static PyObject *_wrap_CashFlow_date(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CashFlowHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:CashFlow_date",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CashFlowHandle,1)) == -1) return NULL;
    {
        try {
            result = new Date (CashFlowHandle_date(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


void CashFlowHandle_notifyObservers(CashFlowHandle *self) {
    {
        (*self)->notifyObservers();
    }
}


static PyObject *_wrap_CashFlow_notifyObservers(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CashFlowHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:CashFlow_notifyObservers",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CashFlowHandle,1)) == -1) return NULL;
    {
        try {
            CashFlowHandle_notifyObservers(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_delete_SimpleCashFlowHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SimpleCashFlowHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_SimpleCashFlowHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SimpleCashFlowHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


SimpleCashFlowHandle * new_SimpleCashFlowHandle(double amount,Date date) {
    {
        return new SimpleCashFlowHandle(
        new SimpleCashFlow(amount,date));
    }
}


static PyObject *_wrap_new_SimpleCashFlow(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    double arg0 ;
    Date *arg1 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "amount","date", NULL 
    };
    SimpleCashFlowHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"dO:new_SimpleCashFlow",kwnames,&arg0,&obj1)) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (SimpleCashFlowHandle *)new_SimpleCashFlowHandle(arg0,*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SimpleCashFlowHandle);
    return resultobj;
}


static PyObject *_wrap_delete_FixedRateCouponHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FixedRateCouponHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_FixedRateCouponHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FixedRateCouponHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


FixedRateCouponHandle * new_FixedRateCouponHandle(double nominal,Rate rate,Calendar calendar,RollingConvention convention,DayCounter dayCounter,Date startDate,Date endDate,Date refPeriodStart,Date refPeriodEnd) {
    {
        return new FixedRateCouponHandle(
        new FixedRateCoupon(nominal, rate, calendar, convention,
        dayCounter, startDate, endDate, refPeriodStart,
        refPeriodEnd));
    }
}


static PyObject *_wrap_new_FixedRateCoupon(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    double arg0 ;
    Rate arg1 ;
    Calendar *arg2 ;
    RollingConvention *arg3 ;
    DayCounter *arg4 ;
    Date *arg5 ;
    Date *arg6 ;
    Date *arg7 ;
    Date *arg8 ;
    PyObject * argo2 =0 ;
    RollingConvention temp ;
    PyObject * obj3  = 0 ;
    PyObject * argo4 =0 ;
    Date temp0 ;
    PyObject * obj5  = 0 ;
    Date temp1 ;
    PyObject * obj6  = 0 ;
    Date temp2 ;
    PyObject * obj7  = 0 ;
    Date temp3 ;
    PyObject * obj8  = 0 ;
    char *kwnames[] = {
        "nominal","rate","calendar","convention","dayCounter","startDate","endDate","refPeriodStart","refPeriodEnd", NULL 
    };
    FixedRateCouponHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"ddOOOOOOO:new_FixedRateCoupon",kwnames,&arg0,&arg1,&argo2,&obj3,&argo4,&obj5,&obj6,&obj7,&obj8)) return NULL;
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        if (PyString_Check(obj3)) {
            std::string s(PyString_AsString(obj3));
            s = StringFormatter::toLowercase(s);
            if (s == "f" || s == "fol" || s == "following")
            temp = Following;
            else if (s == "mf" ||s == "modfol" || s == "modifiedfollowing")
            temp = ModifiedFollowing;
            else if (s == "p" || s == "pre" || s == "preceding")
            temp = Preceding;
            else if (s == "mp" ||s == "modpre" || s == "modifiedpreceding")
            temp = ModifiedPreceding;
            else {
                PyErr_SetString(PyExc_TypeError,(s+" is not "
                "a rolling convention").c_str());
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"rolling convention expected");
            return NULL;
        }
        arg3 = &temp;
    }
    if ((SWIG_ConvertPtr(argo4,(void **) &arg4,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    {
        Date* x;
        if (obj5 == Py_None) {
            temp0 = Date();
            arg5 = &temp0;
        }else if ((SWIG_ConvertPtr(obj5,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg5 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj6 == Py_None) {
            temp1 = Date();
            arg6 = &temp1;
        }else if ((SWIG_ConvertPtr(obj6,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg6 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj7 == Py_None) {
            temp2 = Date();
            arg7 = &temp2;
        }else if ((SWIG_ConvertPtr(obj7,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg7 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj8 == Py_None) {
            temp3 = Date();
            arg8 = &temp3;
        }else if ((SWIG_ConvertPtr(obj8,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg8 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (FixedRateCouponHandle *)new_FixedRateCouponHandle(arg0,arg1,*arg2,*arg3,*arg4,*arg5,*arg6,*arg7,*arg8);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FixedRateCouponHandle);
    return resultobj;
}


static PyObject *_wrap_delete_FloatingRateCouponHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FloatingRateCouponHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_FloatingRateCouponHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FloatingRateCouponHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


FloatingRateCouponHandle * new_FloatingRateCouponHandle(double nominal,XiborHandle index,TermStructureRelinkableHandle termStructure,Date startDate,Date endDate,int fixingDays,Spread spread,Date refPeriodStart,Date refPeriodEnd) {
    {
        return new FloatingRateCouponHandle(
        new FloatingRateCoupon(nominal, index,
        termStructure, startDate, endDate, fixingDays, spread,
        refPeriodStart, refPeriodEnd));
    }
}


static PyObject *_wrap_new_FloatingRateCoupon(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    double arg0 ;
    XiborHandle *arg1 ;
    TermStructureRelinkableHandle *arg2 ;
    Date *arg3 ;
    Date *arg4 ;
    int arg5 ;
    Spread arg6 ;
    Date *arg7 ;
    Date *arg8 ;
    PyObject * argo1 =0 ;
    PyObject * argo2 =0 ;
    Date temp ;
    PyObject * obj3  = 0 ;
    Date temp0 ;
    PyObject * obj4  = 0 ;
    Date temp1 ;
    PyObject * obj7  = 0 ;
    Date temp2 ;
    PyObject * obj8  = 0 ;
    char *kwnames[] = {
        "nominal","index","termStructure","startDate","endDate","fixingDays","spread","refPeriodStart","refPeriodEnd", NULL 
    };
    FloatingRateCouponHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"dOOOOidOO:new_FloatingRateCoupon",kwnames,&arg0,&argo1,&argo2,&obj3,&obj4,&arg5,&arg6,&obj7,&obj8)) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_XiborHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        Date* x;
        if (obj3 == Py_None) {
            temp = Date();
            arg3 = &temp;
        }else if ((SWIG_ConvertPtr(obj3,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg3 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj4 == Py_None) {
            temp0 = Date();
            arg4 = &temp0;
        }else if ((SWIG_ConvertPtr(obj4,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg4 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj7 == Py_None) {
            temp1 = Date();
            arg7 = &temp1;
        }else if ((SWIG_ConvertPtr(obj7,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg7 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj8 == Py_None) {
            temp2 = Date();
            arg8 = &temp2;
        }else if ((SWIG_ConvertPtr(obj8,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg8 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (FloatingRateCouponHandle *)new_FloatingRateCouponHandle(arg0,*arg1,*arg2,*arg3,*arg4,arg5,arg6,*arg7,*arg8);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FloatingRateCouponHandle);
    return resultobj;
}


static PyObject *_wrap_delete_CashFlowHandleVector(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CashFlowHandleVector *arg0 ;
    CashFlowHandleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_CashFlowHandleVector",kwnames,&obj0)) return NULL;
    {
        CashFlowHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = CashFlowHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                CashFlowHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_CashFlowHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"CashFlow" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_CashFlowHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"CashFlowVector" " expected");
            return NULL;
        }
    }
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


CashFlowHandleVector * new_CashFlowHandleVector(CashFlowHandleVector const &v) {
    {
        return new CashFlowHandleVector(v);
    }
}


static PyObject *_wrap_new_CashFlowVector(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CashFlowHandleVector *arg0 ;
    CashFlowHandleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "v", NULL 
    };
    CashFlowHandleVector *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_CashFlowVector",kwnames,&obj0)) return NULL;
    {
        CashFlowHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = CashFlowHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                CashFlowHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_CashFlowHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"CashFlow" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_CashFlowHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"CashFlowVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (CashFlowHandleVector *)new_CashFlowHandleVector((CashFlowHandleVector const &)*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_CashFlowHandleVector);
    return resultobj;
}


int CashFlowHandleVector___len__(CashFlowHandleVector *self) {
    {
        return self->size();
    }
}


static PyObject *_wrap_CashFlowVector___len__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CashFlowHandleVector *arg0 ;
    CashFlowHandleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:CashFlowVector___len__",kwnames,&obj0)) return NULL;
    {
        CashFlowHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = CashFlowHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                CashFlowHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_CashFlowHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"CashFlow" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_CashFlowHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"CashFlowVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (int )CashFlowHandleVector___len__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


CashFlowHandle CashFlowHandleVector___getitem__(CashFlowHandleVector *self,int i) {
    {
        int size_ = static_cast<int>(self->size());
        if (i>=0 && i<size_) {
            return (*self)[i];
        }else if (i<0 && -i<=size_) {
            return (*self)[size_+i];
        }else {
            throw IndexError("CashFlowVector" " index out of range");
        }
        QL_DUMMY_RETURN(CashFlowHandle())
    }
}


static PyObject *_wrap_CashFlowVector___getitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CashFlowHandleVector *arg0 ;
    int arg1 ;
    CashFlowHandleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self","i", NULL 
    };
    CashFlowHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:CashFlowVector___getitem__",kwnames,&obj0,&arg1)) return NULL;
    {
        CashFlowHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = CashFlowHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                CashFlowHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_CashFlowHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"CashFlow" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_CashFlowHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"CashFlowVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = new CashFlowHandle (CashFlowHandleVector___getitem__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_CashFlowHandle);
    return resultobj;
}


void CashFlowHandleVector___setitem__(CashFlowHandleVector *self,int i,CashFlowHandle const &x) {
    {
        int size_ = static_cast<int>(self->size());
        if (i>=0 && i<size_) {
            (*self)[i] = x;
        }else if (i<0 && -i<=size_) {
            (*self)[size_+i] = x;
        }else {
            throw IndexError("CashFlowVector" " index out of range");
        }
    }
}


static PyObject *_wrap_CashFlowVector___setitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CashFlowHandleVector *arg0 ;
    int arg1 ;
    CashFlowHandle *arg2 ;
    CashFlowHandleVector temp ;
    PyObject * obj0  = 0 ;
    PyObject * argo2 =0 ;
    char *kwnames[] = {
        "self","i","x", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OiO:CashFlowVector___setitem__",kwnames,&obj0,&arg1,&argo2)) return NULL;
    {
        CashFlowHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = CashFlowHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                CashFlowHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_CashFlowHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"CashFlow" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_CashFlowHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"CashFlowVector" " expected");
            return NULL;
        }
    }
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_CashFlowHandle,1)) == -1) return NULL;
    {
        try {
            CashFlowHandleVector___setitem__(arg0,arg1,(CashFlowHandle const &)*arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


CashFlowHandleVector CashFlowHandleVector___getslice__(CashFlowHandleVector *self,int i,int j) {
    {
        int size_ = static_cast<int>(self->size());
        if (i<0)
        i = size_+i;
        if (j<0)
        j = size_+j;
        i = QL_MAX(0,i);
        j = QL_MIN(size_,j);
        CashFlowHandleVector tmp(j-i);
        std::copy(self->begin()+i,self->begin()+j,tmp.begin());
        return tmp;
    }
}


static PyObject *_wrap_CashFlowVector___getslice__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CashFlowHandleVector *arg0 ;
    int arg1 ;
    int arg2 ;
    CashFlowHandleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self","i","j", NULL 
    };
    CashFlowHandleVector *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oii:CashFlowVector___getslice__",kwnames,&obj0,&arg1,&arg2)) return NULL;
    {
        CashFlowHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = CashFlowHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                CashFlowHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_CashFlowHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"CashFlow" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_CashFlowHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"CashFlowVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = new CashFlowHandleVector (CashFlowHandleVector___getslice__(arg0,arg1,arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_CashFlowHandleVector);
    return resultobj;
}


void CashFlowHandleVector___setslice__(CashFlowHandleVector *self,int i,int j,CashFlowHandleVector const &rhs) {
    {
        int size_ = static_cast<int>(self->size());
        if (i<0)
        i = size_+i;
        if (j<0)
        j = size_+j;
        i = QL_MAX(0,i);
        j = QL_MIN(size_,j);
        QL_ENSURE(static_cast<int>(rhs.size()) == j-i,
        "CashFlowVector""s are not resizable");
        std::copy(rhs.begin(),rhs.end(),self->begin()+i);
    }
}


static PyObject *_wrap_CashFlowVector___setslice__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CashFlowHandleVector *arg0 ;
    int arg1 ;
    int arg2 ;
    CashFlowHandleVector *arg3 ;
    CashFlowHandleVector temp ;
    PyObject * obj0  = 0 ;
    CashFlowHandleVector temp0 ;
    PyObject * obj3  = 0 ;
    char *kwnames[] = {
        "self","i","j","rhs", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OiiO:CashFlowVector___setslice__",kwnames,&obj0,&arg1,&arg2,&obj3)) return NULL;
    {
        CashFlowHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = CashFlowHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                CashFlowHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_CashFlowHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"CashFlow" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_CashFlowHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"CashFlowVector" " expected");
            return NULL;
        }
    }
    {
        CashFlowHandleVector* v;
        if (PyTuple_Check(obj3) || PyList_Check(obj3)) {
            /* Size */ int size = (PyTuple_Check(obj3) ?
            PyTuple_Size(obj3) :
            PyList_Size(obj3));
            temp0 = CashFlowHandleVector(size);
            arg3 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                CashFlowHandle* x;
                PyObject* o = PySequence_GetItem(obj3,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_CashFlowHandle,0)) != -1) {
                    (*arg3)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"CashFlow" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj3,(void **) &v,
        SWIGTYPE_p_CashFlowHandleVector,0)) != -1) {
            arg3 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"CashFlowVector" " expected");
            return NULL;
        }
    }
    {
        try {
            CashFlowHandleVector___setslice__(arg0,arg1,arg2,(CashFlowHandleVector const &)*arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


bool CashFlowHandleVector___nonzero__(CashFlowHandleVector *self) {
    {
        return (self->size() != 0);
    }
}


static PyObject *_wrap_CashFlowVector___nonzero__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CashFlowHandleVector *arg0 ;
    CashFlowHandleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:CashFlowVector___nonzero__",kwnames,&obj0)) return NULL;
    {
        CashFlowHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = CashFlowHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                CashFlowHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_CashFlowHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"CashFlow" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_CashFlowHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"CashFlowVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (bool )CashFlowHandleVector___nonzero__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_new_FixedRateCouponVector(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DoubleVector *arg0 ;
    DoubleVector *arg1 ;
    Date *arg2 ;
    Date *arg3 ;
    int arg4 ;
    Calendar *arg5 ;
    RollingConvention *arg6 ;
    bool arg7 ;
    DayCounter *arg8 ;
    DayCounter *arg9 ;
    Date *arg10 ;
    DoubleVector temp ;
    PyObject * obj0  = 0 ;
    DoubleVector temp0 ;
    PyObject * obj1  = 0 ;
    Date temp1 ;
    PyObject * obj2  = 0 ;
    Date temp2 ;
    PyObject * obj3  = 0 ;
    PyObject * argo5 =0 ;
    RollingConvention temp3 ;
    PyObject * obj6  = 0 ;
    int tempbool7 ;
    PyObject * argo8 =0 ;
    PyObject * argo9 =0 ;
    Date temp4 ;
    PyObject * obj10  = 0 ;
    char *kwnames[] = {
        "nominals","couponRates","startDate","endDate","frequency","calendar","convention","isAdjusted","dayCount","firstPeriodDayCount","stubDate", NULL 
    };
    FixedRateCouponVector *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOOOiOOiOOO:new_FixedRateCouponVector",kwnames,&obj0,&obj1,&obj2,&obj3,&arg4,&argo5,&obj6,&tempbool7,&argo8,&argo9,&obj10)) return NULL;
    {
        DoubleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DoubleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            /* Size */ int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp0 = DoubleVector(size);
            arg1 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (o == Py_None) {
                    (*arg1)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj2 == Py_None) {
            temp1 = Date();
            arg2 = &temp1;
        }else if ((SWIG_ConvertPtr(obj2,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg2 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj3 == Py_None) {
            temp2 = Date();
            arg3 = &temp2;
        }else if ((SWIG_ConvertPtr(obj3,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg3 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    if ((SWIG_ConvertPtr(argo5,(void **) &arg5,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        if (PyString_Check(obj6)) {
            std::string s(PyString_AsString(obj6));
            s = StringFormatter::toLowercase(s);
            if (s == "f" || s == "fol" || s == "following")
            temp3 = Following;
            else if (s == "mf" ||s == "modfol" || s == "modifiedfollowing")
            temp3 = ModifiedFollowing;
            else if (s == "p" || s == "pre" || s == "preceding")
            temp3 = Preceding;
            else if (s == "mp" ||s == "modpre" || s == "modifiedpreceding")
            temp3 = ModifiedPreceding;
            else {
                PyErr_SetString(PyExc_TypeError,(s+" is not "
                "a rolling convention").c_str());
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"rolling convention expected");
            return NULL;
        }
        arg6 = &temp3;
    }
    arg7 = (bool ) tempbool7;
    if ((SWIG_ConvertPtr(argo8,(void **) &arg8,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo9,(void **) &arg9,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    {
        Date* x;
        if (obj10 == Py_None) {
            temp4 = Date();
            arg10 = &temp4;
        }else if ((SWIG_ConvertPtr(obj10,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg10 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (FixedRateCouponVector *)new FixedRateCouponVector(*arg0,*arg1,*arg2,*arg3,arg4,*arg5,*arg6,arg7,*arg8,*arg9,*arg10);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FixedRateCouponVector);
    return resultobj;
}


static PyObject *_wrap_delete_FixedRateCouponVector(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FixedRateCouponVector *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_FixedRateCouponVector",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FixedRateCouponVector,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_delete_FloatingRateCouponVector(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FloatingRateCouponVector *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_FloatingRateCouponVector",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FloatingRateCouponVector,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


FloatingRateCouponVector * new_FloatingRateCouponVector(DoubleVector nominals,Date startDate,Date endDate,int frequency,Calendar calendar,RollingConvention convention,TermStructureRelinkableHandle termStructure,XiborHandle index,int indexFixingDays,DoubleVector spreads,Date stubDate) {
    {
        return new FloatingRateCouponVector(nominals,
        startDate, endDate, frequency, calendar,
        convention, termStructure, index,
        indexFixingDays, spreads, stubDate);
    }
}


static PyObject *_wrap_new_FloatingRateCouponVector(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DoubleVector *arg0 ;
    Date *arg1 ;
    Date *arg2 ;
    int arg3 ;
    Calendar *arg4 ;
    RollingConvention *arg5 ;
    TermStructureRelinkableHandle *arg6 ;
    XiborHandle *arg7 ;
    int arg8 ;
    DoubleVector *arg9 ;
    Date *arg10 ;
    DoubleVector temp ;
    PyObject * obj0  = 0 ;
    Date temp0 ;
    PyObject * obj1  = 0 ;
    Date temp1 ;
    PyObject * obj2  = 0 ;
    PyObject * argo4 =0 ;
    RollingConvention temp2 ;
    PyObject * obj5  = 0 ;
    PyObject * argo6 =0 ;
    PyObject * argo7 =0 ;
    DoubleVector temp3 ;
    PyObject * obj9  = 0 ;
    Date temp4 ;
    PyObject * obj10  = 0 ;
    char *kwnames[] = {
        "nominals","startDate","endDate","frequency","calendar","convention","termStructure","index","indexFixingDays","spreads","stubDate", NULL 
    };
    FloatingRateCouponVector *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOOiOOOOiOO:new_FloatingRateCouponVector",kwnames,&obj0,&obj1,&obj2,&arg3,&argo4,&obj5,&argo6,&argo7,&arg8,&obj9,&obj10)) return NULL;
    {
        DoubleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = DoubleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (o == Py_None) {
                    (*arg0)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj1 == Py_None) {
            temp0 = Date();
            arg1 = &temp0;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj2 == Py_None) {
            temp1 = Date();
            arg2 = &temp1;
        }else if ((SWIG_ConvertPtr(obj2,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg2 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    if ((SWIG_ConvertPtr(argo4,(void **) &arg4,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        if (PyString_Check(obj5)) {
            std::string s(PyString_AsString(obj5));
            s = StringFormatter::toLowercase(s);
            if (s == "f" || s == "fol" || s == "following")
            temp2 = Following;
            else if (s == "mf" ||s == "modfol" || s == "modifiedfollowing")
            temp2 = ModifiedFollowing;
            else if (s == "p" || s == "pre" || s == "preceding")
            temp2 = Preceding;
            else if (s == "mp" ||s == "modpre" || s == "modifiedpreceding")
            temp2 = ModifiedPreceding;
            else {
                PyErr_SetString(PyExc_TypeError,(s+" is not "
                "a rolling convention").c_str());
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"rolling convention expected");
            return NULL;
        }
        arg5 = &temp2;
    }
    if ((SWIG_ConvertPtr(argo6,(void **) &arg6,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo7,(void **) &arg7,SWIGTYPE_p_XiborHandle,1)) == -1) return NULL;
    {
        DoubleVector* v;
        if (PyTuple_Check(obj9) || PyList_Check(obj9)) {
            /* Size */ int size = (PyTuple_Check(obj9) ?
            PyTuple_Size(obj9) :
            PyList_Size(obj9));
            temp3 = DoubleVector(size);
            arg9 = &temp3;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj9,i);
                if (o == Py_None) {
                    (*arg9)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg9)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg9)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj9,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg9 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        Date* x;
        if (obj10 == Py_None) {
            temp4 = Date();
            arg10 = &temp4;
        }else if ((SWIG_ConvertPtr(obj10,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg10 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (FloatingRateCouponVector *)new_FloatingRateCouponVector(*arg0,*arg1,*arg2,arg3,*arg4,*arg5,*arg6,*arg7,arg8,*arg9,*arg10);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FloatingRateCouponVector);
    return resultobj;
}


static PyObject *_wrap_delete_SwapHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SwapHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_SwapHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SwapHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


SwapHandle * new_SwapHandle(CashFlowHandleVector firstLeg,CashFlowHandleVector secondLeg,TermStructureRelinkableHandle termStructure,String isinCode,String description) {
    {
        return new SwapHandle(
        new Swap(firstLeg, secondLeg, termStructure,
        isinCode, description));
    }
}


static PyObject *_wrap_new_Swap(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CashFlowHandleVector *arg0 ;
    CashFlowHandleVector *arg1 ;
    TermStructureRelinkableHandle *arg2 ;
    String *arg3 ;
    String *arg4 ;
    CashFlowHandleVector temp ;
    PyObject * obj0  = 0 ;
    CashFlowHandleVector temp0 ;
    PyObject * obj1  = 0 ;
    PyObject * argo2 =0 ;
    PyObject * obj3  = 0 ;
    PyObject * obj4  = 0 ;
    char *kwnames[] = {
        "firstLeg","secondLeg","termStructure","isinCode","description", NULL 
    };
    SwapHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOOOO:new_Swap",kwnames,&obj0,&obj1,&argo2,&obj3,&obj4)) return NULL;
    {
        CashFlowHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = CashFlowHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                CashFlowHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_CashFlowHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"CashFlow" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_CashFlowHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"CashFlowVector" " expected");
            return NULL;
        }
    }
    {
        CashFlowHandleVector* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            /* Size */ int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp0 = CashFlowHandleVector(size);
            arg1 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                CashFlowHandle* x;
                PyObject* o = PySequence_GetItem(obj1,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_CashFlowHandle,0)) != -1) {
                    (*arg1)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"CashFlow" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_CashFlowHandleVector,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"CashFlowVector" " expected");
            return NULL;
        }
    }
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        if (PyString_Check(obj3)) {
            arg3 = new std::string(PyString_AsString(obj3));
        }else {
            PyErr_SetString(PyExc_TypeError,"not a string");
            return NULL;
        }
    }
    {
        if (PyString_Check(obj4)) {
            arg4 = new std::string(PyString_AsString(obj4));
        }else {
            PyErr_SetString(PyExc_TypeError,"not a string");
            return NULL;
        }
    }
    {
        try {
            result = (SwapHandle *)new_SwapHandle(*arg0,*arg1,*arg2,*arg3,*arg4);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SwapHandle);
    {
        delete arg3;
    }
    {
        delete arg4;
    }
    return resultobj;
}


static PyObject *_wrap_delete_SimpleSwapHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SimpleSwapHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_SimpleSwapHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SimpleSwapHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


SimpleSwapHandle * new_SimpleSwapHandle(bool payFixedRate,Date startDate,int n,TimeUnit unit,Calendar calendar,RollingConvention rollingConvention,double nominal,int fixedFrequency,Rate fixedRate,bool fixedIsAdjusted,DayCounter fixedDayCount,int floatingFrequency,XiborHandle index,int indexFixingDays,Spread spread,TermStructureRelinkableHandle termStructure,String isinCode,String description) {
    {
        QL_REQUIRE(!index.isNull(), "null index given");
        Handle<Xibor> h = index;
        QL_REQUIRE(!h.isNull(), "index not of Libor type");
        return new SimpleSwapHandle(
        new SimpleSwap(payFixedRate, startDate, n, unit, calendar,
        rollingConvention, nominal, fixedFrequency, fixedRate,
        fixedIsAdjusted, fixedDayCount, floatingFrequency,
        h, indexFixingDays, spread, termStructure, 
        isinCode, description));
    }
}


static PyObject *_wrap_new_SimpleSwap(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    bool arg0 ;
    Date *arg1 ;
    int arg2 ;
    TimeUnit *arg3 ;
    Calendar *arg4 ;
    RollingConvention *arg5 ;
    double arg6 ;
    int arg7 ;
    Rate arg8 ;
    bool arg9 ;
    DayCounter *arg10 ;
    int arg11 ;
    XiborHandle *arg12 ;
    int arg13 ;
    Spread arg14 ;
    TermStructureRelinkableHandle *arg15 ;
    String *arg16 ;
    String *arg17 ;
    int tempbool0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    TimeUnit temp0 ;
    PyObject * obj3  = 0 ;
    PyObject * argo4 =0 ;
    RollingConvention temp1 ;
    PyObject * obj5  = 0 ;
    int tempbool9 ;
    PyObject * argo10 =0 ;
    PyObject * argo12 =0 ;
    PyObject * argo15 =0 ;
    PyObject * obj16  = 0 ;
    PyObject * obj17  = 0 ;
    char *kwnames[] = {
        "payFixedRate","startDate","n","unit","calendar","rollingConvention","nominal","fixedFrequency","fixedRate","fixedIsAdjusted","fixedDayCount","floatingFrequency","index","indexFixingDays","spread","termStructure","isinCode","description", NULL 
    };
    SimpleSwapHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"iOiOOOdidiOiOidOOO:new_SimpleSwap",kwnames,&tempbool0,&obj1,&arg2,&obj3,&argo4,&obj5,&arg6,&arg7,&arg8,&tempbool9,&argo10,&arg11,&argo12,&arg13,&arg14,&argo15,&obj16,&obj17)) return NULL;
    arg0 = (bool ) tempbool0;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    {
        if (PyString_Check(obj3)) {
            std::string s(PyString_AsString(obj3));
            s = StringFormatter::toLowercase(s);
            if (s == "d" || s == "day" || s == "days")
            temp0 = Days;
            else if (s == "w" || s == "week" || s == "weeks")
            temp0 = Weeks;
            else if (s == "m" || s == "month" || s == "months")
            temp0 = Months;
            else if (s == "y" || s == "year" || s == "years")
            temp0 = Years;
            else {
                PyErr_SetString(PyExc_TypeError,"not a time unit");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a time unit");
            return NULL;
        }
        arg3 = &temp0;
    }
    if ((SWIG_ConvertPtr(argo4,(void **) &arg4,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        if (PyString_Check(obj5)) {
            std::string s(PyString_AsString(obj5));
            s = StringFormatter::toLowercase(s);
            if (s == "f" || s == "fol" || s == "following")
            temp1 = Following;
            else if (s == "mf" ||s == "modfol" || s == "modifiedfollowing")
            temp1 = ModifiedFollowing;
            else if (s == "p" || s == "pre" || s == "preceding")
            temp1 = Preceding;
            else if (s == "mp" ||s == "modpre" || s == "modifiedpreceding")
            temp1 = ModifiedPreceding;
            else {
                PyErr_SetString(PyExc_TypeError,(s+" is not "
                "a rolling convention").c_str());
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"rolling convention expected");
            return NULL;
        }
        arg5 = &temp1;
    }
    arg9 = (bool ) tempbool9;
    if ((SWIG_ConvertPtr(argo10,(void **) &arg10,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo12,(void **) &arg12,SWIGTYPE_p_XiborHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo15,(void **) &arg15,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        if (PyString_Check(obj16)) {
            arg16 = new std::string(PyString_AsString(obj16));
        }else {
            PyErr_SetString(PyExc_TypeError,"not a string");
            return NULL;
        }
    }
    {
        if (PyString_Check(obj17)) {
            arg17 = new std::string(PyString_AsString(obj17));
        }else {
            PyErr_SetString(PyExc_TypeError,"not a string");
            return NULL;
        }
    }
    {
        try {
            result = (SimpleSwapHandle *)new_SimpleSwapHandle(arg0,*arg1,arg2,*arg3,*arg4,*arg5,arg6,arg7,arg8,arg9,*arg10,arg11,*arg12,arg13,arg14,*arg15,*arg16,*arg17);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SimpleSwapHandle);
    {
        delete arg16;
    }
    {
        delete arg17;
    }
    return resultobj;
}


Rate SimpleSwapHandle_fairRate(SimpleSwapHandle *self) {
    {
        return (*self)->fairRate();
    }
}


static PyObject *_wrap_SimpleSwap_fairRate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SimpleSwapHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Rate result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:SimpleSwap_fairRate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SimpleSwapHandle,1)) == -1) return NULL;
    {
        try {
            result = (Rate )SimpleSwapHandle_fairRate(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


double SimpleSwapHandle_fixedLegBPS(SimpleSwapHandle *self) {
    {
        return (*self)->fixedLegBPS();
    }
}


static PyObject *_wrap_SimpleSwap_fixedLegBPS(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SimpleSwapHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:SimpleSwap_fixedLegBPS",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SimpleSwapHandle,1)) == -1) return NULL;
    {
        try {
            result = (double )SimpleSwapHandle_fixedLegBPS(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


double SimpleSwapHandle_floatingLegBPS(SimpleSwapHandle *self) {
    {
        return (*self)->floatingLegBPS();
    }
}


static PyObject *_wrap_SimpleSwap_floatingLegBPS(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SimpleSwapHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:SimpleSwap_floatingLegBPS",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SimpleSwapHandle,1)) == -1) return NULL;
    {
        try {
            result = (double )SimpleSwapHandle_floatingLegBPS(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


Date SimpleSwapHandle_maturity(SimpleSwapHandle *self) {
    {
        return (*self)->maturity();
    }
}


static PyObject *_wrap_SimpleSwap_maturity(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SimpleSwapHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:SimpleSwap_maturity",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SimpleSwapHandle,1)) == -1) return NULL;
    {
        try {
            result = new Date (SimpleSwapHandle_maturity(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


static PyObject *_wrap_delete_Swaption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SwaptionHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_Swaption",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SwaptionHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


SwaptionHandle * new_SwaptionHandle(SimpleSwapHandle const &swap,Exercise const &exercise,TermStructureRelinkableHandle const &termStructure,OptionEngineHandle const &engine) {
    {
        return new SwaptionHandle(new Swaption(swap,exercise,
        termStructure,engine));
    }
}


static PyObject *_wrap_new_Swaption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SimpleSwapHandle *arg0 ;
    Exercise *arg1 ;
    TermStructureRelinkableHandle *arg2 ;
    OptionEngineHandle *arg3 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    PyObject * argo2 =0 ;
    PyObject * argo3 =0 ;
    char *kwnames[] = {
        "swap","exercise","termStructure","engine", NULL 
    };
    SwaptionHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOOO:new_Swaption",kwnames,&argo0,&argo1,&argo2,&argo3)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SimpleSwapHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_Exercise,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo3,(void **) &arg3,SWIGTYPE_p_OptionEngineHandle,1)) == -1) return NULL;
    {
        try {
            result = (SwaptionHandle *)new_SwaptionHandle((SimpleSwapHandle const &)*arg0,(Exercise const &)*arg1,(TermStructureRelinkableHandle const &)*arg2,(OptionEngineHandle const &)*arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SwaptionHandle);
    return resultobj;
}


static PyObject *_wrap_delete_VanillaCapHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    VanillaCapHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_VanillaCapHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_VanillaCapHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


VanillaCapHandle * new_VanillaCapHandle(FloatingRateCouponVector const &leg,DoubleVector const &capRates,TermStructureRelinkableHandle const &termStructure,OptionEngineHandle const &engine) {
    {
        return new VanillaCapHandle(
        new VanillaCap(leg,capRates,
        termStructure,engine));
    }
}


static PyObject *_wrap_new_Cap(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FloatingRateCouponVector *arg0 ;
    DoubleVector *arg1 ;
    TermStructureRelinkableHandle *arg2 ;
    OptionEngineHandle *arg3 ;
    PyObject * argo0 =0 ;
    DoubleVector temp ;
    PyObject * obj1  = 0 ;
    PyObject * argo2 =0 ;
    PyObject * argo3 =0 ;
    char *kwnames[] = {
        "leg","capRates","termStructure","engine", NULL 
    };
    VanillaCapHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOOO:new_Cap",kwnames,&argo0,&obj1,&argo2,&argo3)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FloatingRateCouponVector,1)) == -1) return NULL;
    {
        DoubleVector* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            /* Size */ int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp = DoubleVector(size);
            arg1 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (o == Py_None) {
                    (*arg1)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo3,(void **) &arg3,SWIGTYPE_p_OptionEngineHandle,1)) == -1) return NULL;
    {
        try {
            result = (VanillaCapHandle *)new_VanillaCapHandle((FloatingRateCouponVector const &)*arg0,(DoubleVector const &)*arg1,(TermStructureRelinkableHandle const &)*arg2,(OptionEngineHandle const &)*arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_VanillaCapHandle);
    return resultobj;
}


static PyObject *_wrap_delete_VanillaFloorHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    VanillaFloorHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_VanillaFloorHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_VanillaFloorHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


VanillaFloorHandle * new_VanillaFloorHandle(FloatingRateCouponVector const &leg,DoubleVector const &floorRates,TermStructureRelinkableHandle const &termStructure,OptionEngineHandle const &engine) {
    {
        return new VanillaFloorHandle(
        new VanillaFloor(leg,floorRates,
        termStructure,engine));
    }
}


static PyObject *_wrap_new_Floor(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FloatingRateCouponVector *arg0 ;
    DoubleVector *arg1 ;
    TermStructureRelinkableHandle *arg2 ;
    OptionEngineHandle *arg3 ;
    PyObject * argo0 =0 ;
    DoubleVector temp ;
    PyObject * obj1  = 0 ;
    PyObject * argo2 =0 ;
    PyObject * argo3 =0 ;
    char *kwnames[] = {
        "leg","floorRates","termStructure","engine", NULL 
    };
    VanillaFloorHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOOO:new_Floor",kwnames,&argo0,&obj1,&argo2,&argo3)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FloatingRateCouponVector,1)) == -1) return NULL;
    {
        DoubleVector* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            /* Size */ int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp = DoubleVector(size);
            arg1 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (o == Py_None) {
                    (*arg1)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo3,(void **) &arg3,SWIGTYPE_p_OptionEngineHandle,1)) == -1) return NULL;
    {
        try {
            result = (VanillaFloorHandle *)new_VanillaFloorHandle((FloatingRateCouponVector const &)*arg0,(DoubleVector const &)*arg1,(TermStructureRelinkableHandle const &)*arg2,(OptionEngineHandle const &)*arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_VanillaFloorHandle);
    return resultobj;
}


static PyObject *_wrap_delete_VanillaCollarHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    VanillaCollarHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_VanillaCollarHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_VanillaCollarHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


VanillaCollarHandle * new_VanillaCollarHandle(FloatingRateCouponVector const &leg,DoubleVector const &capRates,DoubleVector const &floorRates,TermStructureRelinkableHandle const &termStructure,OptionEngineHandle const &engine) {
    {
        return new VanillaCollarHandle(
        new VanillaCollar(leg,capRates,floorRates,
        termStructure,engine));
    }
}


static PyObject *_wrap_new_Collar(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FloatingRateCouponVector *arg0 ;
    DoubleVector *arg1 ;
    DoubleVector *arg2 ;
    TermStructureRelinkableHandle *arg3 ;
    OptionEngineHandle *arg4 ;
    PyObject * argo0 =0 ;
    DoubleVector temp ;
    PyObject * obj1  = 0 ;
    DoubleVector temp0 ;
    PyObject * obj2  = 0 ;
    PyObject * argo3 =0 ;
    PyObject * argo4 =0 ;
    char *kwnames[] = {
        "leg","capRates","floorRates","termStructure","engine", NULL 
    };
    VanillaCollarHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOOOO:new_Collar",kwnames,&argo0,&obj1,&obj2,&argo3,&argo4)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FloatingRateCouponVector,1)) == -1) return NULL;
    {
        DoubleVector* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            /* Size */ int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp = DoubleVector(size);
            arg1 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (o == Py_None) {
                    (*arg1)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj2) || PyList_Check(obj2)) {
            /* Size */ int size = (PyTuple_Check(obj2) ?
            PyTuple_Size(obj2) :
            PyList_Size(obj2));
            temp0 = DoubleVector(size);
            arg2 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj2,i);
                if (o == Py_None) {
                    (*arg2)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg2)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg2)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj2,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg2 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    if ((SWIG_ConvertPtr(argo3,(void **) &arg3,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo4,(void **) &arg4,SWIGTYPE_p_OptionEngineHandle,1)) == -1) return NULL;
    {
        try {
            result = (VanillaCollarHandle *)new_VanillaCollarHandle((FloatingRateCouponVector const &)*arg0,(DoubleVector const &)*arg1,(DoubleVector const &)*arg2,(TermStructureRelinkableHandle const &)*arg3,(OptionEngineHandle const &)*arg4);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_VanillaCollarHandle);
    return resultobj;
}


static PyObject *_wrap_delete_BlackModelHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BlackModelHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_BlackModelHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BlackModelHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


BlackModelHandle * new_BlackModelHandle(MarketElementRelinkableHandle const &volatility,TermStructureRelinkableHandle const &termStructure) {
    {
        return new BlackModelHandle(new BlackModel(volatility,termStructure));
    }
}


static PyObject *_wrap_new_BlackModel(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementRelinkableHandle *arg0 ;
    TermStructureRelinkableHandle *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "volatility","termStructure", NULL 
    };
    BlackModelHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:new_BlackModel",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_TermStructureRelinkableHandle,1)) == -1) return NULL;
    {
        try {
            result = (BlackModelHandle *)new_BlackModelHandle((MarketElementRelinkableHandle const &)*arg0,(TermStructureRelinkableHandle const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_BlackModelHandle);
    return resultobj;
}


static PyObject *_wrap_delete_BlackSwaptionHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BlackSwaptionHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_BlackSwaptionHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BlackSwaptionHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


BlackSwaptionHandle * new_BlackSwaptionHandle(BlackModelHandle const &model) {
    {
        return new BlackSwaptionHandle(new BlackSwaption(model));
    }
}


static PyObject *_wrap_new_BlackSwaptionEngine(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BlackModelHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "model", NULL 
    };
    BlackSwaptionHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_BlackSwaptionEngine",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BlackModelHandle,1)) == -1) return NULL;
    {
        try {
            result = (BlackSwaptionHandle *)new_BlackSwaptionHandle((BlackModelHandle const &)*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_BlackSwaptionHandle);
    return resultobj;
}


static PyObject *_wrap_delete_BlackCapFloorHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BlackCapFloorHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_BlackCapFloorHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BlackCapFloorHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


BlackCapFloorHandle * new_BlackCapFloorHandle(BlackModelHandle const &model) {
    {
        return new BlackCapFloorHandle(new BlackCapFloor(model));
    }
}


static PyObject *_wrap_new_BlackCapFloorEngine(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BlackModelHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "model", NULL 
    };
    BlackCapFloorHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_BlackCapFloorEngine",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BlackModelHandle,1)) == -1) return NULL;
    {
        try {
            result = (BlackCapFloorHandle *)new_BlackCapFloorHandle((BlackModelHandle const &)*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_BlackCapFloorHandle);
    return resultobj;
}


static PyObject *_wrap_new_BoundaryCondition(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BoundaryConditionType *arg0 ;
    double arg1 ;
    BoundaryConditionType temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "type","value", NULL 
    };
    BoundaryCondition *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:new_BoundaryCondition",kwnames,&obj0,&arg1)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "" || s == "none")
            temp = BoundaryCondition::None;
            else if (s == "neumann")
            temp = BoundaryCondition::Neumann;
            else if (s == "dirichlet")
            temp = BoundaryCondition::Dirichlet;
            else {
                PyErr_SetString(PyExc_TypeError,"not a boundary condition type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a boundary condition type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        try {
            result = (BoundaryCondition *)new BoundaryCondition(*arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_BoundaryCondition);
    return resultobj;
}


static PyObject *_wrap_delete_BoundaryCondition(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BoundaryCondition *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_BoundaryCondition",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BoundaryCondition,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_BoundaryCondition_type(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BoundaryCondition *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    BoundaryConditionType *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BoundaryCondition_type",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BoundaryCondition,1)) == -1) return NULL;
    {
        try {
            result = new BoundaryConditionType (arg0->type());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        switch (*result) {
            case BoundaryCondition::None:
            resultobj = PyString_FromString("None");
            break;
            case BoundaryCondition::Neumann:
            resultobj = PyString_FromString("Neumann");
            break;
            case BoundaryCondition::Dirichlet:
            resultobj = PyString_FromString("Dirichlet");
            break;
            default:
            throw Error("unknown boundary condition type");
        }
    }
    {
        delete result;
    }
    return resultobj;
}


static PyObject *_wrap_BoundaryCondition_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BoundaryCondition *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BoundaryCondition_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BoundaryCondition,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_NormalDistribution(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    double arg0 = 0.0 ;
    double arg1 = 1.0 ;
    char *kwnames[] = {
        "average","sigma", NULL 
    };
    NormalDistribution *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"|dd:new_NormalDistribution",kwnames,&arg0,&arg1)) return NULL;
    {
        try {
            result = (NormalDistribution *)new NormalDistribution(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_NormalDistribution);
    return resultobj;
}


static PyObject *_wrap_delete_NormalDistribution(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    NormalDistribution *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_NormalDistribution",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_NormalDistribution,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_NormalDistribution_derivative(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    NormalDistribution *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","x", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:NormalDistribution_derivative",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_NormalDistribution,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->derivative(arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


double NormalDistribution___call__(NormalDistribution *self,double x) {
    {
        return (*self)(x);
    }
}


static PyObject *_wrap_NormalDistribution___call__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    NormalDistribution *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","x", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:NormalDistribution___call__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_NormalDistribution,1)) == -1) return NULL;
    {
        try {
            result = (double )NormalDistribution___call__(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_CumulativeNormalDistribution(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    double arg0 = 0.0 ;
    double arg1 = 1.0 ;
    char *kwnames[] = {
        "average","sigma", NULL 
    };
    CumulativeNormalDistribution *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"|dd:new_CumulativeNormalDistribution",kwnames,&arg0,&arg1)) return NULL;
    {
        try {
            result = (CumulativeNormalDistribution *)new CumulativeNormalDistribution(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_CumulativeNormalDistribution);
    return resultobj;
}


static PyObject *_wrap_delete_CumulativeNormalDistribution(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CumulativeNormalDistribution *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_CumulativeNormalDistribution",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CumulativeNormalDistribution,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_CumulativeNormalDistribution_derivative(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CumulativeNormalDistribution *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","x", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:CumulativeNormalDistribution_derivative",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CumulativeNormalDistribution,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->derivative(arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


double CumulativeNormalDistribution___call__(CumulativeNormalDistribution *self,double x) {
    {
        return (*self)(x);
    }
}


static PyObject *_wrap_CumulativeNormalDistribution___call__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CumulativeNormalDistribution *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","x", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:CumulativeNormalDistribution___call__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CumulativeNormalDistribution,1)) == -1) return NULL;
    {
        try {
            result = (double )CumulativeNormalDistribution___call__(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_InvCumulativeNormalDistribution(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    double arg0 = 0.0 ;
    double arg1 = 1.0 ;
    char *kwnames[] = {
        "average","sigma", NULL 
    };
    InvCumulativeNormalDistribution *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"|dd:new_InvCumulativeNormalDistribution",kwnames,&arg0,&arg1)) return NULL;
    {
        try {
            result = (InvCumulativeNormalDistribution *)new InvCumulativeNormalDistribution(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_InvCumulativeNormalDistribution);
    return resultobj;
}


static PyObject *_wrap_delete_InvCumulativeNormalDistribution(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    InvCumulativeNormalDistribution *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_InvCumulativeNormalDistribution",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_InvCumulativeNormalDistribution,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


double InvCumulativeNormalDistribution___call__(InvCumulativeNormalDistribution *self,double x) {
    {
        return (*self)(x);
    }
}


static PyObject *_wrap_InvCumulativeNormalDistribution___call__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    InvCumulativeNormalDistribution *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","x", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:InvCumulativeNormalDistribution___call__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_InvCumulativeNormalDistribution,1)) == -1) return NULL;
    {
        try {
            result = (double )InvCumulativeNormalDistribution___call__(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_FdEuropean(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    double arg2 ;
    Spread arg3 ;
    Rate arg4 ;
    Time arg5 ;
    double arg6 ;
    int arg7 = 200 ;
    int arg8 = 800 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "type","underlying","strike","dividendYield","riskFreeRate","residualTime","volatility","timeSteps","gridPoints", NULL 
    };
    FdEuropean *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Odddddd|ii:new_FdEuropean",kwnames,&obj0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6,&arg7,&arg8)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        try {
            result = (FdEuropean *)new FdEuropean(*arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FdEuropean);
    return resultobj;
}


static PyObject *_wrap_delete_FdEuropean(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdEuropean *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_FdEuropean",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdEuropean,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_FdEuropean_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdEuropean *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdEuropean_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdEuropean,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdEuropean_delta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdEuropean *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdEuropean_delta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdEuropean,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->delta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdEuropean_gamma(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdEuropean *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdEuropean_gamma",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdEuropean,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->gamma();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdEuropean_theta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdEuropean *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdEuropean_theta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdEuropean,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->theta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdEuropean_vega(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdEuropean *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdEuropean_vega",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdEuropean,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->vega();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdEuropean_rho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdEuropean *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdEuropean_rho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdEuropean,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->rho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdEuropean_dividendRho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdEuropean *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdEuropean_dividendRho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdEuropean,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->dividendRho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdEuropean_getGrid(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdEuropean *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Array *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdEuropean_getGrid",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdEuropean,1)) == -1) return NULL;
    {
        try {
            result = new Array (arg0->getGrid());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Array);
    return resultobj;
}


static PyObject *_wrap_FdEuropean_getPrices(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdEuropean *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Array *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdEuropean_getPrices",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdEuropean,1)) == -1) return NULL;
    {
        try {
            result = new Array (arg0->getPrices());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Array);
    return resultobj;
}


static PyObject *_wrap_FdEuropean_impliedVolatility(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdEuropean *arg0 ;
    double arg1 ;
    double arg2 = 1e-4 ;
    int arg3 = 100 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","targetValue","accuracy","maxEvaluations", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|di:FdEuropean_impliedVolatility",kwnames,&argo0,&arg1,&arg2,&arg3)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdEuropean,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->impliedVolatility(arg1,arg2,arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_FdAmericanOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    double arg2 ;
    Spread arg3 ;
    Rate arg4 ;
    Time arg5 ;
    double arg6 ;
    int arg7 = 100 ;
    int arg8 = 100 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "type","underlying","strike","dividendYield","riskFreeRate","residualTime","volatility","timeSteps","gridPoints", NULL 
    };
    FdAmericanOption *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Odddddd|ii:new_FdAmericanOption",kwnames,&obj0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6,&arg7,&arg8)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        try {
            result = (FdAmericanOption *)new FdAmericanOption(*arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FdAmericanOption);
    return resultobj;
}


static PyObject *_wrap_delete_FdAmericanOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_FdAmericanOption",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdAmericanOption,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_FdAmericanOption_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdAmericanOption_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdAmericanOption_delta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdAmericanOption_delta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->delta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdAmericanOption_gamma(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdAmericanOption_gamma",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->gamma();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdAmericanOption_theta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdAmericanOption_theta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->theta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdAmericanOption_vega(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdAmericanOption_vega",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->vega();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdAmericanOption_rho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdAmericanOption_rho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->rho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdAmericanOption_dividendRho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdAmericanOption_dividendRho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->dividendRho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdAmericanOption_impliedVolatility(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdAmericanOption *arg0 ;
    double arg1 ;
    double arg2 = 1e-4 ;
    int arg3 = 100 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","targetValue","accuracy","maxEvaluations", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|di:FdAmericanOption_impliedVolatility",kwnames,&argo0,&arg1,&arg2,&arg3)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->impliedVolatility(arg1,arg2,arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_FdShoutOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    double arg2 ;
    Spread arg3 ;
    Rate arg4 ;
    Time arg5 ;
    double arg6 ;
    int arg7 = 100 ;
    int arg8 = 100 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "type","underlying","strike","dividendYield","riskFreeRate","residualTime","volatility","timeSteps","gridPoints", NULL 
    };
    FdShoutOption *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Odddddd|ii:new_FdShoutOption",kwnames,&obj0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6,&arg7,&arg8)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        try {
            result = (FdShoutOption *)new FdShoutOption(*arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FdShoutOption);
    return resultobj;
}


static PyObject *_wrap_delete_FdShoutOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_FdShoutOption",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdShoutOption,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_FdShoutOption_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdShoutOption_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdShoutOption_delta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdShoutOption_delta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->delta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdShoutOption_gamma(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdShoutOption_gamma",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->gamma();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdShoutOption_theta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdShoutOption_theta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->theta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdShoutOption_vega(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdShoutOption_vega",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->vega();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdShoutOption_rho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdShoutOption_rho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->rho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdShoutOption_dividendRho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdShoutOption_dividendRho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->dividendRho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdShoutOption_impliedVolatility(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdShoutOption *arg0 ;
    double arg1 ;
    double arg2 = 1e-4 ;
    int arg3 = 100 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","targetValue","accuracy","maxEvaluations", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|di:FdShoutOption_impliedVolatility",kwnames,&argo0,&arg1,&arg2,&arg3)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->impliedVolatility(arg1,arg2,arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_FdBermudanOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    double arg2 ;
    Spread arg3 ;
    Rate arg4 ;
    Time arg5 ;
    double arg6 ;
    DoubleVector *arg7 ;
    int arg8 = 100 ;
    int arg9 = 100 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    DoubleVector temp0 ;
    PyObject * obj7  = 0 ;
    char *kwnames[] = {
        "type","underlying","strike","dividendYield","riskFreeRate","residualTime","volatility","dates","timeSteps","gridPoints", NULL 
    };
    FdBermudanOption *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OddddddO|ii:new_FdBermudanOption",kwnames,&obj0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6,&obj7,&arg8,&arg9)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj7) || PyList_Check(obj7)) {
            /* Size */ int size = (PyTuple_Check(obj7) ?
            PyTuple_Size(obj7) :
            PyList_Size(obj7));
            temp0 = DoubleVector(size);
            arg7 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj7,i);
                if (o == Py_None) {
                    (*arg7)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg7)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg7)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj7,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg7 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (FdBermudanOption *)new FdBermudanOption(*arg0,arg1,arg2,arg3,arg4,arg5,arg6,(DoubleVector const &)*arg7,arg8,arg9);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FdBermudanOption);
    return resultobj;
}


static PyObject *_wrap_delete_FdBermudanOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdBermudanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_FdBermudanOption",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdBermudanOption,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_FdBermudanOption_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdBermudanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdBermudanOption_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdBermudanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdBermudanOption_delta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdBermudanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdBermudanOption_delta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdBermudanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->delta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdBermudanOption_gamma(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdBermudanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdBermudanOption_gamma",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdBermudanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->gamma();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdBermudanOption_theta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdBermudanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdBermudanOption_theta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdBermudanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->theta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdBermudanOption_vega(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdBermudanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdBermudanOption_vega",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdBermudanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->vega();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdBermudanOption_rho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdBermudanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdBermudanOption_rho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdBermudanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->rho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdBermudanOption_dividendRho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdBermudanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdBermudanOption_dividendRho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdBermudanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->dividendRho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdBermudanOption_impliedVolatility(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdBermudanOption *arg0 ;
    double arg1 ;
    double arg2 = 1e-4 ;
    int arg3 = 100 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","targetValue","accuracy","maxEvaluations", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|di:FdBermudanOption_impliedVolatility",kwnames,&argo0,&arg1,&arg2,&arg3)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdBermudanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->impliedVolatility(arg1,arg2,arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_FdDividendShoutOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    double arg2 ;
    Spread arg3 ;
    Rate arg4 ;
    Time arg5 ;
    double arg6 ;
    DoubleVector *arg7 ;
    DoubleVector *arg8 ;
    int arg9 = 100 ;
    int arg10 = 100 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    DoubleVector temp0 ;
    PyObject * obj7  = 0 ;
    DoubleVector temp1 ;
    PyObject * obj8  = 0 ;
    char *kwnames[] = {
        "type","underlying","strike","dividendYield","riskFreeRate","residualTime","volatility","dividends","exdivdates","timeSteps","gridPoints", NULL 
    };
    FdDividendShoutOption *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OddddddOO|ii:new_FdDividendShoutOption",kwnames,&obj0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6,&obj7,&obj8,&arg9,&arg10)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj7) || PyList_Check(obj7)) {
            /* Size */ int size = (PyTuple_Check(obj7) ?
            PyTuple_Size(obj7) :
            PyList_Size(obj7));
            temp0 = DoubleVector(size);
            arg7 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj7,i);
                if (o == Py_None) {
                    (*arg7)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg7)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg7)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj7,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg7 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj8) || PyList_Check(obj8)) {
            /* Size */ int size = (PyTuple_Check(obj8) ?
            PyTuple_Size(obj8) :
            PyList_Size(obj8));
            temp1 = DoubleVector(size);
            arg8 = &temp1;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj8,i);
                if (o == Py_None) {
                    (*arg8)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg8)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg8)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj8,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg8 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (FdDividendShoutOption *)new FdDividendShoutOption(*arg0,arg1,arg2,arg3,arg4,arg5,arg6,(DoubleVector const &)*arg7,(DoubleVector const &)*arg8,arg9,arg10);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FdDividendShoutOption);
    return resultobj;
}


static PyObject *_wrap_delete_FdDividendShoutOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_FdDividendShoutOption",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendShoutOption,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_FdDividendShoutOption_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendShoutOption_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendShoutOption_delta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendShoutOption_delta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->delta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendShoutOption_gamma(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendShoutOption_gamma",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->gamma();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendShoutOption_theta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendShoutOption_theta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->theta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendShoutOption_vega(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendShoutOption_vega",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->vega();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendShoutOption_rho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendShoutOption_rho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->rho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendShoutOption_dividendRho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendShoutOption_dividendRho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->dividendRho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendShoutOption_controlVariateCorrection(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendShoutOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendShoutOption_controlVariateCorrection",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->controlVariateCorrection();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendShoutOption_impliedVolatility(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendShoutOption *arg0 ;
    double arg1 ;
    double arg2 = 1e-4 ;
    int arg3 = 100 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","targetValue","accuracy","maxEvaluations", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|di:FdDividendShoutOption_impliedVolatility",kwnames,&argo0,&arg1,&arg2,&arg3)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendShoutOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->impliedVolatility(arg1,arg2,arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_FdDividendAmericanOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    double arg2 ;
    Spread arg3 ;
    Rate arg4 ;
    Time arg5 ;
    double arg6 ;
    DoubleVector *arg7 ;
    DoubleVector *arg8 ;
    int arg9 = 100 ;
    int arg10 = 100 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    DoubleVector temp0 ;
    PyObject * obj7  = 0 ;
    DoubleVector temp1 ;
    PyObject * obj8  = 0 ;
    char *kwnames[] = {
        "type","underlying","strike","dividendYield","riskFreeRate","residualTime","volatility","dividends","exdivdates","timeSteps","gridPoints", NULL 
    };
    FdDividendAmericanOption *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OddddddOO|ii:new_FdDividendAmericanOption",kwnames,&obj0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6,&obj7,&obj8,&arg9,&arg10)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj7) || PyList_Check(obj7)) {
            /* Size */ int size = (PyTuple_Check(obj7) ?
            PyTuple_Size(obj7) :
            PyList_Size(obj7));
            temp0 = DoubleVector(size);
            arg7 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj7,i);
                if (o == Py_None) {
                    (*arg7)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg7)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg7)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj7,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg7 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj8) || PyList_Check(obj8)) {
            /* Size */ int size = (PyTuple_Check(obj8) ?
            PyTuple_Size(obj8) :
            PyList_Size(obj8));
            temp1 = DoubleVector(size);
            arg8 = &temp1;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj8,i);
                if (o == Py_None) {
                    (*arg8)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg8)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg8)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj8,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg8 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (FdDividendAmericanOption *)new FdDividendAmericanOption(*arg0,arg1,arg2,arg3,arg4,arg5,arg6,(DoubleVector const &)*arg7,(DoubleVector const &)*arg8,arg9,arg10);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FdDividendAmericanOption);
    return resultobj;
}


static PyObject *_wrap_delete_FdDividendAmericanOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_FdDividendAmericanOption",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendAmericanOption,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_FdDividendAmericanOption_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendAmericanOption_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendAmericanOption_delta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendAmericanOption_delta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->delta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendAmericanOption_gamma(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendAmericanOption_gamma",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->gamma();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendAmericanOption_theta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendAmericanOption_theta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->theta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendAmericanOption_vega(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendAmericanOption_vega",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->vega();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendAmericanOption_rho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendAmericanOption_rho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->rho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendAmericanOption_dividendRho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendAmericanOption_dividendRho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->dividendRho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendAmericanOption_controlVariateCorrection(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendAmericanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendAmericanOption_controlVariateCorrection",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->controlVariateCorrection();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendAmericanOption_impliedVolatility(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendAmericanOption *arg0 ;
    double arg1 ;
    double arg2 = 1e-4 ;
    int arg3 = 100 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","targetValue","accuracy","maxEvaluations", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|di:FdDividendAmericanOption_impliedVolatility",kwnames,&argo0,&arg1,&arg2,&arg3)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendAmericanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->impliedVolatility(arg1,arg2,arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_FdDividendEuropeanOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    double arg2 ;
    Spread arg3 ;
    Rate arg4 ;
    Time arg5 ;
    double arg6 ;
    DoubleVector *arg7 ;
    DoubleVector *arg8 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    DoubleVector temp0 ;
    PyObject * obj7  = 0 ;
    DoubleVector temp1 ;
    PyObject * obj8  = 0 ;
    char *kwnames[] = {
        "type","underlying","strike","dividendYield","riskFreeRate","residualTime","volatility","dividends","exdivdates", NULL 
    };
    FdDividendEuropeanOption *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OddddddOO:new_FdDividendEuropeanOption",kwnames,&obj0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6,&obj7,&obj8)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj7) || PyList_Check(obj7)) {
            /* Size */ int size = (PyTuple_Check(obj7) ?
            PyTuple_Size(obj7) :
            PyList_Size(obj7));
            temp0 = DoubleVector(size);
            arg7 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj7,i);
                if (o == Py_None) {
                    (*arg7)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg7)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg7)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj7,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg7 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj8) || PyList_Check(obj8)) {
            /* Size */ int size = (PyTuple_Check(obj8) ?
            PyTuple_Size(obj8) :
            PyList_Size(obj8));
            temp1 = DoubleVector(size);
            arg8 = &temp1;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj8,i);
                if (o == Py_None) {
                    (*arg8)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg8)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg8)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj8,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg8 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (FdDividendEuropeanOption *)new FdDividendEuropeanOption(*arg0,arg1,arg2,arg3,arg4,arg5,arg6,(DoubleVector const &)*arg7,(DoubleVector const &)*arg8);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FdDividendEuropeanOption);
    return resultobj;
}


static PyObject *_wrap_delete_FdDividendEuropeanOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendEuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_FdDividendEuropeanOption",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendEuropeanOption,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_FdDividendEuropeanOption_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendEuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendEuropeanOption_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendEuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendEuropeanOption_delta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendEuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendEuropeanOption_delta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendEuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->delta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendEuropeanOption_gamma(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendEuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendEuropeanOption_gamma",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendEuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->gamma();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendEuropeanOption_theta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendEuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendEuropeanOption_theta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendEuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->theta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendEuropeanOption_vega(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendEuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendEuropeanOption_vega",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendEuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->vega();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendEuropeanOption_rho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendEuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendEuropeanOption_rho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendEuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->rho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendEuropeanOption_dividendRho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendEuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:FdDividendEuropeanOption_dividendRho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendEuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->dividendRho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_FdDividendEuropeanOption_impliedVolatility(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FdDividendEuropeanOption *arg0 ;
    double arg1 ;
    double arg2 = 1e-4 ;
    int arg3 = 100 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","targetValue","accuracy","maxEvaluations", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|di:FdDividendEuropeanOption_impliedVolatility",kwnames,&argo0,&arg1,&arg2,&arg3)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FdDividendEuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->impliedVolatility(arg1,arg2,arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_delete_Array(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_Array",kwnames,&obj0)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


Array * new_Array(Array const &a) {
    {
        return new Array(a);
    }
}


static PyObject *_wrap_new_Array(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "a", NULL 
    };
    Array *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_Array",kwnames,&obj0)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            result = (Array *)new_Array((Array const &)*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Array);
    return resultobj;
}


String Array___str__(Array *self) {
    {
        String s = "(";
        /*Size */ int size_ = self->size();
        if (size_>0) {
            for (/* Size */ int i=0; i<size_-1; i++) {
                s += DoubleFormatter::toString((*self)[i]);
                s += ", ";
            }
            s += DoubleFormatter::toString((*self)[size_-1]);
        }
        s += ")";
        return s;
    }
}


static PyObject *_wrap_Array___str__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Array___str__",kwnames,&obj0)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            result = new String (Array___str__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


int Array___len__(Array *self) {
    {
        return self->size();
    }
}


static PyObject *_wrap_Array___len__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Array___len__",kwnames,&obj0)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            result = (int )Array___len__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


double Array___getitem__(Array *self,int i) {
    {
        int size_ = static_cast<int>(self->size());
        if (i>=0 && i<size_) {
            return (*self)[i];
        }else if (i<0 && -i<=size_) {
            return (*self)[size_+i];
        }else {
            throw IndexError("Array index out of range");
        }
        QL_DUMMY_RETURN(0.0)
    }
}


static PyObject *_wrap_Array___getitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    int arg1 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self","i", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:Array___getitem__",kwnames,&obj0,&arg1)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            result = (double )Array___getitem__(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


void Array___setitem__(Array *self,int i,double x) {
    {
        int size_ = static_cast<int>(self->size());
        if (i>=0 && i<size_) {
            (*self)[i] = x;
        }else if (i<0 && -i<=size_) {
            (*self)[size_+i] = x;
        }else {
            throw IndexError("Array index out of range");
        }
    }
}


static PyObject *_wrap_Array___setitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    int arg1 ;
    double arg2 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self","i","x", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oid:Array___setitem__",kwnames,&obj0,&arg1,&arg2)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            Array___setitem__(arg0,arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


Array Array___getslice__(Array *self,int i,int j) {
    {
        int size_ = static_cast<int>(self->size());
        if (i<0)
        i = size_+i;
        if (j<0)
        j = size_+j;
        i = QL_MAX(0,i);
        j = QL_MIN(size_,j);
        Array tmp(j-i);
        std::copy(self->begin()+i,self->begin()+j,tmp.begin());
        return tmp;
    }
}


static PyObject *_wrap_Array___getslice__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    int arg1 ;
    int arg2 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self","i","j", NULL 
    };
    Array *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oii:Array___getslice__",kwnames,&obj0,&arg1,&arg2)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            result = new Array (Array___getslice__(arg0,arg1,arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Array);
    return resultobj;
}


void Array___setslice__(Array *self,int i,int j,Array const &rhs) {
    {
        int size_ = static_cast<int>(self->size());
        if (i<0)
        i = size_+i;
        if (j<0)
        j = size_+j;
        i = QL_MAX(0,i);
        j = QL_MIN(size_,j);
        QL_ENSURE(static_cast<int>(rhs.size()) == j-i,
        "Arrays are not resizable");
        std::copy(rhs.begin(),rhs.end(),self->begin()+i);
    }
}


static PyObject *_wrap_Array___setslice__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    int arg1 ;
    int arg2 ;
    Array *arg3 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    Array temp0 ;
    PyObject * obj3  = 0 ;
    char *kwnames[] = {
        "self","i","j","rhs", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OiiO:Array___setslice__",kwnames,&obj0,&arg1,&arg2,&obj3)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Array* v;
        if (PyTuple_Check(obj3) || PyList_Check(obj3)) {
            int size = (PyTuple_Check(obj3) ?
            PyTuple_Size(obj3) :
            PyList_Size(obj3));
            temp0 = Array(size);
            arg3 = &temp0;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj3,i);
                if (PyFloat_Check(o)) {
                    (*arg3)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg3)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj3,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg3 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            Array___setslice__(arg0,arg1,arg2,(Array const &)*arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


bool Array___nonzero__(Array *self) {
    {
        return (self->size() != 0);
    }
}


static PyObject *_wrap_Array___nonzero__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Array___nonzero__",kwnames,&obj0)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            result = (bool )Array___nonzero__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_delete_LexicographicalViewColumn(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    LexicographicalViewColumn *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_LexicographicalViewColumn",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_LexicographicalViewColumn,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


double LexicographicalViewColumn___getitem__(LexicographicalViewColumn *self,int i) {
    {
        return (*self)[i];
    }
}


static PyObject *_wrap_LexicographicalViewColumn___getitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    LexicographicalViewColumn *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","i", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:LexicographicalViewColumn___getitem__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_LexicographicalViewColumn,1)) == -1) return NULL;
    {
        try {
            result = (double )LexicographicalViewColumn___getitem__(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


void LexicographicalViewColumn___setitem__(LexicographicalViewColumn *self,int i,double x) {
    {
        (*self)[i] = x;
    }
}


static PyObject *_wrap_LexicographicalViewColumn___setitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    LexicographicalViewColumn *arg0 ;
    int arg1 ;
    double arg2 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","i","x", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oid:LexicographicalViewColumn___setitem__",kwnames,&argo0,&arg1,&arg2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_LexicographicalViewColumn,1)) == -1) return NULL;
    {
        try {
            LexicographicalViewColumn___setitem__(arg0,arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_delete_LexicographicalView(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    LexicographicalView *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_LexicographicalView",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_LexicographicalView,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_LexicographicalView_xSize(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    LexicographicalView *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:LexicographicalView_xSize",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_LexicographicalView,1)) == -1) return NULL;
    {
        try {
            result = (int )arg0->xSize();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_LexicographicalView_ySize(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    LexicographicalView *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:LexicographicalView_ySize",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_LexicographicalView,1)) == -1) return NULL;
    {
        try {
            result = (int )arg0->ySize();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


LexicographicalView * new_LexicographicalView(Array &a,int xSize) {
    {
        return new LexicographicalView(a.begin(),a.end(),xSize);
    }
}


static PyObject *_wrap_new_LexicographicalView(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    int arg1 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "a","xSize", NULL 
    };
    LexicographicalView *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:new_LexicographicalView",kwnames,&obj0,&arg1)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            result = (LexicographicalView *)new_LexicographicalView(*arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_LexicographicalView);
    return resultobj;
}


LexicographicalViewColumn LexicographicalView___getitem__(LexicographicalView *self,int i) {
    {
        return (*self)[i];
    }
}


static PyObject *_wrap_LexicographicalView___getitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    LexicographicalView *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","i", NULL 
    };
    LexicographicalViewColumn *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:LexicographicalView___getitem__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_LexicographicalView,1)) == -1) return NULL;
    {
        try {
            result = new LexicographicalViewColumn (LexicographicalView___getitem__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_LexicographicalViewColumn);
    return resultobj;
}


String LexicographicalView___str__(LexicographicalView *self) {
    {
        String s;
        for (int j=0; j<static_cast<int>(self->ySize()); j++) {
            s += "\n";
            for (int i=0; i<static_cast<int>(self->xSize()); i++) {
                if (i != 0)
                s += ",";
                s += QuantLib::DoubleFormatter::toString((*self)[i][j]);
            }
        }
        s += "\n";
        return s;
    }
}


static PyObject *_wrap_LexicographicalView___str__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    LexicographicalView *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:LexicographicalView___str__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_LexicographicalView,1)) == -1) return NULL;
    {
        try {
            result = new String (LexicographicalView___str__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


static PyObject *_wrap_delete_MatrixRow(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MatrixRow *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_MatrixRow",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MatrixRow,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


double MatrixRow___getitem__(MatrixRow *self,int i) {
    {
        return (*self)[i];
    }
}


static PyObject *_wrap_MatrixRow___getitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MatrixRow *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","i", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:MatrixRow___getitem__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MatrixRow,1)) == -1) return NULL;
    {
        try {
            result = (double )MatrixRow___getitem__(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


void MatrixRow___setitem__(MatrixRow *self,int i,double x) {
    {
        (*self)[i] = x;
    }
}


static PyObject *_wrap_MatrixRow___setitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MatrixRow *arg0 ;
    int arg1 ;
    double arg2 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","i","x", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oid:MatrixRow___setitem__",kwnames,&argo0,&arg1,&arg2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MatrixRow,1)) == -1) return NULL;
    {
        try {
            MatrixRow___setitem__(arg0,arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_delete_Matrix(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_Matrix",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Matrix,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_Matrix_rows(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Matrix_rows",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Matrix,1)) == -1) return NULL;
    {
        try {
            result = (int )arg0->rows();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_Matrix_columns(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Matrix_columns",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Matrix,1)) == -1) return NULL;
    {
        try {
            result = (int )arg0->columns();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


Matrix * new_Matrix(Matrix const &m) {
    {
        return new Matrix(m);
    }
}


static PyObject *_wrap_new_Matrix(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    Matrix temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "m", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_Matrix",kwnames,&obj0)) return NULL;
    {
        Matrix* m;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            // look ahead
            PyObject* o = PySequence_GetItem(obj0,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg0 = &temp;
        }else if ((SWIG_ConvertPtr(obj0,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg0 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    {
        try {
            result = (Matrix *)new_Matrix((Matrix const &)*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Matrix);
    return resultobj;
}


MatrixRow Matrix___getitem__(Matrix *self,int i) {
    {
        return (*self)[i];
    }
}


static PyObject *_wrap_Matrix___getitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","i", NULL 
    };
    MatrixRow *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:Matrix___getitem__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Matrix,1)) == -1) return NULL;
    {
        try {
            result = new MatrixRow (Matrix___getitem__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_MatrixRow);
    return resultobj;
}


Matrix Matrix___add__(Matrix *self,Matrix const &m) {
    {
        return *self+m;
    }
}


static PyObject *_wrap_Matrix___add__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    Matrix *arg1 ;
    PyObject * argo0 =0 ;
    Matrix temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","m", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:Matrix___add__",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Matrix,1)) == -1) return NULL;
    {
        Matrix* m;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            // look ahead
            PyObject* o = PySequence_GetItem(obj1,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg1 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    {
        try {
            result = new Matrix (Matrix___add__(arg0,(Matrix const &)*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Matrix);
    return resultobj;
}


Matrix Matrix___iadd__(Matrix *self,Matrix const &m) {
    {
        return *self+m;
    }
}


static PyObject *_wrap_Matrix___iadd__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    Matrix *arg1 ;
    PyObject * argo0 =0 ;
    Matrix temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","m", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:Matrix___iadd__",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Matrix,1)) == -1) return NULL;
    {
        Matrix* m;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            // look ahead
            PyObject* o = PySequence_GetItem(obj1,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg1 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    {
        try {
            result = new Matrix (Matrix___iadd__(arg0,(Matrix const &)*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Matrix);
    return resultobj;
}


Matrix Matrix___sub__(Matrix *self,Matrix const &m) {
    {
        return *self-m;
    }
}


static PyObject *_wrap_Matrix___sub__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    Matrix *arg1 ;
    PyObject * argo0 =0 ;
    Matrix temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","m", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:Matrix___sub__",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Matrix,1)) == -1) return NULL;
    {
        Matrix* m;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            // look ahead
            PyObject* o = PySequence_GetItem(obj1,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg1 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    {
        try {
            result = new Matrix (Matrix___sub__(arg0,(Matrix const &)*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Matrix);
    return resultobj;
}


Matrix Matrix___isub__(Matrix *self,Matrix const &m) {
    {
        return *self-m;
    }
}


static PyObject *_wrap_Matrix___isub__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    Matrix *arg1 ;
    PyObject * argo0 =0 ;
    Matrix temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","m", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:Matrix___isub__",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Matrix,1)) == -1) return NULL;
    {
        Matrix* m;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            // look ahead
            PyObject* o = PySequence_GetItem(obj1,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg1 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    {
        try {
            result = new Matrix (Matrix___isub__(arg0,(Matrix const &)*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Matrix);
    return resultobj;
}


Matrix Matrix___mul__(Matrix *self,double x) {
    {
        return *self*x;
    }
}


static PyObject *_wrap_Matrix___mul__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","x", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:Matrix___mul__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Matrix,1)) == -1) return NULL;
    {
        try {
            result = new Matrix (Matrix___mul__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Matrix);
    return resultobj;
}


Matrix Matrix___imul__(Matrix *self,double x) {
    {
        return *self*x;
    }
}


static PyObject *_wrap_Matrix___imul__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","x", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:Matrix___imul__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Matrix,1)) == -1) return NULL;
    {
        try {
            result = new Matrix (Matrix___imul__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Matrix);
    return resultobj;
}


Matrix Matrix___rmul__(Matrix *self,double x) {
    {
        return *self*x;
    }
}


static PyObject *_wrap_Matrix___rmul__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","x", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:Matrix___rmul__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Matrix,1)) == -1) return NULL;
    {
        try {
            result = new Matrix (Matrix___rmul__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Matrix);
    return resultobj;
}


Matrix Matrix___div__(Matrix *self,double x) {
    {
        return *self/x;
    }
}


static PyObject *_wrap_Matrix___div__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","x", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:Matrix___div__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Matrix,1)) == -1) return NULL;
    {
        try {
            result = new Matrix (Matrix___div__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Matrix);
    return resultobj;
}


Matrix Matrix___idiv__(Matrix *self,double x) {
    {
        return *self/x;
    }
}


static PyObject *_wrap_Matrix___idiv__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","x", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:Matrix___idiv__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Matrix,1)) == -1) return NULL;
    {
        try {
            result = new Matrix (Matrix___idiv__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Matrix);
    return resultobj;
}


String Matrix___str__(Matrix *self) {
    {
        String s;
        for (/* Size */ unsigned int j=0; j<self->rows(); j++) {
            s += "\n";
            s += QuantLib::DoubleFormatter::toString((*self)[j][0]);
            for (/* Size */ unsigned int i=1; i<self->columns(); i++) {
                s += ",";
                s += QuantLib::DoubleFormatter::toString((*self)[j][i]);
            }
        }
        s += "\n";
        return s;
    }
}


static PyObject *_wrap_Matrix___str__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    String *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Matrix___str__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Matrix,1)) == -1) return NULL;
    {
        try {
            result = new String (Matrix___str__(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }{
        resultobj = PyString_FromString(result->c_str());
    }
    {
        delete result;
    }
    return resultobj;
}


static PyObject *_wrap_transpose(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    Matrix temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "m", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:transpose",kwnames,&obj0)) return NULL;
    {
        Matrix* m;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            // look ahead
            PyObject* o = PySequence_GetItem(obj0,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg0 = &temp;
        }else if ((SWIG_ConvertPtr(obj0,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg0 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    {
        try {
            result = new Matrix (transpose((Matrix const &)*arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Matrix);
    return resultobj;
}


static PyObject *_wrap_outerProduct(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Array *arg1 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    Array temp0 ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "v1","v2", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:outerProduct",kwnames,&obj0,&obj1)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Array* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp0 = Array(size);
            arg1 = &temp0;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            result = new Matrix (outerProduct((Array const &)*arg0,(Array const &)*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Matrix);
    return resultobj;
}


static PyObject *_wrap_matrixProduct(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    Matrix *arg1 ;
    Matrix temp ;
    PyObject * obj0  = 0 ;
    Matrix temp0 ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "m1","m2", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:matrixProduct",kwnames,&obj0,&obj1)) return NULL;
    {
        Matrix* m;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            // look ahead
            PyObject* o = PySequence_GetItem(obj0,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg0 = &temp;
        }else if ((SWIG_ConvertPtr(obj0,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg0 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    {
        Matrix* m;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            // look ahead
            PyObject* o = PySequence_GetItem(obj1,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp0 = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp0[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp0[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp0[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg1 = &temp0;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg1 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    {
        try {
            result = new Matrix (matrixProduct((Matrix const &)*arg0,(Matrix const &)*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Matrix);
    return resultobj;
}


static PyObject *_wrap_matrixSqrt(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    Matrix temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "m", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:matrixSqrt",kwnames,&obj0)) return NULL;
    {
        Matrix* m;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            // look ahead
            PyObject* o = PySequence_GetItem(obj0,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg0 = &temp;
        }else if ((SWIG_ConvertPtr(obj0,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg0 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    {
        try {
            result = new Matrix (matrixSqrt((Matrix const &)*arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Matrix);
    return resultobj;
}


static PyObject *_wrap_new_LinearInterpolation(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Array *arg1 ;
    bool arg2 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    Array temp0 ;
    PyObject * obj1  = 0 ;
    int tempbool2 ;
    char *kwnames[] = {
        "x","y","allowExtrapolation", NULL 
    };
    PyLinearInterpolation *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOi:new_LinearInterpolation",kwnames,&obj0,&obj1,&tempbool2)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Array* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp0 = Array(size);
            arg1 = &temp0;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    arg2 = (bool ) tempbool2;
    {
        try {
            result = (PyLinearInterpolation *)new PyLinearInterpolation((Array const &)*arg0,(Array const &)*arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_PyLinearInterpolation);
    return resultobj;
}


static PyObject *_wrap_delete_PyLinearInterpolation(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PyLinearInterpolation *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_PyLinearInterpolation",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PyLinearInterpolation,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_LinearInterpolation___call__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PyLinearInterpolation *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","x", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:LinearInterpolation___call__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PyLinearInterpolation,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->__call__(arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_CubicSpline(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Array *arg1 ;
    bool arg2 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    Array temp0 ;
    PyObject * obj1  = 0 ;
    int tempbool2 ;
    char *kwnames[] = {
        "x","y","allowExtrapolation", NULL 
    };
    PyCubicSpline *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOi:new_CubicSpline",kwnames,&obj0,&obj1,&tempbool2)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Array* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp0 = Array(size);
            arg1 = &temp0;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    arg2 = (bool ) tempbool2;
    {
        try {
            result = (PyCubicSpline *)new PyCubicSpline((Array const &)*arg0,(Array const &)*arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_PyCubicSpline);
    return resultobj;
}


static PyObject *_wrap_delete_PyCubicSpline(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PyCubicSpline *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_PyCubicSpline",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PyCubicSpline,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_CubicSpline___call__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PyCubicSpline *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","x", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:CubicSpline___call__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PyCubicSpline,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->__call__(arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_BilinearInterpolation(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Array *arg1 ;
    Matrix *arg2 ;
    bool arg3 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    Array temp0 ;
    PyObject * obj1  = 0 ;
    Matrix temp1 ;
    PyObject * obj2  = 0 ;
    int tempbool3 ;
    char *kwnames[] = {
        "x","y","m","allowExtrapolation", NULL 
    };
    PyBilinearInterpolation *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOOi:new_BilinearInterpolation",kwnames,&obj0,&obj1,&obj2,&tempbool3)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Array* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp0 = Array(size);
            arg1 = &temp0;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Matrix* m;
        if (PyTuple_Check(obj2) || PyList_Check(obj2)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj2) ?
            PyTuple_Size(obj2) :
            PyList_Size(obj2));
            // look ahead
            PyObject* o = PySequence_GetItem(obj2,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp1 = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj2,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp1[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp1[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp1[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg2 = &temp1;
        }else if ((SWIG_ConvertPtr(obj2,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg2 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    arg3 = (bool ) tempbool3;
    {
        try {
            result = (PyBilinearInterpolation *)new PyBilinearInterpolation((Array const &)*arg0,(Array const &)*arg1,(Matrix const &)*arg2,arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_PyBilinearInterpolation);
    return resultobj;
}


static PyObject *_wrap_delete_PyBilinearInterpolation(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PyBilinearInterpolation *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_PyBilinearInterpolation",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PyBilinearInterpolation,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_BilinearInterpolation___call__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PyBilinearInterpolation *arg0 ;
    double arg1 ;
    double arg2 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","x","y", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Odd:BilinearInterpolation___call__",kwnames,&argo0,&arg1,&arg2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PyBilinearInterpolation,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->__call__(arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_McEuropean(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    double arg2 ;
    Spread arg3 ;
    Rate arg4 ;
    double arg5 ;
    double arg6 ;
    bool arg7 ;
    long arg8 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    int tempbool7 ;
    char *kwnames[] = {
        "type","underlying","strike","dividendYield","riskFreeRate","residualTime","volatility","antitheticVariance","seed", NULL 
    };
    McEuropean *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oddddddil:new_McEuropean",kwnames,&obj0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6,&tempbool7,&arg8)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    arg7 = (bool ) tempbool7;
    {
        try {
            result = (McEuropean *)new McEuropean(*arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_McEuropean);
    return resultobj;
}


static PyObject *_wrap_delete_McEuropean(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McEuropean *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_McEuropean",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McEuropean,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_McEuropean_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McEuropean *arg0 ;
    double arg1 ;
    int arg2 = QL_MAX_INT ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","tolerance","maxSample", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|i:McEuropean_value",kwnames,&argo0,&arg1,&arg2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McEuropean,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value(arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McEuropean_valueWithSamples(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McEuropean *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","samples", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:McEuropean_valueWithSamples",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McEuropean,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->valueWithSamples(arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McEuropean_errorEstimate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McEuropean *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:McEuropean_errorEstimate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McEuropean,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->errorEstimate();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_McDiscreteArithmeticAPO(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    double arg2 ;
    Spread arg3 ;
    Rate arg4 ;
    DoubleVector *arg5 ;
    double arg6 ;
    bool arg7 ;
    bool arg8 ;
    long arg9 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    DoubleVector temp0 ;
    PyObject * obj5  = 0 ;
    int tempbool7 ;
    int tempbool8 ;
    char *kwnames[] = {
        "type","underlying","strike","dividendYield","riskFreeRate","timeDelays","volatility","antitheticVariance","controlVariate","seed", NULL 
    };
    McDiscreteArithmeticAPO *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OddddOdiil:new_McDiscreteArithmeticAPO",kwnames,&obj0,&arg1,&arg2,&arg3,&arg4,&obj5,&arg6,&tempbool7,&tempbool8,&arg9)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj5) || PyList_Check(obj5)) {
            /* Size */ int size = (PyTuple_Check(obj5) ?
            PyTuple_Size(obj5) :
            PyList_Size(obj5));
            temp0 = DoubleVector(size);
            arg5 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj5,i);
                if (o == Py_None) {
                    (*arg5)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg5)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg5)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj5,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg5 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    arg7 = (bool ) tempbool7;
    arg8 = (bool ) tempbool8;
    {
        try {
            result = (McDiscreteArithmeticAPO *)new McDiscreteArithmeticAPO(*arg0,arg1,arg2,arg3,arg4,(DoubleVector const &)*arg5,arg6,arg7,arg8,arg9);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_McDiscreteArithmeticAPO);
    return resultobj;
}


static PyObject *_wrap_delete_McDiscreteArithmeticAPO(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McDiscreteArithmeticAPO *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_McDiscreteArithmeticAPO",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McDiscreteArithmeticAPO,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_McDiscreteArithmeticAPO_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McDiscreteArithmeticAPO *arg0 ;
    double arg1 ;
    int arg2 = QL_MAX_INT ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","tolerance","maxSample", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|i:McDiscreteArithmeticAPO_value",kwnames,&argo0,&arg1,&arg2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McDiscreteArithmeticAPO,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value(arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McDiscreteArithmeticAPO_valueWithSamples(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McDiscreteArithmeticAPO *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","samples", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:McDiscreteArithmeticAPO_valueWithSamples",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McDiscreteArithmeticAPO,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->valueWithSamples(arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McDiscreteArithmeticAPO_errorEstimate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McDiscreteArithmeticAPO *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:McDiscreteArithmeticAPO_errorEstimate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McDiscreteArithmeticAPO,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->errorEstimate();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_McDiscreteArithmeticASO(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    Spread arg2 ;
    Rate arg3 ;
    DoubleVector *arg4 ;
    double arg5 ;
    bool arg6 ;
    bool arg7 ;
    long arg8 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    DoubleVector temp0 ;
    PyObject * obj4  = 0 ;
    int tempbool6 ;
    int tempbool7 ;
    char *kwnames[] = {
        "type","underlying","dividendYield","riskFreeRate","timeDelays","volatility","antitheticVariance","controlVariate","seed", NULL 
    };
    McDiscreteArithmeticASO *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OdddOdiil:new_McDiscreteArithmeticASO",kwnames,&obj0,&arg1,&arg2,&arg3,&obj4,&arg5,&tempbool6,&tempbool7,&arg8)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj4) || PyList_Check(obj4)) {
            /* Size */ int size = (PyTuple_Check(obj4) ?
            PyTuple_Size(obj4) :
            PyList_Size(obj4));
            temp0 = DoubleVector(size);
            arg4 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj4,i);
                if (o == Py_None) {
                    (*arg4)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg4)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg4)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj4,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg4 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    arg6 = (bool ) tempbool6;
    arg7 = (bool ) tempbool7;
    {
        try {
            result = (McDiscreteArithmeticASO *)new McDiscreteArithmeticASO(*arg0,arg1,arg2,arg3,(DoubleVector const &)*arg4,arg5,arg6,arg7,arg8);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_McDiscreteArithmeticASO);
    return resultobj;
}


static PyObject *_wrap_delete_McDiscreteArithmeticASO(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McDiscreteArithmeticASO *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_McDiscreteArithmeticASO",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McDiscreteArithmeticASO,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_McDiscreteArithmeticASO_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McDiscreteArithmeticASO *arg0 ;
    double arg1 ;
    int arg2 = QL_MAX_INT ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","tolerance","maxSample", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|i:McDiscreteArithmeticASO_value",kwnames,&argo0,&arg1,&arg2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McDiscreteArithmeticASO,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value(arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McDiscreteArithmeticASO_valueWithSamples(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McDiscreteArithmeticASO *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","samples", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:McDiscreteArithmeticASO_valueWithSamples",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McDiscreteArithmeticASO,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->valueWithSamples(arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McDiscreteArithmeticASO_errorEstimate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McDiscreteArithmeticASO *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:McDiscreteArithmeticASO_errorEstimate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McDiscreteArithmeticASO,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->errorEstimate();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_McBasket(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    Array *arg1 ;
    double arg2 ;
    Array *arg3 ;
    Matrix *arg4 ;
    Rate arg5 ;
    double arg6 ;
    bool arg7 ;
    long arg8 = 0 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    Array temp0 ;
    PyObject * obj1  = 0 ;
    Array temp1 ;
    PyObject * obj3  = 0 ;
    Matrix temp2 ;
    PyObject * obj4  = 0 ;
    int tempbool7 ;
    char *kwnames[] = {
        "type","underlying","strike","dividendYield","covariance","riskFreeRate","residualTime","antitheticVariance","seed", NULL 
    };
    McBasket *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOdOOddi|l:new_McBasket",kwnames,&obj0,&obj1,&arg2,&obj3,&obj4,&arg5,&arg6,&tempbool7,&arg8)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        Array* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp0 = Array(size);
            arg1 = &temp0;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Array* v;
        if (PyTuple_Check(obj3) || PyList_Check(obj3)) {
            int size = (PyTuple_Check(obj3) ?
            PyTuple_Size(obj3) :
            PyList_Size(obj3));
            temp1 = Array(size);
            arg3 = &temp1;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj3,i);
                if (PyFloat_Check(o)) {
                    (*arg3)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg3)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj3,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg3 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Matrix* m;
        if (PyTuple_Check(obj4) || PyList_Check(obj4)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj4) ?
            PyTuple_Size(obj4) :
            PyList_Size(obj4));
            // look ahead
            PyObject* o = PySequence_GetItem(obj4,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp2 = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj4,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp2[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp2[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp2[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg4 = &temp2;
        }else if ((SWIG_ConvertPtr(obj4,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg4 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    arg7 = (bool ) tempbool7;
    {
        try {
            result = (McBasket *)new McBasket(*arg0,(Array const &)*arg1,arg2,(Array const &)*arg3,(Matrix const &)*arg4,arg5,arg6,arg7,arg8);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_McBasket);
    return resultobj;
}


static PyObject *_wrap_delete_McBasket(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McBasket *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_McBasket",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McBasket,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_McBasket_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McBasket *arg0 ;
    double arg1 ;
    int arg2 = QL_MAX_INT ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","tolerance","maxSample", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|i:McBasket_value",kwnames,&argo0,&arg1,&arg2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McBasket,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value(arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McBasket_valueWithSamples(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McBasket *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","samples", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:McBasket_valueWithSamples",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McBasket,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->valueWithSamples(arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McBasket_errorEstimate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McBasket *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:McBasket_errorEstimate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McBasket,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->errorEstimate();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_McMaxBasket(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Array *arg1 ;
    Matrix *arg2 ;
    Rate arg3 ;
    double arg4 ;
    bool arg5 ;
    long arg6 = 0 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    Array temp0 ;
    PyObject * obj1  = 0 ;
    Matrix temp1 ;
    PyObject * obj2  = 0 ;
    int tempbool5 ;
    char *kwnames[] = {
        "underlying","dividendYield","covariance","riskFreeRate","residualTime","antitheticVariance","seed", NULL 
    };
    McMaxBasket *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOOddi|l:new_McMaxBasket",kwnames,&obj0,&obj1,&obj2,&arg3,&arg4,&tempbool5,&arg6)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Array* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp0 = Array(size);
            arg1 = &temp0;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Matrix* m;
        if (PyTuple_Check(obj2) || PyList_Check(obj2)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj2) ?
            PyTuple_Size(obj2) :
            PyList_Size(obj2));
            // look ahead
            PyObject* o = PySequence_GetItem(obj2,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp1 = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj2,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp1[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp1[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp1[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg2 = &temp1;
        }else if ((SWIG_ConvertPtr(obj2,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg2 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    arg5 = (bool ) tempbool5;
    {
        try {
            result = (McMaxBasket *)new McMaxBasket((Array const &)*arg0,(Array const &)*arg1,(Matrix const &)*arg2,arg3,arg4,arg5,arg6);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_McMaxBasket);
    return resultobj;
}


static PyObject *_wrap_delete_McMaxBasket(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McMaxBasket *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_McMaxBasket",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McMaxBasket,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_McMaxBasket_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McMaxBasket *arg0 ;
    double arg1 ;
    int arg2 = QL_MAX_INT ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","tolerance","maxSample", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|i:McMaxBasket_value",kwnames,&argo0,&arg1,&arg2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McMaxBasket,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value(arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McMaxBasket_valueWithSamples(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McMaxBasket *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","samples", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:McMaxBasket_valueWithSamples",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McMaxBasket,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->valueWithSamples(arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McMaxBasket_errorEstimate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McMaxBasket *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:McMaxBasket_errorEstimate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McMaxBasket,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->errorEstimate();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_McHimalaya(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Array *arg1 ;
    Matrix *arg2 ;
    Rate arg3 ;
    double arg4 ;
    DoubleVector *arg5 ;
    bool arg6 ;
    long arg7 = 0 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    Array temp0 ;
    PyObject * obj1  = 0 ;
    Matrix temp1 ;
    PyObject * obj2  = 0 ;
    DoubleVector temp2 ;
    PyObject * obj5  = 0 ;
    int tempbool6 ;
    char *kwnames[] = {
        "underlying","dividendYield","covariance","riskFreeRate","strike","timeDelays","antitheticVariance","seed", NULL 
    };
    McHimalaya *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOOddOi|l:new_McHimalaya",kwnames,&obj0,&obj1,&obj2,&arg3,&arg4,&obj5,&tempbool6,&arg7)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Array* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp0 = Array(size);
            arg1 = &temp0;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Matrix* m;
        if (PyTuple_Check(obj2) || PyList_Check(obj2)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj2) ?
            PyTuple_Size(obj2) :
            PyList_Size(obj2));
            // look ahead
            PyObject* o = PySequence_GetItem(obj2,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp1 = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj2,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp1[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp1[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp1[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg2 = &temp1;
        }else if ((SWIG_ConvertPtr(obj2,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg2 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj5) || PyList_Check(obj5)) {
            /* Size */ int size = (PyTuple_Check(obj5) ?
            PyTuple_Size(obj5) :
            PyList_Size(obj5));
            temp2 = DoubleVector(size);
            arg5 = &temp2;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj5,i);
                if (o == Py_None) {
                    (*arg5)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg5)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg5)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj5,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg5 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    arg6 = (bool ) tempbool6;
    {
        try {
            result = (McHimalaya *)new McHimalaya((Array const &)*arg0,(Array const &)*arg1,(Matrix const &)*arg2,arg3,arg4,(DoubleVector const &)*arg5,arg6,arg7);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_McHimalaya);
    return resultobj;
}


static PyObject *_wrap_delete_McHimalaya(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McHimalaya *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_McHimalaya",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McHimalaya,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_McHimalaya_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McHimalaya *arg0 ;
    double arg1 ;
    int arg2 = QL_MAX_INT ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","tolerance","maxSample", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|i:McHimalaya_value",kwnames,&argo0,&arg1,&arg2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McHimalaya,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value(arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McHimalaya_valueWithSamples(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McHimalaya *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","samples", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:McHimalaya_valueWithSamples",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McHimalaya,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->valueWithSamples(arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McHimalaya_errorEstimate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McHimalaya *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:McHimalaya_errorEstimate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McHimalaya,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->errorEstimate();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_McEverest(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Matrix *arg1 ;
    Rate arg2 ;
    Time arg3 ;
    bool arg4 ;
    long arg5 = 0 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    Matrix temp0 ;
    PyObject * obj1  = 0 ;
    int tempbool4 ;
    char *kwnames[] = {
        "dividendYield","covariance","riskFreeRate","residualTime","antitheticVariance","seed", NULL 
    };
    McEverest *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOddi|l:new_McEverest",kwnames,&obj0,&obj1,&arg2,&arg3,&tempbool4,&arg5)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Matrix* m;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            // look ahead
            PyObject* o = PySequence_GetItem(obj1,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp0 = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp0[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp0[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp0[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg1 = &temp0;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg1 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    arg4 = (bool ) tempbool4;
    {
        try {
            result = (McEverest *)new McEverest((Array const &)*arg0,(Matrix const &)*arg1,arg2,arg3,arg4,arg5);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_McEverest);
    return resultobj;
}


static PyObject *_wrap_delete_McEverest(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McEverest *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_McEverest",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McEverest,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_McEverest_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McEverest *arg0 ;
    double arg1 ;
    int arg2 = QL_MAX_INT ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","tolerance","maxSample", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|i:McEverest_value",kwnames,&argo0,&arg1,&arg2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McEverest,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value(arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McEverest_valueWithSamples(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McEverest *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","samples", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:McEverest_valueWithSamples",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McEverest,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->valueWithSamples(arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McEverest_errorEstimate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McEverest *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:McEverest_errorEstimate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McEverest,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->errorEstimate();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_McPagoda(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    double arg1 ;
    double arg2 ;
    Array *arg3 ;
    Matrix *arg4 ;
    Rate arg5 ;
    DoubleVector *arg6 ;
    bool arg7 ;
    long arg8 = 0 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    Array temp0 ;
    PyObject * obj3  = 0 ;
    Matrix temp1 ;
    PyObject * obj4  = 0 ;
    DoubleVector temp2 ;
    PyObject * obj6  = 0 ;
    int tempbool7 ;
    char *kwnames[] = {
        "portfolio","fraction","roof","dividendYield","covariance","riskFreeRate","timeDelays","antithetic","seed", NULL 
    };
    McPagoda *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OddOOdOi|l:new_McPagoda",kwnames,&obj0,&arg1,&arg2,&obj3,&obj4,&arg5,&obj6,&tempbool7,&arg8)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Array* v;
        if (PyTuple_Check(obj3) || PyList_Check(obj3)) {
            int size = (PyTuple_Check(obj3) ?
            PyTuple_Size(obj3) :
            PyList_Size(obj3));
            temp0 = Array(size);
            arg3 = &temp0;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj3,i);
                if (PyFloat_Check(o)) {
                    (*arg3)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg3)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj3,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg3 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Matrix* m;
        if (PyTuple_Check(obj4) || PyList_Check(obj4)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj4) ?
            PyTuple_Size(obj4) :
            PyList_Size(obj4));
            // look ahead
            PyObject* o = PySequence_GetItem(obj4,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp1 = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj4,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp1[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp1[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp1[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg4 = &temp1;
        }else if ((SWIG_ConvertPtr(obj4,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg4 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj6) || PyList_Check(obj6)) {
            /* Size */ int size = (PyTuple_Check(obj6) ?
            PyTuple_Size(obj6) :
            PyList_Size(obj6));
            temp2 = DoubleVector(size);
            arg6 = &temp2;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj6,i);
                if (o == Py_None) {
                    (*arg6)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg6)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg6)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj6,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg6 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    arg7 = (bool ) tempbool7;
    {
        try {
            result = (McPagoda *)new McPagoda((Array const &)*arg0,arg1,arg2,(Array const &)*arg3,(Matrix const &)*arg4,arg5,(DoubleVector const &)*arg6,arg7,arg8);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_McPagoda);
    return resultobj;
}


static PyObject *_wrap_delete_McPagoda(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McPagoda *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_McPagoda",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McPagoda,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_McPagoda_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McPagoda *arg0 ;
    double arg1 ;
    int arg2 = QL_MAX_INT ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","tolerance","maxSample", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|i:McPagoda_value",kwnames,&argo0,&arg1,&arg2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McPagoda,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value(arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McPagoda_valueWithSamples(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McPagoda *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","samples", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:McPagoda_valueWithSamples",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McPagoda,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->valueWithSamples(arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_McPagoda_errorEstimate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    McPagoda *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:McPagoda_errorEstimate",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_McPagoda,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->errorEstimate();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_getCovariance(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Matrix *arg1 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    Matrix temp0 ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "volatilities","correlations", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:getCovariance",kwnames,&obj0,&obj1)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Matrix* m;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            // look ahead
            PyObject* o = PySequence_GetItem(obj1,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp0 = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp0[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp0[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp0[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg1 = &temp0;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg1 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    {
        try {
            result = new Matrix (getCovariance((Array const &)*arg0,(Matrix const &)*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Matrix);
    return resultobj;
}


static PyObject *_wrap_delete_Path(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Path *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_Path",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Path,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_Path_drift(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Path *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Array *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Path_drift",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Path,1)) == -1) return NULL;
    {
        try {
            result = new Array (arg0->drift());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Array);
    return resultobj;
}


static PyObject *_wrap_Path_diffusion(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Path *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Array *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Path_diffusion",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Path,1)) == -1) return NULL;
    {
        try {
            result = new Array (arg0->diffusion());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Array);
    return resultobj;
}


int Path___len__(Path *self) {
    {
        return int(self->size());
    }
}


static PyObject *_wrap_Path___len__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Path *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:Path___len__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Path,1)) == -1) return NULL;
    {
        try {
            result = (int )Path___len__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


double Path___getitem__(Path *self,int i) {
    {
        int size_ = int(self->size());
        if (i>=0 && i<size_) {
            return (*self)[i];
        }else if (i<0 && -i<=size_) {
            return (*self)[size_+i];
        }else {
            throw IndexError("Path index out of range");
        }
        QL_DUMMY_RETURN(0.0)
    }
}


static PyObject *_wrap_Path___getitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Path *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","i", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:Path___getitem__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_Path,1)) == -1) return NULL;
    {
        try {
            result = (double )Path___getitem__(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_delete_SamplePath(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SamplePath *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_SamplePath",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SamplePath,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_SamplePath_value_set(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SamplePath *arg0 ;
    Path *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","value", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:SamplePath_value_set",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SamplePath,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_Path,1)) == -1) return NULL;
    {
        try {
            arg0->value = *arg1;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_SamplePath_value_get(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SamplePath *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Path *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:SamplePath_value_get",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SamplePath,1)) == -1) return NULL;
    {
        try {
            result = (Path *)& (arg0->value);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Path);
    return resultobj;
}


static PyObject *_wrap_SamplePath_weight_set(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SamplePath *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","weight", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:SamplePath_weight_set",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SamplePath,1)) == -1) return NULL;
    {
        try {
            arg0->weight = arg1;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_SamplePath_weight_get(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SamplePath *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:SamplePath_weight_get",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SamplePath,1)) == -1) return NULL;
    {
        try {
            result = (double ) (arg0->weight);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_GaussianPathGenerator(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    double arg0 ;
    double arg1 ;
    Time arg2 ;
    int arg3 ;
    long arg4 = 0 ;
    char *kwnames[] = {
        "drift","variance","length","steps","seed", NULL 
    };
    GaussianPathGenerator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"dddi|l:new_GaussianPathGenerator",kwnames,&arg0,&arg1,&arg2,&arg3,&arg4)) return NULL;
    {
        try {
            result = (GaussianPathGenerator *)new GaussianPathGenerator(arg0,arg1,arg2,arg3,arg4);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GaussianPathGenerator);
    return resultobj;
}


static PyObject *_wrap_delete_GaussianPathGenerator(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    GaussianPathGenerator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_GaussianPathGenerator",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_GaussianPathGenerator,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_GaussianPathGenerator_next(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    GaussianPathGenerator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    SamplePath *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:GaussianPathGenerator_next",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_GaussianPathGenerator,1)) == -1) return NULL;
    {
        try {
            result = new SamplePath (arg0->next());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_SamplePath);
    return resultobj;
}


static PyObject *_wrap_delete_MultiPath(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MultiPath *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_MultiPath",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MultiPath,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_MultiPath_assetNumber(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MultiPath *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:MultiPath_assetNumber",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MultiPath,1)) == -1) return NULL;
    {
        try {
            result = (int )arg0->assetNumber();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


int MultiPath___len__(MultiPath *self) {
    {
        return int(self->assetNumber());
    }
}


static PyObject *_wrap_MultiPath___len__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MultiPath *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:MultiPath___len__",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MultiPath,1)) == -1) return NULL;
    {
        try {
            result = (int )MultiPath___len__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


Path MultiPath___getitem__(MultiPath *self,int i) {
    {
        int size_ = int(self->assetNumber());
        if (i>=0 && i<size_) {
            return (*self)[i];
        }else if (i<0 && -i<=size_) {
            return (*self)[size_+i];
        }else {
            throw IndexError("Path index out of range");
        }
        QL_DUMMY_RETURN(0.0)
    }
}


static PyObject *_wrap_MultiPath___getitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MultiPath *arg0 ;
    int arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","i", NULL 
    };
    Path *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:MultiPath___getitem__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MultiPath,1)) == -1) return NULL;
    {
        try {
            result = new Path (MultiPath___getitem__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Path);
    return resultobj;
}


static PyObject *_wrap_delete_SampleMultiPath(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SampleMultiPath *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_SampleMultiPath",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SampleMultiPath,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_SampleMultiPath_value_set(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SampleMultiPath *arg0 ;
    MultiPath *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","value", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:SampleMultiPath_value_set",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SampleMultiPath,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_MultiPath,1)) == -1) return NULL;
    {
        try {
            arg0->value = *arg1;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_SampleMultiPath_value_get(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SampleMultiPath *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    MultiPath *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:SampleMultiPath_value_get",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SampleMultiPath,1)) == -1) return NULL;
    {
        try {
            result = (MultiPath *)& (arg0->value);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_MultiPath);
    return resultobj;
}


static PyObject *_wrap_SampleMultiPath_weight_set(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SampleMultiPath *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","weight", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:SampleMultiPath_weight_set",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SampleMultiPath,1)) == -1) return NULL;
    {
        try {
            arg0->weight = arg1;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_SampleMultiPath_weight_get(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SampleMultiPath *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:SampleMultiPath_weight_get",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SampleMultiPath,1)) == -1) return NULL;
    {
        try {
            result = (double ) (arg0->weight);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_GaussianMultiPathGenerator(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Matrix *arg1 ;
    DoubleVector *arg2 ;
    long arg3 = 0 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    Matrix temp0 ;
    PyObject * obj1  = 0 ;
    DoubleVector temp1 ;
    PyObject * obj2  = 0 ;
    char *kwnames[] = {
        "drifts","covariance","timeDelays","seed", NULL 
    };
    GaussianMultiPathGenerator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOO|l:new_GaussianMultiPathGenerator",kwnames,&obj0,&obj1,&obj2,&arg3)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Matrix* m;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            // look ahead
            PyObject* o = PySequence_GetItem(obj1,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp0 = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp0[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp0[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp0[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg1 = &temp0;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg1 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj2) || PyList_Check(obj2)) {
            /* Size */ int size = (PyTuple_Check(obj2) ?
            PyTuple_Size(obj2) :
            PyList_Size(obj2));
            temp1 = DoubleVector(size);
            arg2 = &temp1;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj2,i);
                if (o == Py_None) {
                    (*arg2)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg2)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg2)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj2,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg2 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (GaussianMultiPathGenerator *)new GaussianMultiPathGenerator((Array const &)*arg0,(Matrix const &)*arg1,(DoubleVector const &)*arg2,arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GaussianMultiPathGenerator);
    return resultobj;
}


static PyObject *_wrap_delete_GaussianMultiPathGenerator(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    GaussianMultiPathGenerator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_GaussianMultiPathGenerator",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_GaussianMultiPathGenerator,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_GaussianMultiPathGenerator_next(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    GaussianMultiPathGenerator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    SampleMultiPath *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:GaussianMultiPathGenerator_next",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_GaussianMultiPathGenerator,1)) == -1) return NULL;
    {
        try {
            result = new SampleMultiPath (arg0->next());
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_SampleMultiPath);
    return resultobj;
}


static PyObject *_wrap_new_TridiagonalOperator(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Array *arg1 ;
    Array *arg2 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    Array temp0 ;
    PyObject * obj1  = 0 ;
    Array temp1 ;
    PyObject * obj2  = 0 ;
    char *kwnames[] = {
        "low","mid","high", NULL 
    };
    TridiagonalOperator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOO:new_TridiagonalOperator",kwnames,&obj0,&obj1,&obj2)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Array* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp0 = Array(size);
            arg1 = &temp0;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Array* v;
        if (PyTuple_Check(obj2) || PyList_Check(obj2)) {
            int size = (PyTuple_Check(obj2) ?
            PyTuple_Size(obj2) :
            PyList_Size(obj2));
            temp1 = Array(size);
            arg2 = &temp1;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj2,i);
                if (PyFloat_Check(o)) {
                    (*arg2)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg2)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj2,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg2 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            result = (TridiagonalOperator *)new TridiagonalOperator(*arg0,*arg1,*arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_TridiagonalOperator);
    return resultobj;
}


static PyObject *_wrap_delete_TridiagonalOperator(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_TridiagonalOperator",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_TridiagonalOperator_solveFor(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    Array *arg1 ;
    PyObject * argo0 =0 ;
    Array temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","rhs", NULL 
    };
    Array *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:TridiagonalOperator_solveFor",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp = Array(size);
            arg1 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            result = new Array (arg0->solveFor((Array const &)*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Array);
    return resultobj;
}


static PyObject *_wrap_TridiagonalOperator_applyTo(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    Array *arg1 ;
    PyObject * argo0 =0 ;
    Array temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "self","v", NULL 
    };
    Array *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:TridiagonalOperator_applyTo",kwnames,&argo0,&obj1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp = Array(size);
            arg1 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            result = new Array (arg0->applyTo((Array const &)*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Array);
    return resultobj;
}


static PyObject *_wrap_TridiagonalOperator_size(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:TridiagonalOperator_size",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        try {
            result = (int )arg0->size();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_TridiagonalOperator_setLowerBC(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    BoundaryCondition *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","bc", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:TridiagonalOperator_setLowerBC",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_BoundaryCondition,1)) == -1) return NULL;
    {
        try {
            arg0->setLowerBC(*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_TridiagonalOperator_setUpperBC(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    BoundaryCondition *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","bc", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:TridiagonalOperator_setUpperBC",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_BoundaryCondition,1)) == -1) return NULL;
    {
        try {
            arg0->setUpperBC(*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_TridiagonalOperator_setFirstRow(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    double arg1 ;
    double arg2 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","arg1","arg2", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Odd:TridiagonalOperator_setFirstRow",kwnames,&argo0,&arg1,&arg2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        try {
            arg0->setFirstRow(arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_TridiagonalOperator_setMidRow(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    int arg1 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","arg1","arg2","arg3","arg4", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oiddd:TridiagonalOperator_setMidRow",kwnames,&argo0,&arg1,&arg2,&arg3,&arg4)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        try {
            arg0->setMidRow(arg1,arg2,arg3,arg4);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_TridiagonalOperator_setMidRows(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    double arg1 ;
    double arg2 ;
    double arg3 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","arg1","arg2","arg3", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oddd:TridiagonalOperator_setMidRows",kwnames,&argo0,&arg1,&arg2,&arg3)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        try {
            arg0->setMidRows(arg1,arg2,arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_TridiagonalOperator_setLastRow(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    double arg1 ;
    double arg2 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","arg1","arg2", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Odd:TridiagonalOperator_setLastRow",kwnames,&argo0,&arg1,&arg2)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        try {
            arg0->setLastRow(arg1,arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


TridiagonalOperator TridiagonalOperator___add__(TridiagonalOperator *self,TridiagonalOperator const &O) {
    {
        return *self+O;
    }
}


static PyObject *_wrap_TridiagonalOperator___add__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    TridiagonalOperator *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","O", NULL 
    };
    TridiagonalOperator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:TridiagonalOperator___add__",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        try {
            result = new TridiagonalOperator (TridiagonalOperator___add__(arg0,(TridiagonalOperator const &)*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_TridiagonalOperator);
    return resultobj;
}


TridiagonalOperator TridiagonalOperator___sub__(TridiagonalOperator *self,TridiagonalOperator const &O) {
    {
        return *self-O;
    }
}


static PyObject *_wrap_TridiagonalOperator___sub__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    TridiagonalOperator *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","O", NULL 
    };
    TridiagonalOperator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:TridiagonalOperator___sub__",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        try {
            result = new TridiagonalOperator (TridiagonalOperator___sub__(arg0,(TridiagonalOperator const &)*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_TridiagonalOperator);
    return resultobj;
}


TridiagonalOperator TridiagonalOperator___mul__(TridiagonalOperator *self,double a) {
    {
        return *self*a;
    }
}


static PyObject *_wrap_TridiagonalOperator___mul__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","a", NULL 
    };
    TridiagonalOperator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:TridiagonalOperator___mul__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        try {
            result = new TridiagonalOperator (TridiagonalOperator___mul__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_TridiagonalOperator);
    return resultobj;
}


TridiagonalOperator TridiagonalOperator___div__(TridiagonalOperator *self,double a) {
    {
        return *self/a;
    }
}


static PyObject *_wrap_TridiagonalOperator___div__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","a", NULL 
    };
    TridiagonalOperator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:TridiagonalOperator___div__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        try {
            result = new TridiagonalOperator (TridiagonalOperator___div__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_TridiagonalOperator);
    return resultobj;
}


TridiagonalOperator TridiagonalOperator___iadd__(TridiagonalOperator *self,TridiagonalOperator const &O) {
    {
        return *self+O;
    }
}


static PyObject *_wrap_TridiagonalOperator___iadd__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    TridiagonalOperator *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","O", NULL 
    };
    TridiagonalOperator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:TridiagonalOperator___iadd__",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        try {
            result = new TridiagonalOperator (TridiagonalOperator___iadd__(arg0,(TridiagonalOperator const &)*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_TridiagonalOperator);
    return resultobj;
}


TridiagonalOperator TridiagonalOperator___isub__(TridiagonalOperator *self,TridiagonalOperator const &O) {
    {
        return *self-O;
    }
}


static PyObject *_wrap_TridiagonalOperator___isub__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    TridiagonalOperator *arg1 ;
    PyObject * argo0 =0 ;
    PyObject * argo1 =0 ;
    char *kwnames[] = {
        "self","O", NULL 
    };
    TridiagonalOperator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:TridiagonalOperator___isub__",kwnames,&argo0,&argo1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        try {
            result = new TridiagonalOperator (TridiagonalOperator___isub__(arg0,(TridiagonalOperator const &)*arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_TridiagonalOperator);
    return resultobj;
}


TridiagonalOperator TridiagonalOperator___imul__(TridiagonalOperator *self,double a) {
    {
        return *self*a;
    }
}


static PyObject *_wrap_TridiagonalOperator___imul__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","a", NULL 
    };
    TridiagonalOperator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:TridiagonalOperator___imul__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        try {
            result = new TridiagonalOperator (TridiagonalOperator___imul__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_TridiagonalOperator);
    return resultobj;
}


TridiagonalOperator TridiagonalOperator___rmul__(TridiagonalOperator *self,double a) {
    {
        return *self*a;
    }
}


static PyObject *_wrap_TridiagonalOperator___rmul__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","a", NULL 
    };
    TridiagonalOperator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:TridiagonalOperator___rmul__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        try {
            result = new TridiagonalOperator (TridiagonalOperator___rmul__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_TridiagonalOperator);
    return resultobj;
}


TridiagonalOperator TridiagonalOperator___idiv__(TridiagonalOperator *self,double a) {
    {
        return *self/a;
    }
}


static PyObject *_wrap_TridiagonalOperator___idiv__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalOperator *arg0 ;
    double arg1 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","a", NULL 
    };
    TridiagonalOperator *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od:TridiagonalOperator___idiv__",kwnames,&argo0,&arg1)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalOperator,1)) == -1) return NULL;
    {
        try {
            result = new TridiagonalOperator (TridiagonalOperator___idiv__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_TridiagonalOperator);
    return resultobj;
}


static PyObject *_wrap_delete_TridiagonalIdentity(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    TridiagonalIdentity *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_TridiagonalIdentity",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_TridiagonalIdentity,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


TridiagonalIdentity * new_TridiagonalIdentity(int gridPoints) {
    {
        return new TridiagonalOperator(
        TridiagonalOperator::identity(gridPoints));
    }
}


static PyObject *_wrap_new_Identity(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    int arg0 ;
    char *kwnames[] = {
        "gridPoints", NULL 
    };
    TridiagonalIdentity *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"i:new_Identity",kwnames,&arg0)) return NULL;
    {
        try {
            result = (TridiagonalIdentity *)new_TridiagonalIdentity(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_TridiagonalIdentity);
    return resultobj;
}


static PyObject *_wrap_new_DPlus(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    int arg0 ;
    double arg1 ;
    char *kwnames[] = {
        "gridPoints","h", NULL 
    };
    DPlus *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"id:new_DPlus",kwnames,&arg0,&arg1)) return NULL;
    {
        try {
            result = (DPlus *)new DPlus(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DPlus);
    return resultobj;
}


static PyObject *_wrap_delete_DPlus(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DPlus *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_DPlus",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DPlus,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_new_DMinus(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    int arg0 ;
    double arg1 ;
    char *kwnames[] = {
        "gridPoints","h", NULL 
    };
    DMinus *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"id:new_DMinus",kwnames,&arg0,&arg1)) return NULL;
    {
        try {
            result = (DMinus *)new DMinus(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DMinus);
    return resultobj;
}


static PyObject *_wrap_delete_DMinus(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DMinus *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_DMinus",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DMinus,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_new_DZero(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    int arg0 ;
    double arg1 ;
    char *kwnames[] = {
        "gridPoints","h", NULL 
    };
    DZero *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"id:new_DZero",kwnames,&arg0,&arg1)) return NULL;
    {
        try {
            result = (DZero *)new DZero(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DZero);
    return resultobj;
}


static PyObject *_wrap_delete_DZero(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DZero *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_DZero",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DZero,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_new_DPlusDMinus(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    int arg0 ;
    double arg1 ;
    char *kwnames[] = {
        "gridPoints","h", NULL 
    };
    DPlusDMinus *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"id:new_DPlusDMinus",kwnames,&arg0,&arg1)) return NULL;
    {
        try {
            result = (DPlusDMinus *)new DPlusDMinus(arg0,arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DPlusDMinus);
    return resultobj;
}


static PyObject *_wrap_delete_DPlusDMinus(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DPlusDMinus *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_DPlusDMinus",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DPlusDMinus,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_valueAtCenter(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "a", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:valueAtCenter",kwnames,&obj0)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            result = (double )valueAtCenter((Array const &)*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_firstDerivativeAtCenter(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Array *arg1 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    Array temp0 ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "a","g", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:firstDerivativeAtCenter",kwnames,&obj0,&obj1)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Array* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp0 = Array(size);
            arg1 = &temp0;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            result = (double )firstDerivativeAtCenter((Array const &)*arg0,(Array const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_secondDerivativeAtCenter(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Array *arg0 ;
    Array *arg1 ;
    Array temp ;
    PyObject * obj0  = 0 ;
    Array temp0 ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "a","g", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OO:secondDerivativeAtCenter",kwnames,&obj0,&obj1)) return NULL;
    {
        Array* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = Array(size);
            arg0 = &temp;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyFloat_Check(o)) {
                    (*arg0)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg0)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        Array* v;
        if (PyTuple_Check(obj1) || PyList_Check(obj1)) {
            int size = (PyTuple_Check(obj1) ?
            PyTuple_Size(obj1) :
            PyList_Size(obj1));
            temp0 = Array(size);
            arg1 = &temp0;
            for (int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj1,i);
                if (PyFloat_Check(o)) {
                    (*arg1)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg1)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,
                    "doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj1,(void **) &v,
        SWIGTYPE_p_Array,0)) != -1) {
            arg1 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"Array expected");
            return NULL;
        }
    }
    {
        try {
            result = (double )secondDerivativeAtCenter((Array const &)*arg0,(Array const &)*arg1);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_SymmetricEigenvalues(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    Matrix temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "s", NULL 
    };
    Array *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:SymmetricEigenvalues",kwnames,&obj0)) return NULL;
    {
        Matrix* m;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            // look ahead
            PyObject* o = PySequence_GetItem(obj0,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg0 = &temp;
        }else if ((SWIG_ConvertPtr(obj0,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg0 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    {
        try {
            result = new Array (SymmetricEigenvalues(*arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Array);
    return resultobj;
}


static PyObject *_wrap_SymmetricEigenvectors(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Matrix *arg0 ;
    Matrix temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "s", NULL 
    };
    Matrix *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:SymmetricEigenvectors",kwnames,&obj0)) return NULL;
    {
        Matrix* m;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int rows, cols;
            rows = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            // look ahead
            PyObject* o = PySequence_GetItem(obj0,0);
            if (PyTuple_Check(o) || PyList_Check(o)) {
                cols = (PyTuple_Check(o) ?
                PyTuple_Size(o) :
                PyList_Size(o));
                Py_DECREF(o);
            }else {
                PyErr_SetString(PyExc_TypeError, "Matrix expected");
                Py_DECREF(o);
                return NULL;
            }
            
            temp = Matrix(rows,cols);
            for (/* Size */ int i=0; i<rows; i++) {
                PyObject* o = PySequence_GetItem(obj0,i);
                if (PyTuple_Check(o) || PyList_Check(o)) {
                    /* Size */ int items = (PyTuple_Check(o) ?
                    PyTuple_Size(o) :
                    PyList_Size(o));
                    if (items != cols) {
                        PyErr_SetString(PyExc_TypeError, 
                        "Matrix must have equal-length rows");
                        Py_DECREF(o);
                        return NULL;
                    }
                    for (/* Size */ int j=0; j<cols; j++) {
                        PyObject* d = PySequence_GetItem(o,j);
                        if (d == Py_None) {
                            temp[i][j] = Null<double>();
                            Py_DECREF(d);
                        }else if (PyFloat_Check(d)) {
                            temp[i][j] = PyFloat_AsDouble(d);
                            Py_DECREF(d);
                        }else if (PyInt_Check(d)) {
                            temp[i][j] = double(PyInt_AsLong(d));
                            Py_DECREF(d);
                        }else {
                            PyErr_SetString(PyExc_TypeError,"doubles expected");
                            Py_DECREF(d);
                            Py_DECREF(o);
                            return NULL;
                        }
                    }
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError, "Matrix expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
            arg0 = &temp;
        }else if ((SWIG_ConvertPtr(obj0,(void **) &m,
        SWIGTYPE_p_Matrix,0)) != -1) {
            arg0 = m;
        }else {
            PyErr_SetString(PyExc_TypeError,"Matrix expected");
            return NULL;
        }
    }
    {
        try {
            result = new Matrix (SymmetricEigenvectors(*arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Matrix);
    return resultobj;
}


static PyObject *_wrap_delete_RateHelperHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    RateHelperHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_RateHelperHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_RateHelperHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


Date RateHelperHandle_maturity(RateHelperHandle *self) {
    {
        return (*self)->maturity();
    }
}


static PyObject *_wrap_RateHelper_maturity(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    RateHelperHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    Date *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:RateHelper_maturity",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_RateHelperHandle,1)) == -1) return NULL;
    {
        try {
            result = new Date (RateHelperHandle_maturity(arg0));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_Date);
    return resultobj;
}


static PyObject *_wrap_delete_DepositRateHelperHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DepositRateHelperHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_DepositRateHelperHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DepositRateHelperHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


DepositRateHelperHandle * new_DepositRateHelperHandle(MarketElementRelinkableHandle rate,int settlementDays,int n,TimeUnit units,Calendar calendar,RollingConvention convention,DayCounter dayCounter) {
    {
        return new DepositRateHelperHandle(
        new DepositRateHelper(rate,settlementDays,n,units,calendar,
        convention,dayCounter));
    }
}


static PyObject *_wrap_new_DepositRateHelper(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementRelinkableHandle *arg0 ;
    int arg1 ;
    int arg2 ;
    TimeUnit *arg3 ;
    Calendar *arg4 ;
    RollingConvention *arg5 ;
    DayCounter *arg6 ;
    PyObject * argo0 =0 ;
    TimeUnit temp ;
    PyObject * obj3  = 0 ;
    PyObject * argo4 =0 ;
    RollingConvention temp0 ;
    PyObject * obj5  = 0 ;
    PyObject * argo6 =0 ;
    char *kwnames[] = {
        "rate","settlementDays","n","units","calendar","convention","dayCounter", NULL 
    };
    DepositRateHelperHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OiiOOOO:new_DepositRateHelper",kwnames,&argo0,&arg1,&arg2,&obj3,&argo4,&obj5,&argo6)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    {
        if (PyString_Check(obj3)) {
            std::string s(PyString_AsString(obj3));
            s = StringFormatter::toLowercase(s);
            if (s == "d" || s == "day" || s == "days")
            temp = Days;
            else if (s == "w" || s == "week" || s == "weeks")
            temp = Weeks;
            else if (s == "m" || s == "month" || s == "months")
            temp = Months;
            else if (s == "y" || s == "year" || s == "years")
            temp = Years;
            else {
                PyErr_SetString(PyExc_TypeError,"not a time unit");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a time unit");
            return NULL;
        }
        arg3 = &temp;
    }
    if ((SWIG_ConvertPtr(argo4,(void **) &arg4,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        if (PyString_Check(obj5)) {
            std::string s(PyString_AsString(obj5));
            s = StringFormatter::toLowercase(s);
            if (s == "f" || s == "fol" || s == "following")
            temp0 = Following;
            else if (s == "mf" ||s == "modfol" || s == "modifiedfollowing")
            temp0 = ModifiedFollowing;
            else if (s == "p" || s == "pre" || s == "preceding")
            temp0 = Preceding;
            else if (s == "mp" ||s == "modpre" || s == "modifiedpreceding")
            temp0 = ModifiedPreceding;
            else {
                PyErr_SetString(PyExc_TypeError,(s+" is not "
                "a rolling convention").c_str());
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"rolling convention expected");
            return NULL;
        }
        arg5 = &temp0;
    }
    if ((SWIG_ConvertPtr(argo6,(void **) &arg6,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    {
        try {
            result = (DepositRateHelperHandle *)new_DepositRateHelperHandle(*arg0,arg1,arg2,*arg3,*arg4,*arg5,*arg6);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DepositRateHelperHandle);
    return resultobj;
}


static PyObject *_wrap_delete_FraRateHelperHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FraRateHelperHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_FraRateHelperHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FraRateHelperHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


FraRateHelperHandle * new_FraRateHelperHandle(MarketElementRelinkableHandle rate,int settlementDays,int monthsToStart,int monthsToEnd,Calendar calendar,RollingConvention convention,DayCounter dayCounter) {
    {
        return new FraRateHelperHandle(
        new FraRateHelper(rate,settlementDays,monthsToStart,
        monthsToEnd,calendar,convention,dayCounter));
    }
}


static PyObject *_wrap_new_FraRateHelper(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementRelinkableHandle *arg0 ;
    int arg1 ;
    int arg2 ;
    int arg3 ;
    Calendar *arg4 ;
    RollingConvention *arg5 ;
    DayCounter *arg6 ;
    PyObject * argo0 =0 ;
    PyObject * argo4 =0 ;
    RollingConvention temp ;
    PyObject * obj5  = 0 ;
    PyObject * argo6 =0 ;
    char *kwnames[] = {
        "rate","settlementDays","monthsToStart","monthsToEnd","calendar","convention","dayCounter", NULL 
    };
    FraRateHelperHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OiiiOOO:new_FraRateHelper",kwnames,&argo0,&arg1,&arg2,&arg3,&argo4,&obj5,&argo6)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo4,(void **) &arg4,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        if (PyString_Check(obj5)) {
            std::string s(PyString_AsString(obj5));
            s = StringFormatter::toLowercase(s);
            if (s == "f" || s == "fol" || s == "following")
            temp = Following;
            else if (s == "mf" ||s == "modfol" || s == "modifiedfollowing")
            temp = ModifiedFollowing;
            else if (s == "p" || s == "pre" || s == "preceding")
            temp = Preceding;
            else if (s == "mp" ||s == "modpre" || s == "modifiedpreceding")
            temp = ModifiedPreceding;
            else {
                PyErr_SetString(PyExc_TypeError,(s+" is not "
                "a rolling convention").c_str());
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"rolling convention expected");
            return NULL;
        }
        arg5 = &temp;
    }
    if ((SWIG_ConvertPtr(argo6,(void **) &arg6,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    {
        try {
            result = (FraRateHelperHandle *)new_FraRateHelperHandle(*arg0,arg1,arg2,arg3,*arg4,*arg5,*arg6);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FraRateHelperHandle);
    return resultobj;
}


static PyObject *_wrap_delete_FuturesRateHelperHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    FuturesRateHelperHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_FuturesRateHelperHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_FuturesRateHelperHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


FuturesRateHelperHandle * new_FuturesRateHelperHandle(MarketElementRelinkableHandle price,Date const &ImmDate,int settlementDays,int nMonths,Calendar calendar,RollingConvention convention,DayCounter dayCounter) {
    {
        return new FuturesRateHelperHandle(
        new FuturesRateHelper(price,ImmDate,settlementDays,nMonths,
        calendar,convention,dayCounter));
    }
}


static PyObject *_wrap_new_FuturesRateHelper(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementRelinkableHandle *arg0 ;
    Date *arg1 ;
    int arg2 ;
    int arg3 ;
    Calendar *arg4 ;
    RollingConvention *arg5 ;
    DayCounter *arg6 ;
    PyObject * argo0 =0 ;
    Date temp ;
    PyObject * obj1  = 0 ;
    PyObject * argo4 =0 ;
    RollingConvention temp0 ;
    PyObject * obj5  = 0 ;
    PyObject * argo6 =0 ;
    char *kwnames[] = {
        "price","ImmDate","settlementDays","nMonths","calendar","convention","dayCounter", NULL 
    };
    FuturesRateHelperHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOiiOOO:new_FuturesRateHelper",kwnames,&argo0,&obj1,&arg2,&arg3,&argo4,&obj5,&argo6)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    {
        Date* x;
        if (obj1 == Py_None) {
            temp = Date();
            arg1 = &temp;
        }else if ((SWIG_ConvertPtr(obj1,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg1 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    if ((SWIG_ConvertPtr(argo4,(void **) &arg4,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        if (PyString_Check(obj5)) {
            std::string s(PyString_AsString(obj5));
            s = StringFormatter::toLowercase(s);
            if (s == "f" || s == "fol" || s == "following")
            temp0 = Following;
            else if (s == "mf" ||s == "modfol" || s == "modifiedfollowing")
            temp0 = ModifiedFollowing;
            else if (s == "p" || s == "pre" || s == "preceding")
            temp0 = Preceding;
            else if (s == "mp" ||s == "modpre" || s == "modifiedpreceding")
            temp0 = ModifiedPreceding;
            else {
                PyErr_SetString(PyExc_TypeError,(s+" is not "
                "a rolling convention").c_str());
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"rolling convention expected");
            return NULL;
        }
        arg5 = &temp0;
    }
    if ((SWIG_ConvertPtr(argo6,(void **) &arg6,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    {
        try {
            result = (FuturesRateHelperHandle *)new_FuturesRateHelperHandle(*arg0,(Date const &)*arg1,arg2,arg3,*arg4,*arg5,*arg6);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FuturesRateHelperHandle);
    return resultobj;
}


static PyObject *_wrap_delete_SwapRateHelperHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    SwapRateHelperHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_SwapRateHelperHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_SwapRateHelperHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


SwapRateHelperHandle * new_SwapRateHelperHandle(MarketElementRelinkableHandle rate,int settlementDays,int lengthInYears,Calendar calendar,RollingConvention rollingConvention,int fixedFrequency,bool fixedIsAdjusted,DayCounter fixedDayCount,int floatingFrequency) {
    {
        return new SwapRateHelperHandle(
        new SwapRateHelper(rate, settlementDays, lengthInYears,
        calendar, rollingConvention, fixedFrequency,
        fixedIsAdjusted, fixedDayCount, floatingFrequency));
    }
}


static PyObject *_wrap_new_SwapRateHelper(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    MarketElementRelinkableHandle *arg0 ;
    int arg1 ;
    int arg2 ;
    Calendar *arg3 ;
    RollingConvention *arg4 ;
    int arg5 ;
    bool arg6 ;
    DayCounter *arg7 ;
    int arg8 ;
    PyObject * argo0 =0 ;
    PyObject * argo3 =0 ;
    RollingConvention temp ;
    PyObject * obj4  = 0 ;
    int tempbool6 ;
    PyObject * argo7 =0 ;
    char *kwnames[] = {
        "rate","settlementDays","lengthInYears","calendar","rollingConvention","fixedFrequency","fixedIsAdjusted","fixedDayCount","floatingFrequency", NULL 
    };
    SwapRateHelperHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OiiOOiiOi:new_SwapRateHelper",kwnames,&argo0,&arg1,&arg2,&argo3,&obj4,&arg5,&tempbool6,&argo7,&arg8)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_MarketElementRelinkableHandle,1)) == -1) return NULL;
    if ((SWIG_ConvertPtr(argo3,(void **) &arg3,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        if (PyString_Check(obj4)) {
            std::string s(PyString_AsString(obj4));
            s = StringFormatter::toLowercase(s);
            if (s == "f" || s == "fol" || s == "following")
            temp = Following;
            else if (s == "mf" ||s == "modfol" || s == "modifiedfollowing")
            temp = ModifiedFollowing;
            else if (s == "p" || s == "pre" || s == "preceding")
            temp = Preceding;
            else if (s == "mp" ||s == "modpre" || s == "modifiedpreceding")
            temp = ModifiedPreceding;
            else {
                PyErr_SetString(PyExc_TypeError,(s+" is not "
                "a rolling convention").c_str());
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"rolling convention expected");
            return NULL;
        }
        arg4 = &temp;
    }
    arg6 = (bool ) tempbool6;
    if ((SWIG_ConvertPtr(argo7,(void **) &arg7,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    {
        try {
            result = (SwapRateHelperHandle *)new_SwapRateHelperHandle(*arg0,arg1,arg2,*arg3,*arg4,arg5,arg6,*arg7,arg8);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_SwapRateHelperHandle);
    return resultobj;
}


static PyObject *_wrap_delete_RateHelperHandleVector(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    RateHelperHandleVector *arg0 ;
    RateHelperHandleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_RateHelperHandleVector",kwnames,&obj0)) return NULL;
    {
        RateHelperHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = RateHelperHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                RateHelperHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_RateHelperHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"RateHelper" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_RateHelperHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"RateHelperVector" " expected");
            return NULL;
        }
    }
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


RateHelperHandleVector * new_RateHelperHandleVector(RateHelperHandleVector const &v) {
    {
        return new RateHelperHandleVector(v);
    }
}


static PyObject *_wrap_new_RateHelperVector(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    RateHelperHandleVector *arg0 ;
    RateHelperHandleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "v", NULL 
    };
    RateHelperHandleVector *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:new_RateHelperVector",kwnames,&obj0)) return NULL;
    {
        RateHelperHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = RateHelperHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                RateHelperHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_RateHelperHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"RateHelper" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_RateHelperHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"RateHelperVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (RateHelperHandleVector *)new_RateHelperHandleVector((RateHelperHandleVector const &)*arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_RateHelperHandleVector);
    return resultobj;
}


int RateHelperHandleVector___len__(RateHelperHandleVector *self) {
    {
        return self->size();
    }
}


static PyObject *_wrap_RateHelperVector___len__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    RateHelperHandleVector *arg0 ;
    RateHelperHandleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    int result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:RateHelperVector___len__",kwnames,&obj0)) return NULL;
    {
        RateHelperHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = RateHelperHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                RateHelperHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_RateHelperHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"RateHelper" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_RateHelperHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"RateHelperVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (int )RateHelperHandleVector___len__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


RateHelperHandle RateHelperHandleVector___getitem__(RateHelperHandleVector *self,int i) {
    {
        int size_ = static_cast<int>(self->size());
        if (i>=0 && i<size_) {
            return (*self)[i];
        }else if (i<0 && -i<=size_) {
            return (*self)[size_+i];
        }else {
            throw IndexError("RateHelperVector" " index out of range");
        }
        QL_DUMMY_RETURN(RateHelperHandle())
    }
}


static PyObject *_wrap_RateHelperVector___getitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    RateHelperHandleVector *arg0 ;
    int arg1 ;
    RateHelperHandleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self","i", NULL 
    };
    RateHelperHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oi:RateHelperVector___getitem__",kwnames,&obj0,&arg1)) return NULL;
    {
        RateHelperHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = RateHelperHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                RateHelperHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_RateHelperHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"RateHelper" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_RateHelperHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"RateHelperVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = new RateHelperHandle (RateHelperHandleVector___getitem__(arg0,arg1));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_RateHelperHandle);
    return resultobj;
}


void RateHelperHandleVector___setitem__(RateHelperHandleVector *self,int i,RateHelperHandle const &x) {
    {
        int size_ = static_cast<int>(self->size());
        if (i>=0 && i<size_) {
            (*self)[i] = x;
        }else if (i<0 && -i<=size_) {
            (*self)[size_+i] = x;
        }else {
            throw IndexError("RateHelperVector" " index out of range");
        }
    }
}


static PyObject *_wrap_RateHelperVector___setitem__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    RateHelperHandleVector *arg0 ;
    int arg1 ;
    RateHelperHandle *arg2 ;
    RateHelperHandleVector temp ;
    PyObject * obj0  = 0 ;
    PyObject * argo2 =0 ;
    char *kwnames[] = {
        "self","i","x", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OiO:RateHelperVector___setitem__",kwnames,&obj0,&arg1,&argo2)) return NULL;
    {
        RateHelperHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = RateHelperHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                RateHelperHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_RateHelperHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"RateHelper" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_RateHelperHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"RateHelperVector" " expected");
            return NULL;
        }
    }
    if ((SWIG_ConvertPtr(argo2,(void **) &arg2,SWIGTYPE_p_RateHelperHandle,1)) == -1) return NULL;
    {
        try {
            RateHelperHandleVector___setitem__(arg0,arg1,(RateHelperHandle const &)*arg2);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


RateHelperHandleVector RateHelperHandleVector___getslice__(RateHelperHandleVector *self,int i,int j) {
    {
        int size_ = static_cast<int>(self->size());
        if (i<0)
        i = size_+i;
        if (j<0)
        j = size_+j;
        i = QL_MAX(0,i);
        j = QL_MIN(size_,j);
        RateHelperHandleVector tmp(j-i);
        std::copy(self->begin()+i,self->begin()+j,tmp.begin());
        return tmp;
    }
}


static PyObject *_wrap_RateHelperVector___getslice__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    RateHelperHandleVector *arg0 ;
    int arg1 ;
    int arg2 ;
    RateHelperHandleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self","i","j", NULL 
    };
    RateHelperHandleVector *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Oii:RateHelperVector___getslice__",kwnames,&obj0,&arg1,&arg2)) return NULL;
    {
        RateHelperHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = RateHelperHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                RateHelperHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_RateHelperHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"RateHelper" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_RateHelperHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"RateHelperVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = new RateHelperHandleVector (RateHelperHandleVector___getslice__(arg0,arg1,arg2));
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *)result, SWIGTYPE_p_RateHelperHandleVector);
    return resultobj;
}


void RateHelperHandleVector___setslice__(RateHelperHandleVector *self,int i,int j,RateHelperHandleVector const &rhs) {
    {
        int size_ = static_cast<int>(self->size());
        if (i<0)
        i = size_+i;
        if (j<0)
        j = size_+j;
        i = QL_MAX(0,i);
        j = QL_MIN(size_,j);
        QL_ENSURE(static_cast<int>(rhs.size()) == j-i,
        "RateHelperVector""s are not resizable");
        std::copy(rhs.begin(),rhs.end(),self->begin()+i);
    }
}


static PyObject *_wrap_RateHelperVector___setslice__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    RateHelperHandleVector *arg0 ;
    int arg1 ;
    int arg2 ;
    RateHelperHandleVector *arg3 ;
    RateHelperHandleVector temp ;
    PyObject * obj0  = 0 ;
    RateHelperHandleVector temp0 ;
    PyObject * obj3  = 0 ;
    char *kwnames[] = {
        "self","i","j","rhs", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OiiO:RateHelperVector___setslice__",kwnames,&obj0,&arg1,&arg2,&obj3)) return NULL;
    {
        RateHelperHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = RateHelperHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                RateHelperHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_RateHelperHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"RateHelper" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_RateHelperHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"RateHelperVector" " expected");
            return NULL;
        }
    }
    {
        RateHelperHandleVector* v;
        if (PyTuple_Check(obj3) || PyList_Check(obj3)) {
            /* Size */ int size = (PyTuple_Check(obj3) ?
            PyTuple_Size(obj3) :
            PyList_Size(obj3));
            temp0 = RateHelperHandleVector(size);
            arg3 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                RateHelperHandle* x;
                PyObject* o = PySequence_GetItem(obj3,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_RateHelperHandle,0)) != -1) {
                    (*arg3)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"RateHelper" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj3,(void **) &v,
        SWIGTYPE_p_RateHelperHandleVector,0)) != -1) {
            arg3 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"RateHelperVector" " expected");
            return NULL;
        }
    }
    {
        try {
            RateHelperHandleVector___setslice__(arg0,arg1,arg2,(RateHelperHandleVector const &)*arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


bool RateHelperHandleVector___nonzero__(RateHelperHandleVector *self) {
    {
        return (self->size() != 0);
    }
}


static PyObject *_wrap_RateHelperVector___nonzero__(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    RateHelperHandleVector *arg0 ;
    RateHelperHandleVector temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    bool result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:RateHelperVector___nonzero__",kwnames,&obj0)) return NULL;
    {
        RateHelperHandleVector* v;
        if (PyTuple_Check(obj0) || PyList_Check(obj0)) {
            /* Size */ int size = (PyTuple_Check(obj0) ?
            PyTuple_Size(obj0) :
            PyList_Size(obj0));
            temp = RateHelperHandleVector(size);
            arg0 = &temp;
            for (/* Size */ int i=0; i<size; i++) {
                RateHelperHandle* x;
                PyObject* o = PySequence_GetItem(obj0,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_RateHelperHandle,0)) != -1) {
                    (*arg0)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"RateHelper" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj0,(void **) &v,
        SWIGTYPE_p_RateHelperHandleVector,0)) != -1) {
            arg0 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"RateHelperVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (bool )RateHelperHandleVector___nonzero__(arg0);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyInt_FromLong((long)result);
    return resultobj;
}


static PyObject *_wrap_delete_PiecewiseFlatForwardHandle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PiecewiseFlatForwardHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_PiecewiseFlatForwardHandle",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PiecewiseFlatForwardHandle,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


PiecewiseFlatForwardHandle * new_PiecewiseFlatForwardHandle(Currency currency,DayCounter dayCounter,Date todaysDate,Calendar calendar,int settlementDays,RateHelperHandleVector instruments,double accuracy) {
    {
        return new PiecewiseFlatForwardHandle(
        new PiecewiseFlatForward(currency, dayCounter,
        todaysDate, calendar, settlementDays,
        instruments, accuracy));
    }
}


static PyObject *_wrap_new_PiecewiseFlatForward(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    Currency *arg0 ;
    DayCounter *arg1 ;
    Date *arg2 ;
    Calendar *arg3 ;
    int arg4 ;
    RateHelperHandleVector *arg5 ;
    double arg6 ;
    Currency temp ;
    PyObject * obj0  = 0 ;
    PyObject * argo1 =0 ;
    Date temp0 ;
    PyObject * obj2  = 0 ;
    PyObject * argo3 =0 ;
    RateHelperHandleVector temp1 ;
    PyObject * obj5  = 0 ;
    char *kwnames[] = {
        "currency","dayCounter","todaysDate","calendar","settlementDays","instruments","accuracy", NULL 
    };
    PiecewiseFlatForwardHandle *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOOOiOd:new_PiecewiseFlatForward",kwnames,&obj0,&argo1,&obj2,&argo3,&arg4,&obj5,&arg6)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toUppercase(s);
            if (s == "EUR")      temp = EUR;
            else if (s == "USD") temp = USD;
            else if (s == "GBP") temp = GBP;
            else if (s == "DEM") temp = DEM;
            else if (s == "ITL") temp = ITL;
            else if (s == "CHF") temp = CHF;
            else if (s == "AUD") temp = AUD;
            else if (s == "CAD") temp = CAD;
            else if (s == "DKK") temp = DKK;
            else if (s == "JPY") temp = JPY;
            else if (s == "PLZ") temp = PLZ;
            else if (s == "SEK") temp = SEK;
            else if (s == "CZK") temp = CZK;
            else if (s == "EEK") temp = EEK;
            else if (s == "ISK") temp = ISK;
            else if (s == "NOK") temp = NOK;
            else if (s == "SKK") temp = SKK;
            else if (s == "HKD") temp = HKD;
            else if (s == "NZD") temp = NZD;
            else if (s == "SGD") temp = SGD;
            else if (s == "GRD") temp = GRD;
            else if (s == "HUF") temp = HUF;
            else if (s == "LVL") temp = LVL;
            else if (s == "ROL") temp = ROL;
            else if (s == "BGL") temp = BGL;
            else if (s == "CYP") temp = CYP;
            else if (s == "LTL") temp = LTL;
            else if (s == "MTL") temp = MTL;
            else if (s == "TRL") temp = TRL;
            else if (s == "ZAR") temp = ZAR;
            else if (s == "SIT") temp = SIT;
            else if (s == "KRW") temp = KRW;
            else {
                PyErr_SetString(PyExc_TypeError,"not a currency");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a currency");
            return NULL;
        }
        arg0 = &temp;
    }
    if ((SWIG_ConvertPtr(argo1,(void **) &arg1,SWIGTYPE_p_DayCounter,1)) == -1) return NULL;
    {
        Date* x;
        if (obj2 == Py_None) {
            temp0 = Date();
            arg2 = &temp0;
        }else if ((SWIG_ConvertPtr(obj2,(void **) &x,
        SWIGTYPE_p_Date,0)) != -1) {
            arg2 = x;
        }else {
            PyErr_SetString(PyExc_TypeError,"Date" " expected");
            return NULL;
        }
    }
    if ((SWIG_ConvertPtr(argo3,(void **) &arg3,SWIGTYPE_p_Calendar,1)) == -1) return NULL;
    {
        RateHelperHandleVector* v;
        if (PyTuple_Check(obj5) || PyList_Check(obj5)) {
            /* Size */ int size = (PyTuple_Check(obj5) ?
            PyTuple_Size(obj5) :
            PyList_Size(obj5));
            temp1 = RateHelperHandleVector(size);
            arg5 = &temp1;
            for (/* Size */ int i=0; i<size; i++) {
                RateHelperHandle* x;
                PyObject* o = PySequence_GetItem(obj5,i);
                if ((SWIG_ConvertPtr(o,(void **) &x,
                SWIGTYPE_p_RateHelperHandle,0)) != -1) {
                    (*arg5)[i] = *x;
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"RateHelper" "s expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj5,(void **) &v,
        SWIGTYPE_p_RateHelperHandleVector,0)) != -1) {
            arg5 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"RateHelperVector" " expected");
            return NULL;
        }
    }
    {
        try {
            result = (PiecewiseFlatForwardHandle *)new_PiecewiseFlatForwardHandle(*arg0,*arg1,*arg2,*arg3,arg4,*arg5,arg6);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_PiecewiseFlatForwardHandle);
    return resultobj;
}


DateVector const &PiecewiseFlatForwardHandle_dates(PiecewiseFlatForwardHandle *self) {
    {
        return (*self)->dates();
    }
}


static PyObject *_wrap_PiecewiseFlatForward_dates(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PiecewiseFlatForwardHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    DateVector *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:PiecewiseFlatForward_dates",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PiecewiseFlatForwardHandle,1)) == -1) return NULL;
    {
        try {
            DateVector const &_result_ref = PiecewiseFlatForwardHandle_dates(arg0);
            result = (DateVector *) &_result_ref;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DateVector);
    return resultobj;
}


DoubleVector const &PiecewiseFlatForwardHandle_times(PiecewiseFlatForwardHandle *self) {
    {
        return (*self)->times();
    }
}


static PyObject *_wrap_PiecewiseFlatForward_times(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    PiecewiseFlatForwardHandle *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    DoubleVector *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:PiecewiseFlatForward_times",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_PiecewiseFlatForwardHandle,1)) == -1) return NULL;
    {
        try {
            DoubleVector const &_result_ref = PiecewiseFlatForwardHandle_times(arg0);
            result = (DoubleVector *) &_result_ref;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DoubleVector);
    return resultobj;
}


static PyObject *_wrap_new_EuropeanOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    double arg2 ;
    Spread arg3 ;
    Rate arg4 ;
    Time arg5 ;
    double arg6 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "type","underlying","strike","dividendYield","riskFreeRate","residualTime","volatility", NULL 
    };
    EuropeanOption *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Odddddd:new_EuropeanOption",kwnames,&obj0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        try {
            result = (EuropeanOption *)new EuropeanOption(*arg0,arg1,arg2,arg3,arg4,arg5,arg6);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_EuropeanOption);
    return resultobj;
}


static PyObject *_wrap_delete_EuropeanOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    EuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_EuropeanOption",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EuropeanOption,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_EuropeanOption_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    EuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:EuropeanOption_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_EuropeanOption_delta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    EuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:EuropeanOption_delta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->delta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_EuropeanOption_gamma(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    EuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:EuropeanOption_gamma",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->gamma();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_EuropeanOption_theta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    EuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:EuropeanOption_theta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->theta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_EuropeanOption_vega(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    EuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:EuropeanOption_vega",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->vega();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_EuropeanOption_rho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    EuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:EuropeanOption_rho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->rho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_EuropeanOption_dividendRho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    EuropeanOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:EuropeanOption_dividendRho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->dividendRho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_EuropeanOption_impliedVolatility(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    EuropeanOption *arg0 ;
    double arg1 ;
    double arg2 = 1e-4 ;
    int arg3 = 100 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","targetValue","accuracy","maxEvaluations", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|di:EuropeanOption_impliedVolatility",kwnames,&argo0,&arg1,&arg2,&arg3)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_EuropeanOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->impliedVolatility(arg1,arg2,arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_CliquetOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    Spread arg2 ;
    Rate arg3 ;
    DoubleVector *arg4 ;
    double arg5 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    DoubleVector temp0 ;
    PyObject * obj4  = 0 ;
    char *kwnames[] = {
        "type","underlying","dividendYield","riskFreeRate","dates","volatility", NULL 
    };
    CliquetOption *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OdddOd:new_CliquetOption",kwnames,&obj0,&arg1,&arg2,&arg3,&obj4,&arg5)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj4) || PyList_Check(obj4)) {
            /* Size */ int size = (PyTuple_Check(obj4) ?
            PyTuple_Size(obj4) :
            PyList_Size(obj4));
            temp0 = DoubleVector(size);
            arg4 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj4,i);
                if (o == Py_None) {
                    (*arg4)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg4)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg4)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj4,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg4 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (CliquetOption *)new CliquetOption(*arg0,arg1,arg2,arg3,(DoubleVector const &)*arg4,arg5);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_CliquetOption);
    return resultobj;
}


static PyObject *_wrap_delete_CliquetOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CliquetOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_CliquetOption",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CliquetOption,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_CliquetOption_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CliquetOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:CliquetOption_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CliquetOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_CliquetOption_delta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CliquetOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:CliquetOption_delta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CliquetOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->delta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_CliquetOption_gamma(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CliquetOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:CliquetOption_gamma",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CliquetOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->gamma();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_CliquetOption_theta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CliquetOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:CliquetOption_theta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CliquetOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->theta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_CliquetOption_vega(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CliquetOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:CliquetOption_vega",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CliquetOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->vega();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_CliquetOption_rho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CliquetOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:CliquetOption_rho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CliquetOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->rho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_CliquetOption_dividendRho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CliquetOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:CliquetOption_dividendRho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CliquetOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->dividendRho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_CliquetOption_impliedVolatility(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    CliquetOption *arg0 ;
    double arg1 ;
    double arg2 = 1e-4 ;
    int arg3 = 100 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","targetValue","accuracy","maxEvaluations", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|di:CliquetOption_impliedVolatility",kwnames,&argo0,&arg1,&arg2,&arg3)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_CliquetOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->impliedVolatility(arg1,arg2,arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_BinaryOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    double arg2 ;
    Spread arg3 ;
    Rate arg4 ;
    Time arg5 ;
    double arg6 ;
    double arg7 = 1 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "type","underlying","strike","dividendYield","riskFreeRate","residualTime","volatility","cashPayoff", NULL 
    };
    BinaryOption *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Odddddd|d:new_BinaryOption",kwnames,&obj0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6,&arg7)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        try {
            result = (BinaryOption *)new BinaryOption(*arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_BinaryOption);
    return resultobj;
}


static PyObject *_wrap_delete_BinaryOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BinaryOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_BinaryOption",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BinaryOption,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_BinaryOption_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BinaryOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BinaryOption_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BinaryOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_BinaryOption_delta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BinaryOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BinaryOption_delta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BinaryOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->delta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_BinaryOption_gamma(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BinaryOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BinaryOption_gamma",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BinaryOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->gamma();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_BinaryOption_theta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BinaryOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BinaryOption_theta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BinaryOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->theta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_BinaryOption_vega(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BinaryOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BinaryOption_vega",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BinaryOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->vega();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_BinaryOption_rho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BinaryOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BinaryOption_rho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BinaryOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->rho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_BinaryOption_dividendRho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BinaryOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BinaryOption_dividendRho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BinaryOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->dividendRho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_BinaryOption_impliedVolatility(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BinaryOption *arg0 ;
    double arg1 ;
    double arg2 = 1e-4 ;
    int arg3 = 100 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self","targetValue","accuracy","maxEvaluations", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Od|di:BinaryOption_impliedVolatility",kwnames,&argo0,&arg1,&arg2,&arg3)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BinaryOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->impliedVolatility(arg1,arg2,arg3);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_BarrierOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BarrierType *arg0 ;
    OptionType *arg1 ;
    double arg2 ;
    double arg3 ;
    Spread arg4 ;
    Rate arg5 ;
    Time arg6 ;
    double arg7 ;
    double arg8 ;
    double arg9 = 0.0 ;
    PyObject * obj0  = 0 ;
    OptionType temp ;
    PyObject * obj1  = 0 ;
    char *kwnames[] = {
        "barrType","type","underlying","strike","dividendYield","riskFreeRate","residualTime","volatility","barrier","rebate", NULL 
    };
    BarrierOption *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OOddddddd|d:new_BarrierOption",kwnames,&obj0,&obj1,&arg2,&arg3,&arg4,&arg5,&arg6,&arg7,&arg8,&arg9)) return NULL;
    {
        if (PyString_Check(obj0)) {
            arg0 = new BarrierType;
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "downin")			*(arg0) = BarrierOption::DownIn;
            else if (s == "downout")	*(arg0) = BarrierOption::DownOut;
            else if (s == "upin")		*(arg0) = BarrierOption::UpIn;
            else if (s == "upout")		*(arg0) = BarrierOption::UpOut;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown barrier type");
                delete arg0;
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not a barrier type");
            return NULL;
        }
    }
    {
        if (PyString_Check(obj1)) {
            std::string s(PyString_AsString(obj1));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg1 = &temp;
    }
    {
        try {
            result = (BarrierOption *)new BarrierOption(*arg0,*arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_BarrierOption);
    {
        delete arg0;
    }
    return resultobj;
}


static PyObject *_wrap_delete_BarrierOption(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BarrierOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_BarrierOption",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BarrierOption,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_BarrierOption_delta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BarrierOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BarrierOption_delta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BarrierOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->delta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_BarrierOption_gamma(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BarrierOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BarrierOption_gamma",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BarrierOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->gamma();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_BarrierOption_theta(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BarrierOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BarrierOption_theta",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BarrierOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->theta();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_BarrierOption_vega(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BarrierOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BarrierOption_vega",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BarrierOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->vega();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_BarrierOption_rho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BarrierOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BarrierOption_rho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BarrierOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->rho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_BarrierOption_dividendRho(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BarrierOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BarrierOption_dividendRho",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BarrierOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->dividendRho();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_BarrierOption_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    BarrierOption *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:BarrierOption_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_BarrierOption,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_ContinuousGeometricAPO(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    double arg2 ;
    Spread arg3 ;
    Rate arg4 ;
    double arg5 ;
    double arg6 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    char *kwnames[] = {
        "type","underlying","strike","dividendYield","riskFreeRate","residualTime","volatility", NULL 
    };
    ContinuousGeometricAPO *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"Odddddd:new_ContinuousGeometricAPO",kwnames,&obj0,&arg1,&arg2,&arg3,&arg4,&arg5,&arg6)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        try {
            result = (ContinuousGeometricAPO *)new ContinuousGeometricAPO(*arg0,arg1,arg2,arg3,arg4,arg5,arg6);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_ContinuousGeometricAPO);
    return resultobj;
}


static PyObject *_wrap_delete_ContinuousGeometricAPO(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    ContinuousGeometricAPO *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_ContinuousGeometricAPO",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_ContinuousGeometricAPO,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_ContinuousGeometricAPO_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    ContinuousGeometricAPO *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:ContinuousGeometricAPO_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_ContinuousGeometricAPO,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_DiscreteGeometricAPO(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    double arg2 ;
    Spread arg3 ;
    Rate arg4 ;
    DoubleVector *arg5 ;
    double arg6 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    DoubleVector temp0 ;
    PyObject * obj5  = 0 ;
    char *kwnames[] = {
        "type","underlying","strike","dividendYield","riskFreeRate","timeDelays","volatility", NULL 
    };
    DiscreteGeometricAPO *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OddddOd:new_DiscreteGeometricAPO",kwnames,&obj0,&arg1,&arg2,&arg3,&arg4,&obj5,&arg6)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj5) || PyList_Check(obj5)) {
            /* Size */ int size = (PyTuple_Check(obj5) ?
            PyTuple_Size(obj5) :
            PyList_Size(obj5));
            temp0 = DoubleVector(size);
            arg5 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj5,i);
                if (o == Py_None) {
                    (*arg5)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg5)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg5)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj5,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg5 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (DiscreteGeometricAPO *)new DiscreteGeometricAPO(*arg0,arg1,arg2,arg3,arg4,(DoubleVector const &)*arg5,arg6);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DiscreteGeometricAPO);
    return resultobj;
}


static PyObject *_wrap_delete_DiscreteGeometricAPO(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DiscreteGeometricAPO *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_DiscreteGeometricAPO",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DiscreteGeometricAPO,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_DiscreteGeometricAPO_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DiscreteGeometricAPO *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    double result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:DiscreteGeometricAPO_value",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DiscreteGeometricAPO,1)) == -1) return NULL;
    {
        try {
            result = (double )arg0->value();
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = PyFloat_FromDouble(result);
    return resultobj;
}


static PyObject *_wrap_new_DiscreteGeometricASO(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    OptionType *arg0 ;
    double arg1 ;
    Spread arg2 ;
    Rate arg3 ;
    DoubleVector *arg4 ;
    double arg5 ;
    OptionType temp ;
    PyObject * obj0  = 0 ;
    DoubleVector temp0 ;
    PyObject * obj4  = 0 ;
    char *kwnames[] = {
        "type","underlying","dividendYield","riskFreeRate","timeDelays","volatility", NULL 
    };
    DiscreteGeometricASO *result ;
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"OdddOd:new_DiscreteGeometricASO",kwnames,&obj0,&arg1,&arg2,&arg3,&obj4,&arg5)) return NULL;
    {
        if (PyString_Check(obj0)) {
            std::string s(PyString_AsString(obj0));
            s = StringFormatter::toLowercase(s);
            if (s == "c" || s == "call")          temp = Option::Call;
            else if (s == "p" || s == "put")      temp = Option::Put;
            else if (s == "s" || s == "straddle") temp = Option::Straddle;
            else {
                PyErr_SetString(PyExc_TypeError,"unknown option type");
                return NULL;
            }
        }else {
            PyErr_SetString(PyExc_TypeError,"not an option type");
            return NULL;
        }
        arg0 = &temp;
    }
    {
        DoubleVector* v;
        if (PyTuple_Check(obj4) || PyList_Check(obj4)) {
            /* Size */ int size = (PyTuple_Check(obj4) ?
            PyTuple_Size(obj4) :
            PyList_Size(obj4));
            temp0 = DoubleVector(size);
            arg4 = &temp0;
            for (/* Size */ int i=0; i<size; i++) {
                PyObject* o = PySequence_GetItem(obj4,i);
                if (o == Py_None) {
                    (*arg4)[i] = Null<double>();
                    Py_DECREF(o);
                }else if (PyFloat_Check(o)) {
                    (*arg4)[i] = PyFloat_AsDouble(o);
                    Py_DECREF(o);
                }else if (PyInt_Check(o)) {
                    (*arg4)[i] = double(PyInt_AsLong(o));
                    Py_DECREF(o);
                }else {
                    PyErr_SetString(PyExc_TypeError,"doubles expected");
                    Py_DECREF(o);
                    return NULL;
                }
            }
        }else if ((SWIG_ConvertPtr(obj4,(void **) &v,
        SWIGTYPE_p_DoubleVector,0)) != -1) {
            arg4 = v;
        }else {
            PyErr_SetString(PyExc_TypeError,"DoubleVector expected");
            return NULL;
        }
    }
    {
        try {
            result = (DiscreteGeometricASO *)new DiscreteGeometricASO(*arg0,arg1,arg2,arg3,(DoubleVector const &)*arg4,arg5);
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }resultobj = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DiscreteGeometricASO);
    return resultobj;
}


static PyObject *_wrap_delete_DiscreteGeometricASO(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject *resultobj;
    DiscreteGeometricASO *arg0 ;
    PyObject * argo0 =0 ;
    char *kwnames[] = {
        "self", NULL 
    };
    
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,(char *)"O:delete_DiscreteGeometricASO",kwnames,&argo0)) return NULL;
    if ((SWIG_ConvertPtr(argo0,(void **) &arg0,SWIGTYPE_p_DiscreteGeometricASO,1)) == -1) return NULL;
    {
        try {
            delete arg0;
            
        }catch (IndexError& e) {
            PyErr_SetString(PyExc_IndexError,e.what());
            return NULL;
        }catch (Error& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (std::exception& e) {
            PyErr_SetString(PyExc_Exception,e.what());
            return NULL;
        }catch (...) {
            PyErr_SetString(PyExc_Exception,"unknown error");
            return NULL;
        }
    }Py_INCREF(Py_None);
    resultobj = Py_None;
    return resultobj;
}


static PyObject *_wrap_DiscreteGeometricASO_value(PyObject *self, PyObject *args, PyObject *kwargs) {