#
# Copyright (c) 2003 Art Haas
#
# This file is part of PythonCAD.
#
# PythonCAD is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# PythonCAD is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PythonCAD; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# This code handles interpreting entries in the gtkimage.entry box
# and calling the apprpriate internal command
#
# Author: David Broadwell ( dbroadwell@mindspring.com, 05/26/2003 )
#

''' defines the internal maping for a human name like circle() to
    an internal function, so that the config file can look all
    clean and pretty. AKA: evalkey interface Release 5/25/03 '''

''' 05/29/03 R2c Complete redesign, no longer does the internal name
    need to be a function, dropped prompt.py filesize from 9.8 to
    5.3Kb! cleaned up the feywords file, no appreciable difference
    Used a dictionary instead of discreet functions for every entry
    and for R3, menus. '''

def bouncer(text): # deprecated
    """import redirector, no appending Generic.prompt.??? to everything

depreciated interface for pre r2c, will be removed in r3
    """
    return lookup(text)

def lookup(text):
    """Interface to promptdef dictionary, returns code by keyword definition

lookup(text)    
    """
    assert text in promptdefs, "No command for %s" % str(text)
    return promptdefs[text]

promptdefs = {
    'pcline' : "gtkmenus.draw_perpendicular_cline('draw_perpendicular_cline',gtkimage)",
    'tcline' : "gtkmenus.draw_tangent_cline('draw_tangent_cline',gtkimage)",
    'hcline' : "gtkmenus.draw_hcl_cb('draw_hcl',gtkimage)",
    'vcline' : "gtkmenus.draw_vcl_cb('draw_vcl',gtkimage)",
    'acline' : "gtkmenus.draw_acl_cb('draw_acl',gtkimage)",
    'cl' : "gtkmenus.draw_cl_cb('draw_cl',gtkimage)",
    'point' : "gtkmenus.draw_point_cb('draw_point',gtkimage)",
    'segment' : "gtkmenus.draw_segment_cb('draw_segment',gtkimage)",
    'circen' : "gtkmenus.draw_circle_center_cb('draw_circle_center',gtkimage)",
    'cir2p' : "gtkmenus.draw_circle_tp_cb('draw_circle_tp',gtkimage)",
    'ccircen' : "gtkmenus.draw_ccirc_cp_cb('draw_ccirc_cp',gtkimage)",
    'ccir2p' : "gtkmenus.draw_ccirc_tp_cb('draw_ccirc_tp',gtkimage)",
    'arcc' : "gtkmenus.draw_arc_center_cb('draw_arc_center',gtkimage)",
    'rect' : "gtkmenus.draw_rectangle_cb('draw_rectangle',gtkimage)",
    'leader' : "gtkmenus.draw_leader_cb('draw_leader',gtkimage)",
    'polyline' : "gtkmenus.draw_polyline_cb('draw_polyline',gtkimage)",
    'text' : "gtkmenus.draw_text_cb('draw_text',gtkimage)",
    'transfer' : "gtkmenus.transfer_object_cb('transfer',gtkimage)",
    'split' : "gtkmenus.split_object_cb('split',gtkimage)",
    'mirror' : "gtkmenus.mirror_object_cb('mirror',gtkimage)",
    'delete' : "gtkmenus.delete_cb('delete',gtkimage)",
    'moveh' : "gtkmenus.move_horizontal_cb('move_horiz',gtkimage)",
    'movev' : "gtkmenus.move_vertical_cb('stretch_vert',gtkimage)",
    'move' : "gtkmenus.move_twopoint_cb('move_twopoint',gtkimage)",
    'chamfer' : "gtkmenus.draw_chamfer_cb('draw_chamfer',gtkimage)",
    'fillet' : "gtkmenus.draw_fillet_cb('draw_fillet',gtkimage)",
    'strh' : "gtkmenus.stretch_horiz_cb('stretch_horiz',gtkimage)",
    'strv' : "gtkmenus.stretch_vert_cb('stretch_vert',gtkimage)",
    'str' : "gtkmenus.stretch_twopoint_cb('stretch_twopoint',gtkimage)",
    'close' : "gtkmenus.file_close_cb('file_close',gtkimage)",
    'quit' : "gtkmenus.file_quit_cb('file_quit',gtkimage)",
    'new' : "gtkmenus.file_new_cb('file_new',gtkimage)",
    'opend' : "gtkmenus.file_open_cb('file_open',gtkimage)",
    'saves' : "gtkmenus.file_save_cb('file_save',gtkimage)",
    'saveas' : "gtkmenus.file_save_as_cb('file_save_as',gtkimage)",
    'savel' : "gtkmenus.file_save_layer_cb('file_save_layer',gtkimage)",
    'cut' : "gtkmenus.edit_cut_cb('edit_cut',gtkimage)",
    'copy' : "gtkmenus.edit_copy_cb('edit_copy',gtkimage)",
    'paste' : "gtkmenus.edit_paste_cb('edit_paste',gtkimage)",
    'saa' : "gtkmenus.select_all_arcs_cb('select_all_arcs',gtkimage)",
    'sac' : "gtkmenus.select_all_circles_cb('select_all_circles',gtkimage)",
    'sacc' : "gtkmenus.select_all_ccircles_cb('select_all_ccircles',gtkimage)",
    'sacl' : "gtkmenus.select_all_clines_cb('select_all_clines',gtkimage)",
    'sahcl' : "gtkmenus.select_all_hclines_cb('select_all_hclines',gtkimage)",
    'savcl' : "gtkmenus.select_all_vclines_cb('select_all_vclines',gtkimage)",
    'saacl' : "gtkmenus.select_all_aclines_cb('select_all_aclines',gtkimage)",
    'sap' : "gtkmenus.select_all_points_cb('select_all_points',gtkimage)",
    'sas' : "gtkmenus.select_all_segments_cb('select_all_segments',gtkimage)",
    'redraw' : "gtkimage.redraw()",
    'refresh' : "gtkimage.refresh()",
    'pref' : "gtkmenus.prefs_cb('prefs',gtkimage)",
    'dimpref' : "gtkmenus.dimension_prefs_cb('dimension_prefs',gtkimage)",
    'zoomd' : "gtkmenus.zoom_cb('zoom',gtkimage)",
    'zoomi' : "gtkmenus.zoom_in_cb('zoom_in',gtkimage)",
    'zoomo' : "gtkmenus.zoom_out_cb('zoom_out',gtkimage)",
    'zoomf' : "gtkmenus.zoom_fit_cb('zoom_fit',gtkimage)"
}
