# This is the sub-class of the PizzaEntry dialog class where the new
# sendOrder() slot is implemented.


from qt import QMessageBox, QDate
from pizza import PizzaEntry


class PizzaEntryImpl(PizzaEntry):
    def __init__(self,parent=None,name=None,modal=0,f=0):
        PizzaEntry.__init__(self,parent,name,modal,f)
        
        date = QDate.currentDate()
        if date.dayOfWeek() == 1:
            self.CheckBox5.setChecked(1)
        else:
            self.CheckBox5.setChecked(0)

    def sendOrder(self):
        QMessageBox.information(self,'Pizza Entry Information',
            'Your order has been sent. Your pizza will arrive in 30-45 minutes',
            QMessageBox.Ok)