#!/usr/bin/env python


import sys
from qt import QApplication


if __name__ == '__main__':
    app = QApplication(sys.argv)

    # We can only import these after creating the QApplication because they
    # make Qt calls that need the QApplication to exist.
    from DebugServer import DebugServer
    from UserInterface import UserInterface

    # Use the program on the command line if one was given.
    try:
        prog = sys.argv[1]
    except:
        prog = None

    dbs = DebugServer()
    mw = UserInterface(dbs,prog)
    app.setMainWidget(mw)
    mw.show()

    app.exec_loop()
