dnl Copyright (c) 1999 - 2001 Phil Thompson <phil@river-bank.demon.co.uk>

dnl A suite of configuration macros used by SIP generated packages.


dnl Get the destination of the documentation a particular package.  $1 is the
dnl name of the package.  Set SIP_DOCINSTALLDIR appropriately.

AC_DEFUN(SIP_GET_DOCINSTALLDIR,
[
	AC_ARG_WITH(doc-install,
		[  --with-doc-install=DIR  install documentation in DIR [PREFIX/doc/$1]])

	if test "X$with_doc_install" = "X"
	then
		SIP_DOCINSTALLDIR=$prefix/doc/$1
	else
		SIP_DOCINSTALLDIR=$with_doc_install
	fi

	AC_SUBST(SIP_DOCINSTALLDIR)
])


dnl Get the destination of the .sip files for a particular package.  $1 is the
dnl name of the package.  Set SIP_SIPINSTALLDIR appropriately.

AC_DEFUN(SIP_GET_SIPINSTALLDIR,
[
	AC_ARG_WITH(sip-install,
		[  --with-sip-install=DIR  install .sip's in DIR [DATADIR/sip/$1]])

	if test "X$with_sip_install" = "X"
	then
		SIP_SIPINSTALLDIR=$datadir/sip/$1
	else
		SIP_SIPINSTALLDIR=$with_sip_install
	fi

	AC_SUBST(SIP_SIPINSTALLDIR)
])


dnl Find a file and stop if it can't be found.  $1 is the name of the file.  $2
dnl is the list of directories to try.  $3 is the name of a variable that will
dnl be set to the directory the file was found in.

AC_DEFUN(SIP_FIND_FILE,
[
	AC_MSG_CHECKING([for $1])

	dir=

	for d in $2
	do
		if test -r $d/$1
		then
			dir=$d
			break
		fi
	done

	if test "X$dir" = "X"
	then
		AC_MSG_ERROR([not found])
	fi

	AC_MSG_RESULT($dir)

	$3=$dir
])


dnl Find a header file and stop if it can't be found.  $1 is the name of the
dnl header file.  $2 is the list of directories to try.  Update SIP_CPPFLAGS
dnl appropriately.

AC_DEFUN(SIP_FIND_HEADER,
[
	SIP_FIND_FILE($1,$2,incdir)

	dnl Add to the list of flags if needed.

	if test ! "$incdir" = "/usr/include"
	then
		incflag="-I$incdir"

		for d in $SIP_CPPFLAGS
		do
			if test "$d" = "$incflag"
			then
				incflag=
				break
			fi
		done

		SIP_CPPFLAGS="$SIP_CPPFLAGS $incflag"
	fi
])


dnl Find a library and stop if it can't be found.  $1 is the name of the
dnl library.  $2 is the list of directories to try.  Update SIP_LDLIBDIRS
dnl appropriately.

AC_DEFUN(SIP_FIND_LIBRARY,
[
	AC_MSG_CHECKING([for -l$1])

	libdir=

	for d in $2
	do
		ls $d/lib$1* 2>/dev/null >/dev/null

		if test $? = 0
		then
			libdir=$d
			break
		fi
	done

	if test "X$libdir" = "X"
	then
		AC_MSG_ERROR([not found])
	fi

	AC_MSG_RESULT($libdir)

	dnl Add to the list of flags if needed.

	if test "$libdir" = "/usr/lib"
	then
		libflag=
	else
		libflag="-L$libdir"

		for d in $SIP_LDLIBDIRS
		do
			if test "$d" = "$libflag"
			then
				libflag=
				break
			fi
		done
	fi

	SIP_LDLIBDIRS="$SIP_LDLIBDIRS $libflag"
])


dnl Check if the version of Qt is a particular version or later.  $1 is the
dnl version to check.  $2 is the name of a variable to set if the check was
dnl successful.

AC_DEFUN(SIP_CHECK_QT_VERSION,
[
	AC_MSG_CHECKING([for Qt version >= $1])
	AC_LANG_SAVE
	AC_LANG_CPLUSPLUS

	save_CPPFLAGS="$CPPFLAGS"
	CPPFLAGS="$SIP_CPPFLAGS"

	AC_EGREP_CPP(yes,[
#include <qglobal.h>

#if QT_VERSION >= $1
	yes
#endif
	], check=yes,
	   check=no)
 
	CPPFLAGS="$save_CPPFLAGS"
	AC_LANG_RESTORE

	AC_MSG_RESULT($check)

	$2=$check
])


dnl Check if the version of Qt is in a particular range of versions.  $1 is the
dnl minimum version to check.  $2 is the maximum version to check.

AC_DEFUN(SIP_CHECK_QT_VERSION_RANGE,
[
	AC_MSG_CHECKING([for Qt version >= $1 and < $2])
	AC_LANG_SAVE
	AC_LANG_CPLUSPLUS

	save_CPPFLAGS="$CPPFLAGS"
	CPPFLAGS="$SIP_CPPFLAGS"

	AC_EGREP_CPP(yes,[
#include <qglobal.h>

#if QT_VERSION >= $1 && QT_VERSION < $2
	yes
#endif
	], check=yes,
	   check=no)
 
	CPPFLAGS="$save_CPPFLAGS"
	AC_LANG_RESTORE

	if test ! "$check" = "yes"
	then
		AC_MSG_ERROR("incompatible Qt version")
	fi

	AC_MSG_RESULT($check)
])


dnl Set the variables needed by any SIP generated module.  Update
dnl SIP_PYTHONMODULES, SIP_CPPFLAGS, SIP_CXXFLAGS and SIP_LDLIBDIRS
dnl appropriately.

AC_DEFUN(SIP_SET_COMMONFLAGS,
[
	SIP_CPPFLAGS=
	SIP_CXXFLAGS=
	SIP_LDLIBDIRS=

	dnl Strip -g from CXXFLAGS.

	AC_ARG_WITH(debug,
		[  --with-debug            don't remove -g from CXXFLAGS])

	if test "X$with_debug" = "X"
	then
		save_CXXFLAGS="$CXXFLAGS"
		CXXFLAGS=

		for f in $save_CXXFLAGS
		do
			if test ! "$f" = "-g"
			then
				CXXFLAGS="$CXXFLAGS $f"
			fi
		done
	fi

	dnl See if we can disable exceptions.  It isn't enough just to try and
	dnl compile as some platforms only complain about an unknown option at
	dnl link time.

	AC_MSG_CHECKING([for -fno-exceptions])
	AC_LANG_SAVE
	AC_LANG_CPLUSPLUS

	save_CXXFLAGS="$CXXFLAGS"
	CXXFLAGS="$CXXFLAGS -fno-exceptions"
 
	AC_TRY_LINK([],[
        	int i;
	], works=yes,
	   works=no)
 
	CXXFLAGS="$save_CXXFLAGS"
	AC_LANG_RESTORE

	AC_MSG_RESULT($works)
 
	if test $works = "yes"
	then
        	SIP_CXXFLAGS="-fno-exceptions"
	fi

	dnl Find Python.
 
	AC_ARG_WITH(python,
		[  --with-python=File      Python executable is in FILE])

	if test "X$with_python" = "X"
	then
		AC_PATH_PROG(PYTHONINTERP,python)
 
		if test "X$PYTHONINTERP" = "X"
		then
			AC_MSG_ERROR("Unable to find a Python interpreter")
		fi
	else
		PYTHONINTERP=$with_python
	fi
 
 
	dnl Find the different bits of Python.
 
	pyprefix=`$PYTHONINTERP -c 'import sys; print sys.prefix'`
	pyversion=`$PYTHONINTERP -c 'import sys; print sys.version'`
	pyversion=`echo $pyversion | cut -c -3`

	dnl Make sure the user knows what version we have found.
 
	AC_MSG_CHECKING([Python version])
	AC_MSG_RESULT($pyversion)

	dnl Find the Python headers.

	SIP_FIND_HEADER(Python.h,$pyprefix/include/python$pyversion)

	dnl Find the where to install Python modules.

	SIP_FIND_FILE(lib-dynload,$pyprefix/lib/python$pyversion,SIP_PYTHONMODULES)

	dnl Use site-packages in preference if it is there.

	if test -d $SIP_PYTHONMODULES/site-packages
	then
		SIP_PYTHONMODULES=$SIP_PYTHONMODULES/site-packages
		SIP_PYTHONDLMODULES=$SIP_PYTHONMODULES
	else
		SIP_PYTHONDLMODULES=$SIP_PYTHONMODULES/lib-dynload
	fi

	AC_SUBST(SIP_PYTHONMODULES)
	AC_SUBST(SIP_PYTHONDLMODULES)

	dnl Find the SIP headers.

	AC_ARG_WITH(sip-includes,
		[  --with-sip-includes=DIR SIP include files are in DIR])

	if test "X$with_sip_includes" = "X"
	then
		incdirs="/opt/sip/include/sip /usr/local/include/sip /usr/include/sip /usr/local/include /usr/include /usr/local/sip/include/sip /usr/sip/include/sip"
	else
		incdirs=$with_sip_includes
	fi

	SIP_FIND_HEADER(sip.h,$incdirs)

	dnl Find the SIP library.

	AC_ARG_WITH(sip-libraries,
		[  --with-sip-libraries=DIR  SIP library is in DIR])

	if test "X$with_sip_libraries" = "X"
	then
		libdirs="/opt/sip/lib /usr/local/lib /usr/lib /usr/local/sip/lib /usr/sip/lib"
	else
		libdirs=$with_sip_libraries
	fi

	SIP_FIND_LIBRARY(sip,$libdirs)

	AC_SUBST(SIP_CPPFLAGS)
	AC_SUBST(SIP_CXXFLAGS)
	AC_SUBST(SIP_LDLIBDIRS)
])


dnl Find moc and add the necessary C pre-processor and ld flags needed for Qt
dnl based modules.  Update SIP_MOC, SIP_CPPFLAGS, SIP_LDLIBDIRS and
dnl SIP_LDXFLAGS appropriately.

AC_DEFUN(SIP_SET_QTFLAGS,
[
	dnl These are in the order they are preferred.

	sip_qt_versions="2.3.1 2.3.0 2.2.4 2.2.3 2.2.2 2.2.1 2.2.0 2.1.1 2.1.0 2.0.2 2.0.1 2.00 1.44"

	sip_qt_base_dirs="/opt/qt /usr/lib/qt /usr/local/qt /usr/qt"
	sip_qt_dirs="/usr/X11R6 /usr /usr/local"

	sip_extra_qt_bin_dirs=
	sip_extra_qt_lib_dirs=
	sip_extra_qt_inc_dirs="/usr/include/qt"

	dnl Build up a list of standard directories to look in.

	for d in $sip_qt_base_dirs
	do
		sip_qt_dirs="$d ${sip_qt_dirs}2 $sip_qt_dirs"

		for v in $sip_qt_versions
		do
			sip_qt_dirs="$d-$v $sip_qt_dirs"
		done
	done

	if test ! "X$QTDIR" = "X"
	then
		dnl At this stage the list is in reverse order.

		sip_qt_dirs="$sip_qt_dirs $QTDIR"
	fi

	dnl Forget it all if a Qt root directory was explicitly given.
 
	AC_ARG_WITH(qt-dir,
		[  --with-qt-dir=DIR       Qt root directory is DIR])

	if test ! "X$with_qt_dir" = "X"
	then
		with_qt_mocdir="$with_qt_dir/bin"
		with_qt_includes="$with_qt_dir/include"
		with_qt_libraries="$with_qt_dir/lib"
	fi

	dnl Find the Qt meta-object compiler.

	AC_ARG_WITH(qt-mocdir,
		[  --with-qt-mocdir=DIR    Qt meta-object compiler is in DIR])

	new_path=

	if test "X$with_qt_mocdir" = "X"
	then
		for d in $sip_extra_qt_bin_dirs
		do
			if test "X$new_path" = "X"
			then
				new_path=$d
			else
				new_path="$new_path:$d"
			fi
		done

		for d in $sip_qt_dirs
		do
			if test "X$new_path" = "X"
			then
				new_path=$d/bin
			else
				new_path="$d/bin:$new_path"
			fi
		done
	else
		new_path=$with_qt_mocdir
	fi

	PATH="$new_path:$PATH"

	AC_PATH_PROG(SIP_MOC,moc)

	dnl Find the Qt headers.

	AC_ARG_WITH(qt-includes,
		[  --with-qt-includes=DIR  Qt include files are in DIR])

	if test "X$with_qt_includes" = "X"
	then
		incdirs=$sip_extra_qt_inc_dirs

		for d in $sip_qt_dirs
		do
			incdirs="$d/include $incdirs"
		done

	else
		incdirs=$with_qt_includes
	fi

	SIP_FIND_HEADER(qobject.h,$incdirs)

	dnl Find the Qt library.

	AC_ARG_WITH(qt-libraries,
		[  --with-qt-libraries=DIR Qt library is in DIR])

	if test "X$with_qt_libraries" = "X"
	then
		libdirs=$sip_extra_qt_lib_dirs

		for d in $sip_qt_dirs
		do
			libdirs="$d/lib $libdirs"
		done
	else
		libdirs=$with_qt_libraries
	fi

	SIP_FIND_LIBRARY(qt,$libdirs)

	dnl Find the X headers and libraries.

	AC_PATH_XTRA

	if test "$no_x" = "yes"
	then
		AC_MSG_ERROR([X11 not found])
	fi

	SIP_CPPFLAGS="$SIP_CPPFLAGS $X_CFLAGS"
	SIP_LDXFLAGS="$X_LIBS $X_PRE_LIBS -lX11 $X_EXTRA_LIBS"

	AC_SUBST(SIP_LDXFLAGS)
])
