#include <orb/interface_repository.h>
#include <Python.h>
#include "CORBAmodule.h"

typedef struct {
	CORBA_unsigned_long len;
	char opname[1];
} OpNameData;

GPtrArray *marshal_call(CORBA_Object obj, GIOPConnection *con,
                        GIOP_unsigned_long req_id,
                        CORBA_OperationDescription *opd, PyObject *args)
{
	OpNameData *ond;
	static struct iovec ovec;
	GIOPSendBuffer *send_buffer = NULL;
	GPtrArray *return_types = g_ptr_array_new();
	CORBA_unsigned_long i = 0, cur = 0;

	ond = (OpNameData *)g_malloc(sizeof(OpNameData) + strlen(opd->name));
	ond->len = strlen(opd->name) + 1;
	strcpy(ond->opname, opd->name);
	ovec.iov_base = (char *)ond;
	ovec.iov_len = sizeof(CORBA_unsigned_long) + ond->len;

	send_buffer = giop_send_request_buffer_use(con, NULL, req_id,
						   CORBA_TRUE, &obj->active_profile->object_key_vec,
						   &ovec, &ORBit_default_principal_iovec);

	if (!send_buffer) {
		// FIXME
		raise_system_exception(OPExc_COMM_FAILURE, 0, CORBA_COMPLETED_NO, NULL);
		goto exception;
	}

	// Now we marshal and stuff the return types into an array for
	// demarshalling.
	if (opd->result->kind != CORBA_tk_void) 
		g_ptr_array_add(return_types, opd->result);

	for (i = 0, cur = 0; i < opd->parameters._length; i++) {
		PyObject *a;
		CORBA_TypeCode tc = opd->parameters._buffer[i].type;
		switch (opd->parameters._buffer[i].mode) {

			case CORBA_PARAM_IN:
				a = PyTuple_GetItem(args, cur);
				if (!marshal_arg(a, send_buffer, tc)) 
					goto exception;
				cur++;
				break;

			case CORBA_PARAM_INOUT:
				a = PyTuple_GetItem(args, cur);
				if (!marshal_arg(a, send_buffer, tc)) 
					goto exception;

			case CORBA_PARAM_OUT:
				g_ptr_array_add(return_types, tc);
				cur++;
				break;
		}
	}
	// still need to handle attribute stuff

#ifndef ORBIT_PYTHON_NOT_THREADED
	Py_BEGIN_ALLOW_THREADS
#endif /* ORBIT_PYTHON_NOT_THREADED */
	giop_send_buffer_write(send_buffer);
#ifndef ORBIT_PYTHON_NOT_THREADED
	Py_END_ALLOW_THREADS
#endif /* ORBIT_PYTHON_NOT_THREADED */

exception:
	giop_send_buffer_unuse(send_buffer);
	g_free(ond);

	return return_types;
}
	
GIOPConnection *demarshal_call(CORBA_Object obj, GIOPConnection *con,
                          GIOP_unsigned_long req_id,
                          CORBA_OperationDescription *opd,
                          PyObject *args,
                          GPtrArray *return_types, PyObject **tuple)
{
	GIOPRecvBuffer *buf;
	CORBA_unsigned_long i;

	buf = giop_recv_reply_buffer_use_2(con, req_id, TRUE);
	if (!buf) {
		raise_system_exception(OPExc_COMM_FAILURE, 0, CORBA_COMPLETED_NO, NULL);
		goto exception;
	}

	// TODO: figure out WTF this does.
	if (buf->message.u.reply.reply_status == GIOP_LOCATION_FORWARD) {
		if (obj->forward_locations != NULL)
			ORBit_delete_profiles(obj->forward_locations);

		obj->forward_locations = ORBit_demarshal_IOR(buf);
		con = ORBit_object_get_forwarded_connection(obj);
		giop_recv_buffer_unuse(buf);
		return con;
	}
	else if (buf->message.u.reply.reply_status != GIOP_NO_EXCEPTION) {
		demarshal_exception(buf, NULL, (CORBA_exception_type)
		                    buf->message.u.reply.reply_status, opd, obj->orb);
		goto exception;
	}
	// We are ready to demarshal now
	*tuple = PyTuple_New(return_types->len);
	for (i = 0; i < return_types->len; i++) {
		CORBA_TypeCode tc = (CORBA_TypeCode)return_types->pdata[i];
		PyObject *o = demarshal_arg(buf, tc, obj->orb);
		if (!o) 
			goto exception;
		PyTuple_SetItem(*tuple, i, o);
	}
	
exception:
//	if (PyErr_Occurred())
//		PyErr_Print();
	giop_recv_buffer_unuse(buf);
	return NULL;	
}
		

PyObject *_stub_func(CORBA_Object obj, PyObject *args,
                     CORBA_OperationDescription *opd)
{
	GIOPConnection *con;
	GIOP_unsigned_long req_id;
	GPtrArray *r = NULL;
	PyObject *tuple = NULL;
	// Figure out how many arguments we need (total args - # OUT args)
	int need_args = opd->parameters._length, i;
	for (i = 0; i < opd->parameters._length; i++)
		if (opd->parameters._buffer[i].mode == CORBA_PARAM_OUT)
			need_args--;
		
	if (PyTuple_Size(args) != need_args) {
		PyErr_Format(PyExc_TypeError, 
		   "function requires %d arguments; %d given", 
		    need_args, PyTuple_Size(args));
		goto bail;
	}

	con = ORBit_object_get_connection(obj);

retry_request:
	req_id = GPOINTER_TO_UINT(alloca(0));
	r = marshal_call(obj, con, req_id, opd, args);

	// Demarshal the results if there are any
	if (opd->mode == CORBA_OP_ONEWAY && r->len)
		d_warning(0, "ONEWAY operation has output parameters!");
	else if (opd->mode != CORBA_OP_ONEWAY && !PyErr_Occurred()) {
		GIOPConnection *newcon;
		newcon  = demarshal_call(obj, con, req_id, opd, args, r, &tuple);
		if (newcon) {
			con = newcon;
			goto retry_request;
		}
	}
	g_ptr_array_free(r, TRUE);
		                      
bail:
	if (PyErr_Occurred())
		return NULL;

	if (!tuple) {
		Py_INCREF(Py_None);
		return Py_None;
	} else if (PyTuple_Size(tuple) == 0) {
		Py_INCREF(Py_None);
		Py_XDECREF(tuple);
		return Py_None;
	} else if (PyTuple_Size(tuple) == 1) {
		// don't return a tuple for just one return value
		PyObject *o = PyTuple_GetItem(tuple, 0);
		Py_INCREF(o);
		// XXX: Calling Py_XDECREF on this tuple causes instability.  But why?!
		// I think I fixed this, but I'll leave this comment here just in case.
		Py_XDECREF(tuple);
		return o;
	}
	return tuple;
}
/*
PyObject *stub_func(CORBA_PyObject *self, PyObject *args)
{
	CORBA_PyObject_Glue *glue;
	PyObject *r;
	CORBA_OperationDescription *opd;
	GSList *lm;
	// pop an item from the last_method stack
	char *last_method = (char *)self->last_method->data;
	lm = self->last_method;
	self->last_method = g_slist_remove_link(self->last_method, 
	                                        self->last_method);
	g_slist_free(lm);
	glue = (CORBA_PyObject_Glue *)g_hash_table_lookup(object_glue,self->repo_id);
	opd = find_operation(glue, last_method);
	g_free(last_method);
	if (!opd) {
		raise_system_exception(OPExc_INTERNAL, 0, CORBA_COMPLETED_NO, NULL);
		return NULL;
	}
	r = _stub_func(self->obj, args, opd);
	return r;

}
*/
PyObject *get_attribute(CORBA_PyInstance_Glue *glue, 
                        CORBA_AttributeDescription *ad)
{
	CORBA_OperationDescription *opd;
	PyObject *args, *result;
	char *method = g_strconcat("_get_", ad->name, NULL);
	
	opd = find_operation(glue->class_glue, method);
	g_free(method);
	if (!opd) {
		printf("opd == NULL\n");
		raise_system_exception(OPExc_INTERNAL, 0, CORBA_COMPLETED_NO, 0, 
		                "Interface %s not registered.", glue->repo_id);
		return NULL;
	}

	// make a dummy tuple of size 0
	args = PyTuple_New(0);
	result = _stub_func(glue->obj, args, opd);
	Py_XDECREF(args);
	if (!result) {
		d_warning(1, "Apparently get attribute failed");
	}
	return result;
}

PyObject *set_attribute(CORBA_PyInstance_Glue *glue, 
                        CORBA_AttributeDescription *ad, PyObject *value)
{
	PyObject *result, *tuple;
	CORBA_OperationDescription *opd;
	char *method = g_strconcat("_set_", ad->name, NULL);

	if (ad->mode == CORBA_ATTR_READONLY) {
		raise_system_exception(OPExc_NO_PERMISSION, 0,
				       CORBA_COMPLETED_NO, "attribute %s readonly",
				       ad->name);
		return 0;
	}
	
	opd = find_operation(glue->class_glue, method);
	g_free(method);
	if (!opd) {
		raise_system_exception(OPExc_INTERNAL, 0, CORBA_COMPLETED_NO, 
		                "Interface %s not registered.", glue->repo_id);
		return 0;
	}
	
	tuple = PyTuple_New(1);
	Py_INCREF(value);
	PyTuple_SetItem(tuple, 0, value);
	result = _stub_func(glue->obj, tuple, opd);
	Py_DECREF(tuple);
	if (!result)
		return 0;
	Py_INCREF(Py_None);
	return Py_None;
}

/* Local Variables: */
/* c-file-style: "python" */
/* End: */
