# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import ServiceClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from .operations.catalog_operations import CatalogOperations
from . import models


class DataLakeAnalyticsCatalogManagementClientConfiguration(AzureConfiguration):
    """Configuration for DataLakeAnalyticsCatalogManagementClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param api_version: Client Api Version.
    :type api_version: str
    :param adla_catalog_dns_suffix: Gets the DNS suffix used as the base for
     all Azure Data Lake Analytics Catalog service requests.
    :type adla_catalog_dns_suffix: str
    :param accept_language: Gets or sets the preferred language for the
     response.
    :type accept_language: str
    :param long_running_operation_retry_timeout: Gets or sets the retry
     timeout in seconds for Long Running Operations. Default value is 30.
    :type long_running_operation_retry_timeout: int
    :param generate_client_request_id: When set to true a unique
     x-ms-client-request-id value is generated and included in each request.
     Default is true.
    :type generate_client_request_id: bool
    :param str filepath: Existing config
    """

    def __init__(
            self, credentials, adla_catalog_dns_suffix, api_version='2015-10-01-preview', accept_language='en-US', long_running_operation_retry_timeout=30, generate_client_request_id=True, filepath=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if api_version is not None and not isinstance(api_version, str):
            raise TypeError("Optional parameter 'api_version' must be str.")
        if adla_catalog_dns_suffix is None:
            raise ValueError("Parameter 'adla_catalog_dns_suffix' must not be None.")
        if not isinstance(adla_catalog_dns_suffix, str):
            raise TypeError("Parameter 'adla_catalog_dns_suffix' must be str.")
        if accept_language is not None and not isinstance(accept_language, str):
            raise TypeError("Optional parameter 'accept_language' must be str.")
        base_url = 'https://{accountName}.{adlaCatalogDnsSuffix}'

        super(DataLakeAnalyticsCatalogManagementClientConfiguration, self).__init__(base_url, filepath)

        self.add_user_agent('datalakeanalyticscatalogmanagementclient/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.api_version = api_version
        self.adla_catalog_dns_suffix = adla_catalog_dns_suffix
        self.accept_language = accept_language
        self.long_running_operation_retry_timeout = long_running_operation_retry_timeout
        self.generate_client_request_id = generate_client_request_id


class DataLakeAnalyticsCatalogManagementClient(object):
    """Creates an Azure Data Lake Analytics catalog client.

    :ivar config: Configuration for client.
    :vartype config: DataLakeAnalyticsCatalogManagementClientConfiguration

    :ivar catalog: Catalog operations
    :vartype catalog: .operations.CatalogOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param api_version: Client Api Version.
    :type api_version: str
    :param adla_catalog_dns_suffix: Gets the DNS suffix used as the base for
     all Azure Data Lake Analytics Catalog service requests.
    :type adla_catalog_dns_suffix: str
    :param accept_language: Gets or sets the preferred language for the
     response.
    :type accept_language: str
    :param long_running_operation_retry_timeout: Gets or sets the retry
     timeout in seconds for Long Running Operations. Default value is 30.
    :type long_running_operation_retry_timeout: int
    :param generate_client_request_id: When set to true a unique
     x-ms-client-request-id value is generated and included in each request.
     Default is true.
    :type generate_client_request_id: bool
    :param str filepath: Existing config
    """

    def __init__(
            self, credentials, adla_catalog_dns_suffix, api_version='2015-10-01-preview', accept_language='en-US', long_running_operation_retry_timeout=30, generate_client_request_id=True, filepath=None):

        self.config = DataLakeAnalyticsCatalogManagementClientConfiguration(credentials, adla_catalog_dns_suffix, api_version, accept_language, long_running_operation_retry_timeout, generate_client_request_id, filepath)
        self._client = ServiceClient(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.catalog = CatalogOperations(
            self._client, self.config, self._serialize, self._deserialize)
