# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Error(Model):
    """Generic resource error information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: the HTTP status code or error code associated with this error
    :vartype code: str
    :ivar message: the error message to display.
    :vartype message: str
    :ivar target: the target of the error.
    :vartype target: str
    :ivar details: the list of error details
    :vartype details: list of :class:`ErrorDetails
     <azure.mgmt.datalake.analytics.account.models.ErrorDetails>`
    :ivar inner_error: the inner exceptions or errors, if any
    :vartype inner_error: :class:`InnerError
     <azure.mgmt.datalake.analytics.account.models.InnerError>`
    """ 

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'inner_error': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetails]'},
        'inner_error': {'key': 'innerError', 'type': 'InnerError'},
    }

    def __init__(self):
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.inner_error = None
