import os, tempfile

from Ft.Lib.CommandLine import CommandLineTestUtil
from Ft.Lib.Uri import OsPathToUri
from Ft.Server.Client import Core
from Server.Client.Core import test_helper

import test_prime

FIRST_RAWFILE = '/' + test_prime.BASE_CONTAINER + '/rf1'
FIRST_ALIAS = '/' + test_prime.BASE_CONTAINER + '/rfa1'
SECOND_RAWFILE = '/' + test_prime.BASE_CONTAINER + '/rf2'
SECOND_ALIAS = '/' + test_prime.BASE_CONTAINER + '/rfa2'


def val1(tester):
    repo = test_helper.GetRepo(tester)
    try:
        if not repo.hasResource(FIRST_RAWFILE):
            return 0
        if not repo.hasResource(FIRST_ALIAS):
            return 0
        tester.compare(RAW1,repo.fetchResource(FIRST_RAWFILE).getContent())
        return 1

    finally:
        repo.txRollback()

def val2(tester):
    repo = test_helper.GetRepo(tester)
    try:
        if not repo.hasResource(SECOND_RAWFILE):
            return 0
        if not repo.hasResource(SECOND_ALIAS):
            return 0
        tester.compare(RAW1,repo.fetchResource(SECOND_RAWFILE).getContent())
        return 1
    finally:
        repo.txRollback()


def Init(repo):
    for uri in [FIRST_RAWFILE,
                SECOND_RAWFILE,
                FIRST_ALIAS,
                SECOND_ALIAS]:
        if repo.hasResource(uri):
            repo.deleteResource(uri,traverseAliases=0)

def Test(tester):

    test_prime.InitRepo(tester,Init,['4ss','create','rawfile'])

    baseConfig = {'host':tester.test_data['ftrpc-host'],
                  'port':tester.test_data['ftrpc-port'],
                  'username':tester.test_data['userName'],
                  'password':tester.test_data['password'],
                  }

    tempFiles = []
    fileName = tempfile.mktemp()
    f = open(fileName,'w')
    f.write(RAW1)
    f.close()
    fileUri = OsPathToUri(fileName)

    try:
        tempFiles.append(fileName)
        tr1 = CommandLineTestUtil.TestRun('Basic Create',
                                          baseConfig,
                                          [FIRST_RAWFILE,fileUri,FIRST_ALIAS],
                                          validationFunc = val1)

        #Create a raw file from stdin
        tr2 = CommandLineTestUtil.TestRun('STDIN Create',
                                          baseConfig,
                                          [SECOND_RAWFILE,'-',SECOND_ALIAS],
                                          validationFunc = val2,
                                          input=RAW1)

        #Create a RF that does not exist
        uri = '/' + test_prime.BASE_CONTAINER + '/rf1'
        tr3 = CommandLineTestUtil.TestRun('Re-Create',
                                          baseConfig,
                                          [uri,fileUri],
                                          expected_3%uri)


        t = CommandLineTestUtil.Test('4ss create rawfile',[tr1,tr2,tr3])

        return t.test(tester)
    finally:
        for f in tempFiles:
            os.unlink(f)
RAW1 = """This is a text file"""

expected_3 = "Path %s is already in the repository\n"

