########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Xslt/Server.py,v 1.3 2004/12/24 22:02:35 mbrown Exp $
"""
XSLT extension elements and functions supporting the 4SS Server API

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ns import SCORE_NS
from Ft.Xml.XPath import Conversions


def GetAvailableModules(context):
    doc = context.node.rootNode
    from Ft.Server.Server import Modules

    return map(doc.createTextNode, Modules._ft_builtins.keys())


def GetAvailableHandlers(context,module):
    module = Conversions.StringValue(module)
    doc = context.node.rootNode
    from Ft.Server.Server import Modules
    mod = Modules._ft_builtins.get(module,None)
    if mod == None: return ""
    if not hasattr(mod,"handlers"): return ""
    return map(doc.createTextNode, getattr(mod,"handlers").keys())


ExtFunctions = {
    (SCORE_NS, 'get-available-modules'): GetAvailableModules,
    (SCORE_NS, 'get-available-handlers'): GetAvailableHandlers,
}

ExtElements = {
}
