########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/SCore/UriReferenceFileImp.py,v 1.13 2006/03/23 09:53:43 cogbuji Exp $
"""
UriReferenceFile repository resource class

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import time, urllib

import RawFileImp

from Ft.Server import FTSERVER_NAMESPACE
from Ft.Server.Common import Schema,XmlLib
from Ft.Server.Common.ResourceTypes import ResourceType
from Ft.Server.Server import FtServerServerException, Error
from Ft.Server.Server.Drivers import FtssDriver
from Ft.Xml.XLink import XLINK_NAMESPACE
from Ft.Lib import Uri
from Ft.Server.Server.Drivers import FtssInputSource, Constants
from Ft.Xml.XPath import Evaluate

class UriReferenceFileImp(RawFileImp.RawFileImp):
    """
    An Uri Reference File is a reference to a URI.  You are given read only access to it.
    MetaData about the Content is updated every time you call getContent
    """
    resourceType = ResourceType.URI_REFERENCE_FILE

    def getReference(self):
        self._verifyTx()
        con = self._driver.getContext(self._path.normalize('.;metadata;no-traverse'))
        rt=Evaluate(Constants.URI_REFERENCE_XPATH,context=con)
        if not rt:
            return ""
        return rt

    def setContent(self,*args):
        raise FtServerServerException(Error.PERMISSION_DENIED,
                                      level='write',
                                      path = self._path)

    def getContent(self):

        ref = self.getReference()
        if not ref:
            content = ""
        else:
            fd = FtssInputSource.FTSS_RESOLVER.resolve(ref)
            content = fd.read()
            fd.close()
        from Ft.Server.Server.Drivers import FtssDriver
        xu = FtssDriver.UPDATE_SIZE % (FTSERVER_NAMESPACE, (len(content)))
        self._driver.xupdateMetaData(self._path, xu,updateRDF=False)
        return content

    def setReference(self,newRef):
        """
        Set what this URI references
        """
        self._verifyTx()
        xu = XmlLib.MakeString(SET_REFERENCE_XUPDATE%(FTSERVER_NAMESPACE,XLINK_NAMESPACE,newRef))
        self._driver.xupdateMetaData(self._path,xu)
        self.getContent()  #To update



def NewUriReferenceFileXml(driver,path,acl,owner,imt,srcUri):
    if srcUri:
        fd = Uri.UrlOpen(srcUri)
        size = len(fd.read())
        fd.close()
    else:
        size = 0
    keywords = {
        'ns' : FTSERVER_NAMESPACE,
        'path' : path,
        'type' : Schema.g_rdfResourceTypes[ResourceType.URI_REFERENCE_FILE],
        'dt' : FtssDriver.CurrentTime(),
        'acl' : driver.aclToXml(acl),
        'owner' : owner,
        'media-type' : imt,
        'size' : size,
        'reference' : srcUri,
        }

    xml = """\
<ftss:MetaData xmlns:ftss='%(ns)s' path='%(path)s' type='%(type)s' creation-date='%(dt)s'>
  %(acl)s
  <ftss:LastModifiedDate>%(dt)s</ftss:LastModifiedDate>
  <ftss:Owner>%(owner)s</ftss:Owner>
  <ftss:Imt>%(media-type)s</ftss:Imt>
  <ftss:Size>%(size)d</ftss:Size>
  <ftss:Reference>%(reference)s</ftss:Reference>
</ftss:MetaData>""" % keywords

    return XmlLib.MakeString(xml)

SET_REFERENCE_XUPDATE="""<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  xmlns:ftss="%s"
  xmlns:xlink="%s"
>
  <xupdate:update select="/ftss:MetaData/ftss:Reference">%s</xupdate:update>
</xupdate:modifications>
"""
