from Ft.Server.Server import Error, FtServerServerException
from Ft.Server.Common import AclConstants

import test_helper

def Test(tester):
    tester.startTest("Anonymous Open")
    repo = test_helper.GetAnonRepo(tester)
    tester.compare(1,len(repo.getAclIdentifiers()))
    tester.compareIn(repo.getAclIdentifiers(),AclConstants.WORLD_GROUP_NAME)
    tester.compare('/',repo.getDisplayPath())
    tester.compare('/',repo.getAbsolutePath())
    repo.txRollback()
    tester.testDone()

    tester.startTest("User Open")

    repo = test_helper.GetRepo(tester)
    tester.compare(4,len(repo.getAclIdentifiers()))
    tester.compareIn(repo.getAclIdentifiers(),AclConstants.USERS_GROUP_NAME)
    tester.compareIn(repo.getAclIdentifiers(),AclConstants.WORLD_GROUP_NAME)
    tester.compareIn(repo.getAclIdentifiers(),AclConstants.SUPER_USER_GROUP_NAME)
    tester.compareIn(repo.getAclIdentifiers(),tester.test_data['userName'])
    repo.txRollback()
    tester.testDone()

    tester.startTest("Open Errors")
    tester.testException(test_helper.GetRepo,(tester,'not a user name','foo'),FtServerServerException,{'code':Error.INVALID_LOGIN})
    tester.testException(test_helper.GetRepo,(tester,tester.test_data['userName'],'foo'),FtServerServerException,{'code':Error.INVALID_LOGIN})
    tester.testDone()

