__revision__ = '$Id: __init__.py,v 1.9 2005/10/29 19:00:54 cogbuji Exp $'

def PreprocessFiles(dirs, files):
    """
    PreprocessFiles(dirs, files) -> (dirs, files)
    
    This function is responsible for sorting and trimming the
    file and directory lists as needed for proper testing.
    """
    from Ft.Lib.TestSuite import RemoveTests, SortTests

    ignored_files = ['test_helper',
                     'test_repository_reader',
                     'DatabaseModes',
                     'GetScoreFunctionList',
                     'test_coverage_start',
                     'test_coverage_end']
    RemoveTests(files, ignored_files)

    ordered_files = ['test_get_repository',
                     'test_basic_resource_metadata',
                     'test_container',
                     'test_basic_rawfile',
                     'test_raw_file',
                     'test_xml_document',
                     'test_documentdefinition',
                     'test_meta_document',
                     ]
    at_end_files = []
    SortTests(files, ordered_files, at_end_files)

    ignored_dirs = []
    RemoveTests(dirs, ignored_dirs)

    ordered_dirs = []
    SortTests(dirs, ordered_dirs)

    return (dirs, files)

CoverageModule = 'Ft.Server.Server.SCore'

# -- run modes -------------------------------------------------------

import DatabaseModes
MODES = [DatabaseModes._FlatFileMode()]

try:
    import _pg
except ImportError:
    pass
else:
    MODES.append(DatabaseModes._PostgresMode())
    
try:
    import MySQLdb
except ImportError:
    pass
else:
    MODES.append(DatabaseModes._MySQLMode())

try:
    import bsddb3
except ImportError:
    pass
else:
    MODES.append(DatabaseModes._BerkeleyDBMode())

try:
    import rdflib
except ImportError:
    pass
else:
    MODES.append(DatabaseModes._RdflibFSMode())
