########################################################################
#
# File Name: 		TimeStampFactory.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/DateFactory.py.html
#
"""
Implements the TimeStampFactory interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""
#"

from Ft.Ods import Date,Interval, TimeImp, TimeStamp, Exception
import time

InvalidTimestamp = Exception.InvalidTimestamp


def from_UTC(t):
    t = time.localtime(t)
    return TimeStamp.TimeStamp(None,
                                     (t[0],
                                      t[1],
                                      t[2],
                                      t[3],
                                      t[4],
                                      t[5],
                                      0,
                                      time.timezone/-3600,
                                      0)
                                     )

    
def current():
    return from_UTC(time.time())


def create(a_date,a_time):
    return TimeStamp.TimeStamp(None,
                               (a_date.year(),
                                a_date.month(),
                                a_date.day(),
                                a_time.hour(),
                                a_time.minute(),
                                a_time.second(),
                                a_time.millisecond(),
                                a_time.tz_hour(),
                                a_time.tz_minute())
                               )


