from Ft.Server.Server import FTSERVER_SERVER_NS, Module
import FtpHandler

class FtpModule(Module):

    handlers = {'ftp' : FtpHandler.FtpHandler}

    commands = {
        (FTSERVER_SERVER_NS, 'ExtendedMapping'): 'addExtendedMapping',
        }

    def initialize(self, parser, config):
        config.extenedMapping = {}
        return

    def addExtendedMapping(self, parser, config, name, data, attrs):
        """
        An extended mapping will map an extension to IMT, docdef, or
        resource type
        """
        try:
            ext = attrs[(None, 'ext')]
        except KeyError:
            raise Exception('%s requires ext attribute' % name)

        dd = attrs.get((None, 'doc-def'), None)
        imt = attrs.get((None, 'imt'), None)
        rt = attrs.get((None, 'resource-type'), None)

        if not (dd or imt or rt):
            raise Exception("%s requires one of doc-def, imt or resource-type attributes" % name)

        config.extendedMapping[ext] = (dd,imt,rt)
        return
