__revision__ = '$Id: __init__.py,v 1.2 2002/07/17 22:58:12 jkloth Exp $'

def PreprocessFiles(dirs, files):
    """
    PreprocessFiles(dirs, files) -> (dirs, files)
    
    This function is responsible for sorting and trimming the
    file and directory lists as needed for proper testing.
    """
    from Ft.Lib.TestSuite import RemoveTests, SortTests

    ignored_files = []
    RemoveTests(files, ignored_files)

    ordered_files = []
    SortTests(files, ordered_files)

    ignored_dirs = []
    RemoveTests(dirs, ignored_dirs)

    ordered_dirs = ['Adapters',
                    'StorageManager',
                    'Collections',
                    'MetaData',
                    'Parsers',
                    'Parsers',
                    ]
    SortTests(dirs, ordered_dirs)

    return (dirs, files)

# -- run modes -------------------------------------------------------

from Ft.Lib.TestSuite import TestMode

class _OdsMode(TestMode.TestMode):

    def __init__(self):
        TestMode.TestMode.__init__(self,self.driverName,self.default)

    def _pre(self, tester):
        from Ft.Ods.StorageManager import Adapters
        from Ft.Ods.StorageManager import GlobalCache
        from Ft.Ods.StorageManager.Adapters import ClassCache

        Adapters.g_driverName = self.driverName
        GlobalCache.GlobalCache().purgeAll()
        ClassCache.ClassCache().purgeAll()
        tester.test_data['driver'] = self.driverName
        return

    def _post(self,tester):
        tester.test_data['driver'] = None
        

class DbmMode(_OdsMode):
    driverName = 'Dbm'
    default = 1


    def _init(self,tester):
        try:
            from Ft.Ods.StorageManager.Adapters import Dbm
        except Exception, error:
            tester.warning("Unable to use mode 'Dbm': %s" % (str(error)))
            return 0
        return 1

class PostgresMode(_OdsMode):
    driverName = 'Postgres'
    default = 0

    def _init(self,tester):
        try:
            from Ft.Ods.StorageManager.Adapters import Postgres
        except Exception, error:
            tester.warning("Unable to use mode 'Postgres': %s" % (str(error)))
            return 0
        return 1

class OracleMode(_OdsMode):
    driverName = 'Oracle'
    default = 0

    def _init(self,tester):
        tester.warning("Unable to use mode 'Oracle'")
        return 0

MODES = [DbmMode(), PostgresMode(), OracleMode()]

