########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/List/DocDefs.py,v 1.7 2004/09/23 20:53:30 mbrown Exp $
"""
Implementation of '4ss list docdefs' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command lists all Document Definition resources in a \
4Suite repository. If necessary, you will be prompted first for \
credentials and access info to connect to the repository."""

import sys

from Ft.Server.Client.Commands import CommandUtil


def Run(options,args):
    repo = CommandUtil.GetRepository(options, '4ss.list.docdefs')
    if repo is not None:
        try:
            dds = repo.getAllDocumentDefinitionPaths()
            CommandUtil.WritePreamble("Document Definitions in the repository:")
            for d in dds:
                print d
        finally:
            try:
                repo.txRollback()
            except:
                pass

    return


def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('docdefs',
                          'List all Document Definitions in a repository',
                          '',
                          __doc__,
                          function=Run,
                          arguments=[
                                    ],
                          fileName=__file__,
                          )
    return cmd
