%
% PDVItoMP change file for DVItoMP, Version 0.64 (Web2C 7.2)
%
% written by Michio Matsuyama <fwhw5892@mb.infoweb.ne.jp>
%            Hideyuki Suzuki <hideyuki@sat.t.u-tokyo.ac.jp>
%
% $Id: pdvitomp.ch,v 1.36 2000/03/20 02:55:50 hideyuki Exp $

@x
@d banner=='% Written by DVItoMP, Version 0.64'
@y
@d banner=='% Written by PDVItoMP Ver.0.04, based on DVItoMP Ver.0.64'
@z

@x
@d term_banner=='This is DVItoMP, Version 0.64'
@y
@d term_banner=='This is PDVItoMP, Version 0.04, based on DVItoMP, Version 0.64'
@z

@x
@!max_widths=10000; {maximum number of different characters among all fonts}
@!virtual_space=10000;
@y
@!max_widths=400000; {maximum number of different characters among all fonts}
@!virtual_space=400000;
@z

@x
@ Under our assumption that the visible characters of standard ASCII are
all present, the following assignment statements initialize the
|xchr| array properly, without needing any system-dependent changes.
@y
@ Under our assumption that the visible characters of standard ASCII are
all present, the following assignment statements initialize the
|xchr| array properly, without needing any system-dependent changes.

{\tt PDVItoMP}: Character codes with range from |0| to |@'37| and from
|@'177| to |255| are also meaningful for {\tt PDVItoMP} because
lower codes of Japanese two-bytes characters are in these ranges.
@z

@x
for i:=0 to @'37 do xchr[i]:='?';
@y
for i:=0 to @'37 do xchr[i]:=i;
@z

@x
for i:=@'177 to 255 do xchr[i]:='?';
@y
for i:=@'177 to 255 do xchr[i]:=i;
@z

@x
@d undefined_commands==250,251,252,253,254,255
@y
@d dir=255 {p\TeX\ direction}
@d undefined_commands==250,251,252,253,254
@z

@x
read_tfm_word; lh:=b2*intcast(256)+b3;
@y
read_tfm_word;
@<Read the pTeX header data@>;@/
lh:=b2*intcast(256)+b3;
@z

@x
    if b0<128 then tfm_check_sum:=((b0*intcast(256)+b1)*256+b2)*256+b3
    else tfm_check_sum:=(((b0-256)*intcast(256)+b1)*256+b2)*256+b3;
  end;
@y
    if b0<128 then tfm_check_sum:=((b0*intcast(256)+b1)*256+b2)*256+b3
    else tfm_check_sum:=(((b0-256)*intcast(256)+b1)*256+b2)*256+b3;
  end;
  @<Read JFM character type table@>;
@z

@x
@<Width of character |c| in font |f|@>=
round(dvi_scale*font_scaled_size[f]*char_width(f)(c)-0.5)

@ @<Width of character |p| in font |cur_font|@>=
round(dvi_scale*font_scaled_size[cur_font]*char_width(cur_font)(p)-0.5)
@y
@p @<Declare JFM character type table lookup routine@>@; {p\TeX}
function scaled_char_width(@!f,@!c:integer):integer;
begin
  if font_jfm_p(f) then c:=lookup_ctype(f,c);
  scaled_char_width:=round(dvi_scale*font_scaled_size[f]*char_width(f)(c)-0.5)
end;
@z

@x
@ @p @<Declare a procedure called |finish_last_char|@>@;
procedure do_set_char(@!f,@!c:integer);
begin if (c<font_bc[f])or(c>font_ec[f]) then
  abort('attempt to typeset invalid character ',c:1);
@.attempt to typeset...@>
@y
@ {\tt PDVItoMP}: |do_set_char| is called with non-virtual font.
In the case of non-virtual Kanji font, the width is looked up
with the character type, and the character is printed by the
function |set_kanji_char|.

When the width written in the virtual font is same as
the width of the substituted font, the next character can be
written in the same string in output mpx file.
In other words, the width of the character is calculated
in |do_dvi_commands|. So even if the width is wrong here, the output PostScript file is not affected.

@p @<Declare a procedure called |finish_last_char|@>@;
procedure do_set_char(@!f,@!c:integer);
var jfm_char_type: integer;
begin 
if font_jfm_p(f) then begin
  jfm_char_type:=lookup_ctype(f,c);
  if (jfm_char_type<font_bc[f])or(jfm_char_type>font_ec[f]) then@/
    abort('attempt to typeset invalid character (JFM) ',c:1);
  end
else if (c<font_bc[f])or(c>font_ec[f]) then
  abort('attempt to typeset invalid character ',c:1);
@.attempt to typeset...@>
@z

@x
if (h<>str_h2)or(v<>str_v)or(f<>str_f)or(dvi_scale<>str_scale) then
@y
if (h<>str_h2)or(v<>str_v2)or(f<>str_f)or(dvi_scale<>str_scale) then
@z

@x
  print('_s('); print_col:=3;@/
  str_scale:=dvi_scale; str_f:=f; str_v:=v; str_h1:=h;
@y
  if (d=0) or (font_id[f]=9) then begin print('_s('); print_col:=3 end
  else begin print('_sr('); print_col:=4 end;@/
  str_scale:=dvi_scale; str_f:=f; str_v1:=v; str_h1:=h;
@z

@x
print_char(c);
str_h2:=h+@<Width of character |c| in font |f|@>;
@y
if font_jfm_p(f) then print_kanji_char(c) {non-virtual kanji font}
else print_char(c);
if d=0 then begin
  str_h2:=h+scaled_char_width(f,c);
  str_v2:=v;
  end
else begin
  str_h2:=h;
  str_v2:=v+scaled_char_width(f,c);
  end
@z

@x
@!str_h1,str_v:integer; {starting position for current output string}
@!str_h2:integer; {where the current output string ends}
@y
@!str_h1,str_v1:integer; {starting position for current output string}
@!str_h2,str_v2:integer; {where the current output string ends}
@z

@x
print_ln('vardef _s(expr _t,_f,_m,_x,_y)=');
print_ln('  addto _p also _t infont _f scaled _m shifted (_x,_y); enddef;');
@y
print_ln('vardef _s(expr _t,_f,_m,_x,_y)=');
print_ln('  addto _p also _t infont _f scaled _m shifted (_x,_y); enddef;');
print_ln('vardef _sr(expr _t,_f,_m,_x,_y)=');  
print_ln('  addto _p also _t infont _f rotated -90',
  ' scaled _m shifted (_x,_y); enddef;');
@z

@x
  x:=conv*str_h1; y:=conv*(-str_v);
@y
  x:=conv*str_h1; y:=conv*(-str_v1);
@z

@x
@<Handle a special rule that determines the box size@>=
begin pic_wd:=h; pic_dp:=v; pic_ht:=ht-v;
end
@y
@<Handle a special rule that determines the box size@>=
begin if d=0 then begin pic_wd:=h; pic_dp:=v; pic_ht:=ht-v end
  else begin pic_wd:=v; pic_dp:=-h; pic_ht:=ht+h end
end
@z

@x
str_v:=0; str_h2:=0; str_scale:=1.0; {values don't matter}
@y
str_h2:=0; str_v2:=0; str_scale:=1.0; {values don't matter}
@z

@x
dd:=-pic_dp*conv;
w:=conv*pic_wd; h:=conv*pic_ht;@/
print('setbounds _p to (0,');
fprint_real(mpx_file, dd,1,4); print(')--(');
fprint_real(mpx_file, w,1,4);  print(',');
fprint_real(mpx_file, dd,1,4); print_ln(')--');@/
print(' (');
fprint_real(mpx_file, w,1,4);  print(',');
fprint_real(mpx_file, h,1,4);  print(')--(0,');
fprint_real(mpx_file, h,1,4);  print_ln(')--cycle;')
@y
if d=0 then begin
  dd:=-pic_dp*conv;
  w:=conv*pic_wd; h:=conv*pic_ht;@/
  print('setbounds _p to (0,');
  fprint_real(mpx_file, dd,1,4); print(')--(');
  fprint_real(mpx_file, w,1,4);  print(',');
  fprint_real(mpx_file, dd,1,4); print_ln(')--');@/
  print(' (');
  fprint_real(mpx_file, w,1,4);  print(',');
  fprint_real(mpx_file, h,1,4);  print(')--(0,');
  fprint_real(mpx_file, h,1,4);  print_ln(')--cycle;')
  end
else begin
  dd:=-pic_dp*conv;
  w:=-pic_wd*conv; h:=conv*pic_ht;@/
  print('setbounds _p to (');
  fprint_real(mpx_file, h,1,4); print(',0)--(');
  fprint_real(mpx_file, h,1,4); print(',');
  fprint_real(mpx_file, w,1,4);  print(')--(');
  fprint_real(mpx_file, dd,1,4);  print(',');
  fprint_real(mpx_file, w,1,4);  print(')--(');
  fprint_real(mpx_file, dd,1,4);  print_ln(',0)--cycle;');
  end
@z

@x
@!w,@!x,@!y,@!z:integer; 
  {current state values (|h| and |v| have already been declared)}
@!hstack,@!vstack,@!wstack,@!xstack,@!ystack,@!zstack: 
@y
@!w,@!x,@!y,@!z,@!d:integer;
  {current state values (|h| and |v| have already been declared)}
@!hstack,@!vstack,@!wstack,@!xstack,@!ystack,@!zstack,@!dstack:
@z

@x
h:=0; v:=0
@y
h:=0; v:=0; d:=0
@z 

@x
hstack[stk_siz]:=h; vstack[stk_siz]:=v; wstack[stk_siz]:=w;
xstack[stk_siz]:=x; ystack[stk_siz]:=y; zstack[stk_siz]:=z;
@y 
hstack[stk_siz]:=h; vstack[stk_siz]:=v; wstack[stk_siz]:=w;
xstack[stk_siz]:=x; ystack[stk_siz]:=y; zstack[stk_siz]:=z;
dstack[stk_siz]:=d;
@z

@x
  h:=hstack[stk_siz]; v:=vstack[stk_siz]; w:=wstack[stk_siz];
  x:=xstack[stk_siz]; y:=ystack[stk_siz]; z:=zstack[stk_siz];
@y
  h:=hstack[stk_siz]; v:=vstack[stk_siz]; w:=wstack[stk_siz];
  x:=xstack[stk_siz]; y:=ystack[stk_siz]; z:=zstack[stk_siz];
  d:=dstack[stk_siz];
@z

@x
z0: first_par:=z;
@y
z0: first_par:=z;
dir: first_par:=get_byte;
@z

@x
  h:=h+@<Width of character |p| in font |cur_font|@>;
@y
  if d=0 then h:=h+scaled_char_width(cur_font,p)
  else v:=v+scaled_char_width(cur_font,p);
@z

@x
    h:=h+q;
@y
    if d=0 then h:=h+q
    else v:=v+q;
@z

@x
pop: do_pop;
@y
pop: do_pop;
dir: d:=p;
@z

@x
four_cases(right1):h:=h+trunc(p*dvi_scale);
w0,four_cases(w1):begin w:=trunc(p*dvi_scale); h:=h+w;
  end;
x0,four_cases(x1):begin x:=trunc(p*dvi_scale); h:=h+x;
  end;
four_cases(down1):v:=v+trunc(p*dvi_scale);
y0,four_cases(y1):begin y:=trunc(p*dvi_scale); v:=v+y;
  end;
z0,four_cases(z1):begin z:=trunc(p*dvi_scale); v:=v+z;
  end;
@y
four_cases(right1):
  if d=0 then h:=h+trunc(p*dvi_scale)
  else v:=v+trunc(p*dvi_scale);
w0,four_cases(w1):begin w:=trunc(p*dvi_scale);
  if d=0 then h:=h+w
  else v:=v+w;
  end;
x0,four_cases(x1):begin x:=trunc(p*dvi_scale);
  if d=0 then h:=h+x
  else v:=v+x;
  end;
four_cases(down1):
  if d=0 then v:=v+trunc(p*dvi_scale)
  else h:=h-trunc(p*dvi_scale);
y0,four_cases(y1):begin y:=trunc(p*dvi_scale);
  if d=0 then v:=v+y
  else h:=h-y;
  end;
z0,four_cases(z1):begin z:=trunc(p*dvi_scale);
  if d=0 then v:=v+z
  else h:=h-z;
  end;
@z

@x
    end else if getopt_return_val = "?" then begin
      usage (1, 'dvitomp');

    end else if argument_is ('help') then begin
      usage (0, DVITOMP_HELP);
@y
    end else if getopt_return_val = "?" then begin
      usage (1, 'pdvitomp');

    end else if argument_is ('help') then begin
      usage (0, PDVITOMP_HELP);
@z
@x
  if (optind + 1 <> argc) and (optind + 2 <> argc) then begin
    write_ln (stderr, 'dvitomp: Need one or two file arguments.');
    usage (1, 'dvitomp');
@y
  if (optind + 1 <> argc) and (optind + 2 <> argc) then begin
    write_ln (stderr, 'pdvitomp: Need one or two file arguments.');
    usage (1, 'pdvitomp');
@z

@x
@<Global...@> =
@!dvi_name, @!mpx_name:c_string;
@y
@<Global...@> =
@!dvi_name, @!mpx_name:c_string;

@* Kanji handling procedures.

@ ASCII p\TeX JFM ID
@d yoko_jfm_id = 11 {for `yoko-kumi' fonts}
@d tate_jfm_id = 9  {for `tate-kumi' fonts}
@d font_jfm_p(#) == (font_id[#]<>0)

@ @<Global...@>=
@!font_nt: array [0..max_fonts] of integer; {number of words in ctype table}
@!font_id: array [0..max_fonts] of integer;
@!jfm_char_code:array [0..max_widths] of integer;
@!jfm_char_type:array [0..max_widths] of integer;
@!jfm_char_index: array [0..max_fonts] of integer;
@!next_jfm_char_index:integer;

@ @<Set init...@>=
font_nt[0]:=0;
font_id[0]:=0;
jfm_char_type[0]:=0;
next_jfm_char_index:=0;

@ JFM character type table is stored in the array |jfm_char_code| and
|jfm_char_type|. The character code and the character type of $i$-th
record is stored in |jfm_char_code[i]| and |jfm_char_type[i]|, respectively.
The table is in the order of character code.

@<Read the pTeX header data@>=
font_id[f]:=b0*intcast(256)+b1;
if (font_id[f]=yoko_jfm_id) or (font_id[f]=tate_jfm_id) then
  begin font_nt[f]:=b2*intcast(256)+b3; read_tfm_word end
else begin font_id[f]:=0; font_nt[f]:=0 end

@ @<Read JFM character type table@>=
jfm_char_index[f]:=next_jfm_char_index;
k:=jfm_char_index[f];
next_jfm_char_index:=next_jfm_char_index+font_nt[f];
while k<next_jfm_char_index do begin
  read_tfm_word;
  jfm_char_code[k]:=b0*intcast(256)+b1;
  jfm_char_type[k]:=b2*intcast(256)+b3;
  incr(k)
  end

@ JFM character type table is looked up by binary search.

@<Declare JFM character type table lookup routine@>=
function lookup_ctype(@!f:integer;@!c:integer):integer;
var l, u, r, ch:integer;
begin
  l:=0; u:=font_nt[f]-1;
  while l<u do begin
    r:=(l+u)/2;
    ch:=jfm_char_code[jfm_char_index[f]+r];
    if (ch=c) then begin
      lookup_ctype:=jfm_char_type[jfm_char_index[f]+r]; goto done end;
    if (ch<c) then l:=r+1
    else u:=r-1;
    end;
  lookup_ctype:=0;
done:
end;

@ Every Kanji characters are supposed to be printable here,
so that the state always results in normal at the end of the procedure.
Kanji characters need to be converted into output Kanji encoding
from JIS.

@<Declare subroutines for printing strings@>=
procedure print_kanji_char(@!c:integer);
begin 
  if print_col+2>line_length-2 then begin
    if state=normal then begin
      print('"'); state:=special end;
    print_ln(' ');
    print_col:=0;
    end;
  if state=special then begin
    print('&'); incr(print_col);
    end;
  if state<>normal then begin
    print('"'); incr(print_col);
    state:=normal;
    end;
  ifdef('EUCPTEX') c := JIStoEUC(c); endif('EUCPTEX')@/
  ifdef('SJISPTEX') c := JIStoSJIS(c); endif('SJISPTEX')@/
  print(xchr[c div 256]); print(xchr[c mod 256]);
  print_col:=print_col+2;
end;
@z
