(** Wrapper around Perl [HTML::TreeBuilder] class.
  *
  * Copyright (C) 2003 Merjis Ltd.
  *
  * $Id: pl_HTML_TreeBuilder.ml,v 1.3 2003/10/16 13:41:07 rich Exp $
  *)

open Perl

open Pl_HTML_Parser
open Pl_HTML_Element

let _ = eval "use HTML::TreeBuilder"

class html_treebuilder sv =

object (self)
  inherit html_parser sv

  method elementify =
    let sv = call_method sv "elementify" [] in
    new html_element sv
end

(* Note that "new" is a reserved word, so I've appended an _ character. *)
let new_ () =
  let sv = call_class_method "HTML::TreeBuilder" "new" [] in
  new html_treebuilder sv

let new_from_file filename =
  let sv = call_class_method "HTML::TreeBuilder" "new_from_file"
	     [sv_of_string filename] in
  new html_treebuilder sv

let new_from_content content =
  let sv = call_class_method "HTML::TreeBuilder" "new_from_content"
	     [sv_of_string content] in
  new html_treebuilder sv
