#
#                             COPYRIGHT
# 
#   PCB, interactive printed circuit board design
#   Copyright (C) 1994,1995,1996 Thomas Nau
# 
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
# 
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 
#   Contact addresses for paper mail and Email:
#   Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
#   Thomas.Nau@rz.uni-ulm.de
# 
#   RCS: $Id: texas_inst_amplifier.list,v 1.1 1998/05/27 00:50:00 huiban Exp $
#
# mask package values...
#
TL031_dil:P:TL031CP:TL031ACP:TL031IP:TL031AIP:TL031MP:TL031AMP
TL031_dil:JG:TL031CJG:TL031ACJG:TL031AJG:TL031AIJG:TL031MJG:TL031AMJG
TL031_dil:D:TL031CD:TL031ACD:TL031ID:TL031AID:TL031MD:TL031AMD
#
TL032_dil:P:TL032CP:TL032ACP:TL032IP:TL032AIP:TL032MP:TL032AMP
TL032_dil:JG:TL032CJG:TL032ACJG:TL032AJG:TL032AIJG:TL032MJG:TL032AMJG
TL032_dil:D:TL032CD:TL032ACD:TL032ID:TL032AID:TL032MD:TL032AMD
#
TL034_dil:P:TL034CP:TL034ACP:TL034IP:TL034AIP:TL034MP:TL034AMP
TL034_dil:JG:TL034CJG:TL034ACJG:TL034AJG:TL034AIJG:TL034MJG:TL034AMJG
TL034_dil:D:TL034CD:TL034ACD:TL034ID:TL034AID:TL034MD:TL034AMD
#
TL051_dil:P:TL051CP:TL051ACP:TL051IP:TL051AIP:TL051MP:TL051AMP
TL051_dil:JG:TL051CJG:TL051ACJG:TL051AJG:TL051AIJG:TL051MJG:TL051AMJG
TL051_dil:D:TL051CD:TL051ACD:TL051ID:TL051AID:TL051MD:TL051AMD
#
TL052_dil:P:TL052CP:TL052ACP:TL052IP:TL052AIP:TL052MP:TL052AMP
TL052_dil:JG:TL052CJG:TL052ACJG:TL052AJG:TL052AIJG:TL052MJG:TL052AMJG
TL052_dil:D:TL052CD:TL052ACD:TL052ID:TL052AID:TL052MD:TL052AMD
#
TL054_dil:P:TL054CP:TL054ACP:TL054IP:TL054AIP:TL054MP:TL054AMP
TL054_dil:JG:TL054CJG:TL054ACJG:TL054AJG:TL054AIJG:TL054MJG:TL054AMJG
TL054_dil:D:TL054CD:TL054ACD:TL054ID:TL054AID:TL054MD:TL054AMD
#
TL060_dil:P:TL060CP:TL060ACP:TL060IP
TL060_dil:JG:TL060CJG:TL060ACJG:TL060BCJG:TL060IJG
TL060_dil:D:TL060CD:TL060ACD:TL060BCD:TL060ID
#
TL061_dil:P:TL061CP:TL061ACP:TL061BCP:TL061IP
TL061_dil:JG:TL061CJG:TL061ACJG:TL061BCJG:TL061IJG:TL061MJG
TL061_dil:D:TL061CD:TL061ACD:TL061BCD:TL061ID
#
TL062_dil:P:TL062CP:TL062ACP:TL062BCP:TL062IP
TL062_dil:JG:TL062CJG:TL062ACJG:TL062BCJG:TL062IJG:TL062MJG
TL062_dil:D:TL062CD:TL062ACD:TL062BCD:TL062ID
#
TL064_dil:N:TL064CN:TL064ACN:TL064BCN:TL064IN
TL064_dil:J:TL064CJ:TL064ACJ:TL064BCJ:TL064IJ:TL064MJ
TL064_dil:D:TL064CD:TL064ACD:TL064BCD:TL064ID
#
TL070_dil:P:TL070CP:TL070ACP:TL070IP
TL070_dil:JG:TL070CJG:TL070ACJG:TL070IJG:TL070MJG
TL070_dil:D:TL070CD:TL070ACD:TL070ID
#
TL071_dil:P:TL071CP:TL071ACP:TL071BCP:TL071IP
TL071_dil:JG:TL071CJG:TL071ACJG:TL071BCJG:TL071IJG:TL071MJG
TL071_dil:D:TL071CD:TL071ACD:TL071BCD:TL071ID
#
TL072_dil:P:TL072CP:TL072ACP:TL072BCP:TL072IP
TL072_dil:JG:TL072CJG:TL072ACJG:TL072BCJG:TL072IJG:TL072MJG
TL072_dil:D:TL072CD:TL072ACD:TL072BCD:TL072ID
#
TL074_dil:N:TL074CN:TL074ACN:TL074BCN:TL074IN
TL074_dil:J:TL074CJ:TL074ACJ:TL074BCJ:TL074IJ:TL074MJ
TL074_dil:D:TL074CD:TL074ACD:TL074BCD:TL074ID
#
TL075_dil:N:TL075CN
#
TL080_dil:P:TL080CP:TL080ACP:TL080IP
TL080_dil:JG:TL080CJG:TL080ACJG:TL080IJG:TL080MJG
TL080_dil:D:TL080CD:TL080ACD:TL080ID
#
TL081_dil:P:TL081CP:TL081ACP:TL081BCP:TL081IP
TL081_dil:JG:TL081CJG:TL081ACJG:TL081BCJG:TL081IJG:TL081MJG
TL081_dil:D:TL081CD:TL081ACD:TL081BCD:TL081ID
#
TL082_dil:P:TL082CP:TL082ACP:TL082BCP:TL082IP
TL082_dil:JG:TL082CJG:TL082ACJG:TL082BCJG:TL082IJG:TL082MJG
TL082_dil:D:TL082CD:TL082ACD:TL082BCD:TL820ID
#
TL083_dil:N:TL083CN:TL083ACN:TL083IN
TL083_dil:J:TL083CJ:TL083ACJ:TL083IJ:TL083MJ
TL083_dil:D:TL083CD:TL083ACD:TL083ID
#
TL084_dil:N:TL084CN:TL084ACN:TL084BCN:TL084IN
TL084_dil:J:TL084CJ:TL084ACJ:TL084BCJ:TL084IJ:TL084MJ
TL084_dil:D:TL084CD:TL084ACD:TL084BCD:TL084ID
#
TL085_dil:N:TL085CN
#
TL087_dil:P:TL087CP:TL088CP:TL087IP:TL088IP
TL087_dil:JG:TL087CJG:TL088CJG:TL087IJG:TL088IGJ:TL088MJG
TL087_dil:D:TL087CD:TL088CD:TL087ID:TL088ID
#
TL287_dil:P:TL287CP:TL288CP:TL287IP:TL288IP
TL287_dil:JG:TL287CJG:TL288CJG:TL287IJG:TL288IGJ:TL288MJG
TL287_dil:D:TL287CD:TL288CD:TL287ID:TL288ID
#
TL136_dil:N:TL136N
#
TL321_dil:P:TL321CP:TL321IP
TL321_dil:JG:TL321CJG:TL321IJG
TL321_dil:D:TL321CD:TL321ID
#
TL322_dil:P:TL322CP:TL322IP
TL322_dil:JG:TL322CJG:TL322IJG
TL322_dil:D:TL322CD:TL322ID
#
TLC251_dil:P:TLC251CP:TLC251ACP:TLC251BCP
TLC251_dil:JG:TLC251CJG:TLC251ACJG:TLC251BCJG
TLC251_dil:D:TLC251CD:TLC251ACD:TLC251BCD
#
TLC252_dil:P:TLC252CP:TLC252ACP:TLC252BCP
TLC252_dil:JG:TLC252CJG:TLC252ACJG:TLC252BCJG
TLC252_dil:D:TLC252CD:TLC252ACD:TLC252BCD
#
TLC252_dil:P:TLC25L2CP:TLC25L2ACP:TLC25L2BCP
TLC252_dil:JG:TLC25L2CJG:TLC25L2ACJG:TLC25L2BCJG
TLC252_dil:D:TLC25L2CD:TLC25L2ACD:TLC25L2BCD
#
TLC252_dil:P:TLC25M2CP:TLC25M2ACP:TLC25M2BCP
TLC252_dil:JG:TLC25M2CJG:TLC25M2ACJG:TLC25M2BCJG
TLC252_dil:D:TLC25M2CD:TLC25M2ACD:TLC25M2BCD
#
TLC254_dil:P:TLC254CP:TLC254ACP:TLC254BCP
TLC254_dil:JG:TLC254CJG:TLC254ACJG:TLC254BCJG
TLC254_dil:D:TLC254CD:TLC254ACD:TLC254BCD
#
TLC254_dil:P:TLC25L4CP:TLC25L4ACP:TLC25L4BCP
TLC254_dil:JG:TLC25L4CJG:TLC25L4ACJG:TLC25L4BCJG
TLC254_dil:D:TLC25L4CD:TLC25L4ACD:TLC25L4BCD
#
TLC254_dil:P:TLC25M4CP:TLC25M4ACP:TLC25M4BCP
TLC254_dil:JG:TLC25M4CJG:TLC25M4ACJG:TLC25M4BCJG
TLC254_dil:D:TLC25M4CD:TLC25M4ACD:TLC25M4BCD
#
TLC271_dil:P:TLC271CP:TLC271ACP:TLC271BCP:TLC271IP:TLC271AIP:TLC271BIP
TLC271_dil:JG:TLC271CJG:TLC271ACJG:TLC271BCJG:TLC271IJG:TLC271AIJG:TLC271BIJG:TLC271MJG
TLC271_dil:D:TLC271CD:TLC271ACD:TLC271BCD:TLC271ID:TLC271AID:TLC271BID
#
TLC272_dil:P:TLC272CP:TLC272ACP:TLC272BCP:TLC272IP:TLC272AIP:TLC272BIP:TLC277CP:TLC277IP
TLC272_dil:JG:TLC272CJG:TLC272ACJG:TLC272BCJG:TLC272IJG:TLC272AIJG:TLC272BIJG:TLC272MJG:TLC277CJG:TLC277IJG:TLC277MJG
TLC272_dil:D:TLC272CD:TLC272ACD:TLC272BCD:TLC272ID:TLC272AID:TLC272BID:TLC277CD:TLC277ID
#
TLC274_dil:N:TLC274CN:TLC274ACN:TLC274BCN:TLC274IN:TLC274AIN:TLC274BIN:TLC279CN:TLC279IN
TLC274_dil:J:TLC274CJ:TLC274ACJ:TLC274BCJ:TLC274IJ:TLC274AIJ:TLC274BIJ:TLC274MJ:TLC279CJ:TLC279IJ:TLC279MJ
TLC274_dil:D:TLC274CD:TLC274ACD:TLC274BCD:TLC274ID:TLC274AID:TLC274BID:TLC279CD:TLC279ID
#
TLC272_dil:P:TLC27L2CP:TLC27L2ACP:TLC27L2BCP:TLC27L2IP:TLC27L2AIP:TLC27L2BIP:TLC27L7CP:TLC27L7IP
TLC272_dil:JG:TLC27L2CJG:TLC27L2ACJG:TLC27L2BCJG:TLC27L2IJG:TLC27L2AIJG:TLC27L2BIJG:TLC27L2MJG:TLC27L7CJG:TLC27L7IJG:TLC27L7MJG
TLC272_dil:D:TLC27L2CD:TLC27L2ACD:TLC27L2BCD:TLC27L2ID:TLC27L2AID:TLC27L2BID:TLC27L7CD:TLC27L7ID
#
TLC274_dil:N:TLC27L4CN:TLC27L4ACN:TLC27L4BCN:TLC27L4IN:TLC27L4AIN:TLC27L4BIN:TLC27L9CN:TLC27L9IN
TLC274_dil:J:TLC27L4CJ:TLC27L4ACJ:TLC27L4BCJ:TLC27L4IJ:TLC27L4AIJ:TLC27L4BIJ:TLC27L4MJ:TLC27L9CJ:TLC27L9IJ:TLC27L9MJ
TLC274_dil:D:TLC27L4CD:TLC27L4ACD:TLC27L4BCD:TLC27L4ID:TLC27L4AID:TLC27L4BID:TLC27L9CD:TLC27L9ID
#
TLC272_dil:P:TLC27M2CP:TLC27M2ACP:TLC27M2BCP:TLC27M2IP:TLC27M2AIP:TLC27M2BIP:TLC27M7CP:TLC27M7IP
TLC272_dil:JG:TLC27M2CJG:TLC27M2ACJG:TLC27M2BCJG:TLC27M2IJG:TLC27M2AIJG:TLC27M2BIJG:TLC27M2MJG:TLC27M7CJG:TLC27M7IJG:TLC27M7MJG
TLC272_dil:D:TLC27M2CD:TLC27M2ACD:TLC27M2BCD:TLC27M2ID:TLC27M2AID:TLC27M2BID:TLC27M7CD:TLC27M7ID
#
TLC274_dil:N:TLC27M4CN:TLC27M4ACN:TLC27M4BCN:TLC27M4IN:TLC27M4AIN:TLC27M4BIN:TLC27M9CN:TLC27M9IN
TLC274_dil:J:TLC27M4CJ:TLC27M4ACJ:TLC27M4BCJ:TLC27M4IJ:TLC27M4AIJ:TLC27M4BIJ:TLC27M4MJ:TLC27M9CJ:TLC27M9IJ:TLC27M9MJ
TLC274_dil:D:TLC27M4CD:TLC27M4ACD:TLC27M4BCD:TLC27M4ID:TLC27M4AID:TLC27M4BID:TLC27M9CD:TLC27M9ID
#
TLC1078:P:TLC1078CP:TLC1078IP
TLC1078:JG:TLC1078CJG:TLC1078IJG:TLC1078MJG
TLC1078:D:TLC1078CD:TLC1078ID
#
TLC1079:P:TLC1079CP:TLC1079IP
TLC1079:JG:TLC1079CJG:TLC1079IJG:TLC1079MJG
TLC1079:D:TLC1079CD:TLC1079ID
#
uA709_dil:P:uA709CP
uA709_dil:JG:uA709CJG:uA709MJG:uA709AMJG
uA709_dil:D:uA709CD
uA709J_dil:J:uA709MJ:uA709AMJ
#
uA741_dil:P:uA741CP
uA741_dil:JG:uA741CJG:uA741MJG:uA741AMJG
uA741_dil:D:uA741CD
uA741J_dil:J:uA741MJ:uA741AMJ
#
uA747_dil:N:uA747CN
uA747_dil:D:uA747CD
uA747_dil:J:uA747CJ:uA747MJ
#
uA748_dil:P:uA748CP
uA748_dil:JG:uA748CJG:uA748MJG
uA748_dil:D:uA748CD
#
LM101_dil:P:LM201AP:LM301AP
LM101_dil:D:LM201AD:LM301AD
LM101_dil:JG:LM101AJG:LM201AJG:LM301AJG
#
LM107_dil:P:LM207P:LM307P
LM107_dil:D:LM207D:LM307D
LM107_dil:JG:LM107JG:LM207JG:LM307JG
LM107J_dil:N:LM107J
#
LM108_dil:P:LM108P:LM108AP:LM308P:LM308AP
#
LM148_dil:N:LM248N:LM348N
LM148_dil:D:LM248D:LM348D
LM148_dil:J:LM148J:LM248J:LM348J
#
LM218_dil:P:LM218P:LM318P
LM218_dil:D:LM218D:LM318D
LM218_dil:JG:LM218JG:LM318JG
#
LM324_dil:N:LM224N:LM224AN:LM324N:LM324AN:LM2902N
LM324_dil:D:LM224D:LM224AD:LM324D:LM324AD:LM2902D
LM324_dil:J:LM124J:LM224J:LM224AJ:LM324J:LM324AJ:LM2902J
#
LM358_dil:N:LM258P:LM258AP:LM358P:LM358AP:LM2904P
LM358_dil:D:LM258D:LM258AD:LM358D:LM358AD:LM2904D
LM358_dil:JG:LM158JG:LM258JG:LM258AJG:LM358JG:LM358AJG:LM2904JG
#
LM2900_dil:N:LM2900N:LM3900N
LM2900_dil:J:LM2900J:LM3900J
#
LF347_dil:N:LF347N:LF347BN
LF347_dil:D:LF347D:LF347BD
LF347_dil:J:LF347J:LF347BJ
#
LF351_dil:P:LF351P
LF351_dil:D:LF351D
LF351_dil:JG:LF351JG
#
LF353_dil:P:LF353P
LF353_dil:D:LF353D
LF353_dil:JG:LF353JG
#
LF411_dil:P:LF411CP
LF411_dil:D:LF411CD
LF411_dil:JG:LF411CJG
#
LF412_dil:P:LF412CP
LF412_dil:D:LF412CD
LF412_dil:JG:LF412CJG
#
LT1001_dil:P:LT1001CP:LT1001ACP
LT1001_dil:D:LT1001CD
LT1001_dil:JG:LT1001CJG:LT1001ACJG:LT1001MJG:LT1001AMJG
#
LT1007_dil:P:LT1007CP:LT1007ACP:LT1007MP:LT1007AMP:LT1037CP:LT1037ACP:LT1037MP:LT1037AMP
LT1007_dil:JG:LT1007CJG:LT1007ACJG:LT1007MJG:LT1007AMJG:LT1037CJG:LT1037ACJG:LT1037MJG:LT1037AMJG
LT1007DW_dil:DW:LT1007CDW:LT1037CDW7
#
LT1008_dil:P:LT1008CP:LT1008MP
LT1008_dil:JG:LT1008CJG:LT1008MJG
#
LT1012_dil:P:LT1012CP
#
LT1028_dil:P:LT1028CP:LT1028ACP
LT1028_dil:JG:LT1028CJG:LT1028ACJG:LT1028MJG:LT1028AMJG
LT1028DW_dil:DW:LT1028ACDW
#
MC1558_dil:D:MC1458D
MC1558_dil:JG:MC1558JG:MC1458JG
MC1558_dil:P:MC1458P
#
MC3303_dil:N:MC3303N:MC3403N
MC3303_dil:J:MC3303J:MC3403J
MC3303_dil:D:MC3303D:MC3403D
#
NE5532_dil:P:NE5532P:NE5532AP
NE5532_dil:JG:NE5532JG:NE5532AJG
#
NE5534_dil:P:NE5534P:NE5534AP
NE5534_dil:JG:SE5534JG:NE5534JG:SE5534AJG:NE5534AJG
NE5534_dil:D:NE5534D:NE5534AD
#
OP07_dil:P:OP-07CP:OP-07DP:OP-07EP
OP07_dil:JG:OP-07CJG:OP-07DJG:OP-07EJG
OP07_dil:D:OP-07CD:OP-07DD:OP-07ED
#
OP27_dil:P:OP-27AP:OP-27CP:OP-27EP:OP-27GP:OP-37AP:OP-37CP:OP-37EP:OP-37GP
OP27_dil:JG:OP-27AJG:OP-27CJG:OP-27EJG:OP-27GJG:OP-37AJG:OP-37CJG:OP-37EJG:OP-37GJG
#
RC4559_dil:P:RC4559P
RC4559_dil:D:RC4559D
#
RM4136_dil:N:RV4136N:RC4136N
RM4136_dil:J:RV4136J:RC4136J:RM4136J
RM4136_dil:D:RV4136D:RC4136D
#
RM4558_dil:P:RV4558P:RC4558P
RM4558_dil:JG:RV4558JG:RC4558JG:RM4558JG
RM4558_dil:D:RV4558D:RC4558D
#
divert(-1)
#
#                             COPYRIGHT
# 
#   PCB, interactive printed circuit board design
#   Copyright (C) 1994,1995,1996 Thomas Nau
# 
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
# 
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 
#   Contact addresses for paper mail and Email:
#   Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
#   Thomas.Nau@rz.uni-ulm.de
# 
#   RCS: $Id: texas_inst_amplifier.m4,v 1.0 1998/04/17 01:00:00 huiban Exp $
#
define(`Description_TL031_dil', `Single enhanced JFET low-power low-offset operational amplifier')
define(`Param1_TL031_dil', 8)
define(`Param2_TL031_dil', 300)
define(`PinList_TL031_dil',  ``OfsN1',`In-',`In+',`Vcc-',`OfsN2',`Out',`Vcc+',`NC'')

define(`Description_TL032_dil', `Dual enhanced JFET low-power low-offset operational amplifiers')
define(`Param1_TL032_dil', 8)
define(`Param2_TL032_dil', 300)
define(`PinList_TL032_dil',  ``Out1',`In1-',`In1+',`Vcc-',`In2+',`In2-',`Out2',`Vcc+'')

define(`Description_TL034_dil', `Quad enhanced JFET low-power low-offset operational amplifiers')
define(`Param1_TL034_dil', 14)
define(`Param2_TL034_dil', 300)
define(`PinList_TL034_dil',  ``Out1',`In1-',`In1+',`Vcc+',`In2+',`In2-',`Out2',`Out3',`In3-',`In3+',`Vcc-',`In4+',`In4-',`Out4'')

define(`Description_TL051_dil', `Single Enhanced JFET precision operational amplifier')
define(`Param1_TL051_dil', 8)
define(`Param2_TL051_dil', 300)
define(`PinList_TL051_dil',  ``OfsN1',`In-',`In+',`Vcc-',`OfsN2',`Out',`Vcc+',`NC'')

define(`Description_TL052_dil', `Dual enhanced JFET precision operational amplifiers')
define(`Param1_TL052_dil', 8)
define(`Param2_TL052_dil', 300)
define(`PinList_TL052_dil',  ``Out1',`In1-',`In1+',`Vcc-',`In2+',`In2-',`Out2',`Vcc+'')

define(`Description_TL054_dil', `Quad enhanced JFET precision  operational amplifiers')
define(`Param1_TL054_dil', 14)
define(`Param2_TL054_dil', 300)
define(`PinList_TL054_dil',  ``Out1',`In1-',`In1+',`Vcc+',`In2+',`In2-',`Out2',`Out3',`In3-',`In3+',`Vcc-',`In4+',`In4-',`Out4'')

define(`Description_TL060_dil', `Single low-power  JFET-input operational amplifier')
define(`Param1_TL060_dil', 8)
define(`Param2_TL060_dil', 300)
define(`PinList_TL060_dil',  ``N1Comp',`In-',`In+',`Vcc-',`OfsN2',`Out',`Vcc+',`Comp'')

define(`Description_TL061_dil', `Single low-power JFET-input operational amplifier')
define(`Param1_TL061_dil', 8)
define(`Param2_TL061_dil', 300)
define(`PinList_TL061_dil',  ``OfsN1',`In-',`In+',`Vcc-',`OfsN2',`Out',`Vcc+',`NC'')

define(`Description_TL062_dil', `Dual low-power JFET-input operational amplifiers')
define(`Param1_TL062_dil', 8)
define(`Param2_TL062_dil', 300)
define(`PinList_TL062_dil',  ``Out1',`In1-',`In1+',`Vcc-',`In2+',`In2-',`Out2',`Vcc+'')

define(`Description_TL064_dil', `Quad low-power JFET-input operational amplifiers')
define(`Param1_TL064_dil', 14)
define(`Param2_TL064_dil', 300)
define(`PinList_TL064_dil',  ``Out1',`In1-',`In1+',`Vcc+',`In2+',`In2-',`Out2',`Out4',`In4-',`In4+',`Vcc-',`In3+',`In3-',`Out3'')

define(`Description_TL070_dil', `Single low-noise JFET-input operational amplifier')
define(`Param1_TL070_dil', 8)
define(`Param2_TL070_dil', 300)
define(`PinList_TL070_dil',  ``N1Comp',`In-',`In+',`Vcc-',`OfsN2',`Out',`Vcc+',`Comp'')

define(`Description_TL071_dil', `Single low-noise JFET-input operational amplifier')
define(`Param1_TL071_dil', 8)
define(`Param2_TL071_dil', 300)
define(`PinList_TL071_dil',  ``OfsN1',`In-',`In+',`Vcc-',`OfsN2',`Out',`Vcc+',`NC'')

define(`Description_TL072_dil', `Dual low-noise JFET-input operational amplifiers')
define(`Param1_TL072_dil', 8)
define(`Param2_TL072_dil', 300)
define(`PinList_TL072_dil',  ``Out1',`In1-',`In1+',`Vcc-',`In2+',`In2-',`Out2',`Vcc+'')

define(`Description_TL074_dil', `Quad low-noise JFET-input operational amplifiers')
define(`Param1_TL074_dil', 14)
define(`Param2_TL074_dil', 300)
define(`PinList_TL074_dil',  ``Out1',`In1-',`In1+',`Vcc+',`In2+',`In2-',`Out2',`Out4',`In4-',`In4+',`Vcc-',`In3+',`In3-',`Out3'')

define(`Description_TL075_dil', `Quad low-noise JFET-input operational amplifiers')
define(`Param1_TL075_dil', 14)
define(`Param2_TL075_dil', 300)
define(`PinList_TL075_dil',  ``In1-',`In1+',`Out1',`Out2',`In2+',`In2-',`Vcc-',`In4-',`In4+',`Out4',`Vcc+',`Out3',`In3+',`In3-'')

define(`Description_TL080_dil', `Single JFET-input operational amplifier')
define(`Param1_TL080_dil', 8)
define(`Param2_TL080_dil', 300)
define(`PinList_TL080_dil',  ``N1Comp',`In-',`In+',`Vcc-',`OfsN2',`Out',`Vcc+',`Comp'')

define(`Description_TL081_dil', `Single JFET-input operational amplifier')
define(`Param1_TL081_dil', 8)
define(`Param2_TL081_dil', 300)
define(`PinList_TL081_dil',  ``OfsN1',`In-',`In+',`Vcc-',`OfsN2',`Out',`Vcc+',`NC'')

define(`Description_TL082_dil', `Dual JFET-input operational amplifiers')
define(`Param1_TL082_dil', 8)
define(`Param2_TL082_dil', 300)
define(`PinList_TL082_dil',  ``Out1',`In1-',`In1+',`Vcc-',`In2+',`In2-',`Out2',`Vcc+'')

define(`Description_TL083_dil', `Dual JFET-input operational amplifiers')
define(`Param1_TL083_dil', 14)
define(`Param2_TL083_dil', 300)
define(`PinList_TL083_dil',  ``#1 In-',`#1 In+',`#1 OfsN2',`Vcc-',`#2 OfsN2',`#2 In+', \
	`#2 In-',`#2 OfsN1',`Vcc+',`#2 Out',`NC',`#1 Out',`Vcc+',`#1 OfsN1'')

define(`Description_TL084_dil', `Quad JFET-input operational amplifiers')
define(`Param1_TL084_dil', 14)
define(`Param2_TL084_dil', 300)
define(`PinList_TL084_dil',  ``Out1',`In1-',`In1+',`Vcc+',`In2+',`In2-',`Out2',`Out3',`In3-',`In3+',`Vcc-',`In4+',`In4-',`Out4'')

define(`Description_TL085_dil', `Quad JFET-input operational amplifiers')
define(`Param1_TL085_dil', 14)
define(`Param2_TL085_dil', 300)
define(`PinList_TL085_dil',  ``In1-',`In1+',`Out1',`Out2',`In2+',`In2-',`Vcc-',`In3-',`In3+',`Out3',`Vcc+',`Out4',`In4+',`In4-'')

define(`Description_TL087_dil', `Single JFET-input operational amplifier')
define(`Param1_TL087_dil', 8)
define(`Param2_TL087_dil', 300)
define(`PinList_TL087_dil',  ``OfsN1',`In-',`In+',`Vcc-',`OfsN2',`Out',`Vcc+',`NC'')

define(`Description_TL287_dil', `Dual JFET-input operational amplifiers')
define(`Param1_TL287_dil', 8)
define(`Param2_TL287_dil', 300)
define(`PinList_TL287_dil',  ``Out1',`In1-',`In1+',`Vcc-',`In2+',`In2-',`Out2',`Vcc+'')

define(`Description_TL136_dil', `Quad high-performance operational amplifiers')
define(`Param1_TL136_dil', 14)
define(`Param2_TL136_dil', 300)
define(`PinList_TL136_dil',  ``Out1',`In1-',`In1+',`Vcc+',`In2+',`In2-',`Out2',`Out3',`In3-',`In3+',`Vcc-',`In4+',`In4-',`Out4'')

define(`Description_TL321_dil', `Single operational amplifier')
define(`Param1_TL321_dil', 8)
define(`Param2_TL321_dil', 300)
define(`PinList_TL321_dil',  ``NC',`In-',`In+',`Gnd',`NC',`Out',`Vcc+',`NC'')

define(`Description_TL322_dil', `Dual low-power operational amplifiers')
define(`Param1_TL322_dil', 8)
define(`Param2_TL322_dil', 300)
define(`PinList_TL322_dil',  ``Out1',`In1-',`In1+',`Gnd',`In2+',`In2-',`Out2',`Vcc+'')

define(`Description_TLC251_dil', `Single programmable low power operational amplifier')
define(`Param1_TLC271_dil', 8)
define(`Param2_TLC271_dil', 300)
define(`PinList_TLC271_dil',  ``OfsN1',`In-',`In+',`Gnd',`OfsN2',`Out',`Vdd',`BiasSelect'')

define(`Description_TLC252_dil', `Dual operational amplifiers')
define(`Param1_TLC272_dil', 8)
define(`Param2_TLC272_dil', 300)
define(`PinList_TLC272_dil',  ``Out1',`In1-',`In1+',`Gnd',`In2+',`In2-',`Out2',`Vdd'')

define(`Description_TLC254_dil', `Quad operational amplifiers')
define(`Param1_TLC274_dil', 14)
define(`Param2_TLC274_dil', 300)
define(`PinList_TLC274_dil',  ``Out1',`In1-',`In1+',`Vdd',`In2+',`In2-',`Out2',`Out3',`In3-',`In3+',`Gnd',`In4+',`In4-',`Out4'')

define(`Description_TLC271_dil', `Single programmable low power operational amplifier')
define(`Param1_TLC271_dil', 8)
define(`Param2_TLC271_dil', 300)
define(`PinList_TLC271_dil',  ``OfsN1',`In-',`In+',`Gnd',`OfsN2',`Out',`Vdd',`BiasSelect'')

define(`Description_TLC272_dil', `Dual precision operational amplifiers')
define(`Param1_TLC272_dil', 8)
define(`Param2_TLC272_dil', 300)
define(`PinList_TLC272_dil',  ``Out1',`In1-',`In1+',`Gnd',`In2+',`In2-',`Out2',`Vdd'')

define(`Description_TLC274_dil', `Quad precision operational amplifiers')
define(`Param1_TLC274_dil', 14)
define(`Param2_TLC274_dil', 300)
define(`PinList_TLC274_dil',  ``Out1',`In1-',`In1+',`Vdd',`In2+',`In2-',`Out2',`Out3',`In3-',`In3+',`Gnd',`In4+',`In4-',`Out4'')

define(`Description_TLC1078_dil', `Dual uPower precision operational amplifiers')
define(`Param1_TLC1078_dil', 8)
define(`Param2_TLC1078_dil', 300)
define(`PinList_TLC1078_dil',  ``Out1',`In1-',`In1+',`Gnd',`In2+',`In2-',`Out2',`Vdd'')

define(`Description_TLC1079_dil', `Quad uPower precision operational amplifiers')
define(`Param1_TLC1079_dil', 14)
define(`Param2_TLC1079_dil', 300)
define(`PinList_TLC1079_dil',  ``Out1',`In1-',`In1+',`Vdd',`In2+',`In2-',`Out2',`Out3',`In3-',`In3+',`Gnd',`In4+',`In4-',`Out4'')

define(`Description_LM324_dil', `Quad operational amplifiers')
define(`Param1_LM324_dil', 14)
define(`Param2_LM324_dil', 300)
define(`PinList_LM324_dil',  ``Out1',`In1-',`In1+',`Vcc',`In2+',`In2-',`Out2',`Out3',`In3-',`In3+',`Gnd',`In4+',`In4-',`Out4'')

define(`Description_uA709_dil', `Single general purpose operational amplifier')
define(`Param1_uA709_dil', 8)
define(`Param2_uA709_dil', 300)
define(`PinList_uA709_dil',  ``FreqCompB',`In-',`In+',`Vcc-',`OutFreqComp',`Out',`Vcc+',`FreqCompA'')

define(`Description_uA709J_dil', `Single general purpose operational amplifier')
define(`Param1_uA709J_dil', 14)
define(`Param2_uA709J_dil', 300)
define(`PinList_uA709J_dil',  ``NC',`NC',`FreqCompB',`In-',`In+',`Vcc-',`NC',`NC',`OutFreqComp',`Out',`Vcc+',`FreqCompA',`NC',`NC'')

define(`Description_uA741_dil', `Single general purpose operational amplifier')
define(`Param1_uA741_dil', 8)
define(`Param2_uA741_dil', 300)
define(`PinList_uA741_dil',  ``OfsN1',`In-',`In+',`Vcc-',`OfsN2',`Out',`Vcc+',`NC'')

define(`Description_uA741J_dil', `Single general purpose operational amplifier')
define(`Param1_uA741J_dil', 14)
define(`Param2_uA741J_dil', 300)
define(`PinList_uA741J_dil',  ``NC',`NC',`OfsN1',`In-',`In+',`Vcc-',`NC',`NC',`OfsN2',`Out',`Vcc+',`NC',`NC',`NC'')

define(`Description_uA747_dil', `Dual general purpose operational amplifiers')
define(`Param1_uA747_dil', 14)
define(`Param2_uA747_dil', 300)
define(`PinList_uA747_dil',  ``#1 In-',`#1 In+',`#1 OfsN2',`Vcc-',`#2 OfsN2',`#2 In+',`#2 In-',`#2 OfsN1',`#2 Vcc+',`#2 Out',`NC',`#1 Out',`#1 Vcc+',`#1 OfsN1'')

define(`Description_uA748_dil', `Single general purpose operational amplifier')
define(`Param1_uA748_dil', 8)
define(`Param2_uA748_dil', 300)
define(`PinList_uA748_dil',  ``N1Comp',`In-',`In+',`Vcc-',`OfsN2',`Out',`Vcc+',`Comp'')

define(`Description_LM358_dil', `Dual operational amplifiers')
define(`Param1_LM358_dil', 8)
define(`Param2_LM358_dil', 300)
define(`PinList_LM358_dil',  ``Out1',`In1-',`In1+',`Gnd',`In2+',`In2-',`Out2',`Vcc'')

define(`Description_LF347_dil', `Wide-bandwidth Quad JFET-input operational amplifiers')
define(`Param1_LF347_dil', 14)
define(`Param2_LF347_dil', 300)
define(`PinList_LF347_dil',  ``Out1',`In1-',`In1+',`Vcc+',`In2+',`In2-',`Out2',`Out3',`In3-',`In3+',`Vcc-',`In4+',`In4-',`Out4'')

define(`Description_LF351_dil', `Wide-bandwidth JFET-input operational amplifier')
define(`Param1_LF351_dil', 8)
define(`Param2_LF351_dil', 300)
define(`PinList_LF351_dil',  ``Bal1',`In-',`In+',`Vcc-',`Bal2',`Out',`Vcc+',`NC'')

define(`Description_LF353_dil', `Wide-bandwidth dual JFET input operational amplifiers')
define(`Param1_LF353_dil', 8)
define(`Param2_LF353_dil', 300)
define(`PinList_LF353_dil',  ``Out1',`In1-',`In1+',`Vcc-',`In2+',`In2-',`Out2',`Vcc+'')

define(`Description_LF411_dil', `JFET input operational amplifier')
define(`Param1_LF411_dil', 8)
define(`Param2_LF411_dil', 300)
define(`PinList_LF411_dil',  ``Bal1',`In-',`In+',`Vcc-',`Bal2',`Out',`Vcc+',`NC'')

define(`Description_LF412_dil', `Dual JFET input operational amplifiers')
define(`Param1_LF412_dil', 8)
define(`Param2_LF412_dil', 300)
define(`PinList_LF412_dil',  ``Out1',`In1-',`In1+',`Vcc-',`In2+',`In2-',`Out2',`Vcc+'')

define(`Description_LM101_dil', `High performance operational amplifier')
define(`Param1_LM101_dil', 8)
define(`Param2_LM101_dil', 300)
define(`PinList_LM101_dil',  ``N1Comp',`In-',`In+',`Vcc-',`OfsN2',`Out',`Vcc+',`Comp'')

define(`Description_LM107_dil', `High performance operational amplifier')
define(`Param1_LM107_dil', 8)
define(`Param2_LM107_dil', 300)
define(`PinList_LM107_dil',  ``NC',`In-',`In+',`Vcc-',`NC',`Out',`Vcc+',`NC'')

define(`Description_LM107J_dil', `High performance operational amplifier')
define(`Param1_LM107J_dil', 14)
define(`Param2_LM107J_dil', 300)
define(`PinList_LM107J_dil',  ``NC',`NC',`NC',`In-',`In+',`Vcc-',`NC',`NC',`NC',`Out',`Vcc+',`NC',`NC',`NC'')

define(`Description_LM108_dil', `Operational amplifier')
define(`Param1_LM108_dil', 8)
define(`Param2_LM108_dil', 300)
define(`PinList_LM108_dil',  ``Comp1',`In-',`In+',`Vcc-',`NC',`Out',`Vcc+',`Comp2'')

define(`Description_LM148_dil', `Quad operational amplifiers')
define(`Param1_LM148_dil', 14)
define(`Param2_LM148_dil', 300)
define(`PinList_LM148_dil',  ``Out1',`In1-',`In1+',`Vcc+',`In2+',`In2-',`Out2',`Out3',`In3-',`In3+',`Vcc-',`In4+',`In4-',`Out4'')

define(`Description_LM218_dil', `High performance operational amplifier')
define(`Param1_LM218_dil', 8)
define(`Param2_LM218_dil', 300)
define(`PinList_LM218_dil',  ``Balcomp',`In-',`In+',`Vcc-',`Balcomp3',`Out',`Vcc+',`Comp2'')

define(`Description_LM2900_dil', `Quad Norton operational amplifiers')
define(`Param1_LM2900_dil', 14)
define(`Param2_LM2900_dil', 300)
define(`PinList_LM2900_dil',  ``#1in+',`#2in+',`#2in-',`#2out',`#1out',`#1in-',`Gnd',`#3in-',`#3out-',`#4out',`#4in-',`#4in+',`#3in+',`Vcc'')

define(`Description_LT1001_dil', `Precision operational amplifier')
define(`Param1_LT1001_dil', 8)
define(`Param2_LT1001_dil', 300)
define(`PinList_LT1001_dil',  ``VioTrim',`In-',`In+',`Vcc-',`NC',`Out',`Vcc+',`Viotrim'')

define(`Description_LT1007_dil', `Low-noise high speed precision operational amplifier')
define(`Param1_LT1007_dil', 8)
define(`Param2_LT1007_dil', 300)
define(`PinList_LT1007_dil',  ``VioTrim',`In-',`In+',`Vcc-',`NC',`Out',`Vcc+',`Viotrim'')

define(`Description_LT1007DW_dil', `Low-noise high speed precision operational amplifier')
define(`Param1_LT1007DW_dil', 16)
define(`Param2_LT1007DW_dil', 300)
define(`PinList_LT1007DW_dil',  ``NC',`NC',`VioTrim',`In-',`In+',`Vcc-',`NC',`NC',`NC',`NC',`NC',`Out',`Vcc+',`Viotrim',`NC',`NC'')

define(`Description_LT1008_dil', `Picoamp input current microvolt offset low-noise operational amplifier')
define(`Param1_LT1008_dil', 8)
define(`Param2_LT1008_dil', 300)
define(`PinList_LT1008_dil',  ``Comp1',`In-',`In+',`Vcc-',`NC',`Out',`Vcc+',`Comp2'')

define(`Description_LT1012_dil', `High performance low-noise operational amplifier')
define(`Param1_LT1012_dil', 8)
define(`Param2_LT1012_dil', 300)
define(`PinList_LT1012_dil',  ``VioTrim',`In-',`In+',`Vcc-',`Overcomp',`Out',`Vcc+',`VioTrim'')

define(`Description_LT1028_dil', `Ultralow-noise high-speed precision amplifier')
define(`Param1_LT1028_dil', 8)
define(`Param2_LT1028_dil', 300)
define(`PinList_LT1028_dil',  ``VioTrim',`In-',`In+',`Vcc-',`Overcomp',`Out',`Vcc+',`VioTrim'')

define(`Description_LT1028DW_dil', `Ultralow-noise high-speed precision amplifier')
define(`Param1_LT1028DW_dil', 16)
define(`Param2_LT1028DW_dil', 300)
define(`PinList_LT1028DW_dil',  ``NC',`NC',`VioTrim',`In-',`In+',`Vcc-',`NC',`NC',`NC',`NC',`Overcomp',`Out',`Vcc+',`VioTrim',`NC',`NC'')

define(`Description_MC1558_dil', `Dual general purpose operational amplifiers')
define(`Param1_MC1558_dil', 8)
define(`Param2_MC1558_dil', 300)
define(`PinList_MC1558_dil',  ``Out1',`In1-',`In1+',`Vcc-',`In2+',`In2-',`Out2',`Vcc+'')

define(`Description_MC3303_dil', `Quad low power operational amplifiers')
define(`Param1_MC3303_dil', 14)
define(`Param2_MC3303_dil', 300)
define(`PinList_M3303_dil',  ``Out1',`In1-',`In1+',`Vcc+',`In2+',`In2-',`Out2',`Out3',`In3-',`In3+',`Vcc-',`In4+',`In4-',`Out4'')

define(`Description_NE5532_dil', `Dual low-noise operational amplifiers')
define(`Param1_NE5532_dil', 8)
define(`Param2_NE5532_dil', 300)
define(`PinList_NE5532_dil',  ``Out1',`In1-',`In1+',`Vcc-',`In2+',`In2-',`Out2',`Vcc+'')

define(`Description_NE5534_dil', `Low-noise operational amplifier')
define(`Param1_NE5534_dil', 8)
define(`Param2_NE5534_dil', 300)
define(`PinList_NE5534_dil',  ``Balance',`In-',`In+',`Vcc-',`Comp',`Out',`Vcc+',`CompBal'')

define(`Description_OP07_dil', `Ultra-low-offset-voltage operational amplifier')
define(`Param1_OP07_dil', 8)
define(`Param2_OP07_dil', 300)
define(`PinList_OP07_dil',  ``OfsN1',`In-',`In+',`Vcc-',`NC',`Out',`Vcc+',`OfsN2'')

define(`Description_OP27_dil', `Low-noise high speed precision operational amplifier')
define(`Param1_OP27_dil', 8)
define(`Param2_OP27_dil', 300)
define(`PinList_OP27_dil',  ``VioTrim',`In-',`In+',`Vcc-',`NC',`Out',`Vcc+',`Viotrim'')

define(`Description_RC4559_dil', `Dual high performance operational amplifiers')
define(`Param1_RC4559_dil', 8)
define(`Param2_RC4559_dil', 300)
define(`PinList_RC4559_dil',  ``Out1',`In1-',`In1+',`Vcc-',`In2+',`In2-',`Out2',`Vcc+'')

define(`Description_RM4136_dil', `Quad high performance operational amplifiers')
define(`Param1_RM4136_dil', 14)
define(`Param2_RM4136_dil', 300)
define(`PinList_RM4136_dil',  ``In1-',`In1+',`Out1',`Out2',`In2+',`In2-',`Vcc-',`In3-',`In3+',`Out3',`Vcc+',`Out4',`In4+',`In4-'')

define(`Description_RM4558_dil', `Dual high performance operational amplifiers')
define(`Param1_RM4558_dil', 8)
define(`Param2_RM4558_dil', 300)
define(`PinList_RM4558_dil',  ``Out1',`In1-',`In1+',`Vcc-',`In2+',`In2-',`Out2',`Vcc+'')

divert(0)dnl
