
# NAME

osmium-add-locations-to-ways - add node locations to ways in OSM file


# SYNOPSIS

**osmium add-locations-to-ways** \[*OPTIONS*\] *OSM-FILE*...


# DESCRIPTION

Usually only nodes have locations and the ways refer to those locations via the
IDs of the nodes. This program will copy the input file(s) to the output,
taking the locations from the nodes and adding them to the ways. This makes
it easier for other programs to assemble the way geometries.

The input file must contain all nodes needed for the ways, otherwise there will
be an error. You can change this behaviour using the `--ignore-missing-nodes`
option.

Nodes without any tags will not be copied (unless the **--keep-untagged-nodes**,
**-n** option is used). The size of the output file will be similar or a bit
smaller than the input file (unless the **--keep-untagged-nodes**,
**-n** option is used in which case it will be a lot bigger).

Note that the OSM files generated by this command use a non-standard format
extension.

The node locations have to be kept in memory while doings this. Use the
**--index-type**, **-i** option to set the index type used. Default is
`sparse_mmap_array` on Linux and `sparse_mem_array` on OSX/Windows. This is
the right index type for small to medium sized extracts. For large
(continent-sized) extracts or the full planet use `dense_mmap_array` on Linux
or `dense_mem_array` on OSX/Windows.

This program will not work on full history files.


# OPTIONS

-i, --index-type=TYPE
:   Set the index type.

-I, --show-index-types
:   Shows a list of available index types. It depends on your operating system
    which index types are available.

-n, --keep-untagged-nodes
:   Keep the untagged nodes in the output file.

--ignore-missing-nodes
:   If this is not set a missing node needed for a way results in an error.
    If this is set, errors are ignored and the way will have an invalid
    location set for the missing node.

@MAN_COMMON_OPTIONS@
@MAN_PROGRESS_OPTIONS@
@MAN_INPUT_OPTIONS@
@MAN_OUTPUT_OPTIONS@

# DIAGNOSTICS

**osmium add-locations-to-ways** exits with exit code

0
  ~ if everything went alright,

1
  ~ if there was an error processing the data, or

2
  ~ if there was a problem with the command line arguments.


# MEMORY USAGE

**osmium add-locations-to-ways** needs to keep all node locations in memory.
It depends on the index type used how much memory is needed:

* For `sparse` types 16 bytes per node in the input file are used.
* For `dense` types 8 bytes times the largest node ID in the input file
  are used.

The `*_mem_*` types use potentially up to twice this amount.


# EXAMPLES

Add node locations to an extract keeping all nodes:

    osmium add-locations-to-ways -n -o germany-low.osm.pbf germany.osm.pbf

Add node locations to a planet file (without untagged nodes):

    osmium add-locations-to-ways -i dense_mmap_array -o planet-low.osm.pbf planet.osm.pbf


# SEE ALSO

* **osmium**(1), **osmium-file-formats**(5)
* [Osmium website](http://osmcode.org/osmium-tool/)

