###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_office_products_version_900032.nasl 0021 2008-08-13 19:36:44Z aug $#
#
# MS Office Products Version Detection
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Retrieving Version from file (Removed old method and updated with GetVer).
# - By Chandan S <schandan@secpod.com> 10:46:00 2009-04-24
#
# Updated to include detect mechanism for Word Viewer and Word Converter - Sharath S
#
# Updated to include detect mechanism for Excel Viewer - Sharath S
#
# Updated to include detect mechanism for Power Point Viewer - Sharath S
#
# Updated to include detect mechanism for Office Publisher - Sharath S
#
# Updated to include detect mechanism for Office Outlook
#  - By Antu Sanadi <santu@secpod.com> On 2009/10/14
#
# Updated to include detect mechanism for Office Groove and Office Compatibility Pack
#  - By Sharath S <sharaths@secpod.com> On 2009-10-20 #5269
#
# Updated to include detect mechanism for Office Visio Viewer 2007
#  - By Sharath S <sharaths@secpod.com> On 2009-10-29 #5269
#
# Updated to check office installtion by adding registrty key check
#  - By Antu Sanadi <santu@secpod.com> on 2010-03-10 #7621
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900032);
  script_version("$Revision: 7542 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("MS Office Products Version Detection");
  desc = "
  Overview : Retrieve the version of MS Office products from file and
  sets KB.

  Risk factor : None";
  script_description(desc);
  script_summary("Determines the version of Microsoft Office products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Windows");
  script_dependencies("secpod_reg_enum.nasl", "secpod_ms_office_detection_900025.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Microsoft\Office")){
  exit(0);
}

# Word Viewer
wordviewFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                   "\App Paths\wordview.exe", item:"Path");
if(wordviewFile)
{
  wordviewFile += "\WORDVIEW.exe";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:wordviewFile);
  wview = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:wordviewFile);
  wordviewVer = GetVer(file:wview, share:share);
  if(wordviewVer){
    set_kb_item(name:"SMB/Office/WordView/Version", value:wordviewVer);
  }
}

# Excel Viewer (or) PowerPoint Viewer (or) Office Compatibility Pack
key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  if("Microsoft Office Excel Viewer" ><
     registry_get_sz(key:key + item, item:"DisplayName"))
  {
    xlviewVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(xlviewVer != NULL)
    {
      xlviewFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion",
                                   item:"ProgramFilesDir");
      if(xlviewVer =~ "^11(\..*)")
        xlviewFile += "\Microsoft Office\Office11\XLVIEW.EXE";
      else if(xlviewVer =~ "^12(\..*)")
        xlviewFile += "\Microsoft Office\Office12\XLVIEW.EXE";

      if(xlviewFile != NULL)
      {
        share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:xlviewFile);
        xlview = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:xlviewFile);
        xlviewVer = GetVer(file:xlview, share:share);
        if(xlviewVer != NULL){
          set_kb_item(name:"SMB/Office/XLView/Version", value:xlviewVer);
        }
      }
    }
  }
  else if("Microsoft Office PowerPoint Viewer" ><
     registry_get_sz(key:key + item, item:"DisplayName"))
  {
    pptviewVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(pptviewVer != NULL)
    {
      ppviewFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion",
                                   item:"ProgramFilesDir");
      if(pptviewVer =~ "^11(\..*)")
        ppviewFile += "\Microsoft Office\PowerPoint Viewer\PPTVIEW.exe";
      else if(pptviewVer =~ "^12(\..*)")
        ppviewFile += "\Microsoft Office\Office12\PPTVIEW.exe";
      if(ppviewFile != NULL)
      {
        share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:ppviewFile);
        pptview = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:ppviewFile);
        pptviewVer = GetVer(file:pptview, share:share);
        if(pptviewVer != NULL){
          set_kb_item(name:"SMB/Office/PPView/Version", value:pptviewVer);
        }
      }
    }
  }
  else if("Compatibility Pack" ><
     registry_get_sz(key:key + item, item:"DisplayName"))
  {
    cPackVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(cPackVer != NULL){
      set_kb_item(name:"SMB/Office/ComptPack/Version", value:cPackVer);
    }
  }
}

# Office Groove
groovePath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                 "\App Paths\GROOVE.EXE", item:"Path");
if(groovePath != NULL)
{
  groovePath += "\GROOVE.exe";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:groovePath);
  groove = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:groovePath);
  grooveVer = GetVer(file:groove, share:share);
  if(grooveVer != NULL){
    set_kb_item(name:"SMB/Office/Groove/Version", value:grooveVer);
  }
}

# Office Power Point Convertes
if(registry_key_exists(key:"SOFTWARE\Microsoft\Office"))
{
  ppcnvFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion",
                              item:"ProgramFilesDir");
  if(ppcnvFile)
  {
    ppcnvFile += "\Microsoft Office\Office12\PPCNVCOM.exe";
    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:ppcnvFile);
    ppfile = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:ppcnvFile);
    ppcnvVer = GetVer(file:ppfile, share:share);
    if(ppcnvVer){
      set_kb_item(name:"SMB/Office/PowerPntCnv/Version", value:ppcnvVer);
    }
  }
}

# Office Visio Viewer
if(registry_key_exists(key:"SOFTWARE\Microsoft\Office\Visio"))
{
  visioPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion",
                              item:"ProgramFilesDir");
  if(visioPath)
  {
    visioPath += "\Microsoft Office\Office12\VPREVIEW.EXE";
    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:visioPath);
    vvfile = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:visioPath);
    visiovVer = GetVer(file:vvfile, share:share);
    if(visiovVer){
      set_kb_item(name:"SMB/Office/VisioViewer/Ver", value:visiovVer);
    }
  }
}

# To Conform Office Installation
if(!get_kb_item("MS/Office/Ver") && !registry_key_exists(key:"SOFTWARE\Microsoft\Office" )){
  exit(0);
}

# Office Word
wordFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                               "\App Paths\Winword.exe", item:"Path");
if(wordFile)
{
  wordFile += "\winword.exe";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:wordFile);
  word = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:wordFile);
  wordVer = GetVer(file:word, share:share);
  if(wordVer){
    set_kb_item(name:"SMB/Office/Word/Version", value:wordVer);
  }
}

# Office Excel
excelFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                "\App Paths\Excel.exe", item:"Path");
if(excelFile)
{
  excelFile += "\excel.exe";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:excelFile);
  excel =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:excelFile);
  excelVer = GetVer(file:excel, share:share);
  if(excelVer){
    set_kb_item(name:"SMB/Office/Excel/Version", value:excelVer);
  }
}

# Office Access
accessFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                 "\App Paths\MSACCESS.exe", item:"Path");
if(accessFile)
{
  accessFile += "\msaccess.exe";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:accessFile);
  access = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:accessFile);
  accessVer = GetVer(file:access, share:share);
  if(accessVer){
    set_kb_item(name:"SMB/Office/Access/Version", value:accessVer);
  }
}

# Office PowerPoint
powerpointFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                     "\App Paths\PowerPnt.exe", item:"Path");
if(powerpointFile)
{
  powerpointFile += "\powerpnt.exe";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:powerpointFile);
  power = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:powerpointFile);
  powerPptVer = GetVer(file:power, share:share);
  if(powerPptVer){
    set_kb_item(name:"SMB/Office/PowerPnt/Version", value:powerPptVer);
  }
}

# Office Word Converter
wordcnvFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion",
                              item:"ProgramFilesDir");
if(wordcnvFile)
{
  wordcnvFile += "\Microsoft Office\Office12\Wordconv.exe";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:wordcnvFile);
  word  = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:wordcnvFile);
  wordcnvVer = GetVer(file:word, share:share);
   if(wordcnvVer){
    set_kb_item(name:"SMB/Office/WordCnv/Version", value:wordcnvVer);
  }
}

# Office Excel Converter
xlcnvFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion",
                            item:"ProgramFilesDir");
if(xlcnvFile)
{
  xlcnvFile += "\Microsoft Office\Office12\excelcnv.exe";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:xlcnvFile);
  xlfile = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:xlcnvFile);
  xlcnvVer = GetVer(file:xlfile, share:share);
  if(xlcnvVer){
    set_kb_item(name:"SMB/Office/XLCnv/Version", value:xlcnvVer);
  }
}

# Office Publisher
pubFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                              "\App Paths\MSPUB.EXE", item:"Path");
if(pubFile)
{
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:pubFile);
  pub = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:pubFile + "\MSPUB.exe");
  pubVer = GetVer(file:pub, share:share);
  if(pubVer){
    set_kb_item(name:"SMB/Office/Publisher/Version", value:pubVer);
  }
}

# Office outlook
outlookFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                              "\App Paths\OUTLOOK.EXE", item:"Path");
if(outlookFile)
{
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:outlookFile);
  outlookFile = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                             string:outlookFile + "\OUTLOOK.EXE");
  outlookVer = GetVer(file:outlookFile, share:share);
  if(outlookVer){
    set_kb_item(name:"SMB/Office/Outloook/Version", value:outlookVer);
  }
}
