###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for linux-restricted-modules-2.6.17 regression USN-416-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840144);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "416-2");
  script_name( "Ubuntu Update for linux-restricted-modules-2.6.17 regression USN-416-2");
  desc = "

  Vulnerability Insight:

  USN-416-1 fixed various vulnerabilities in the Linux kernel.
  Unfortunately that update caused the 'nvidia-glx-config' script to not
  work any more. The new version fixes the problem.
  
  We apologize for the inconvenience.

  Affected Software/OS:
  linux-restricted-modules-2.6.17 regression on Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-March/000492.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of linux-restricted-modules-2.6.17 regression");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"avm-fritz-firmware", ver:"2.6.17-11_3.11+2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avm-fritz-kernel-source", ver:"3.11+2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fglrx-control", ver:"8.28.8+2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fglrx-kernel-source", ver:"8.28.8+2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.17-11-386_2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.17-11-generic_2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-dev", ver:"1.0.8776+2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-legacy-dev", ver:"1.0.7184+2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-legacy", ver:"1.0.7184+2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx", ver:"1.0.8776+2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-kernel-source", ver:"1.0.8776+2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-legacy-kernel-source", ver:"1.0.7184+2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"vmware-player-kernel-modules", ver:"2.6.17-11_2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xorg-driver-fglrx-dev", ver:"7.1.0-8.28.8+2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xorg-driver-fglrx", ver:"7.1.0-8.28.8+2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules-common", ver:"2.6.17.7-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}