###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sun_java_ws_code_exec_vuln_lin.nasl 425 2008-11-04 17:50:20Z nov $
#
# Sun Java Web Start Remote Command Execution Vulnerability (Linux)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800127);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-4910");
  script_bugtraq_id(31916);
  script_name("Sun Java Web Start Remote Command Execution Vulnerability (Linux)");
  desc = "
  Overview: This host is running Sun Java Web Start and is prone to Remote
  Command Execution Vulnerability.

  Vulnerability Insight:
  The flaw exist due to weakness in the BasicService showDocument method
  which does not validate the inputs appropriately. This can be exploited
  using a specially crafted Java Web Start application via file:\\ URL
  argument to the showDocument method.
 
  Impact: Successful exploitation allows remote code execution on the
  client machines.

  Impact Level: Application

  Affected Software/OS:
  Sun J2SE 6.0 Update 10 and earlier.

  Fix: No solution/patch is available as on 5th November, 2008. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://java.sun.com/javase/downloads/index.jsp

  References:
  http://xforce.iss.net/xforce/xfdb/46119
  http://archives.neohapsis.com/archives/bugtraq/2008-10/0192.html

  CVSS Score:
    CVSS Base Score     : 5.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 5.2
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Sun Java Web Start");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Gain a shell remotely");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

jwsVer = get_bin_version(full_prog_name:"javaws", version_argv:"-version",
                         ver_pattern:"Java.* Web Start ([0-9._]+)", sock:sock);
jwsVer = ereg_replace(pattern:"_", string:jwsVer[1], replace: ".");

if(jwsVer)
{
  if(version_is_less_equal(version:jwsVer, test_version:"1.6.0.10")){
    security_hole(0);
  }
}
ssh_close_connection();
