###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_electrasoft_32bit_ftp_bof_vuln.nasl 2213 2009-05-11 13:24:41Z may $
#
# ElectraSoft 32bit FTP Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800569);
  script_version("$Revision: 1.1 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1592", "CVE-2009-1611", "CVE-2009-1675");
  script_bugtraq_id(34822, 34838);
  script_name("ElectraSoft 32bit FTP Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is running ElectraSoft 32bit FTP client which is prone
  to Buffer Overflow vulnerability.

  Vulnerability Insight:
  A boundary error occurs while processing,
  - response received from an FTP server with overly long banners.
  - a overly long 257 reply to a CWD command.
  - a overly long 227 reply to a PASV command.

  Impact: Successful exploitation will let the attacker execute arbitrary
  codes within the context of the application by connecting to malicious
  FTP servers or can cause the application to crash.

  Affected Software/OS:
  ElectraSoft 32bit FTP 09.04.24 and prior on Windows

  Fix: Upgrade to 32bit FTP version 09.05.01
  http://www.electrasoft.com/32ftp.htm

  References:
  http://secunia.com/advisories/34993
  http://www.milw0rm.com/exploits/8614
  http://www.milw0rm.com/exploits/8613
  http://www.milw0rm.com/exploits/8623
  http://www.electrasoft.com/readmef.txt
  http://xforce.iss.net/xforce/xfdb/50337

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of ElectraSoft 32bit FTP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_electrasoft_32bit_ftp_detect.nasl");
  script_require_keys("ElectraSoft/FTP/Ver");
  exit(0);
}


include("version_func.inc");

bitftpVer = get_kb_item("ElectraSoft/FTP/Ver");
if(!bitftpVer){
  exit(0);
}

if(version_is_less_equal(version:bitftpVer, test_version:"09.04.24")){
  security_hole(0);
}
