###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_clamav_lzh_dos_vuln_win.nasl 3255 2009-07-03 13:26:22Z jul $
#
# ClamAV LZH File Unpacking Denial of Service Vulnerability (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800596);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-6845");
  script_bugtraq_id(32752);
  script_name("ClamAV LZH File Unpacking Denial of Service Vulnerability (Win)");
  desc = "

  Overview: The host is installed with ClamAV and is prone to Denial of Service
  Vulnerability.

  Vulnerability Insight:
  A segmentation fault ocurs in the unpack feature when processing malicious
  LZH file.

  Impact:
  Attackers can exploit this issue to execute arbitrary code in the context
  of affected application, and can cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  ClamAV 0.93.3 and prior on Windows.

  Fix: Upgrade to ClamAV 0.94 or later
  http://www.clamav.net/download

  References:
  http://osvdb.org/51963
  http://www.ivizsecurity.com/security-advisory-iviz-sr-08011.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of ClamAV");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_clamav_detect_win.nasl");
  script_require_keys("ClamAV/Win/Ver");
  exit(0);
}


include("version_func.inc");

clamavVer = get_kb_item("ClamAV/Win/Ver");
if(clamavVer == NULL){
  exit(0);
}

if(version_is_less_equal(version:clamavVer, test_version:"0.93.3")){
  security_warning(0);
}
