// $Id: FinishFrameEvent.hh 6626 2007-06-15 14:20:52Z m9710797 $

#ifndef FINISHFRAMEEVENT_HH
#define FINISHFRAMEEVENT_HH

#include "Event.hh"
#include "VideoSource.hh"

namespace openmsx {

class FinishFrameEvent: public Event
{
public:
	FinishFrameEvent(VideoSource source_, bool skipped_)
		: Event(OPENMSX_FINISH_FRAME_EVENT)
		, source(source_), skipped(skipped_)
	{
		// nothing
	}

	VideoSource getSource() const { return source; }
	bool isSkipped() const { return skipped; }

private:
	VideoSource source;
	bool skipped;
};

}

#endif
