.\" Copyright (c)  2000, Amnon BARAK (amnon@cs.huji.ac.il)
.\" All rights reserved.
.\"
.\"	MOSIX $Id: mosrun.man,v 1.4 2000/12/18 17:01:53 amnons Exp $
.\"
.\" Permission to use, copy and distribute this software is hereby granted
.\" under the terms of version 2 or any later version of the GNU General
.\" Public License, as published by the Free Software Foundation.
.\"
.\" THIS MANUAL IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
.\" WHATSOEVER. NO LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING
.\" FROM THE USE OF THIS MANUAL WILL BE ACCEPTED.
.\"
.Dd May 3, 1999
.Dt MOSRUN 1
.ds vT MOSIX Reference Manual
.Os MOSIX
.Sh NAME
.Nm \&mosrun
.Nd run a command with particular node-allocation preferences
.Sh SYNOPSIS
.Nm \&mosrun
.Pa [ -{h
|
.Pa MOSIX_ID
|
.Pa jID1-ID2 [ ,ID3-ID4 ] ...
.Pa }
.Op Fl F ]
.Op Fl {l|L|k}
.Pa [ -{c|i|n|s|f| [ -t tt ]
.Pa [ -d dec ] }
.Pa [ -{e|E} ]
.Pa [ -{r|R} ] ]
.Op Fl z
.br
.Pa command
[
.Pa arg ...
]
.sp
.Nm \&nomig
.Op Fl z
.Pa command
[
.Pa arg ...
]
.sp
.Nm \&runhome
.Op Fl z
.Pa command
[
.Pa arg ...
]
.sp
.Nm \&runon
.Pa MOSIX_ID
.Op Fl z
.Pa command
[
.Pa arg ...
]
.sp
.Nm \&cpujob 
.Op Fl {h|MOSIX_id}
.Op Fl z
.Pa command
[
.Pa arg ...
]
.sp
.Nm \&iojob 
.Op Fl {h|MOSIX_id}
.Op Fl z
.Pa command
[
.Pa arg ...
]
.sp
.Nm \&nodecay 
.Op Fl {h|MOSIX_id}
.Op Fl z
.Pa command
[
.Pa arg ...
]
.sp
.Nm \&slowdecay 
.Op Fl {h|MOSIX_id}
.Op Fl z
.Pa command
[
.Pa arg ...
]
.sp
.Nm \&fastdecay 
.Op Fl {h|MOSIX_id}
.Op Fl z
.Pa command
[
.Pa arg ...
]
.Sh DESCRIPTION
.Nm \&mosrun
runs a
.Pa command
while advising MOSIX about the placement, node-lock status and the best
method of decaying its MOSIX per-process statistics to suit the program's
behaviour.
.Pp
The
.Pa -h
option (h for "home") requests that the
.Pa command
be run on the home node.  Similarly, a numeric option
.Pa ( -MOSIX_ID )
requests that the process be run on a particular MOSIX node.
.Pa mosrun
will fail should that node be unavailable, unless the
.Pa -F
option is specified, in which case, the program could run anywhere.
The
.Pa -jID-LIST
option selects a random node from among the supplied list of nodes.
the list should be comma-separated and may contain any combination of
either single MOSIX node numbers, or dash-separated range of MOSIX nodes.
Again,
.Pa mosrun
will fail should the selected random node be unavailable (unless the
.Pa -F
option is specified).
.Pp
The node-lock, preventing automatic process-migrations (except in
emergencies, such as when a node is being shut-down, in which case
the processes will migrate to their home-node), can be controlled
via one of the
.Pa -l
(unlock),
.Pa -L
(lock) or
.Pa -k
(keep) flags.
.br
The default is to lock whenever either
.Pa -h ,
.Pa -MOSIX_ID
or
.Pa -j
are specified or when no decay options are specified and to otherwise keep
the status as per the calling shell/program.
.Pp
The
.Pa -c
option advises MOSIX that the program is heavy user-mode computational and
should therefore ignore the statistics of any I/O or other system-calls.
.Pp
The
.Pa -i
option advises MOSIX that the program uses heavy I/O or other system calls
and should therefore ignore the statistics of any user-mode CPU usage.
.Pp
The
.Pa -n
option advises MOSIX that the program runs an irregular pattern of mixed
CPU and I/O (or other system-calls), thus decaying should not be applied.
.Pp
The
.Pa -s
option advises MOSIX to apply slow decaying over the program's statistics
(this is also MOSIX's default).
.Pp
The
.Pa -f
option advises MOSIX to apply fast decaying over the program's statistics,
indicating a program that alternates between large-granularity chunks of CPU
and I/O (or other system-calls).
.Pp
The
.Pa -d
option and/or the
.Pa -t
option specifies explicitly how often to decay the statistics for the program
and what portion of the statistics should remain after decaying:
.Pa tt
specifies the interval between decays in seconds and
.Pa dec
specifies the (integer) portion to keep out of 1000 units.
If only one of
.Pa -d
or
.Pa -t
is specified, the other is obtained from
.br
the current decaying policy (or if the current policy is either
.Pa -c
or
.Pa -i ,
.br
from the current default settings, eg. of a slow decay).
.Pp
The
.Pa -e
argument specifies that the new decaying preferences will cease to apply for
any of the generated processes that performs a successful
.Pa exec(3)
system call.
.Pa -E
(the default) specifies that the decaying preferences be kept even across an
.Pa exec(3) .
.Pp
The
.Pa -r
argument specifies that the new decaying preferences will not be inherited to
the program's child processes (and further descendants), while
.Pa -R
(the default) specifies that the decaying preferences be inherited.
.Pp
The
.Fl z
argument specifies that the argument-list begins with argument number zero
(which is normally identical to the
\fBcommand\fR),
rather than the usual argument number one.
.Pp
Without any options,
.Pa 'mosrun command arg ...'
is equivalent to
.br
.Pa  'mosrun -L command arg ...' .
.Pp
On a plain, non-MOSIX Linux operating system,
.Pa mosrun
will simply spawn the
.Pa command
with no side-effects.
.Pp
The following scripts operate as simple front-ends to
.Pa mosrun :
.Pp
.Pa Nomig
runs a
.Pa command
with a node-lock.
.Pp
.Pa Runhome
runs a
.Pa command
locked at the home node.
.Pp
.Pa runon
runs a
.Pa command
locked on a particular MOSIX node.
.Pp
.Pa cpujob
runs a
.Pa command ,
advising MOSIX that it is a computation intensive program.
.Pp
.Pa iojob
runs a
.Pa command ,
advising MOSIX that it is an I/O intensive program.
.sp
.Pp
.Pa nodecay
runs a
.Pa command ,
advising MOSIX to not decay the program's statistics.
.Pp
.Pa slowdecay
runs a
.Pa command ,
advising MOSIX to apply slow statistics-decaying.
.Pp
.Pa fastdecay
runs a
.Pa command
advising MOSIX to apply fast statistics-decaying.
.Sh EXAMPLES
.sp
.sp
.Pa mosrun -7 -F -c program
.sp
runs a computation-intensive
.Pa program
on MOSIX node #7, if available.
.sp
.Pa mosrun -j2-5,7,10-16 program arg
.sp
runs a program on a random node among node numbers 2-5, 7 or 10-16.
.sp
.Pp
.Pa mosrun -h -l -i -r job_manager file-name
.sp
runs a program (job_manager) initially on the home-node,
but allowing it to subsequently migrate.  MOSIX is informed that the main
process, a manager is heavily I/O bound, but that its children are not so
necessarily.
.Pp
.Pa mosrun -t 1 -d 700 two_phases
.sp
runs a program that alternates between a relatively long I/O phase and a
computational phase.  MOSIX is advised to decay the statistics very quickly -
leaving only 70% every second, so that the program is migrated away quickly
between the home node and a most available/fast node whenever it switches
between stages.
.Sh SEE ALSO
.Xr mosix 7 .
.Sh HISTORY
.Pa mosrun
is a MOSIX utility.
