/*
 * Copyright (C) 2000, 2001, Amnon Barak (amnon@cs.huji.ac.il)
 *
 * Permission to use this software is hereby granted under the terms of the
 * GNU General Public License, as published by the Free Software Foundation.
 *
 * THIS  SOFTWARE  IS  PROVIDED IN ITS  "AS IS"  CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Oren Laadan, Amnon Shiloh.
 */

#ifndef _MOS_MOSCTL_H
#define _MOS_MOSCTL_H

/*
 * MOSIX API
 */

/* migration requests via /proc/nnnnn/goto */

#define DM_GOBACKHOME    0       /* just go back home */
#define DM_BALANCE       (-1)    /* perform load balancing */


/* constants for status report (/proc/mosix/nodes/nnn/status) */

#define	DS_MOSIX_DEF	0x001
#define DS_MOSIX_UP     0x002
#define DS_STAY         0x004
#define DS_LSTAY        0x008
#define DS_BLOCK        0x010
#define DS_QUIET        0x020
#define DS_NOMFS        0x040


/* constants for statictics decay */

#define DADV_CPU        1       /* a pure CPU task */
#define DADV_NOCPU      2       /* a non-computational task */
#define DADV_NODECAY    3       /* task of a uniform mix of rapid changes */
#define DADV_SLOWDECAY  4       /* task may change its nature over long run */
#define DADV_FASTDECAY  5       /* task changes its nature frequently */
#define DADV_OWNDECAY   6       /* task defined its own decay policy */

#define DADV_POLICY     0x00F   /* policy mask */

#define DADV_CLEAR      0x010   /* clear statistics: nature is changing */
#define DADV_INHERIT    0x020   /* children of same nature */
#define DADV_EXEC       0x040   /* maintain advice after exec */
#define DADV_EXECONCE   0x080   /* maintain advice after only the next exec */
#define DADV_NOINHERIT  0x100   /* cancel inheritance */
#define DADV_NOEXEC     0x200   /* cancel advice on exec */
#define DADV_NOEXECONCE 0x400   /* cancel DADV_EXECONCE */
#define DADV_ENQUIRE    0x1000  /* enquire decay policy */

#define DADV_DEFAULT    DADV_SLOWDECAY

#define DECAY_QUOTIENT  1000    /* quotient for the "decay" argument */


/* load information */

struct mosix_info {
        unsigned long load;
        unsigned short speed;
        unsigned short ncpus;
        unsigned short util;
        unsigned short status;
        unsigned int mem;
        unsigned int rmem;
        unsigned int tmem;
#ifdef CONFIG_MOSIX_RESEARCH
        unsigned int rio;   /* read io  */
        unsigned int wio;   /* write io */
#endif /* CONFIG_MOSIX_REASEARCH */
};

#endif
