/*
 * Copyright (C) 2000, 2001, Amnon Barak (amnon@cs.huji.ac.il)
 *
 * Permission to use this software is hereby granted under the terms of the
 * GNU General Public License, as published by the Free Software Foundation.
 *
 * THIS  SOFTWARE  IS  PROVIDED IN ITS  "AS IS"  CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Oren Laadan.
 */

#ifndef _MOS_LOG_H
#define _MOS_LOG_H


#define MOSIX_LOG_LEN		30
#define MOSIX_LOG_POS(x)	(x)[MOSIX_LOG_LEN]

#define MOSIX_LOG_SENDTYPE	1
#define MOSIX_LOG_RECVTYPE	2
#define MOSIX_LOG_RECEIVE	3
#define MOSIX_LOG_SENDHDR	4
#define MOSIX_LOG_RECVHDR	5
#define MOSIX_LOG_SENDDATA	6
#define MOSIX_LOG_RECVDATA	7
#define MOSIX_LOG_SENDURG	8
#define MOSIX_LOG_RECVURG	9
#define MOSIX_LOG_RETURNVAL	10


#ifdef CONFIG_MOSIX_DEBUG
void add_mosix_log(struct task_struct *, int, int);
#else
#define add_mosix_log(x,y,z)	do {} while (0)
#endif /* CONFIG_MOSIX_DEBUG */


#define add_mosix_log_hdr(p, type, hlen, olen) \
	add_mosix_log((p), (type), \
		( ((hlen) & 0xffff) + (((olen) & 0xff) << 16) ) & 0x00ffffff)

#define add_mosix_log_ret(p, err) \
	add_mosix_log((p), MOSIX_LOG_RETURNVAL, (-(err)) & 0x00ffffff)

#endif /* _MOSIX_LOG_H */
