/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of Opensourced MCL.

   Opensourced MCL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   Opensourced MCL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "Threads.h"
#include <stdio.h>
#include <signal.h>

void
signal_handler(int signum)
{
  fprintf(stderr, "Signal %d \n", signum);
  exit(1);
}

void
bogus()
{
  __asm__ volatile("li 3,51");
  __asm__ volatile("tweqi 3,51");
}
   
void
threadentry(void *param)
{
  ThreadID next  = (ThreadID)param;

  bogus();
  fprintf(stderr, "next thread = %d\n", next);
  YieldToThread(next);
}

main()
{
  ThreadID first, second;
  extern void init_mac_threads(void);
  init_mac_threads();
  signal(SIGSEGV, signal_handler);
  signal(SIGILL, signal_handler);
  if (NewThread(kCooperativeThread,
		threadentry,
		(void *)kApplicationThreadID,
		(16<<10),
		kCreateIfNeeded,
		NULL,
		&first) == 0) {
    if (NewThread(kCooperativeThread,
		  threadentry,
		  (void *)first,
		  (16<<10),
		  kCreateIfNeeded,
		  NULL,
		  &second) == 0) {
      fprintf(stderr, "next thread = %d\n", second);
      YieldToThread(second);
      return 0;
    }
  }
}
  
		    
  
