/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of Opensourced MCL.

   Opensourced MCL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   Opensourced MCL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



	include(lisp.s)
	_beginfile
	.globl jmpsym
	.globl _SPmkcatch1v
	.globl _SPfuncall
	.globl _SPnthrow1value

/* If arg_z is an integer, return in imm0 something whose sign */
/* is the same as arg_z's.  If not an integer, error. */
_spentry(integer_sign)
	__(extract_typecode(imm0,arg_z))
	__(cmpwi cr1,imm0,tag_fixnum)
	__(cmpwi cr0,imm0,subtag_bignum)
	__(mr imm0,arg_z)
	__(beqlr+ cr1)
	__(bne- cr0,1f)
	__(getvheader(imm0,arg_z))
	__(header_length(imm0,imm0)) /* boxed length = scaled size */
	__(addi imm0,imm0,misc_data_offset-4) /* bias, less 1 element */
	__(lwzx imm0,arg_z,imm0)
	__(cmpwi cr0,imm0,0)
	__(li imm0,1)
	__(bgelr cr0)
	__(li imm0,-1)
	__(blr)
1:
	__(uuo_interr(error_object_not_integer,arg_z))


/* Prepend all but the first two (closure code, fn) and last two */
/* (function name, lfbits) elements of nfn to the "arglist". */
/* Doing things this way (the same way that 68K MCL does) lets */
/* functions which take "inherited arguments" work consistently */
/* even in cases where no closure object is created. */
_spentry(call_closure)
	__(cmpwi cr0,nargs,nargregs<<fixnumshift)
	__(cmpwi cr1,nargs,fixnum_one)
	__(vector_length(imm0,nfn,imm0))
	__(subi imm0,imm0,4<<fixnumshift) /* imm0 = inherited arg count */
	__(li imm1,misc_data_offset+(2<<fixnumshift)) /* point to 1st arg */
	__(ble+ cr0,.L_no_insert)
	/* Some arguments have already been vpushed.  Vpush imm0's worth */
	/* of NILs, copy those arguments that have already been vpushed from */
	/* the old TOS to the new, then insert all of the inerited args */
	/* and go to the function. */
	__(li imm2,0)
.L_push_nil_loop:
	__(addi imm2,imm2,fixnum_one)
	__(cmpw cr2,imm2,imm0)
	__(vpush(rnil))
	__(bne cr2,.L_push_nil_loop)

	__(mr imm3,vsp)
	__(add imm4,vsp,imm0)
	__(subi imm2,nargs,nargregs<<fixnumshift)
.L_copy_already_loop:
	__(cmpwi cr2,imm2,fixnum_one)
	__(subi imm2,imm2,fixnum_one)
	__(lwz fname,0(imm4))
	__(addi imm4,imm4,fixnum_one)
	__(stw fname,0(imm3))
	__(addi imm3,imm3,fixnum_one)
	__(bne cr2,.L_copy_already_loop)

.L_insert_loop:
	__(cmpwi cr2,imm0,fixnum_one)
	__(lwzx fname,nfn,imm1)
	__(addi imm1,imm1,fixnum_one)
	__(addi nargs,nargs,fixnum_one)
	__(subi imm0,imm0,fixnum_one)
	__(push(fname,imm4))
	__(bne cr2,.L_insert_loop)
	__(b .L_go)
.L_no_insert:
	/* nargregs or fewer args were already vpushed. */
	/* if exactly nargregs, vpush remaining inherited vars. */
	__(add imm2,imm1,imm0)
	__(bne cr0,.L_set_regs)
.L_vpush_remaining:
	__(cmpwi cr2,imm0,fixnum_one)
	__(lwzx fname,nfn,imm1)
	__(addi imm1,imm1,fixnum_one)
	__(vpush(fname))
	__(subi imm0,imm0,fixnum_one)
	__(addi nargs,nargs,fixnum_one)
	__(bne cr2,.L_vpush_remaining)
	__(b .L_go)
.L_set_regs:
	/* if nargs was > 1 (and we know that it was < 3), it must have */
	/* been 2.  Set arg_x, then vpush the remaining args. */
	__(ble cr1,.L_set_y_z)
.L_set_arg_x:
	__(subi imm0,imm0,fixnum_one)
	__(cmpwi cr0,imm0,0)
	__(subi imm2,imm2,fixnum_one)
	__(lwzx arg_x,nfn,imm2)
	__(addi nargs,nargs,fixnum_one)
	__(bne cr0,.L_vpush_remaining)
	__(b .L_go)
	/* Maybe set arg_y or arg_z, preceding args */
.L_set_y_z:
	__(bne cr1,.L_set_arg_z)
	/* Set arg_y, maybe arg_x, preceding args */
.L_set_arg_y:
	__(subi imm0,imm0,fixnum_one)
	__(cmpwi cr0,imm0,0)
	__(subi imm2,imm2,fixnum_one)
	__(lwzx arg_y,nfn,imm2)
	__(addi nargs,nargs,fixnum_one)
	__(bne cr0,.L_set_arg_x)
	__(b .L_go)
.L_set_arg_z:
	__(subi imm0,imm0,fixnum_one)
	__(cmpwi cr0,imm0,0)
	__(subi imm2,imm2,fixnum_one)
	__(lwzx arg_z,nfn,imm2)
	__(addi nargs,nargs,fixnum_one)
	__(bne cr0,.L_set_arg_y)

.L_go:
	__(vref32(nfn,nfn,1))
	__(lwz loc_pc,_function.codevector(nfn))
	__(mtctr loc_pc)
	__(bctr)


/* Go out of line to do this.  Sheesh. */

_spentry(vpopargregs)
	__(cmpwi cr0,nargs,0)
	__(cmpwi cr1,nargs,2<<fixnumshift)
	__(beqlr cr0)
	__(beq cr1,.L_yz)
	__(blt cr1,.L_z)
	__(lwz arg_z,0(vsp))
	__(lwz arg_y,4(vsp))
	__(lwz arg_x,8(vsp))
	__(la vsp,12(vsp))
	__(blr)
.L_yz:
	__(lwz arg_z,0(vsp))
	__(lwz arg_y,4(vsp))
	__(la vsp,8(vsp))
	__(blr)
.L_z:
	__(lwz arg_z,0(vsp))
	__(la vsp,4(vsp))
	__(blr)

	
/*This (for better or worse) treats anything that's either */
/* (signed-byte 32), (unsigned-byte 32), (simple-base-string 4), or  */
/* (satisfies (lambda (s) (and (symbolp s) (typep (symbol-name s) '(simple-base-string 4))) */
/* as if it denoted a 32-bit value. */
/* Argument in arg_z, result in imm0.  May use temp0. */
_spentry(getxlong)
	__(extract_lisptag(imm0,arg_z))
	__(cmpwi imm0,tag_fixnum)
	__(cmpwi cr1,imm0,tag_misc)
	__(unbox_fixnum(imm0,arg_z))
	__(beqlr)
	__(mr temp0,arg_z)
	__(bne- cr1,.L_error)
	__(getvheader(imm0,temp0))
	__(cmpwi cr0,imm0,symbol_header)
	__(cmpwi cr1,imm0,one_digit_bignum_header)
	__(cmpwi cr7,imm0,two_digit_bignum_header)
	__(bne- cr0,.L_not_sym)
	__(lwz temp0,symbol.pname(arg_z))
	__(getvheader(imm0,temp0))
.L_not_sym:
	__(cmpwi cr0,imm0,(4<<num_subtag_bits)|subtag_simple_base_string)
	__(beq cr1,.L_big1)
	__(beq cr0,.L_big1)
	__(bne cr7,.L_extended)

.L_big2:
	__(vref32(imm0,temp0,1)) /* sign digit must be 0 */
	__(cmpwi imm0,0)
	__(bne .L_error)
.L_big1:
	__(vref32(imm0,temp0,0))
	__(blr)

.L_extended:
	/* Handle extended strings. Maybe later handle displaced strings */
	__(cmpwi cr0,imm0,(4<<num_subtag_bits)|subtag_simple_general_string)
	__(bne cr0,.L_error)

	__(vref16(imm0,temp0,3))
	__(cmpwi cr0,imm0,256)
	__(vref16(imm1,temp0,2))
	__(cmpwi cr1,imm1,256)
	__(rlwimi imm0,imm1,8,16,23)
	__(vref16(imm1,temp0,1))
	__(bge cr0,.L_error)
	__(cmpwi cr0,imm1,256)
	__(rlwimi imm0,imm1,16,8,15)
	__(vref16(imm1,temp0,0))
	__(bge cr1,.L_error)
	__(cmpwi cr1,imm1,256)
	__(rlwimi imm0,imm1,24,0,7)
	__(bge cr0,.L_error)
	__(bge cr1,.L_error)
	__(blr)

.L_error:
	__(uuo_interr(error_object_not_integer,arg_z)) /* not quite right but what 68K MCL said */

/* arg_z should be of type (UNSIGNED-BYTE 64); return high 32 bits
	in imm0, low 32 bits in imm1 */

_spentry(getu64)
	__(extract_typecode(imm0,arg_z))
	__(cmpwi cr0,imm0,tag_fixnum)
	__(cmpwi cr1,arg_z,0)
	__(cmpwi cr2,imm0,subtag_bignum)
	__(unbox_fixnum(imm1,arg_z))
	__(bne cr0,8f)
	__(bgelr cr1)
9:
	__(uuo_interr(error_object_not_u64,arg_z))
8:
	__(bne- cr1,1b)
	__(getvheader(imm2,arg_z))
	__(cmpwi cr2,imm2,two_digit_bignum_header)
	__(vref32(imm1,arg_z,0))
	__(cmpwi cr1,imm1,0)
	__(li imm0,0)
	__(bge cr2,2f)
	__(blt- cr1,9b)
	__(blr)
2:
	__(cmpwi cr0,imm2,three_digit_bignum_header)
	__(vref32(imm0,arg_z,1))
	__(cmpwi cr1,imm0,0)
	__(bne cr2,3f)
	__(blt- cr1,9b)
	__(blr)
3:
	__(vref32(imm2,arg_z,2))
	__(cmpwi cr1,imm2,0)
	__(bne- cr0,9b)
	__(bne- cr1,9b)
	__(blr)

/* arg_z should be of type (SIGNED-BYTE 64); return high 32 bits
	in imm0, low 32 bits in imm1 */

_spentry(gets64)
	__(extract_typecode(imm0,arg_z))
	__(cmpwi cr0,imm0,tag_fixnum)
	__(cmpwi cr2,imm0,subtag_bignum)
	__(unbox_fixnum(imm1,arg_z))
	__(srawi imm0,imm1,31)
	__(beqlr cr0)
	__(bne cr2,9f)
	__(getvheader(imm2,arg_z))
	__(cmpwi cr2,imm2,two_digit_bignum_header)
	__(vref32(imm1,arg_z,0))
	__(srawi imm0,imm1,31)
	__(bltlr cr2)
	__(vref32(imm0,arg_z,1))
	__(beqlr cr2)
9:
	__(uuo_interr(error_object_not_s64,arg_z))

/*
  Construct a lisp integer out of the 64-bit unsigned value in
  imm0 (high 32 bits) and imm1 (low 32 bits). */
_spentry(makeu64)
	__(cmpwi cr1,imm0,0)
	__(rlwinm. imm2,imm1,0,0,fixnum_shift)
	__(li imm2,three_digit_bignum_header)
	__(box_fixnum(arg_z,imm1))
	__(blt cr1,3f)
	__(bne cr1,2f)
	__(beqlr cr0) /* A fixnum */
	__(li imm2,one_digit_bignum_header)
	__(stwu rzero,8(freeptr))
	__(stw imm2,0(initptr))
	__(la arg_z,fulltag_misc(initptr))
	__(mr initptr,freeptr)
	__(stw imm1,misc_data_offset(arg_z))
	__(blr)
2:
	__(li imm2,two_digit_bignum_header)
3:
	__(stwu rzero,16(freeptr))
	__(stw imm2,0(initptr))
	__(la arg_z,fulltag_misc(initptr))
	__(mr initptr,freeptr)
	__(stw imm1,misc_data_offset(arg_z))
	__(stw imm0,misc_data_offset+4(arg_z))
	__(blr)

/*
  Construct a lisp integer out of the 64-bit signed value in
  imm0 (high 32 bits) and imm1 (low 32 bits). */
_spentry(makes64)
	__(srawi imm2,imm1,31)
	__(cmpw cr1,imm2,imm0)
	__(mcrxr cr0)
	__(addo imm2,imm1,imm1)
	__(addo. arg_z,imm2,imm2)
	__(bne cr1,2f) /* High word is significant */
	__(li imm2,one_digit_bignum_header)
	__(bnslr cr0) /* No overflow:	 fixnum */
	__(stwu rzero,8(freeptr))
	__(stw imm2,0(initptr))
	__(la arg_z,fulltag_misc(initptr))
	__(mr initptr,freeptr)
	__(stw imm1,misc_data_offset(arg_z))
	__(blr)
2:
	__(li imm2,two_digit_bignum_header)
	__(stwu rzero,16(freeptr))
	__(stw imm2,0(initptr))
	__(la arg_z,fulltag_misc(initptr))
	__(mr initptr,freeptr)
	__(stw imm1,misc_data_offset(arg_z))
	__(stw imm0,misc_data_offset+4(arg_z))
	__(blr)
		
/* subtype (boxed, of course) is vpushed, followed by nargs bytes worth of */
/* initial-contents.  Note that this can be used to cons any type of initialized */
/* node-header'ed misc object (symbols, closures, ...) as well as vector-like */
/* objects. */
/* Note that we're guaranteed to win (or force GC, or run out of memory) */
/* because nargs < 32K. */
_spentry(gvector)
	__(lwzx arg_z,vsp,nargs)
	__(unbox_fixnum(imm0,arg_z))
	__(rlwimi imm0,nargs,num_subtag_bits-fixnum_shift,0,31-num_subtag_bits)
	__(addi imm1,nargs,4+7)
	__(clrrwi imm1,imm1,3)
	__(stwux rzero,freeptr,imm1)
	__(stw imm0,0(initptr))
	__(la arg_z,fulltag_misc(initptr))
	__(mr initptr,freeptr)
	__(mr imm1,nargs)
	__(addi imm2,imm1,misc_data_offset)
	__(b 2f)
1:
	__(stwx temp0,arg_z,imm2)
2:
	__(subi imm1,imm1,4)
	__(cmpwi cr0,imm1,0)
	__(subi imm2,imm2,4)
	__(vpop(temp0))         /* Note the intentional fencepost:
415
				      discard the subtype as well. */
	__(bge cr0,1b)
	__(blr)


_spentry(ksignalerr)
	.globl ksignalerr
	.globl jmpsym
	/* Signal an error synchronously, via %ERR-DISP. */
	/* If %ERR-DISP isn't fbound, it'd be nice to print a message */
	/* on the C runtime stderr. */
	__(la fname,nrs.errdisp(rnil))
	__(b jmpsym)
	_endfn


/* This is called from a c-style context and calls a lisp function. */
/* This does the moral equivalent of */
/*   (loop 
       (catch %toplevel-catch% 
         (let* ((fn (symbol-value *toplevel-function*)))
           (if fn (funcall fn) (return nil))))))) 
*/

_startfn(.toplevel_loop)
	__(mflr imm0)
	__(stw imm0,eabi_c_frame.savelr(sp))
	__(b .L_test)
.L_loop:
	__(ref_nrs_value(arg_z,toplcatch))
	__(bl _SPmkcatch1v)
	__(b .L_test)			/* cleanup address, not really a branch */

	__(ref_nrs_value(temp0,toplfunc))
	__(cmpw cr0,temp0,rnil)
	__(set_nargs(0))
	__(beq cr0,.L_test)
	__(bl _SPfuncall)
	__(mr arg_z,rnil)
	__(li imm0,fixnum_one)
	__(bl _SPnthrow1value)
.L_test:
	__(ref_nrs_value(temp0,toplfunc))
	__(cmpw cr0,temp0,rnil)
	__(bne cr0,.L_loop)
.L_back_to_c:
	__(lwz imm0,eabi_c_frame.savelr(sp))
	__(mtlr imm0)
	__(blr)
	_endfn


/* This sucker gets called with R3 pointing to lisp_nil. */
/* r4 is 0 if we want to start the whole thing rolling, */
/* non-zero if we want to reset the current process */
/* by throwing to toplevel */
/* Whatever -was- in rtoc isn't very interesting to us. */
	.globl _SPreset
_exportfn(.start_lisp)
	__(mflr r0)
	__(mr r5,r2)
	__(mr rnil,r3)
	__(set_global(r5,saveTOC))
	__(stw r0,eabi_c_frame.savelr(sp))
	__(stwu sp,-(eabi_c_frame.minsiz+(32*4))(sp))
	__(stmw r13,eabi_c_frame.minsiz(sp)) /* don't worry about the stmw. */
	__(stfd fp_s32conv,eabi_c_frame.minsiz+(22*4)(sp))
	__(lwi(r30,0x43300000))
	__(lwi(r31,0x80000000))
	__(stw r30,eabi_c_frame.minsiz+(20*4)(sp))
	__(stw r31,eabi_c_frame.minsiz+(20*4)+4(sp))
	__(lfd fp_s32conv,eabi_c_frame.minsiz+(20*4)(sp))
	__(stfd fp_zero,eabi_c_frame.minsiz+(20*4)(sp))
	__(lfs fp_zero,lisp_globals.short_float_zero(rnil))
	__(li rzero,0)
	__(mr save0,rnil)
	__(mr save1,rnil)
	__(mr save2,rnil)
	__(mr save3,rnil)
	__(mr save4,rnil)
	__(mr save5,rnil)
	__(mr save6,rnil)
	__(mr save7,rnil)
	__(mr arg_z,rnil)
	__(mr arg_y,rnil)
	__(mr arg_x,rnil)
	__(mr temp0,rnil)
	__(mr temp1,rnil)
	__(mr temp2,rnil)
	__(mr temp3,rnil)
	__(li fn,0)
	__(li loc_g,0)
	__(li loc_pc,0)
	__(cmpwi cr0,r4,0)
	__(ref_global(vsp,save_vsp))
	__(ref_global(tsp,save_tsp))
	__(ref_global(memo,save_memo))
	__(ref_global(freeptr,save_freeptr))
	__(mr initptr,freeptr)
	__(bne cr0,1f)
	__(bl .toplevel_loop)
	__(b 2f)
1:
	__(bl _SPreset)
2:
	__(set_global(freeptr,save_freeptr))
	__(set_global(memo,save_memo))
	__(set_global(tsp,save_tsp))
	__(set_global(vsp,save_vsp))
	__(lmw r13,eabi_c_frame.minsiz(sp))
	__(mr r3,rnil)
	__(lfd fp_zero,eabi_c_frame.minsiz+(20*4)(sp))
	__(lfd fp_s32conv,eabi_c_frame.minsiz+(22*4)(sp))
	__(lwz r0,(eabi_c_frame.minsiz+(32*4)+eabi_c_frame.savelr)(sp))
	__(mtlr r0)
	__(la sp,(eabi_c_frame.minsiz+(32*4))(sp))
	__(blr)

	_endfile
