; -*- Mode:Lisp; Package:CCL; -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;


(defmacro print-db (&rest forms &aux)
  `(multiple-value-prog1
     (progn ,@(print-db-aux forms))
     (terpri *trace-output*)))

(defun print-db-aux (forms)
   (when forms
     (cond ((stringp (car forms))
            `((print ',(car forms) *trace-output*)
              ,@(print-db-aux (cdr forms))))
           ((null (cdr forms))
            `((print ',(car forms) *trace-output*)
              (let ((values (multiple-value-list ,(car forms))))
                (prin1 (car values) *trace-output*)
                (apply #'values values))))
           (t `((print ',(car forms) *trace-output*)
                (prin1 ,(car forms) *trace-output*)
                ,@(print-db-aux (cdr forms)))))))


