# The OpenEXR Libraries

The OpenEXR module is a part of the OpenEXR project and contains the following:

* **IlmImf** - the core library that implements the "EXR" file format.
* **IlmImfUtil** - related utilities.
* **IlmImfExamples** - code that demonstrates how
to use the IlmImf library to read and write OpenEXR files.  
* **doc** - high-level documentation and history about the OpenEXR
format.
* **exr2aces** - 
* **exrbuild**
* **exrenvmap**
* **exrmakepreview**
* **exrmaketiled**
* **exrmultipart**
* **exrmultiview**
* **exrstdattr**

In addition, the distribution also includes confidence tests:

* **IlmImfTest** - basic confidence test.
* **IlmImfUtilTest** - huge input resilience test.
* **IlmImfFuzzTest** - damaged input resilience test.
  
## License

These libraries are covered under the
[BSD-3-Clause](https://www.openexr.com/license.html) license of the
OpenEXR project.

## Building and Installation

See the top-level [INSTALL](../INSTALL.md) file for information about
building and installing the OpenEXR libraries.



