#
# Upgrade from 0.38
#

#
# Borrow Duration support is being improved to store total_duration instead of overdue_duration
# which can be calculated (total_duration - borrow_duration)
# 
ALTER TABLE borrowed_item ADD total_duration smallint(3) unsigned AFTER borrow_duration;

# Update statements necessary to convert over to new table structure...
UPDATE borrowed_item set total_duration = borrow_duration + overdue_duration, update_on = update_on WHERE borrow_duration IS NOT NULL AND overdue_duration IS NOT NULL;
UPDATE borrowed_item set total_duration = borrow_duration, update_on = update_on WHERE borrow_duration IS NOT NULL AND overdue_duration IS NULL;

ALTER TABLE borrowed_item DROP overdue_duration;

# Reduce s_attribute_type_lookup value column size
ALTER TABLE s_attribute_type_lookup CHANGE value value varchar(100) NOT NULL;

#
# List Link functionality
#
UPDATE s_attribute_type SET display_type = 'display(%value%, list-link)' where s_attribute_type IN('YEAR','VID_FORMAT','DVD_REGION');
UPDATE s_attribute_type SET display_type = 'display(%display%, list-link)' where s_attribute_type IN('VIDQUALITY','VHS_TYPE','DIVXVIDVER','DIVXAUDVER','DIVXQUALIT');
UPDATE s_attribute_type SET display_type = 'display(%img% %display%, list-link)' where s_attribute_type IN('AUDIO_LANG', 'SUBTITLES');

# Do it for Director as well in case there is dual directorship!
UPDATE s_attribute_type SET display_type = 'list(plain, " ", list-link)' where s_attribute_type IN('DIRECTOR','ACTORS','ARTIST');
# The display(%value%, list-link) widget does not work for attributes which have more than one %value%.
UPDATE s_attribute_type SET display_type = 'list(plain, " ", list-link)' where s_attribute_type IN('RATIO');
UPDATE s_attribute_type SET display_type = 'display(%img%, list-link)' where s_attribute_type  = 'AGE_RATING';
UPDATE s_attribute_type SET display_type = 'category(%display%, list-link)' where s_attribute_type IN('MOVIEGENRE','MUSICGENRE');


