<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/function.php");
include_once("./functions/utils.php");
include_once("./functions/borrowed_item.php");
include_once("./functions/item.php");
include_once("./functions/http.php");
include_once("./functions/fileutils.php");
include_once("./functions/user.php");
include_once("./functions/review.php");
include_once("./functions/item_attribute.php");
include_once("./functions/item_type.php");
include_once("./functions/widgets.php");
include_once("./functions/parseutils.php");
include_once("./functions/site.php");
include_once("./functions/item_input.php");
include_once("./functions/status_type.php");

/**
	Will test the old against the new value.
	* 
	* Assumes that filter_input_field(...) has already
	* been called for new_value.
*/
function is_value_refreshed($s_attribute_type, $new_value, $old_value)
{
	// Do the simplest check first!
	if(strlen($old_value)==0 && strlen($new_value)>0)
		return TRUE;
	else
	{
		if(is_lookup_attribute_type($s_attribute_type))
		{
			$old_value_r = explode(" ", $old_value);
			$new_value_r = explode(" ", $new_value);
		
			if(is_not_empty_array($old_value_r) && is_not_empty_array($new_value_r) && count($old_value_r) == count($new_value_r))
			{
				for($i=0; $i<count($old_value_r); $i++)
				{
					// case insensitive search
					if(array_search2($old_value_r[$i], $new_value_r, TRUE)===FALSE)
					{
						return TRUE;
					}
				}
				
				//else
				return FALSE;
			}
			else
				return TRUE;
		}
		else
		{
			if(strcmp($new_value, $old_value)!==0)
				return TRUE;
			else
				return FALSE;
		}				
	}
}

function status_type_input_field($fieldname, $lookup_results, $value=NULL)
{
	$field = "<table border=0 cellpadding=1 cellspacing=0>\n<tr>";
			
	$is_checked=FALSE;
	while($lookup_r = mysql_fetch_array($lookup_results, MYSQL_ASSOC))
	{
		if(!$is_checked && ((strlen($value)==0 && $lookup_r['default_ind'] == 'Y') || $lookup_r['value'] == $value))
		{
			$lookup_r['checked_ind'] = 'Y';
			$is_checked=TRUE;
		}	
		$lookup_rs[] = $lookup_r;
	}
	mysql_free_result($lookup_results);
			
	// Otherwise enforce the first value as checked.
	if(!$is_checked)
	{
		$lookup_rs[0]['checked_ind'] = 'Y';
	}
			
	$no_columns = 4;
	$columns = 0;
	while(list(,$lookup_r) = each($lookup_rs))
	{
		if($columns>=$no_columns)
		{
			$columns=0;
			$field .= "</tr>\n<tr>";
		}
			
		$field .= "\n<td><input type=radio name=\"$fieldname\" value=\"".$lookup_r['value']."\" ".($lookup_r['checked_ind'] == 'Y'?"CHECKED":"").">".
				format_display_value('%img%', $lookup_r['img'], $lookup_r['value'], $lookup_r['display']).
				"\n</td>";
										
		$columns++;
	}						

	// Now fill remaining columns with nbsp!!!
	for(; $columns<$no_columns;$columns++)
		$field .= "<td>&nbsp;</td>";
											
	$field .= "</tr></table>";
									
	return $field;
}

/*
* Will return a complete TABLE, FORM, including <table ...> <form ...>, </form> and </table>
* 
* @param $confirm_message - If defined, then this edit form, because a Confirm Action form
* as well.
*/
function get_edit_form($op, $confirm_message, $parent_item_r, $item_r, $status_type_r, $siat_results, $HTTP_VARS, $HTTP_POST_FILES)
{
	global $PHP_SELF;
	global $LANG_VARS;
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	if($siat_results)
	{
		// Work out $op value to submit.
		if($op == "edit" || $op == "refresh")
			$op2 = "update";
		else if($op == "new" || $op == "site")
			$op2 = "insert";
		else
			$op2 = $op; // last resort!
				
		$formContents .= "\n<input type=\"hidden\" name=\"op\" value=\"$op2\">";
		$formContents .= "\n<input type=\"hidden\" name=\"s_item_type\" value=\"".$item_r['s_item_type']."\">";
		
		if(is_not_empty_array($parent_item_r))
		{
			$formContents .= "\n<input type=\"hidden\" name=\"parent_id\" value=\"".$HTTP_VARS['parent_id']."\">";
			$formContents .= "\n<input type=\"hidden\" name=\"parent_instance_no\" value=\"".$HTTP_VARS['parent_instance_no']."\">";
		}
		
		if(is_not_empty_array($item_r))
		{
			if(is_numeric($item_r['item_id']))
				$formContents .= "\n<input type=\"hidden\" name=\"item_id\" value=\"".$item_r['item_id']."\">";
			if(is_numeric($item_r['instance_no']))
				$formContents .= "\n<input type=\"hidden\" name=\"instance_no\" value=\"".$item_r['instance_no']."\">";
		}
		
		// Pass owner_id parameter through
		if(strlen($HTTP_VARS['owner_id'])>0)
		{
			$formContents .= "\n<input type=\"hidden\" name=\"owner_id\" value=\"".$HTTP_VARS['owner_id']."\">";
		}
		
		$formContents .= "\n<input type=\"hidden\" name=\"listing_link\" value=\"".$HTTP_VARS['listing_link']."\">";

		// ------------------- Start inline functions - only used by get_edit_form(...)
		// This function will calculate a field input_field value,
		// based on $HTTP_VARS, $op and $indexes (Used for site operations)
		function get_field_value($op, $item_r, $s_attribute_type, $order_no, $s_field_type, $attribute_val, &$indexes)
		{
			global $HTTP_VARS;
			global $HTTP_POST_FILES;
			
			if($op == "add")
			{
				return NULL; // No value!
			}
			else if(is_not_empty_array($HTTP_VARS))// Lets try to get field value, from HTTP
			{
				$fieldname = get_field_name($s_attribute_type, $order_no);
				if(isset($HTTP_VARS[$fieldname.'_new']) && ($HTTP_VARS[$fieldname] == 'old' || $HTTP_VARS[$fieldname] == 'new'))
				{
					if($HTTP_VARS[$fieldname] == 'new')
						$HTTP_VARS[$fieldname] = $HTTP_VARS[$fieldname.'_new'];
					else // Using $item_r value instead.
						unset($HTTP_VARS[$fieldname]);
				}
				
				// If $HTTP_VARS[$fieldname] is set, we have probably come back to
				// edit form, after a failed insert or update.
				if(isset($HTTP_VARS[$fieldname]))
				{
					// Is it an upload operation - There is not much we can do in the case of $HTTP_POST_FILEs, as they
					// cannot be cached and passed into next request.  A user would have to re-upload the specific file.
					if(is_array($HTTP_POST_FILES) && is_array($HTTP_POST_FILES[$fieldname])) 
						return NULL;
					else if(is_array($HTTP_POST_FILES) && is_array($HTTP_POST_FILES[$fieldname."_upload"])) 
						return NULL;
					else if($HTTP_VARS[$fieldname."_saveurl"] == "y")
						return $HTTP_VARS[$fieldname];
					else // normal field
						return $HTTP_VARS[$fieldname];
				}	
			}
	
			// If no $HTTP_VARS field values found, try normal avenues.
			if($s_field_type == 'STATUSTYPE')
			{
				return $item_r['s_status_type'];
			}
			else if($s_field_type == 'STATUSCMNT')
			{
				return $item_r['status_comment'];
			}
			else if($s_field_type == 'DURATION')
			{
				return $item_r['borrow_duration'];
			}
			else if($op == "site" || $op == "refresh")
			{
				if($s_field_type == "CATEGORY")
				{
					return trim(urldecode($HTTP_VARS['category']));
				}
				else if($s_field_type == 'TITLE')
				{
					return trim(urldecode($HTTP_VARS['title']));
				}
				else
				{
					$s_attribute_type = strtolower($s_attribute_type);		
					if(isset($HTTP_VARS[$s_attribute_type]))
						$attrval = $HTTP_VARS[$s_attribute_type];
					else
						$attrval = NULL;

					if(is_array($attrval))
					{   
						// If not defined, set to first index.
						// This allows plugins to pass more than one value for an attribute, and we
						// then cycle through them.  For instance CDTRACK for 'CD' s_item_type.  The
						// freedb plugin passes an array of CDTRACK's and we populate each CDTRACK
						// attribute as we come to it.  The $indexes allows us to keep track of it.
						if(!$indexes[$s_attribute_type])
							$indexes[$s_attribute_type] = 0;

						return trim(urldecode($attrval[$indexes[$s_attribute_type]++]));
					}
					else
					{
						return trim(urldecode($attrval));
					}
				}
			}
			else // $op == "edit"
			{
				if($s_field_type == "CATEGORY")
				{
					return $item_r['category'];
				}
				else if($s_field_type == 'TITLE')
				{
					return $item_r['title'];
				}
				else
					return $attribute_val;
			}				
		} //function get_field_value($op, $item_r, $s_attribute_type, $order_no, $s_field_type, $attribute_val, &$indexes)
		
		function get_old_field_value($item_r, $s_field_type, $attribute_val)
		{
			if($s_field_type == 'STATUSTYPE')
			{
				return $item_r['s_status_type'];
			}
			else if($s_field_type == 'STATUSCMNT')
			{
				return $item_r['status_comment'];
			}
			else if($s_field_type == 'DURATION')
			{
				return $item_r['borrow_duration'];
			}
			else if($s_field_type == "CATEGORY")
			{
				return $item_r['category'];
			}
			else if($s_field_type == 'TITLE')
			{
				return $item_r['title'];
			}
			else
				return $attribute_val;
		}//get_old_field_value($item_r, $s_field_type, $attribute_val)

		// If $old_value !== FALSE, then we will assume a refresh operation and display a
		// special refresh row, if the $new_value is different from the $old_value.
		function get_table_row($s_attribute_type, $order_no, $prompt, $display_type, $input_type, $compulsory_ind, $old_value, $new_value)
		{
			global $LANG_VARS;

			$input_widget_type = get_function_type(trim($input_type));
			$fieldname = get_field_name($s_attribute_type, $order_no);

			// Hidden cannot be involved in a refresh operation directly, but refreshed hidden fields, will still be updated.
			if(strcasecmp($input_widget_type,"hidden")!==0 && $old_value!==FALSE && strlen($new_value)>0 && is_value_refreshed($s_attribute_type, $new_value, $old_value))
			{
				// Do not display 'Old' & 'New' options, if there was NO previous Old value
				if(strlen($old_value)>0)
				{
					// If we are doing a complete refresh block, and display_type is set to 
					// hidden, overwrite to display it.
					if(get_function_type($display_type)=="hidden")
						$display_type = "display(%value%)";
			
					$field = "<table border=1 width=100%>".
						"<tr><td width=75 nowrap><input type=radio name=\"".$fieldname."\" value=\"old\">".$LANG_VARS['old_value']."</td>".
						"<td>".get_display_field($s_attribute_type, $prompt, $display_type, $old_value, FALSE)."</td></tr>".
						"<tr><td width=75 nowrap><input type=radio name=\"".$fieldname."\" value=\"new\" CHECKED>".$LANG_VARS['new_value']."</td>".
						"<td>".get_input_field($fieldname."_new", $s_attribute_type, $prompt, $input_type, $compulsory_ind, $new_value, FALSE)."</td></tr>".
						"</table>";
				}
				else
				{
					$field = get_input_field($fieldname, $s_attribute_type, $prompt, $input_type, $compulsory_ind, $new_value, FALSE);
				}
						
				return format_field(
					$prompt, 
					NULL,
					$field,
					TRUE,
					_theme_image("rs.gif", NULL, $LANG_VARS['refreshed'])."&nbsp;%prompt%");
			}
			else
			{
				return get_input_field($fieldname, 
							$s_attribute_type, 
							$prompt, 
							$input_type, 
							$compulsory_ind, 
							ifempty($new_value, $old_value===FALSE?NULL:$old_value));
			}
		}//get_table_row($s_attribute_type, $order_no, $prompt, $display_type, $input_type, $compulsory_ind, $old_value, $new_value)
		// ------------------- End inline functions - only used by get_edit_form(...)
		
		// Now create the input form
		while($item_attribute_type_r = mysql_fetch_array($siat_results))
		{
			if($item_attribute_type_r['s_field_type'] == "STATUSTYPE")
			{
				if(!is_array($parent_item_r))
				{
					$fieldname = get_field_name($item_attribute_type_r['s_attribute_type'],$item_attribute_type_r['order_no']);
					$new_value = filter_input_field(
								$item_attribute_type_r['s_attribute_type'], 
								$item_attribute_type_r['input_type'], 
								get_field_value($op, $item_r, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $item_attribute_type_r['s_field_type'], $item_attribute_type_r['attribute_val'], $indexes));
						
					if($op == "new" || $op == "site")
					{
						// A s_status_type was not specified, will choose once in the edit form
						if(strlen($status_type_r['s_status_type'])==0)
							$lookup_results = fetch_newitem_status_type_rs($item_r['owner_id']);
						else
						{
							// Have to pass the hidden s_status_type along to insert process.
							$formContents .= hidden_field(get_field_name($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no']), $item_r['s_status_type']);
						}
					}
					else
					{
						// If item has borrowed records, then no s_status_type with borrow_ind == 'X' should be included.
						$lookup_results = fetch_update_status_type_rs($item_r['item_id'], $item_r['instance_no'], $item_r['owner_id']);
					}
					
					if($lookup_results && mysql_num_rows($lookup_results)>0)
					{
						$formContents .= format_field($item_attribute_type_r['prompt'], 
													NULL,
													status_type_input_field($fieldname, $lookup_results, $new_value));
					}
				}//Otherwise Linked Item
			}
			else if($item_attribute_type_r['s_field_type'] == "STATUSCMNT")
			{
				// If $status_type_r['s_status_type'] defined, then the s_status_type has not been specified, so we cannot
				// decide whether to display the status comment field or not.
				if(!is_array($parent_item_r) && (($op != "new" && $op != "site") || strlen($status_type_r['s_status_type'])==0 || $status_type_r['status_comment_ind'] == 'Y' || $status_type_r['status_comment_ind'] == 'H'))
				{
					$fieldname = get_field_name($item_attribute_type_r['s_attribute_type'],$item_attribute_type_r['order_no']);
					$new_value = filter_input_field(
									$item_attribute_type_r['s_attribute_type'], 
									$item_attribute_type_r['input_type'], 
									get_field_value($op, $item_r, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $item_attribute_type_r['s_field_type'], $item_attribute_type_r['attribute_val'], $indexes));
					
					$formContents .= 
						get_input_field(
							$fieldname,
							$item_attribute_type_r['s_attribute_type'], 
							$item_attribute_type_r['prompt'], 
							$item_attribute_type_r['input_type'], 
							$item_attribute_type_r['compulsory_ind'], 
							ifempty($new_value, $item_r['status_comment']));
				}//Otherwise Linked Item
			}
			else if($item_attribute_type_r['s_field_type'] == "DURATION")
			{
				if(!is_array($parent_item_r) && (($op != "new" && $op != "site") || strlen($status_type_r['s_status_type'])==0 || $status_type_r['borrow_ind']=='Y' || $status_type_r['borrow_ind']=='N'|| $status_type_r['borrow_ind']=='B'))
				{
					$fieldname = get_field_name($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no']);
					$borrow_duration = ifempty(
									filter_input_field(
											$item_attribute_type_r['s_attribute_type'], 
											$item_attribute_type_r['input_type'], 
											get_field_value($op, $item_r, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $item_attribute_type_r['s_field_type'], $item_attribute_type_r['attribute_val'], $indexes)),
									$item_r['borrow_duration']);
					
					// The S_DURATION lookup list will most likely include an 'Undefined' option, that equates
					// to an empty string.  So for Updates, we want to allow for a match, by forcing any NULL
					// value to a empty string.  The reason why we do this is, because the Borrow Duration was
					// probably set to 'Undefined', but because this equated to an empty string, the field was
					// never updated.  We do not take advantage of MySQL recognising difference between NULL
					// and empty string, because other databases do not support this.
					if($op != "new" && $op != "site")
					{
						if($borrow_duration === NULL)
							$borrow_duration = '';
					}
									
					$formContents .= 
						get_input_field(
							$fieldname,
							$item_attribute_type_r['s_attribute_type'], 
							$item_attribute_type_r['prompt'], 
							$item_attribute_type_r['input_type'], 
							$item_attribute_type_r['compulsory_ind'], 
							$borrow_duration);
				}//Otherwise Linked Item
			}
			else		
			{
				if($op=='refresh')
				{
					$old_value = get_old_field_value($item_r, $item_attribute_type_r['s_field_type'], $item_attribute_type_r['attribute_val']);
					$new_value = filter_input_field($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['input_type'], get_field_value($op, $item_r, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $item_attribute_type_r['s_field_type'], $item_attribute_type_r['attribute_val'], $indexes));
				}
				else //if($op == 'edit' || $op == 'new')
				{
					// No refresh operation.
					$old_value = FALSE;
				
					$new_value = filter_input_field($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['input_type'], get_field_value($op, $item_r, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $item_attribute_type_r['s_field_type'], $item_attribute_type_r['attribute_val'], $indexes));
				
					// If no HTTP value, especially where FILE UPLOAD is being concerned, attempt to get from database again.
					if($op=='edit' && $new_value == NULL)
						$new_value = filter_input_field($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['input_type'], get_field_value($op, $item_r, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $item_attribute_type_r['s_field_type'], $item_attribute_type_r['attribute_val'], $indexes));
				}
			
				// Enforce compulsory indicator for TITLE.
				if($item_attribute_type_r['s_field_type'] == "TITLE")
				{
					$item_attribute_type_r['compulsory_ind'] = "Y";
					
					// Remove any title articles.
					if(is_not_empty_array($CONFIG_VARS['item_input.title_articles']))
					{
						$new_value = trim(
							format_title_grammar_article($new_value, $CONFIG_VARS['item_input.title_articles']));
					}
				}
				
				$formContents .= 
					get_table_row($item_attribute_type_r['s_attribute_type'],
						$item_attribute_type_r['order_no'],
						$item_attribute_type_r['prompt'],
						$item_attribute_type_r['display_type'],
						$item_attribute_type_r['input_type'],
						$item_attribute_type_r['compulsory_ind'],
						$old_value,
						$new_value);
			}							
		}//while
			
		if($op=='refresh')
		{
			$formContents .= "\n<tr><td align=right>".
						format_help_block(array('img'=>'rs.gif','text'=>$LANG_VARS['refreshed'])).
					"</td><td>&nbsp;</td></tr>";
		}
		
		if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
			$onclick_event = "if(!checkForm(this.form)){return false;}else{this.form.submit();}";
		else
			$onclick_event = "this.form.submit();";
		
		// Add submit button.
		$formContents .= "\n<tr>".
			"<td colspan=2 align=center><br>";
					
		if(strlen($confirm_message)>0)
		{
			$formContents .= "\n<input type=\"hidden\" name=\"confirmed\" value=\"false\">".
				"\n<div class=\"colortext\">".$confirm_message."</div>".
				"\n<input type=\"button\" value=\" ".$LANG_VARS['yes']." \" onclick=\"this.form.confirmed.value='true'; $onclick_event\">&nbsp;".
				"\n<input type=\"button\" value=\" ".$LANG_VARS['no']." \" onclick=\"this.form.confirmed.value='false'; this.form.submit();\">";
		}
		else
		{
			$formContents .= "<input type=\"button\" onclick=\"$onclick_event\" value=\"".$LANG_VARS['save_item']."\">";
		}
		
		$formContents .= "</td>".
					"</tr>";
					
		// Finally - note that get_popup_javascript() is included by get_validation_javascript(), but in the case where
		// javascript validation has been disabled we need to include it manually.
		return ($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE?get_validation_javascript():get_popup_javascript()).
				"\n<table border=0 frameborder=0 cellspacing=1>".
				(is_file_upload_form() && is_file_upload_enabled()?
					"\n<form action=\"$PHP_SELF\" method=\"post\" enctype=\"multipart/form-data\">":
							"\n<form action=\"$PHP_SELF\" method=\"post\">").
				$formContents.
				"\n</form>".
				"\n</table>";
	}
	else // We have nothing to display in this case!
	{
		return NULL;
	}
}

/*
* Will validate that edit/refresh can proceed for the $HTTP_SESSION_VARS['user_id'], and will then
* build the edit form, by calling get_edit_form.  If get_edit_form, returns
* a NOT NULL, value then the complete get_edit_form block will be returned,
* otherwise this function returns false.
*/
function handle_edit_or_refresh($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, &$errors)
{
	global $LANG_VARS;
	global $HTTP_SESSION_VARS;
	
	if(is_empty_array($parent_item_r) || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || $parent_item_r['owner_id'] == $HTTP_SESSION_VARS['user_id'])
	{
		// If $parent_item_r defined, then the test for parent ownership is sufficient!
		if(is_not_empty_array($parent_item_r) || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || $item_r['owner_id'] == $HTTP_SESSION_VARS['user_id'])
		{
			$results = fetch_item_attribute_type_with_val_rs($item_r['s_item_type'], $item_r['item_id'], TRUE, TRUE, TRUE);
			$formContents = get_edit_form($HTTP_VARS['op'], NULL, $parent_item_r, $item_r, $status_type_r, $results, $HTTP_VARS, $HTTP_POST_FILES);
			if($formContents != NULL)
				return $formContents;
			else
			{
				$errors = array('error'=>$LANG_VARS['undefined_error'],detail=>'');
				return FALSE;
			}
		}
		else
		{
			$errors = array('error'=>$LANG_VARS['cannot_edit_item_not_owned'],detail=>'');
			opendb_log("Attempted to edit item instance they do not own (item_id=".$item_r['item_id'].",instance_no=".$item_r['instance_no'].", update_who=".$HTTP_SESSION_VARS['user_id'].")");
			return FALSE;
		}
	}
	else
	{
		$errors = array('error'=>$LANG_VARS['cannot_edit_item_not_owned'],detail=>'');
		opendb_log("Attempted to edit linked item for parent item they do not own (item_id=".$item_r['item_id'].", parent_id=".$parent_item_r['item_id'].",parent_instance_no=".$parent_item_r['instance_no'].", update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return FALSE;
	}
}

/*
* Will validate that new/site can proceed for the $HTTP_SESSION_VARS['user_id'], and will then
* build the edit form, by calling get_edit_form.  If get_edit_form, returns
* a NOT NULL, value then the complete get_edit_form block will be returned,
* otherwise this function returns false.
*/
function handle_new_or_site($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, &$errors)
{
	global $LANG_VARS;
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	if(is_empty_array($parent_item_r) || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || $parent_item_r['owner_id'] == $HTTP_SESSION_VARS['user_id'])
	{
		if(is_empty_array($parent_item_r) || $CONFIG_VARS['item_input.linked_item_support']!==FALSE)
		{
			// No parent, or parent and child same type, or allowed to have separate types.
			if(is_empty_array($parent_item_r) || $CONFIG_VARS['item_input.link_same_type_only']!==TRUE || $parent_item_r['s_item_type'] == $item_r['s_item_type'])
			{
				// Before trying to insert items into this structure, first ensure it is valid.
				if(is_valid_item_type_structure($item_r['s_item_type']))
				{
					if(is_not_empty_array($parent_item_r) || is_newitem_status_type_valid($item_r['owner_id'], $status_type_r, $errors))
					{
						$results = fetch_item_attribute_type_rs($item_r['s_item_type'], TRUE, TRUE);
						$formContents = get_edit_form($HTTP_VARS['op'], NULL, $parent_item_r, $item_r, $status_type_r, $results, $HTTP_VARS, $HTTP_POST_FILES);
						if($formContents != NULL)
							return $formContents;
						else
						{
							$errors = array('error'=>$LANG_VARS['undefined_error'],detail=>'');
							return FALSE;
						}
					}
					else //if(is_not_empty_array($parent_item_r) || is_status_type_insert_valid($item_r['item_id'], $HTTP_SESSION_VARS['user_id'], $status_type_r, $errors))
					{
						return FALSE;
					}
				}
				else//if(is_valid_item_type_structure($item_r['s_item_type']))
				{
					$errors = array('error'=>replace_lang_var("s_item_type", $item_r['s_item_type'], $LANG_VARS['invalid_item_type_structure']),'detail'=>'');

					// An error like this is a big problem, and should be dealt with quickly, but there is no sense in alarming the
					// user by sending back an error.
					opendb_log("Experienced a problem with a system item type.  Either it does not exist, or there is an error in its structure. (s_item_type=".$item_r['s_item_type'].", update_who=".$HTTP_SESSION_VARS['user_id'].")");
					return FALSE;
				}					
			}
			else
			{
				$errors = array('error'=>replace_lang_var("s_item_type", $parent_item_r['s_item_type'], $LANG_VARS['linked_item_must_be_type']),'detail'=>'');
				return FALSE;
			}
		}
		else
		{
			$errors = array('error'=>$LANG_VARS['linked_items_not_supported'],detail=>'');
			return FALSE;
		}
	}
	else
	{
		$errors = array('error'=>$LANG_VARS['cannot_edit_item_not_owned'],detail=>'');
		opendb_log("Attempted to add new linked item for parent item they do not own (parent_id=".$parent_item_r['item_id'].", parent_instance_no=".$parent_item_r['instance_no'].", update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return FALSE;
	}
}

/*
* Will validate that edit/refresh can proceed for the $HTTP_SESSION_VARS['user_id'], and will then
* build the edit form, by calling get_edit_form.  If get_edit_form, returns
* a NOT NULL value then the complete get_edit_form block will be returned,
* otherwise this function returns false.
*/
function handle_confirm_item_instance_update($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, &$errors)
{
	global $LANG_VARS;
	global $HTTP_SESSION_VARS;
	
	// Linked item has no item instance
	if(is_empty_array($parent_item_r))
	{
		if(is_not_empty_array($item_r))
		{
			if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || $item_r['owner_id'] == $HTTP_SESSION_VARS['user_id'])
			{
				$results = fetch_sfieldtype_item_attribute_type_rs($item_r['s_item_type'], array('STATUSTYPE','STATUSCMNT','DURATION'), TRUE, TRUE);
				$formContents = get_edit_form(
							$HTTP_VARS['op'], 
							$LANG_VARS['confirm_item_instance_update'], 
							$parent_item_r, //$parent_item_r is empty at this stage!!!
							$item_r, 
							$status_type_r, 
							$results, 
							$HTTP_VARS, 
							$dummy_post_file);
							
				if($formContents != NULL)
					return $formContents;
				else
				{
					$errors = array('error'=>$LANG_VARS['undefined_error'], detail=>'');
					return FALSE;
				}
			}
			else
			{
				$errors = array('error'=>$LANG_VARS['cannot_edit_item_not_owned'],detail=>'');
				opendb_log("Attempted to edit item instance they do not own (item_id=".$item_r['item_id'].", instance_no=".$item_r['instance_no'].", update_who=".$HTTP_SESSION_VARS['user_id'].")");
				return FALSE;
			}
		}
		else//if(is_not_empty_array($item_r))
		{
			$errors = array('error'=>$LANG_VARS['item_not_found'],'detail'=>'');
			return FALSE;
		}
	}
	else//if(is_empty_array($parent_item_r))
	{
		$errors = array('error'=>$LANG_VARS['operation_not_available'],'detail'=>'');
		return FALSE;
	}
}

/*
*/
function handle_confirm_clone_item($item_r, $HTTP_VARS, &$errors)
{
	global $PHP_SELF;
	global $LANG_VARS;
	global $HTTP_SESSION_VARS;
	
	if($CONFIG_VARS['item_input.clone_item_support']!==FALSE)
	{
		// Linked item has no item instance
		if($item_r['parent_id'] === NULL)
		{
			if(is_not_empty_array($item_r))
			{
				// Get valid s_item_type
				if(strlen($HTTP_VARS['s_item_type']) == 0)
					$HTTP_VARS['s_item_type'] = $item_r['s_item_type'];
								
				$field_rs[] = 
					array('prompt'=>$LANG_VARS['item_type'],
						'field'=>custom_select(
									's_item_type',
									fetch_item_type_rs(),
									'%s_item_type% - %description%', 
									'1',
									$HTTP_VARS['s_item_type'],
									's_item_type'));
				
				// Ensure valid owner_id specified
				if(strlen($HTTP_VARS['owner_id'])==0)
					$HTTP_VARS['owner_id'] = $HTTP_SESSION_VARS['user_id'];
					
				// Ensure valid owner_id specified
				if(strlen($HTTP_VARS['s_status_type'])==0)
					$HTTP_VARS['s_status_type'] = $item_r['s_status_type'];
					
				$field_rs[] = 
					array('prompt'=>$LANG_VARS['s_status_type'],
						'field'=>status_type_input_field(
									's_status_type', 
									fetch_newitem_status_type_rs($HTTP_VARS['owner_id']), 
									$HTTP_VARS['s_status_type']));
				
				$field_rs[] = 
					array('prompt'=>$LANG_VARS['status_comment'],
						'field'=>get_input_field(
							'status_comment',
							NULL, 
							$LANG_VARS['status_comment'], 
							'textarea(50,5)', 
							'N', 
							NULL,
							FALSE));
				
				// If child items exist, we need to prompt, to force conversion to new type.
				if(is_exists_child_item_with_diff_item_type_to_parent($item_r['item_id'], $item_r['s_item_type']))
				{
					$field_rs[] = 
						array('prompt'=>$LANG_VARS['coerce_child_item_types'],
							'field'=>'<input type=checkbox name="coerce_child_item_type" value="Y" CHECKED>');
				}
				
				return format_confirm_form($PHP_SELF, 
								$LANG_VARS['confirm_clone_item'], 
								$field_rs,
								$HTTP_VARS);
			}
			else//if(is_not_empty_array($item_r))
			{
				$errors = array('error'=>$LANG_VARS['item_not_found'],'detail'=>'');
				return FALSE;
			}
		}
		else//if($item_r['parent_id'] === NULL)
		{
			$errors = array('error'=>$LANG_VARS['cannot_clone_linked_item'],detail=>'');
			opendb_log("User attempted to clone linked item (item_id=".$item_r['item_id'].", update_who=".$HTTP_SESSION_VARS['user_id'].")");
			return FALSE;
		}
	}
	else
	{
		$errors = array('error'=>$LANG_VARS['clone_item_not_supported'],detail=>'');
		return FALSE;
	}
}

/**
*/
function get_child_item_table($op, $parent_item_r, $item_r, $HTTP_VARS)
{
	global $LANG_VARS;
	global $CONFIG_VARS;
	global $PHP_SELF;
	
	// Ensure we are at the level of parent item, not a child item (This the is_empty_array($parent_item_r) test!)
	if($op!="new" && $op!="site" && is_empty_array($parent_item_r) && is_not_empty_array($item_r))
	{
		// If existing linked items, then we need to display block, but just disable Add Linked operation!
		// Otherwise if no results and $CONFIG_VARS['item_input.linked_item_support'] enabled, still generate table,
		// but no records will be displayed.
		$results = fetch_child_item_rs($item_r['item_id']);
		if ($results || $CONFIG_VARS['item_input.linked_item_support'] !== FALSE)
		{
			// A interpage link to be used from listings.
			$tableContents = "\n<a name=\"linked_item\"></a>".
							"\n<p><br><div class=\"colortext\"><b>".$LANG_VARS['linked_item(s)'].":</b>&nbsp;";
							
			if($CONFIG_VARS['item_input.linked_item_support'] !== FALSE)
			{
				$tableContents .= "[<a href=\"item_add.php?".($CONFIG_VARS['item_input.link_same_type_only']===TRUE?"s_item_type=".$item_r['s_item_type']."&":"")."parent_id=".$item_r['item_id']."&parent_instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link']."\">".$LANG_VARS['add_linked']."</a>]";
			}				
			$tableContents .= "</div>";

			$tableContents .= "\n<table border=0 cellpadding=0 cellspacing=1>";
			
			$tableContents .= "\n<tr>".
							"<td class=\"navbar\" align=center width=10%>".$LANG_VARS['type']."</td>".
							"<td class=\"navbar\" align=center width=40%>".$LANG_VARS['title']."</td>".
							"<td class=\"navbar\" align=center>".$LANG_VARS['action']."</td>".
							"<td class=\"navbar\" align=center>".$LANG_VARS['category']."</td>".
							"</tr>";
			if($results)
			{
				$toggle = TRUE;
				while($child_item_r = mysql_fetch_array($results))
				{
					if($toggle)
						$color="top";
					else
		 				$color="top2";
					$toggle = !$toggle;
						
					$action_links_rs = NULL;
					
					$child_item_r['title'] = expand_type_title_mask($child_item_r['title'], $child_item_r['s_item_type'], $child_item_r['item_id'], NULL, $child_item_r['s_status_type'], $CONFIG_VARS['listings.title_display_mask'], $parsed_title_mask_r);

					$tableContents .= "\n<tr>".
									"<td class=\"$color\" align=center nowrap>".get_item_image($child_item_r['s_item_type'],NULL,TRUE)."</td>".
									"<td class=\"$color\" align=center>".$child_item_r['title']."</td>";

					$action_links_rs[] = array(url=>$PHP_SELF.'?op=edit&item_id='.$child_item_r['item_id'].'&parent_id='.$item_r['item_id'].'&parent_instance_no='.$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],img=>'edit.gif',text=>$LANG_VARS['edit']);
					
					// Checks if any legal site plugins defined for $s_item_type
					if(is_item_legal_site_type($child_item_r['s_item_type']))
					{
						$action_links_rs[] = array(url=>'item_add.php?item_id='.$child_item_r['item_id'].'&parent_id='.$item_r['item_id'].'&parent_instance_no='.$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],img=>'refresh.gif',text=>$LANG_VARS['refresh']);
					}

					$action_links_rs[] = array(url=>$PHP_SELF.'?op=delete&item_id='.$child_item_r['item_id'].'&parent_id='.$item_r['item_id'].'&parent_instance_no='.$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],img=>'delete.gif',text=>$LANG_VARS['delete']);

					$tableContents .= format_action_links(
							$action_links_rs,
							"\n<td align=\"center\" class=\"$color\" %nowrap%><font class=\"smlink\">%field%</font></td>",
							$LANG_VARS['not_applicable']);
																
					$attribute_type_r = fetch_sfieldtype_item_attribute_type_r($child_item_r['s_item_type'], 'CATEGORY', TRUE);
					$tableContents .= "<td class=\"$color\" align=center>";
					if(is_array($attribute_type_r))
						$tableContents .= ifempty(get_display_field($attribute_type_r['s_attribute_type'], $attribute_type_r['prompt'], $attribute_type_r['display_type'], $child_item_r['category'], FALSE),"&nbsp;");
					else
						$tableContents .= "&nbsp;";
								
					$tableContents .= "</td></tr>";
				}
			}
			else
			{
				$tableContents .= "\n<tr><td align=center colspan=4 class=\"error\">".
							"<div class=\"error\"><b>- ".$LANG_VARS['no_records_found']." -</b></div>".
							"</td></tr>";
			}		
			
			return $tableContents .
					"\n</table></p>";
			
		}//if ($results || $CONFIG_VARS['item_input.linked_item_support'] !== FALSE)
	}//if($op != "new" && $op!="site" && is_empty_array($parent_item_r) && is_not_empty_array($item_r))
	
	//else
	return NULL;
}

/**
* Will work out based on the $op what the title should be.  It will
* return a complete heading, including calling the _theme_header
* and everything.
*/
function do_op_title($parent_item_r, $item_r, $status_type_r, $op)
{
	global $LANG_VARS;
	global $CONFIG_VARS;
	
	// Now do the title
	if(is_not_empty_array($parent_item_r))
	{
		$parent_item_title = replace_lang_var('display_title', expand_item_title_mask($parent_item_r['title'], $parent_item_r['s_item_type'], $parent_item_r['item_id'], $parent_item_r['instance_no'], $parent_item_r['s_status_type'], $CONFIG_VARS['item_display.title_display_mask']), $LANG_VARS['edit_title']);
		switch($op)
		{
			case 'delete':
			case 'update':
			case 'refresh':
			case 'edit':
				$linked_item_title = $LANG_VARS[$op.'_linked_item'];
				break;
			case 'new':
			case 'site':
			case 'insert':
				$linked_item_title = $LANG_VARS['add_linked_item'];
				break;
			default:
				$linked_item_title = $LANG_VARS['operation_not_available'];
		}		
		
		echo _theme_header($parent_item_title);
		echo ("<h2>".$parent_item_title." ".get_item_image($parent_item_r['s_item_type'])."</h2>\n");
		echo ("<h3>".$linked_item_title." ".get_item_image($item_r['s_item_type'], NULL, TRUE)."</h3>\n");
	}
	else
	{
		if($op == 'new' || $op == 'site' || $op == 'newinstance' || $op == 'insert')
		{
			// Not yet provided s_status_type value.
			if(strlen($status_type_r['s_status_type'])>0)
				$item_title = replace_lang_var('s_status_type_desc', $status_type_r['description'], $LANG_VARS['add_s_status_type_item']);
			else
				$item_title = $LANG_VARS['add_item'];
		}
		else if($op == 'update' || $op == 'delete')
		{
			$item_title = $LANG_VARS[$op.'_item'];
		}
		else if ($op == 'refresh' || $op == 'edit' || $op == 'updateinstance' || $op == 'clone_item')
		{
			if($op == 'updateinstance')
				$op = 'update';
			else if($op == 'clone_item')
				$op = 'clone';
			
			$item_title = replace_lang_vars(array('display_title'=>expand_item_title_mask($item_r['title'], $item_r['s_item_type'], $item_r['item_id'], $item_r['instance_no'], $item_r['s_status_type'], $CONFIG_VARS['item_display.title_display_mask'])), $LANG_VARS[$op.'_title']);
		}
		
		echo _theme_header($item_title);
		echo ("<h2>".$item_title." ".get_item_image($item_r['s_item_type'])."</h2>\n");
	}
}

// *****************************************************************************
// MAIN PROCESS
// *****************************************************************************
session_start();
if (is_opendb_valid_session())
{
	if ( is_user_allowed_to_own($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) )
	{
		// Get a reference to the $item_r and $parent_item_r if applicable
		if(is_numeric($HTTP_VARS['parent_id']) && is_numeric($HTTP_VARS['parent_instance_no']))
			$parent_item_r = fetch_item_instance_r($HTTP_VARS['parent_id'], $HTTP_VARS['parent_instance_no']);
		
		// Either no parent relationship - The !is_numeric(...) bit, or a non-empty array.
		if(!is_numeric($HTTP_VARS['parent_id']) || is_not_empty_array($parent_item_r))
		{
			// For a $op == 'site', where an item is actually defined, it is really a 'refresh' site operation.
			if(strlen($HTTP_VARS['s_item_type'])>0 && ((!is_exists_item($HTTP_VARS['item_id']) && $HTTP_VARS['op'] == 'site') || $HTTP_VARS['op'] == 'new' || $HTTP_VARS['op'] == 'insert'))
			{
				// Get the status_type for instances where the s_status_type is being
				// specified according to the s_attribute_type:order_no.  This would
				// occur for site operations, as well as situations where the addition
				// of an item resulted in an error which reloading the Update page.
				if(strlen($HTTP_VARS['s_status_type'])==0)
				{
					$status_attr_type_r = fetch_sfieldtype_item_attribute_type_r($HTTP_VARS['s_item_type'], 'STATUSTYPE');
					$HTTP_VARS['s_status_type'] = $HTTP_VARS[get_field_name($status_attr_type_r['s_attribute_type'], $status_attr_type_r['order_no'])];
				}
				
				// No s_status_type unless actually provided.
				if(strlen($HTTP_VARS['s_status_type'])>0)
					$status_type_r = fetch_status_type_r($HTTP_VARS['s_status_type']);
				else
				{
					// Dummy array entry, as the s_status_type will be chosen in the edit form.
					$status_type_r = array(
								'insert_ind'=>'Y',
								'borrow_ind'=>'Y');
				}
					
				// Ensure valid owner_id specified
				if(strlen($HTTP_VARS['owner_id'])>0 && ($HTTP_VARS['owner_id'] == $HTTP_SESSION_VARS['user_id'] || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type'])))
					$owner_id = $HTTP_VARS['owner_id'];
				else
					$owner_id = $HTTP_SESSION_VARS['user_id'];
			
				$item_r = array(id=>NULL,
						instance_no=>NULL,
						title=>NULL,//Will be provided by get_field_value, when $op == 'site'!
						owner_id=>$owner_id,
						parent_id=>(is_not_empty_array($parent_item_r)?$parent_item_r['item_id']:NULL),
						category=>NULL,//Will be provided by get_field_value, when $op == 'site'!
						s_item_type=>trim($HTTP_VARS['s_item_type']),
						s_status_type=>$status_type_r['s_status_type'],
						status_comment=>NULL
					);
					
				$is_new_operation = TRUE;
			}
			else //otherwise either a site refresh operation or an edit/update/delete
			{
				// We can treat it like this for the rest of the process.
				if($HTTP_VARS['op'] == 'site')
					$HTTP_VARS['op'] = 'refresh';
				
				// Is parent-child relationship
				if(is_not_empty_array($parent_item_r))
				{
					$status_type_r = fetch_status_type_r($parent_item_r['s_status_type']);
					$item_r = fetch_child_item_r($HTTP_VARS['item_id']);
				}
				else
				{
					$item_r = fetch_item_instance_r($HTTP_VARS['item_id'], $HTTP_VARS['instance_no']);
					$status_type_r = fetch_status_type_r($item_r['s_status_type']);
				}
			}
		
			// Includes 'new', because we artificially construct an $item_r array.
			if(is_not_empty_array($item_r))
			{
				// We need a valid $status_type_r as well at this point, and should not
				// continue without it.
				if(is_not_empty_array($status_type_r))
				{
					$footer_links_r = NULL;
				
					switch($HTTP_VARS['op'])
					{
						case 'delete':
							do_op_title($parent_item_r, $item_r, $status_type_r, 'delete');
					
							$return_val = handle_item_delete($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $errors);
							if($return_val === "__CONFIRM__")
							{
								echo get_op_confirm_form($PHP_SELF, 
													replace_lang_var('display_title', expand_item_title_mask($item_r['title'], $item_r['s_item_type'], $item_r['item_id'], $item_r['instance_no'], $item_r['s_status_type'], $CONFIG_VARS['item_display.title_display_mask']), $LANG_VARS['confirm_delete_title']), 
													$HTTP_VARS);
							}
							else
							{
								if($return_val === "__ABORTED__")
								{
									echo("<div class=\"success\">".$LANG_VARS['item_not_deleted']."</div>");
									
									if(is_not_empty_array($parent_item_r))
										$footer_links_r[] = array(url=>"item_display.php?parent_id=".$parent_item_r['item_id']."&parent_instance_no=".$parent_item_r['instance_no']."&item_id=".$item_r['item_id']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
									else
										$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
								}
								else if($return_val === FALSE)
								{
									echo format_error_block($errors);

									if(is_not_empty_array($parent_item_r))
										$footer_links_r[] = array(url=>"item_display.php?parent_id=".$parent_item_r['item_id']."&parent_instance_no=".$parent_item_r['instance_no']."&item_id=".$item_r['item_id']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
									else
										$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
								}
								else
									echo("<div class=\"success\">".$LANG_VARS['item_deleted']."</div>");

								if(is_not_empty_array($parent_item_r))
								{
									$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_parent']);
								}
								
								// Listing link.
								if($HTTP_VARS['listing_link'] === "y" && is_array($HTTP_SESSION_VARS['listing_url_vars']))
									$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
							}
							break;
						
						case 'update':
							do_op_title($parent_item_r, $item_r, $status_type_r, 'update');
					
							$return_val = handle_item_update($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, $errors);
							if($return_val === "__INVALID_DATA__")
							{
								// We need to load the edit form again here!
								echo format_error_block($errors);
							
								$HTTP_VARS['op'] = 'edit';
							
								$formContents = handle_edit_or_refresh($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, $errors);
								if($formContents !== FALSE)
								{
									echo $formContents;
							
									// Do not display child items block, if edit/refresh for a child item!
									if(is_empty_array($parent_item_r))
										echo get_child_item_table($HTTP_VARS['op'], $parent_item_r, $item_r, $HTTP_VARS);
								}
								else
									echo format_error_block($errors);

								if(is_not_empty_array($parent_item_r))
								{
									$footer_links_r[] = array(url=>"item_input.php?op=edit&item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['edit_parent']);
									$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_parent']);
								}
							}
							else if($return_val === TRUE)
							{
								echo("<div class=\"success\">".$LANG_VARS['item_updated']."</div>");
								echo format_error_block($errors, 'warning');//warnings
									
								if(is_not_empty_array($parent_item_r))
								{
									$footer_links_r[] = array(url=>"item_display.php?parent_id=".$parent_item_r['item_id']."&parent_instance_no=".$parent_item_r['instance_no']."&item_id=".$item_r['item_id']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
									$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_parent']);
								}
								else
									$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
								
								// Listing link.
								if($HTTP_VARS['listing_link'] === "y" && is_array($HTTP_SESSION_VARS['listing_url_vars']))
									$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
							}
							else // if($return_val === FALSE)
							{
								echo format_error_block($errors);
										
								// Listing link.
								if($HTTP_VARS['listing_link'] === "y" && is_array($HTTP_SESSION_VARS['listing_url_vars']))
									$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
							}
							break;
						
						case 'insert':
							$return_val = handle_item_insert($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, $errors);
							if($return_val === "__CONFIRM_EXISTS_TITLE__" || $return_val === "__CONFIRM_EXISTS_OWNER_TITLE__" || $return_val === "__CONFIRM_EXISTS_LINKED_TITLE__")
							{
								// TODO: Provide list of duplicates!!!
								if($return_val === "__CONFIRM_EXISTS_OWNER_TITLE__")
								{
									$message_lang_var = $LANG_VARS['confirm_title_same_type_and_owner_insert'];
									$footer_links_r[] = array(url=>"listings.php?search_list=y&inc_menu=N&owner_id=".$item_r['owner_id']."&title=".urlencode("\"".$item_r['title']."\"")."&title_match=exact&s_item_type=".$item_r['s_item_type'],target=>'popup',text=>$LANG_VARS['list_duplicate_title(s)']);
								}
								else if($return_val === "__CONFIRM_EXISTS_TITLE__")
								{
									$message_lang_var = $LANG_VARS['confirm_title_same_type_insert'];
									$footer_links_r[] = array(url=>"listings.php?search_list=y&inc_menu=N&title=".urlencode("\"".$item_r['title']."\"")."&title_match=exact&s_item_type=".$item_r['s_item_type'],target=>'popup',text=>$LANG_VARS['list_duplicate_title(s)']);
								}
								else if($return_val === "__CONFIRM_EXISTS_LINKED_TITLE__")
								{
									$message_lang_var = $LANG_VARS['confirm_title_linked_item_insert'];
									$footer_links_r[] = array(url=>"item_display.php?inc_menu=N&item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."#linked_item",target=>'popup',text=>$LANG_VARS['list_duplicate_title(s)']);
								}
								
								do_op_title($parent_item_r, $item_r, $status_type_r, 'insert');
								
								echo get_popup_javascript();
								
								echo get_op_confirm_form(
										$PHP_SELF, 
										replace_lang_vars(array('title'=>$item_r['title'],'s_item_type'=>$item_r['s_item_type']), $message_lang_var), 
										$HTTP_VARS);
							}
							else
							{
								if($return_val === "__INVALID_DATA__")
								{
									do_op_title($parent_item_r, $item_r, $status_type_r, 'insert');
								
									// We need to load the edit form again here!
									echo format_error_block($errors);
		
									// Reset operation 						
									$HTTP_VARS['op'] = 'new';
									$formContents = handle_new_or_site($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, $errors);
									if($formContents !== FALSE)
										echo $formContents;
									else
										echo format_error_block($errors);
												
									if(is_not_empty_array($parent_item_r))
									{
										$footer_links_r[] = array(url=>"item_input.php?op=edit&item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['edit_parent']);
										$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_parent']);
									}
								}
								else if($return_val === "__ABORTED__")
								{
									do_op_title($parent_item_r, $item_r, $status_type_r, 'insert');
									echo("<div class=\"success\">".$LANG_VARS['item_not_added']."</div>");
									
									// Listing link.
									if($HTTP_VARS['listing_link'] === "y" && is_array($HTTP_SESSION_VARS['listing_url_vars']))
										$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
								}
								else if($return_val === TRUE)
								{
									do_op_title($parent_item_r, $item_r, $status_type_r, 'insert');

									echo("<div class=\"success\">".$LANG_VARS['item_added']."</div>");
									echo format_error_block($errors, 'warning');//warnings

									if(is_not_empty_array($parent_item_r))
									{
										if($CONFIG_VARS['item_input.linked_item_support']!==FALSE)
											$footer_links_r[] = array(url=>"item_add.php?".($CONFIG_VARS['item_input.link_same_type_only']===TRUE?"s_item_type=".$item_r['s_item_type']."&":"")."parent_id=".$parent_item_r['item_id']."&parent_instance_no=".$parent_item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['add_linked']);

										$footer_links_r[] = array(url=>"item_display.php?parent_id=".$parent_item_r['item_id']."&parent_instance_no=".$parent_item_r['instance_no']."&item_id=".$item_r['item_id']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
										$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_parent']);
									}
									else
									{
										$footer_links_r[] = array(url=>"item_add.php?s_status_type=".$item_r['s_status_type'],text=>replace_lang_var('s_status_type_desc', $status_type_r['description'], $LANG_VARS['add_s_status_type_item']));
										$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
									}
									
									// Listing link.
									if($HTTP_VARS['listing_link'] === "y" && is_array($HTTP_SESSION_VARS['listing_url_vars']))
										$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
								}
								else //if($return_val === FALSE)
								{
									do_op_title($parent_item_r, $item_r, $status_type_r, 'insert');
									
									echo format_error_block($errors);
									
									if(is_not_empty_array($parent_item_r))
									{
										$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_parent']);
									}
									
									// Listing link.
									if($HTTP_VARS['listing_link'] === "y" && is_array($HTTP_SESSION_VARS['listing_url_vars']))
										$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
								}
							}
							break;
						
						case 'updateinstance': // Only Status Type / Status Comment update supported
							do_op_title($parent_item_r, $item_r, $status_type_r, $HTTP_VARS['op']);
						
							$return_val = handle_item_instance_update($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $errors);
							if($return_val === "__CONFIRM__")
							{
								$formContents = handle_confirm_item_instance_update($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $errors);
								if($formContents !== FALSE)
									echo $formContents;
								else
								{
									echo format_error_block($errors);
								}
							}
							else if($return_val === "__ABORTED__")
							{
								echo("<div class=\"success\">".$LANG_VARS['item_instance_not_updated']."</div>");
							}
							else if($return_val === TRUE)
							{
								echo("<div class=\"success\">".$LANG_VARS['item_instance_updated']."</div>");
								echo format_error_block($errors, 'warning');//warnings
							}
							else // $return_val == FALSE
							{
								echo format_error_block($errors);
							}
												
							$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
							
							// Listing link.
							if($HTTP_VARS['listing_link'] == "y" && is_array($HTTP_SESSION_VARS['listing_url_vars']))
								$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);

							break;
						
						case 'newinstance':
							do_op_title($parent_item_r, $item_r, $status_type_r, 'newinstance');

							// TODO: Support Administrator new instance for other user.  Via the $HTTP_VARS['owner_id'] parameter.						
							$HTTP_VARS['owner_id'] = $HTTP_SESSION_VARS['user_id'];
							
							if(handle_item_instance_insert($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $errors))
							{
								echo("<div class=\"success\">".$LANG_VARS['item_instance_added']."</div>");
										
					    		// Provide link back to item after insert.
								$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
							}
							else
							{
								echo format_error_block($errors);

								// This will take us back to the item_display entry where the 'New Copy' operation was started.							
								$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
							}
												
							// Listing link.
							if($HTTP_VARS['listing_link'] == "y" && is_array($HTTP_SESSION_VARS['listing_url_vars']))
								$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);

							break;
					
						case 'clone_item':
							do_op_title($parent_item_r, $item_r, $status_type_r, 'clone_item');
						
							// TODO: Support Administrator new instance for other user.  Via a $HTTP_VARS['owner_id'] parameter.						
							$HTTP_VARS['owner_id'] = $HTTP_SESSION_VARS['user_id'];
							
							$return_val = handle_clone_item($item_r, $HTTP_VARS, $errors);
							if($return_val === "__CONFIRM__")
							{
								$formContents = handle_confirm_clone_item($item_r, $HTTP_VARS, $errors);
								if($formContents !== FALSE)
									echo $formContents;
								else
								{
									echo format_error_block($errors);
								}
							}
							else if($return_val === "__ABORTED__")
							{
								echo("<div class=\"success\">".$LANG_VARS['item_not_cloned']."</div>");
								
							}
							else if($return_val === TRUE)
							{
								echo("<div class=\"success\">".$LANG_VARS['item_cloned']."</div>");
								echo format_error_block($errors, 'warning');//warnings
							}
							else
							{
								echo format_error_block($errors);
							}
							
							$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
							
							// Listing link.
							if($HTTP_VARS['listing_link'] === "y" && is_array($HTTP_SESSION_VARS['listing_url_vars']))
								$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);

							break;
						
						case 'new': //add item
						case 'site'://add item, via site plugin
							do_op_title($parent_item_r, $item_r, $status_type_r, 'new');
					
							$formContents = handle_new_or_site($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, $errors);
							if($formContents !== FALSE)
								echo $formContents;
							else
							{
								echo format_error_block($errors);
							}
												
							if(is_not_empty_array($parent_item_r))
							{
								$footer_links_r[] = array(url=>"item_input.php?op=edit&item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['edit_parent']);
								$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_parent']);
							}
							
							break;
						
						case 'edit':// edit item
						case 'refresh': // edit item, but refresh via site plugin first.
							do_op_title($parent_item_r, $item_r, $status_type_r, 'edit');
						
							$formContents = handle_edit_or_refresh($parent_item_r, $item_r, $status_type_r, $HTTP_VARS, $HTTP_POST_FILES, $errors);
							if($formContents !== FALSE)
							{
								echo $formContents;
							
								// Do not display child items block, if edit/refresh for a child item!
								if(is_empty_array($parent_item_r))
									echo get_child_item_table($HTTP_VARS['op'], $parent_item_r, $item_r, $HTTP_VARS);
							}
							else
							{
								echo format_error_block($errors);
							}
							
							if(is_not_empty_array($parent_item_r))
							{
								$footer_links_r[] = array(url=>"item_input.php?op=edit&item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['edit_parent']);
								$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_parent']);
							}
							
							break;
							
						default:
							echo format_error_block($LANG_VARS['operation_not_available']);
					
							if(is_not_empty_array($parent_item_r))
							{
								$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_parent']);
							}
							
							// Listing link.
							if($HTTP_VARS['listing_link'] == "y" && is_array($HTTP_SESSION_VARS['listing_url_vars']))
								$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
					}
				}
				else//if(is_not_empty_array($status_type_r))
				{
					$page_title = replace_lang_var("s_status_type", ifempty((is_not_empty_array($parent_item_r)?$parent_item_r['s_status_type']:$item_r['s_status_type']),$HTTP_VARS['s_status_type']), $LANG_VARS['invalid_s_status_type']);
					echo _theme_header($page_title);
					echo format_error_block($page_title);
					
					// Listing link.
					if($HTTP_VARS['listing_link'] == "y" && is_array($HTTP_SESSION_VARS['listing_url_vars']))
						$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
				}
			}
			else //if(is_not_empty_array($item_r))
			{
				if(is_not_empty_array($parent_item_r))
				{
					echo _theme_header($LANG_VARS['linked_item_not_found']);
					echo format_error_block($LANG_VARS['linked_item_not_found']);
					
					$footer_links_r[] = array(url=>"item_display.php?item_id=".$parent_item_r['item_id']."&instance_no=".$parent_item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_parent']);
				}
				else
				{
					echo _theme_header($LANG_VARS['item_not_found']);
					echo format_error_block($LANG_VARS['item_not_found']);
				}
				
				// Listing link.
				if($HTTP_VARS['listing_link'] == "y" && is_array($HTTP_SESSION_VARS['listing_url_vars']))
					$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
			}
		}
		else //if(!is_numeric($HTTP_VARS['parent_id']) || is_not_empty_array($parent_item_r))
		{
			echo _theme_header($LANG_VARS['parent_item_not_found']);
			echo format_error_block($LANG_VARS['parent_item_not_found']);
			
			// Listing link.
			if($HTTP_VARS['listing_link'] == "y" && is_array($HTTP_SESSION_VARS['listing_url_vars']))
				$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
		}
	}
	else//no guests or borrowers allowed!
	{
		echo _theme_header($LANG_VARS['not_authorized_to_page']);
		echo _theme_error($LANG_VARS['not_authorized_to_page']);
	}

	echo format_footer_links($footer_links_r);
	echo _theme_footer();
}	
else
{
	include("./include/invalidsession.php");
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
